/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.aflow.FlowResults;
import coins.flow.BBlock;
import coins.flow.Flow;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowUtil;
import coins.flow.NodeListIterator;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprHirImpl;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.HIR;
import coins.opt.Opt;
import coins.opt.OptUtil;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import coins.sym.Var;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DeadCodeElim {
    final FlowResults fResults;
    public final Flow flow;
    public final Opt opt;
    protected SubpFlow fSubpFlow;
    protected int fDbgLevel;

    DeadCodeElim(FlowResults pResults, Opt pOpt) {
        this.fResults = pResults;
        this.flow = this.fResults.flowRoot.flow;
        this.opt = pOpt;
    }

    public boolean doSubp(SubpFlow pSubpFlow) {
        boolean lOptimized = false;
        this.fSubpFlow = pSubpFlow;
        this.fDbgLevel = this.fResults.flowRoot.ioRoot.dbgOpt1.getLevel();
        this.flow.dbg(1, "deadcode elim", this.fSubpFlow.getSubpSym().getName());
        Iterator lIt = pSubpFlow.getListOfBBlocksFromEntry().iterator();
        while (lIt.hasNext()) {
            lOptimized |= this.doBBlock((BBlock)lIt.next());
        }
        return lOptimized;
    }

    public boolean doBBlock(BBlock pBBlock) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        this.flow.dbg(3, "\nBBlock " + pBBlock.getBBlockNumber());
        SetRefReprList lSetRefReprs = this.fSubpFlow.getSetRefReprList(pBBlock);
        SubpFlow lSubpFlow = pBBlock.getSubpFlow();
        FlowAnalSymVector lLive = lSubpFlow.flowAnalSymVector();
        FlowAnalSymVector lFullVect = lSubpFlow.flowAnalSymVector();
        lFullVect.vectorNot(lFullVect);
        FlowAnalSymVector lUsed = pBBlock.getUsed();
        Set lUsedSyms = lUsed.flowAnalSyms();
        pBBlock.getLiveOut().vectorCopy(lLive);
        this.flow.dbg(4, "LiveOut", lLive.toStringDescriptive());
        this.flow.dbg(4, "Used", lUsedSyms.toString());
        Object lCallNode = null;
        Set lSetOfUsedSyms = lSubpFlow.getUsedSyms();
        boolean lOptimized = false;
        FlowAnalSymVector lExternallyReferrableVars = lSubpFlow.flowAnalSymVector();
        LinkedList<FlowAnalSym> FlowAnalList = new LinkedList<FlowAnalSym>();
        for (Sym lSym : lSetOfUsedSyms) {
            lExternallyReferrableVars.setBit(((FlowAnalSym)lSym).getIndex());
        }
        Iterator lSetRefReprIt = lSetRefReprs.reverseIterator();
        while (lSetRefReprIt.hasNext()) {
            SetRefRepr lSetRefRepr = (SetRefRepr)lSetRefReprIt.next();
            HIR lDefNode = (HIR)lSetRefRepr.defNode();
            boolean lHasCall = lSetRefRepr.hasCallWithSideEffect();
            if (this.fDbgLevel > 1 && lDefNode != null) {
                this.flow.dbg(4, "SetRefRepr", "Def " + lDefNode.toStringShort() + " hasCall " + lHasCall + " sets " + lSetRefRepr.sets() + " topUseNode " + lSetRefRepr.topUseNode());
            }
            if (lSetRefRepr.sets()) {
                if (((HIR)lSetRefRepr.defNode()).isSameAs((HIR)lSetRefRepr.topUseNode()) && !lHasCall && lDefNode instanceof AssignStmt) {
                    if (this.fDbgLevel >= 3) {
                        this.flow.dbg(3, "deleteStmt", lDefNode.toStringShort());
                    }
                    OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt());
                    lSetRefReprIt.remove();
                    lOptimized = true;
                    continue;
                }
                FlowAnalSym lDefSym = lSetRefRepr.defSym();
                FlowAnalSymVector lIntersection = lSubpFlow.flowAnalSymVector();
                pBBlock.getDefined().vectorAnd(lLive, lIntersection);
                if (lIntersection.isZero() && !DeadCodeElim.mayWriteToExternalAddress(lSetRefRepr) && !lHasCall) {
                    FlowAnalSym lFlowAnalSym;
                    HIR node;
                    boolean remove = true;
                    NodeListIterator lNodeIt = FlowUtil.nodeListIterator(lSetRefRepr.getIR(), true, false);
                    while (lNodeIt.hasNext()) {
                        node = (HIR)lNodeIt.next();
                        if (!(node.getSym() instanceof FlowAnalSym)) continue;
                        lFlowAnalSym = (FlowAnalSym)node.getSym();
                        if (this.fDbgLevel >= 3) {
                            this.flow.dbg(5, "symNode", node.toStringShort());
                        }
                        if (lFlowAnalSym.getFlag(6)) {
                            remove = false;
                            break;
                        }
                        if (!(lFlowAnalSym instanceof Var) || !lFlowAnalSym.getSymType().isScalar()) {
                            remove = false;
                            break;
                        }
                        if (FlowAnalList.contains(lFlowAnalSym)) {
                            remove = false;
                            break;
                        }
                        if (lFlowAnalSym.isGlobal()) {
                            remove = false;
                            break;
                        }
                        if (!lUsedSyms.contains(lFlowAnalSym)) continue;
                        remove = false;
                        break;
                    }
                    if (remove && ((SetRefReprHirImpl)lSetRefRepr).getStmt() instanceof AssignStmt) {
                        if (this.fDbgLevel >= 3) {
                            this.flow.dbg(3, "removeStmt", ((SetRefReprHirImpl)lSetRefRepr).getStmt().toStringShort());
                        }
                        OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt());
                        lSetRefReprIt.remove();
                        lOptimized = true;
                        continue;
                    }
                    lNodeIt = FlowUtil.nodeListIterator(lSetRefRepr.getIR(), true, false);
                    while (lNodeIt.hasNext()) {
                        node = (HIR)lNodeIt.next();
                        if (!(node.getSym() instanceof FlowAnalSym)) continue;
                        lFlowAnalSym = (FlowAnalSym)node.getSym();
                        FlowAnalList.add(lFlowAnalSym);
                    }
                    continue;
                }
                if (lDefSym != null) {
                    lLive.resetBit(lDefSym.getIndex());
                }
                lLive.vectorOr(pBBlock.getExposed(), lLive);
                continue;
            }
            if (!lSetRefRepr.hasControl() && !lSetRefRepr.isReturn() && !lHasCall && ((SetRefReprHirImpl)lSetRefRepr).getStmt() instanceof AssignStmt) {
                OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt());
                lSetRefReprIt.remove();
                lOptimized = true;
                continue;
            }
            lLive.vectorOr(pBBlock.getExposed(), lLive);
        }
        return lOptimized;
    }

    private static boolean mayWriteToExternalAddress(SetRefRepr pSetRefRepr) {
        IR lDefNode = pSetRefRepr.defNode();
        return lDefNode != null && FlowUtil.mayBeExternalAddress(lDefNode);
    }
}

