/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.SymRoot;
import coins.aflow.FlowResults;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.opt.ConstFolding;
import coins.opt.Opt;
import coins.opt.OptError;
import coins.opt.OptUtil;
import coins.sym.BoolConst;
import coins.sym.Const;
import coins.sym.FloatConst;
import coins.sym.IntConst;
import coins.sym.Sym;
import coins.sym.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public strictfp class ConstFoldingHir
extends ConstFolding {
    public final HIR hir;
    public final Opt opt;

    public ConstFoldingHir(FlowResults pResults) {
        super(pResults);
        this.hir = this.flowRoot.hirRoot.hir;
        this.opt = new Opt(this.flowRoot);
        this.fSubpFlow.computeBBlockSetRefReprs();
    }

    boolean isConstNode(IR pIR) {
        return pIR instanceof ConstNode;
    }

    IR getChild1(IR pIR) {
        return pIR.getChild1();
    }

    IR getChild2(IR pIR) {
        return pIR.getChild2();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HIR foldUnary(HIR pParent, FlowRoot pFlowRoot) {
        ConstNode lNewConstNode;
        int lOpCode = pParent.getOperator();
        boolean lBoolResult = false;
        long lIntResult = 0L;
        double lFloatResult = 0.0;
        Type lType = pParent.getType();
        SymRoot lSymRoot = pFlowRoot.symRoot;
        Sym sym = lSymRoot.sym;
        ConstNode lConstNode = (ConstNode)pParent.getChild1();
        Const lConst = lConstNode.getConstSym().getConstSym();
        boolean lBoolVal = false;
        long lIntVal = 0L;
        double lFloatVal = 0.0;
        boolean lIsBasic = lType.isBasicType();
        boolean lIsBool = lType.getTypeKind() == 1;
        boolean lIsInt = pParent.getType().isInteger();
        boolean lIsFloat = pParent.getType().isFloating();
        boolean lChildIsBool = lConst.getSymType().getSymKind() == 1;
        boolean lChildIsInt = lConst.getSymType().isInteger();
        boolean lChildIsFloat = lConst.getSymType().isFloating();
        if (lType.getTypeKind() == 14) {
            return pParent;
        }
        if (lChildIsBool) {
            boolean bl = lBoolVal = lConst == lSymRoot.boolConstTrue;
        }
        if (lChildIsInt) {
            lIntVal = ConstFoldingHir.evaluateAsItsType((IntConst)lConst, lConst.getSymType());
        } else if (lChildIsFloat) {
            lFloatVal = ConstFoldingHir.evaluateAsItsType((FloatConst)lConst, lConst.getSymType());
        }
        switch (lOpCode) {
            case 16: 
            case 34: 
            case 36: 
            case 64: 
            case 66: {
                return pParent;
            }
            case 62: {
                lBoolResult = !lBoolVal;
                lIntResult = lIntVal ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 63: {
                lIntResult = -lIntVal;
                lFloatResult = -lFloatVal;
                break;
            }
            case 65: {
                return pParent;
            }
            default: {
                throw new OptError("Operator \"" + HIR.OP_CODE_NAME[lOpCode] + "\" not yet taken care of.");
            }
        }
        if (!lType.isFloating() && lType.getSizeValue() != 4L) {
            return pParent;
        }
        if (!lIsBasic) return pParent;
        if (lIsBool) {
            lNewConstNode = pFlowRoot.hirRoot.hir.constNode(lSymRoot.sym.boolConst(lBoolResult));
        } else if (lIsInt) {
            lNewConstNode = OptUtil.createConstNodeFromPrimitive(lIntResult, lType, pFlowRoot);
        } else {
            if (!lIsFloat) throw new OptError("Unexpected.");
            lNewConstNode = OptUtil.createConstNodeFromPrimitive(lFloatResult, lType, pFlowRoot);
        }
        OptUtil.replaceNode(pParent, lNewConstNode);
        return lNewConstNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HIR foldBinary(HIR pParent, FlowRoot pFlowRoot) {
        Type lType;
        Exp lNewExpNode;
        block95: {
            boolean lIsTrue0;
            boolean lIsTrue;
            boolean lIsFalse0;
            boolean lIsFalse;
            boolean lIsMinus10;
            boolean lIsMinus1;
            boolean lIsZero0;
            boolean lIsZero;
            boolean lIsOne0;
            boolean lIsOne;
            Const lConstSym0;
            Const lConstSym;
            SubpFlow lSubpFlow;
            boolean lIsSigned;
            int lOpCode;
            HIR lChild0;
            HIR lChild;
            SymRoot symRoot;
            HIR hir;
            block94: {
                hir = pFlowRoot.hirRoot.hir;
                symRoot = pFlowRoot.symRoot;
                Sym sym = symRoot.sym;
                lChild = (HIR)pParent.getChild1();
                lChild0 = (HIR)pParent.getChild2();
                lNewExpNode = null;
                lOpCode = pParent.getOperator();
                lType = pParent.getType();
                Type lChildType = lChild.getType();
                int lTypeKind = lType.getTypeKind();
                boolean lIsIntType = lType.isInteger();
                boolean lIsChildBoolType = lChildType.getTypeKind() == 1;
                boolean lIsChildIntType = lChildType.isInteger();
                lIsSigned = !lType.isUnsigned();
                lSubpFlow = pFlowRoot.fSubpFlow;
                if (lTypeKind == 14) {
                    return pParent;
                }
                ConstNode lConstNode = null;
                ConstNode lConstNode0 = null;
                lConstSym = null;
                lConstSym0 = null;
                boolean lTrivialCheck = false;
                boolean lTrivialCheck0 = false;
                lIsOne = false;
                lIsOne0 = false;
                lIsZero = false;
                lIsZero0 = false;
                lIsMinus1 = false;
                lIsMinus10 = false;
                lIsFalse = false;
                lIsFalse0 = false;
                lIsTrue = false;
                lIsTrue0 = false;
                if (lChild instanceof ConstNode) {
                    lConstNode = (ConstNode)lChild;
                    lConstSym = lConstNode.getConstSym();
                    lTrivialCheck = true;
                }
                if (lChild0 instanceof ConstNode) {
                    lConstNode0 = (ConstNode)lChild0;
                    lConstSym0 = lConstNode0.getConstSym();
                    lTrivialCheck0 = true;
                }
                if (!lTrivialCheck && !lTrivialCheck0) {
                    return pParent;
                }
                if (lTrivialCheck) {
                    if (lConstSym.equals(symRoot.boolConstFalse)) {
                        lIsFalse = true;
                    } else if (lConstSym.equals(symRoot.boolConstTrue)) {
                        lIsTrue = true;
                    } else if (ConstFoldingHir.IsZeroConst(lConstNode, symRoot)) {
                        lIsZero = true;
                    } else if (lConstSym.equals(symRoot.intConst1)) {
                        lIsOne = true;
                    } else if (lConstSym instanceof IntConst && ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) == -1L) {
                        lIsMinus1 = true;
                    }
                }
                if (lTrivialCheck0) {
                    if (lConstSym0.equals(symRoot.boolConstFalse)) {
                        lIsFalse0 = true;
                    } else if (lConstSym0.equals(symRoot.boolConstTrue)) {
                        lIsTrue0 = true;
                    } else if (ConstFoldingHir.IsZeroConst(lConstNode0, symRoot)) {
                        lIsZero0 = true;
                    } else if (lConstSym0.equals(symRoot.intConst1)) {
                        lIsOne0 = true;
                    } else if (lConstSym0 instanceof IntConst && ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lConstSym0.getSymType()) == -1L) {
                        lIsMinus10 = true;
                    }
                }
                if (!lTrivialCheck || !lTrivialCheck0) break block94;
                switch (lOpCode) {
                    case 17: 
                    case 22: 
                    case 67: 
                    case 71: {
                        return pParent;
                    }
                    case 38: {
                        if (!lIsIntType) return pParent;
                        long lIntResult = lConstSym.longValue() + lConstSym0.longValue();
                        lNewExpNode = hir.constNode(sym.intConst(lIntResult, lType));
                        break block95;
                    }
                    case 39: {
                        if (!lIsIntType) return pParent;
                        long lIntResult = lConstSym.longValue() - lConstSym0.longValue();
                        lNewExpNode = hir.constNode(sym.intConst(lIntResult, lType));
                        break block95;
                    }
                    case 41: {
                        if (!lIsIntType) return pParent;
                        long lIntResult = lConstSym.longValue() * lConstSym0.longValue();
                        lNewExpNode = hir.constNode(sym.intConst(lIntResult, lType));
                        break block95;
                    }
                    case 42: {
                        BigInteger lDividend;
                        long lIntResult;
                        if (!lIsIntType) return pParent;
                        if (lIsZero0) {
                            return pParent;
                        }
                        if (lIsSigned) {
                            lIntResult = ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lType) / ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lType);
                        } else {
                            if (!ConstFoldingHir.hasJavaPrimitive(lType)) return pParent;
                            lDividend = ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lType);
                            BigInteger lDivisor = ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lType);
                            lIntResult = lDividend.divide(lDivisor).longValue();
                        }
                        lNewExpNode = hir.constNode(sym.intConst(lIntResult, lType));
                        break block95;
                    }
                    case 43: {
                        long lIntResult;
                        BigInteger lDividend;
                        if (lIsZero0) {
                            return pParent;
                        }
                        if (lIsSigned) {
                            lIntResult = ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lType) % ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lType);
                        } else {
                            if (!ConstFoldingHir.hasJavaPrimitive(lType)) return pParent;
                            lDividend = ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lType);
                            BigInteger lDivisor = ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lType);
                            lIntResult = lDividend.remainder(lDivisor).longValue();
                        }
                        lNewExpNode = hir.constNode(sym.intConst(lIntResult, lType));
                        break block95;
                    }
                    case 46: {
                        long lIntResult = ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) & ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType);
                        lNewExpNode = lIsIntType ? hir.constNode(sym.intConst(lIntResult, lType)) : hir.constNode(sym.boolConst(lIntResult != 0L));
                        break block95;
                    }
                    case 47: {
                        long lIntResult = ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) | ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType);
                        lNewExpNode = lIsIntType ? hir.constNode(sym.intConst(lIntResult, lType)) : hir.constNode(sym.boolConst(lIntResult != 0L));
                        break block95;
                    }
                    case 48: {
                        long lIntResult = ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) ^ ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType);
                        lNewExpNode = lIsIntType ? hir.constNode(sym.intConst(lIntResult, lType)) : hir.constNode(sym.boolConst(lIntResult != 0L));
                        break block95;
                    }
                    case 51: {
                        boolean lBoolResult = lIsChildBoolType ? ((BoolConst)lConstSym).intValue() == ((BoolConst)lConstSym0).intValue() : (lIsChildIntType ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) == ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) == ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType));
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 52: {
                        boolean lBoolResult = lIsChildBoolType ? ((BoolConst)lConstSym).intValue() != ((BoolConst)lConstSym0).intValue() : (lIsChildIntType ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) != ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) != ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType));
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 53: {
                        boolean lBoolResult = lIsChildIntType ? (lIsSigned ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) > ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lChildType).compareTo(ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lChildType)) == 1) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) > ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType);
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 54: {
                        boolean lBoolResult = lIsChildIntType ? (lIsSigned ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) >= ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lChildType).compareTo(ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lChildType)) != -1) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) >= ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType);
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 55: {
                        boolean lBoolResult = lIsChildIntType ? (lIsSigned ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) < ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lChildType).compareTo(ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lChildType)) == -1) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) < ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType);
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 56: {
                        boolean lBoolResult = lIsChildIntType ? (lIsSigned ? ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym, lChildType) <= ConstFoldingHir.evaluateAsItsType((IntConst)lConstSym0, lChildType) : ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym, lChildType).compareTo(ConstFoldingHir.evaluateAsUnsigned((IntConst)lConstSym0, lChildType)) != 1) : ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym, lChildType) <= ConstFoldingHir.evaluateAsItsType((FloatConst)lConstSym0, lChildType);
                        lNewExpNode = hir.constNode(sym.boolConst(lBoolResult));
                        break block95;
                    }
                    case 58: 
                    case 59: 
                    case 60: {
                        return pParent;
                    }
                    default: {
                        throw new OptError("Operator " + HIR.OP_CODE_NAME[lOpCode] + "not yet taken care of.");
                    }
                }
            }
            switch (lOpCode) {
                case 22: 
                case 67: 
                case 71: {
                    return pParent;
                }
                case 17: {
                    return pParent;
                }
                case 38: {
                    if (lIsZero) {
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (!lIsZero0) return pParent;
                    lNewExpNode = (Exp)lChild;
                    break;
                }
                case 39: {
                    return pParent;
                }
                case 41: {
                    if (lIsZero) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = hir.constNode(lConstSym);
                        break;
                    }
                    if (lIsZero0) {
                        if (lSubpFlow.hasCallUnder(lChild)) {
                            return pParent;
                        }
                        lNewExpNode = hir.constNode(lConstSym0);
                        break;
                    }
                    if (lIsOne) {
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (lIsOne0) {
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (lIsMinus1) {
                        lNewExpNode = hir.exp(63, (Exp)lChild0);
                        break;
                    }
                    if (!lIsMinus10) return pParent;
                    lNewExpNode = hir.exp(63, (Exp)lChild);
                    break;
                }
                case 42: {
                    if (lIsZero0) {
                        return pParent;
                    }
                    if (lIsZero) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = hir.constNode(lConstSym);
                        break;
                    }
                    if (lIsOne0) {
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (!lIsMinus10 || !lIsSigned) return pParent;
                    lNewExpNode = hir.exp(63, (Exp)lChild);
                    break;
                }
                case 43: {
                    if (lIsZero0) {
                        return pParent;
                    }
                    if (lIsZero) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = hir.constNode(lConstSym);
                        break;
                    }
                    if (!lIsOne0 && (!lIsMinus10 || !lIsSigned)) return pParent;
                    if (lSubpFlow.hasCallUnder(lChild0)) {
                        return pParent;
                    }
                    lNewExpNode = hir.constNode(symRoot.intConst0);
                    break;
                }
                case 46: {
                    if (lIsFalse || lIsZero) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (lIsTrue || lIsMinus1) {
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (lIsFalse0 || lIsZero0) {
                        if (lSubpFlow.hasCallUnder(lChild)) {
                            return pParent;
                        }
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (!lIsTrue0 && !lIsMinus10) return pParent;
                    lNewExpNode = (Exp)lChild;
                    break;
                }
                case 47: {
                    if (lIsFalse || lIsZero) {
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (lIsTrue || lIsMinus1) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (lIsFalse0 || lIsZero0) {
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (!lIsTrue0 && !lIsMinus10) return pParent;
                    if (lSubpFlow.hasCallUnder(lChild)) {
                        return pParent;
                    }
                    lNewExpNode = (Exp)lChild0;
                    break;
                }
                case 48: {
                    if (lIsFalse || lIsZero) {
                        lNewExpNode = (Exp)lChild0;
                        break;
                    }
                    if (lIsTrue || lIsMinus1) {
                        lNewExpNode = hir.exp(62, (Exp)lChild0);
                        break;
                    }
                    if (lIsFalse0 || lIsZero0) {
                        lNewExpNode = (Exp)lChild;
                        break;
                    }
                    if (!lIsTrue0 && !lIsMinus10) return pParent;
                    lNewExpNode = hir.exp(62, (Exp)lChild);
                    break;
                }
                case 58: 
                case 59: 
                case 60: {
                    if (lIsZero) {
                        if (lSubpFlow.hasCallUnder(lChild0)) {
                            return pParent;
                        }
                        lNewExpNode = hir.constNode(lConstSym);
                        break;
                    }
                    if (!lIsZero0) return pParent;
                    lNewExpNode = (Exp)lChild;
                    break;
                }
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    return pParent;
                }
                default: {
                    throw new OptError("Operator " + HIR.OP_CODE_NAME[lOpCode] + "not yet taken care of.");
                }
            }
        }
        Const llConst = lNewExpNode.getConstSym();
        if (llConst != null && (!llConst.getSymType().isFloating() && lType.getSizeValue() != 4L || lType.getTypeKind() == 1)) {
            return pParent;
        }
        OptUtil.replaceNode(pParent, lNewExpNode);
        return lNewExpNode;
    }

    private static long evaluateAsItsType(IntConst pConst, Type pType) {
        switch ((int)pType.getSizeValue()) {
            case 1: {
                return (byte)pConst.longValue();
            }
            case 2: {
                return pConst.shortValue();
            }
            case 4: {
                return pConst.intValue();
            }
            case 8: {
                return pConst.longValue();
            }
        }
        throw new OptError();
    }

    private static double evaluateAsItsType(FloatConst pConst, Type pType) {
        switch ((int)pType.getSizeValue()) {
            case 4: {
                return pConst.floatValue();
            }
            case 8: {
                return pConst.doubleValue();
            }
        }
        throw new OptError();
    }

    private static double evaluateAsFloatType(long pLong, Type pType) {
        switch ((int)pType.getSizeValue()) {
            case 4: {
                return pLong;
            }
            case 8: {
                return pLong;
            }
        }
        throw new OptError();
    }

    private static long evaluateAsIntType(double pDouble, Type pType) {
        BigInteger lBigInt = new BigDecimal(pDouble).toBigInteger();
        switch ((int)pType.getSizeValue()) {
            case 1: {
                return lBigInt.byteValue();
            }
            case 2: {
                return lBigInt.shortValue();
            }
            case 4: {
                return lBigInt.intValue();
            }
            case 8: {
                return lBigInt.longValue();
            }
        }
        throw new OptError();
    }

    private static BigInteger evaluateAsUnsigned(IntConst pConst, Type pType) {
        String lMask;
        switch ((int)pType.getSizeValue()) {
            case 1: {
                lMask = "ff";
                break;
            }
            case 2: {
                lMask = "ffff";
                break;
            }
            case 4: {
                lMask = "ffffffff";
                break;
            }
            case 8: {
                lMask = "ffffffffffffffff";
                break;
            }
            default: {
                throw new OptError();
            }
        }
        return BigInteger.valueOf(pConst.longValue()).and(new BigInteger(lMask, 16));
    }

    private static boolean hasJavaPrimitive(Type pType) {
        switch ((int)pType.getSizeValue()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean IsZeroConst(ConstNode pConstNode, SymRoot symRoot) {
        Const lConstSym = null;
        lConstSym = pConstNode.getConstSym();
        if (lConstSym.equals(symRoot.doubleConst0)) {
            return true;
        }
        if (lConstSym.equals(symRoot.floatConst0)) {
            return true;
        }
        if (lConstSym.equals(symRoot.intConst0)) {
            return true;
        }
        if (lConstSym.equals(symRoot.longConst0)) {
            return true;
        }
        Type lType = pConstNode.getType();
        if (lType.isInteger() && lConstSym.longValue() == 0L) {
            return true;
        }
        return lType.isUnsigned() && lConstSym.longValue() == 0L;
    }
}

