/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.aflow.BBlock;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import java.util.Iterator;
import java.util.LinkedList;

class Util {
    private MdfEnvironment env;
    private MacroFlowGraph mfg;

    Util(MdfEnvironment e, MacroFlowGraph g) {
        this.env = e;
        this.mfg = g;
    }

    LinkedList findPreBlks(MacroTask mt, LinkedList list) {
        if (mt == null || list.contains(mt)) {
            return list;
        }
        list.add(mt);
        Iterator ite = mt.predList.iterator();
        while (ite.hasNext()) {
            list = this.findPreBlks((MacroTask)ite.next(), list);
        }
        return list;
    }

    LinkedList findPostBlks(MacroTask mt, LinkedList list) {
        if (mt == null || list.contains(mt)) {
            return list;
        }
        list.add(mt);
        Iterator ite = mt.succList.iterator();
        while (ite.hasNext()) {
            list = this.findPostBlks((MacroTask)ite.next(), list);
        }
        return list;
    }

    LinkedList findMtPreBlks(MacroTask mt, BBlock blk, LinkedList list) {
        if (list.contains(blk) || this.mfg.macroTask(blk) != mt) {
            return list;
        }
        list.add(blk);
        Iterator ite = blk.getPredList().iterator();
        while (ite.hasNext()) {
            list = this.findMtPreBlks(mt, (BBlock)ite.next(), list);
        }
        return list;
    }

    int vectorSize() {
        int arraySize = this.numberOfConditions();
        int vectSize = arraySize / this.wordSize();
        if (arraySize % this.wordSize() != 0) {
            ++vectSize;
        }
        return vectSize;
    }

    int wordSize() {
        return this.env.ioRoot.machineParam.evaluateSize(4) * 8;
    }

    int numberOfConditions() {
        int number = this.mfg.bound();
        return number += this.mfg.controlBranch.size();
    }
}

