/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.ir.hir.HIR;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfConditions;
import coins.mdf.MdfEnvironment;
import coins.mdf.TreatNode;
import coins.sym.Label;
import java.util.LinkedList;
import java.util.Stack;

class TreatLoop
extends TreatNode {
    private LoopStmt node;
    private MdfConditions cond;

    TreatLoop(MdfEnvironment e, MacroFlowGraph g, LoopStmt stmt, LinkedList list, MdfConditions c) {
        super(e, g, list, stmt);
        this.cond = c;
        this.node = stmt;
    }

    TreatLoop(MdfEnvironment e, MacroFlowGraph g, LoopStmt stmt, LinkedList list) {
        super(e, g, list, stmt);
        this.cond = null;
        this.node = stmt;
    }

    void replace(MacroTask mt, Label label) {
        LinkedList labelsInLoop = this.getLabelsInLoop(this.node, new LinkedList());
        LinkedList<HIR> check = new LinkedList<HIR>();
        Stmt stmt = this.node.getLoopBodyPart();
        Stack<HIR> stack = new Stack<HIR>();
        stack.push(stmt);
        check.add(stmt);
        while (!stack.empty()) {
            stmt = (Stmt)stack.pop();
            if (stmt instanceof JumpStmt) {
                JumpStmt jump = (JumpStmt)stmt;
                Label lab = jump.getLabel();
                if (label == lab || mt.taskNumber() == this.mfg.macroTask(lab).taskNumber()) continue;
                jump.changeJumpLabel(label);
                if (mt.succList.size() == 1) {
                    Stmt assign = this.cond.finish.finishCond(mt, null);
                    Stmt inserted = jump.insertPreviousStmt(assign);
                    continue;
                }
                MacroTask dst = this.mfg.macroTask(lab);
                Stmt assign = this.cond.finish.finishCond(mt, dst);
                jump.insertPreviousStmt(assign);
                continue;
            }
            if (stmt instanceof ReturnStmt) {
                this.env.output.println("find");
                continue;
            }
            for (int i = 1; i <= stmt.getChildCount(); ++i) {
                HIR child = (HIR)stmt.getChild(i);
                if (child == null || !(child instanceof Stmt) || check.contains(child)) continue;
                check.add(child);
                stack.push(child);
            }
            while (stmt.getNextStmt() != null) {
                if (check.contains(stmt = stmt.getNextStmt())) continue;
                check.add(stmt);
                stack.push(stmt);
            }
        }
    }

    LinkedList getLabelsInLoop(HIR child, LinkedList list) {
        if (child == null) {
            return list;
        }
        if (child instanceof LabeledStmt) {
            list.add(child);
        }
        for (int i = 1; i <= child.getChildCount(); ++i) {
            list = this.getLabelsInLoop((HIR)child.getChild(i), list);
        }
        list = this.getLabelsInLoop(child.getNextStmt(), list);
        return list;
    }
}

