/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.ir.hir.BlockStmt;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfConditions;
import coins.mdf.MdfEnvironment;
import coins.mdf.TreatNode;
import coins.sym.Label;
import java.util.LinkedList;

class TreatIf
extends TreatNode {
    private IfStmt node;
    private MdfConditions cond;

    TreatIf(MdfEnvironment e, MacroFlowGraph g, IfStmt stmt, LinkedList list, MdfConditions c) {
        super(e, g, list, stmt);
        this.cond = c;
        this.node = stmt;
    }

    void replace(MacroTask mt, Label label) {
        if (this.isChange(mt, this.node.getThenPart().getLabel())) {
            this.replacePart(mt, label, true);
        }
        if (this.isChange(mt, this.node.getElsePart().getLabel())) {
            this.replacePart(mt, label, false);
        }
    }

    private void replacePart(MacroTask src, Label label, boolean isThen) {
        BlockStmt blk = this.makeJumpBlk(label);
        LabeledStmt part = null;
        part = isThen ? this.node.getThenPart() : this.node.getElsePart();
        if (src.succList.size() > 1) {
            MacroTask dst = this.mfg.macroTask(part.getLabel());
            Stmt assign = this.cond.finish.finishCond(src, dst);
            blk.addBeforeBranchStmt(assign);
        } else {
            Stmt assign = this.cond.finish.finishCond(src, null);
            blk.addBeforeBranchStmt(assign);
        }
        Label newLab = this.symTab.generateLabel();
        LabeledStmt newLabStmt = blk.attachLabel(newLab);
        if (isThen) {
            this.node.replaceThenPart(newLabStmt);
        } else {
            this.node.replaceElsePart(newLabStmt);
        }
    }
}

