/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

class PostDominators {
    private MacroFlowGraph mfg;
    private MdfEnvironment env;
    public final int[][] pdom;

    PostDominators(MdfEnvironment e, MacroFlowGraph graph) {
        this.env = e;
        this.mfg = graph;
        this.pdom = new int[this.mfg.bound()][this.mfg.bound()];
        for (int i = 0; i < this.mfg.bound(); ++i) {
            for (int j = 0; j < this.mfg.bound(); ++j) {
                this.pdom[i][j] = 0;
            }
        }
        List exitBlks = this.mfg.exitBlks();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            if (exitBlks.contains(mt)) {
                this.pdom[mt.taskNumber()][mt.taskNumber()] = 1;
                continue;
            }
            for (int i = 0; i < this.mfg.bound(); ++i) {
                this.pdom[mt.taskNumber()][i] = 1;
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator ite2 = exitBlks.iterator();
            while (ite2.hasNext()) {
                LinkedList<MacroTask> visited = new LinkedList<MacroTask>();
                MacroTask mt = (MacroTask)ite2.next();
                Stack<MacroTask> stack = new Stack<MacroTask>();
                stack.push(mt);
                visited.add(mt);
                while (!stack.empty()) {
                    mt = (MacroTask)stack.pop();
                    for (MacroTask succ : mt.succList) {
                        for (int i = 0; i < this.mfg.bound(); ++i) {
                            if (i == mt.taskNumber() || this.pdom[mt.taskNumber()][i] != 1 || this.pdom[mt.taskNumber()][i] == this.pdom[succ.taskNumber()][i]) continue;
                            this.pdom[mt.taskNumber()][i] = 0;
                            changed = true;
                        }
                    }
                    for (MacroTask pred : mt.predList) {
                        if (visited.contains(pred)) continue;
                        stack.push(pred);
                        visited.add(pred);
                    }
                }
            }
        }
    }

    void print() {
        for (int i = 0; i < this.mfg.bound(); ++i) {
            this.env.output.print("MT[" + i + "] ");
            for (int j = 0; j < this.mfg.bound(); ++j) {
                this.env.output.print(this.pdom[i][j]);
            }
            this.env.output.println();
        }
    }
}

