/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.aflow.BBlock;
import coins.aflow.SubpFlow;
import coins.mdf.MdfEnvironment;
import java.util.LinkedList;
import java.util.Stack;

class FindScc {
    final LinkedList scc;
    private MdfEnvironment env;
    private int nextDfsNum;
    private int idBound;
    private int[] dfsNum;
    private int[] low;
    private Stack stack;

    FindScc(MdfEnvironment e, SubpFlow subpFlow) {
        this.env = e;
        this.scc = new LinkedList();
        this.nextDfsNum = 0;
        this.idBound = subpFlow.getBBlockTable().size() + 1;
        this.dfsNum = new int[this.idBound];
        this.low = new int[this.idBound];
        for (int i = 0; i < this.idBound; ++i) {
            this.dfsNum[i] = -1;
            this.low[i] = -1;
        }
        this.stack = new Stack();
        for (BBlock blk : subpFlow.getBBlocks()) {
            if (this.dfsNum[blk.getBBlockNumber()] != -1) continue;
            this.dfs(blk);
        }
    }

    private void dfs(BBlock blk) {
        this.dfsNum[blk.getBBlockNumber()] = this.nextDfsNum;
        this.low[blk.getBBlockNumber()] = this.nextDfsNum++;
        this.stack.push(blk);
        for (BBlock succ : blk.getSuccList()) {
            if (this.dfsNum[succ.getBBlockNumber()] == -1) {
                this.dfs(succ);
                if (this.low[blk.getBBlockNumber()] > this.low[succ.getBBlockNumber()]) {
                    this.low[blk.getBBlockNumber()] = this.low[succ.getBBlockNumber()];
                }
            }
            if (this.dfsNum[succ.getBBlockNumber()] >= this.dfsNum[blk.getBBlockNumber()] || !this.stack.contains(succ) || this.dfsNum[succ.getBBlockNumber()] >= this.low[blk.getBBlockNumber()]) continue;
            this.low[blk.getBBlockNumber()] = this.dfsNum[succ.getBBlockNumber()];
        }
        if (this.low[blk.getBBlockNumber()] == this.dfsNum[blk.getBBlockNumber()]) {
            LinkedList<BBlock> sccElem = new LinkedList<BBlock>();
            BBlock b = null;
            do {
                b = (BBlock)this.stack.pop();
                sccElem.addFirst(b);
            } while (b != blk);
            this.scc.addFirst(sccElem);
        }
    }

    void print() {
        for (LinkedList elem : this.scc) {
            this.env.output.print("SCC :");
            for (BBlock blk : elem) {
                this.env.output.print(" " + blk.getBBlockNumber() + "(" + blk.getLabel().getName() + ")");
            }
            this.env.output.println();
        }
    }
}

