/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.HirRoot;
import coins.IoRoot;
import coins.aflow.BBlock;
import coins.aflow.DefUseCell;
import coins.aflow.DefUseList;
import coins.aflow.Flow;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorImpl;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import coins.aflow.UDChain;
import coins.aflow.UDList;
import coins.ir.IR;
import coins.ir.IR0;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpImpl;
import coins.ir.hir.HIR;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.lparallel.ArrayAreaAnalyzer;
import coins.lparallel.BasicInduction;
import coins.lparallel.CheckLoopBody;
import coins.lparallel.IndExp;
import coins.lparallel.Invariant;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import coins.lparallel.PreDefinedFunctions;
import coins.lparallel.Reduction;
import coins.lparallel.RefArrayCell;
import coins.lparallel.Ref_Array;
import coins.lparallel.Ref_Table;
import coins.lparallel.RegionOpImpl;
import coins.sym.Const;
import coins.sym.FlowAnalSym;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class FindLoopParallel
extends FlowAdapter {
    private SubpFlow fSubpFlow;
    private BBlock LoopBackBodyBBlock;
    private BBlock EntryBodyBBlock;
    private BBlock ExitBodyBBlock;
    private IoRoot ioRoot;
    private ArrayAreaAnalyzer ArrayAnalysis;
    private HirRoot HirRoot;
    private HIR hir;
    private LoopTable fLoopTable;
    private LoopUtil fUtil;
    private CheckLoopBody fCheckLoopBody;
    private Flow fFlow;
    protected PreDefinedFunctions predefinedFunctions;
    private Set fTraversedBBlocks;

    public FindLoopParallel(FlowResults pResults) {
        super(pResults);
        this.fFlow = pResults.flowRoot.aflow;
        this.ioRoot = pResults.flowRoot.ioRoot;
        this.predefinedFunctions = new PreDefinedFunctions(pResults.flowRoot.symRoot.sourceLanguage);
    }

    public void find(SubpFlow pSubpFlow, LoopTable pLoopTable) {
        this.ioRoot.dbgPara1.print(1, "\nFindLoopParallel.find " + pSubpFlow.getSubpSym().getName());
        this.fLoopTable = pLoopTable;
        this.fSubpFlow = pSubpFlow;
        if (this.fLoopTable.analysis_flag) {
            return;
        }
        this.fUtil = new LoopUtil(this.fResults, this.fSubpFlow);
        this.fCheckLoopBody = new CheckLoopBody(this.fLoopTable, this.fUtil);
        this.HirRoot = this.fResults.flowRoot.hirRoot;
        this.hir = this.fResults.flowRoot.hirRoot.hir;
        this.LoopBackBodyBBlock = this.fResults.getBBlockForLabel(this.fLoopTable.LoopStmt.getLoopBackLabel());
        this.EntryBodyBBlock = this.fResults.getBBlockForLabel(this.fLoopTable.LoopStmt.getLoopBodyLabel());
        this.ExitBodyBBlock = this.fResults.getBBlockForLabel(this.fLoopTable.LoopStmt.getLoopStepLabel());
        this.fUtil.getLoopBBlockList(this.fLoopTable.BBlockList, this.LoopBackBodyBBlock, this.ExitBodyBBlock, this.EntryBodyBBlock);
        this.ArrayAnalysis = new ArrayAreaAnalyzer(this.hir, this.fUtil);
        this.ArrayAnalysis.setLoopExitBBlock(this.ExitBodyBBlock);
        this.ArrayAnalysis.setFlowResults(this.fResults);
        RegionOpImpl regOp = new RegionOpImpl();
        this.ArrayAnalysis.setRegOp(regOp);
        boolean para_flag = true;
        ListIterator Ie = this.fLoopTable.InnerLoopList.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            this.fResults.get("LoopParallel", pSubpFlow, lTable);
            if (lTable.analysis_flag) continue;
            para_flag = false;
        }
        this.fUtil.TraceFlag = this.fLoopTable.OuterLoop == null;
        this.fUtil.TraceFlag = true;
        this.fUtil.Trace("---pass:Find---------------------------------", 1);
        this.fUtil.Trace("---pass:Find:NestLevel=" + pLoopTable.fNestLevel, 1);
        this.fUtil.Trace("---pass:Find:For=" + pLoopTable.LoopStmt.toString(), 1);
        this.fUtil.Trace("---pass:Find:Entry=" + this.EntryBodyBBlock.getBBlockNumber(), 1);
        this.fUtil.Trace("---pass:Find:InnerLoop=" + pLoopTable.InnerLoop, 1);
        this.fUtil.Trace("---pass:Find---------------------------------", 1);
        if (para_flag) {
            this.fUtil.Trace("para_flag == true", 5);
            if (this.fCheckLoopBody.HIR_CheckLoopBody()) {
                this.fUtil.Trace("CheckLoopBody == true", 5);
                this.fUtil.getLoopInnerBBlockList(this.fLoopTable);
                if (this.CheckLoop()) {
                    this.fUtil.TraceBBlockList(this.fLoopTable);
                    this.invariant();
                    this.induction();
                    this.fLoopTable.DebugInductionList(this.fUtil);
                    this.reduction();
                    if (this.para_loop()) {
                        this.Normalize_loopIndex();
                        this.fLoopTable.DebugInductionList(this.fUtil);
                        if (this.make_ref()) {
                            this.make_BlockRef();
                            this.ParallelCheck();
                            this.OpenMPCheck();
                        }
                        this.fLoopTable.analysis_flag = true;
                    }
                } else {
                    this.fLoopTable.setParaFlag(this.fUtil, false, "CheckLoop");
                }
            } else {
                this.fLoopTable.setParaFlag(this.fUtil, false, "CheckLoopBody");
            }
        } else {
            this.fLoopTable.setParaFlag(this.fUtil, false, "(para_flag == false)");
        }
        this.fResults.put("LoopParallel", pSubpFlow, this.fLoopTable);
        if (this.ioRoot.dbgPara1.getLevel() > 1) {
            this.ioRoot.dbgPara1.print(3, "\nput LoopParallel " + this.fLoopTable);
            this.fLoopTable.print(pLoopTable.fNestLevel);
        }
    }

    private boolean CheckLoop() {
        this.fUtil.Trace("---pass:CheckLoop", 1);
        this.fUtil.Trace("pass:CheckLoop BBlockSize= " + this.fLoopTable.InnerBBlockList.size(), 5);
        ListIterator Ie = this.fLoopTable.InnerBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock CurrBlock = (BBlock)Ie.next();
            this.fUtil.Trace("---pass:CheckLoop:" + CurrBlock.toString(), 5);
            if (CurrBlock == this.LoopBackBodyBBlock || CurrBlock == this.ExitBodyBBlock) continue;
            List SuccList = CurrBlock.getSuccList();
            ListIterator Ie1 = SuccList.listIterator();
            while (Ie1.hasNext()) {
                BBlock Succ = (BBlock)Ie1.next();
                if (this.fLoopTable.BBlockList.contains(Succ)) continue;
                this.fUtil.Trace("---pass:CheckLoop:SUCC" + Succ.toString(), 1);
                return false;
            }
            List PredList = CurrBlock.getPredList();
            ListIterator Ie2 = PredList.listIterator();
            while (Ie2.hasNext()) {
                BBlock Pred = (BBlock)Ie2.next();
                if (this.fLoopTable.BBlockList.contains(Pred)) continue;
                this.fUtil.Trace("---pass:CheckLoop:Pred" + Pred.getLabel().toString(), 1);
                return false;
            }
        }
        if (!this.fLoopTable.BBlockList.contains(this.ExitBodyBBlock)) {
            this.fUtil.Trace("Exit BBlock=" + this.ExitBodyBBlock, 1);
            ListIterator Ie3 = this.fLoopTable.BBlockList.listIterator();
            while (Ie3.hasNext()) {
                BBlock DebugB = (BBlock)Ie3.next();
                this.fUtil.Trace("CheckBody BBlock=" + DebugB.getBBlockNumber(), 1);
            }
            return false;
        }
        return true;
    }

    private boolean para_loop() {
        boolean loop_ctr = false;
        this.fUtil.Trace("---pass:para_loop", 1);
        for (BasicInduction IndTable : this.fLoopTable.IndList) {
            if (!IndTable.loop_ctr) continue;
            loop_ctr = true;
            break;
        }
        if (!loop_ctr) {
            this.fUtil.Trace("PARA_LOOP=false1", 5);
            return false;
        }
        this.fUtil.Trace("para_loop=true", 5);
        return this.exit_cont();
    }

    private boolean exit_cont() {
        this.fUtil.Trace("---pass:exit_cont", 1);
        Exp Cond = this.fLoopTable.LoopStmt.getLoopStartCondition();
        if (Cond == null) {
            return false;
        }
        int op = Cond.getOperator();
        boolean para_flag = false;
        Exp Exp1 = this.fUtil.SkipConv(Cond.getExp1());
        Exp Exp2 = this.fUtil.SkipConv(Cond.getExp2());
        Exp finalExp = null;
        switch (op) {
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                if (this.fLoopTable.fInv.IsInvariant(Exp1)) {
                    para_flag = true;
                    finalExp = Exp1;
                    break;
                }
                if (!this.fLoopTable.fInv.IsInvariant(Exp2)) break;
                para_flag = true;
                finalExp = Exp2;
            }
        }
        if (para_flag) {
            this.fLoopTable.finalExp = finalExp;
            this.setFinalExp(finalExp, this.fLoopTable.finalExpList);
        }
        return para_flag;
    }

    private void setFinalExp(Exp finalNode, LinkedList finalList) {
        int ChildCount = finalNode.getChildCount();
        if (ChildCount == 0) {
            if (this.fUtil.IsVarNode(finalNode)) {
                finalList.add(finalNode);
            }
        } else {
            for (int i = 1; i <= ChildCount; ++i) {
                HIR ChildNode = (HIR)finalNode.getChild(i);
                if (!(ChildNode instanceof Exp)) continue;
                this.setFinalExp((Exp)ChildNode, finalList);
            }
        }
    }

    private void invariant() {
        this.fUtil.Trace("---pass:invariant", 1);
        this.fLoopTable.fInv = new Invariant(this.fLoopTable, this.fSubpFlow, this.fResults, this.fUtil);
    }

    private void Normalize_loopIndex() {
        this.fUtil.Trace("---pass:Normalize_loopIndex", 1);
        BasicInduction IndTable = this.fLoopTable.LoopCtrInduction;
        this.fLoopTable.repeat_no_normalize = this.fLoopTable.repeat_no_value;
        boolean LastData = true;
        Exp Cond = this.fLoopTable.LoopStmt.getLoopStartCondition();
        int op = Cond.getOperator();
        this.fLoopTable.zero_check = false;
        if (IndTable.InitConstValue != 0L || !IndTable.InitConstFlag || IndTable.inc != 1L || op != 55) {
            BasicInduction CtrIndTable;
            SubpDefinition subp = this.fSubpFlow.getSubpDefinition();
            SymTable LocalSymTable = subp.getSubpSym().getSymTable();
            Var tmpVar = LocalSymTable.generateVar(IndTable.DefVarNode.getType(), subp.getSubpSym());
            tmpVar.setSymType(IndTable.DefVarNode.getType());
            this.fLoopTable.addInit = this.hir.assignStmt(this.hir.varNode(tmpVar), this.hir.intConstNode(0));
            if (IndTable.InitConstFlag && this.fLoopTable.const_repeat_no) {
                long e1 = IndTable.InitConstValue;
                long e2 = this.fLoopTable.repeat_no_value;
                long e3 = IndTable.inc;
                long e4 = this.GetCondition_No(e1, e2, e3);
                this.fLoopTable.addCond = new ExpImpl(this.HirRoot, 55, this.hir.varNode(tmpVar), this.hir.intConstNode((int)e4));
                this.fLoopTable.repeat_no_normalize = e4;
            } else {
                SymNode e1 = IndTable.InitConstFlag ? this.hir.intConstNode((int)IndTable.InitConstValue) : this.hir.varNode(IndTable.InitConstNode.getVar());
                Exp e2 = this.fLoopTable.const_repeat_no ? this.hir.intConstNode((int)this.fLoopTable.repeat_no_value) : (Exp)this.fLoopTable.finalExp.copyWithOperands();
                Exp e4 = this.GetCondition_Exp(e1, e2, IndTable.inc);
                this.fLoopTable.addCond = new ExpImpl(this.HirRoot, 55, this.hir.varNode(tmpVar), e4);
            }
            this.fUtil.Trace("---pass:Normalize_loopIndex(ADDSTEP)", 1);
            VarNode Def = this.hir.varNode(tmpVar);
            VarNode Use = this.hir.varNode(tmpVar);
            this.fLoopTable.addStep = this.hir.assignStmt(Def, new ExpImpl(this.HirRoot, 38, Use, this.hir.intConstNode(1)));
            IndTable.loop_ctr = false;
            this.fLoopTable.LoopCtrInduction = CtrIndTable = new BasicInduction((AssignStmt)this.fLoopTable.addStep, Def, Use, 1L);
            this.fLoopTable.IndList.add(CtrIndTable);
            CtrIndTable.InitConstFlag = true;
            CtrIndTable.InitConstValue = 0L;
            CtrIndTable.loop_ctr = true;
        }
        this.fUtil.Trace("repeat_no_normalize =" + this.fLoopTable.repeat_no_normalize, 5);
        this.fLoopTable.LoopCtrInduction.LastConstValue = this.fLoopTable.repeat_no_normalize - 1L;
        this.fUtil.Trace("LastConstValue=" + this.fLoopTable.LoopCtrInduction.LastConstValue, 5);
        this.fUtil.Trace("LastData=" + LastData, 5);
        if (this.fLoopTable.const_repeat_no) {
            this.SetInductionLastData();
        }
        if (this.fLoopTable.repeat_no_normalize > 0L && this.fLoopTable.LoopCtrInduction.InitConstFlag) {
            this.fLoopTable.zero_check = true;
        }
    }

    private long GetCondition_No(long e1, long e2, long e3) {
        this.fUtil.Trace("---pass:GetCondition_No", 1);
        boolean IsEqu = false;
        Exp Cond = this.fLoopTable.LoopStmt.getLoopStartCondition();
        int op = Cond.getOperator();
        this.fUtil.Trace("---pass:GetCondition_No op= " + op, 1);
        if (op == 54 || op == 56) {
            IsEqu = true;
        }
        long e4 = IsEqu ? (e2 - e1) / e3 + 1L : (long)Math.ceil((double)(e2 - e1) / (double)e3);
        return e4;
    }

    private Exp GetCondition_Exp(Exp pE1, Exp pE2, long e3) {
        ExpImpl e4Exp;
        Exp e1 = (Exp)pE1.copyWithOperands();
        Exp e2 = (Exp)pE2.copyWithOperands();
        boolean IsEqu = false;
        this.fUtil.Trace("---pass:GetCondition_Exp", 1);
        Exp Cond = this.fLoopTable.LoopStmt.getLoopStartCondition();
        int op = Cond.getOperator();
        ConstNode e3Exp = this.hir.intConstNode((int)e3);
        if (op == 54 || op == 56) {
            IsEqu = true;
        }
        if (IsEqu) {
            if (e3 == 1L) {
                ++this.fLoopTable.repeat_no_normalize;
                e4Exp = new ExpImpl(this.HirRoot, 38, new ExpImpl(this.HirRoot, 39, e2, e1), this.hir.intConstNode(1));
            } else if (e3 == -1L) {
                this.fLoopTable.repeat_no_normalize *= -1L;
                ++this.fLoopTable.repeat_no_normalize;
                e4Exp = new ExpImpl(this.HirRoot, 38, new ExpImpl(this.HirRoot, 42, new ExpImpl(this.HirRoot, 39, e2, e1), e3Exp), this.hir.intConstNode(1));
            } else {
                ++this.fLoopTable.repeat_no_normalize;
                e4Exp = new ExpImpl(this.HirRoot, 38, new ExpImpl(this.HirRoot, 42, new ExpImpl(this.HirRoot, 39, e2, e1), e3Exp), this.hir.intConstNode(1));
            }
        } else if (e3 == 1L) {
            e4Exp = new ExpImpl(this.HirRoot, 39, e2, e1);
        } else if (e3 == -1L) {
            this.fLoopTable.repeat_no_normalize *= -1L;
            e4Exp = new ExpImpl(this.HirRoot, 39, e1, e2);
        } else {
            e4Exp = new ExpImpl(this.HirRoot, 42, new ExpImpl(this.HirRoot, 38, new ExpImpl(this.HirRoot, 38, new ExpImpl(this.HirRoot, 39, e2, e1), e3Exp), this.hir.intConstNode(-1)), e3Exp);
        }
        this.fUtil.Trace(" e4Exp " + e4Exp.toStringWithChildren(), 3);
        return e4Exp;
    }

    private void SetInductionLastData() {
        long LastValue = 0L;
        this.fUtil.Trace("---pass:SetInductionLastData", 1);
        if (!this.fLoopTable.const_repeat_no) {
            return;
        }
        LastValue = this.fLoopTable.LoopCtrInduction.LastConstValue;
        ListIterator Ie = this.fLoopTable.IndList.listIterator();
        while (Ie.hasNext()) {
            BasicInduction IndTable = (BasicInduction)Ie.next();
            IndTable.SetInductionLastData(LastValue, this.fUtil);
        }
    }

    private void induction() {
        this.fUtil.Trace("---pass:induction", 1);
        ListIterator Ie = this.fLoopTable.InnerBBlockList.listIterator();
        block0: while (Ie.hasNext()) {
            BBlock CurrBlock = (BBlock)Ie.next();
            this.fUtil.Trace("inductionBBlock =" + CurrBlock.getBBlockNumber(), 1);
            if (!this.fUtil.dom_check(CurrBlock, this.ExitBodyBBlock)) continue;
            SetRefReprList llist = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", CurrBlock);
            for (SetRefRepr lSetRefRepr : llist) {
                Const ConstSym;
                Exp Exp2;
                Exp Exp1;
                IR IRnode = lSetRefRepr.getIR();
                boolean ind_flag = false;
                long inc = 0L;
                if (IRnode == null) continue block0;
                if (IRnode.getOperator() != 22) continue;
                Exp LeftExp = ((AssignStmt)IRnode).getLeftSide();
                Exp RightExp = ((AssignStmt)IRnode).getRightSide();
                LeftExp = this.fUtil.SkipConv(LeftExp);
                RightExp = this.fUtil.SkipConv(RightExp);
                int Op2 = RightExp.getOperator();
                this.fUtil.Trace("Debug IR=" + IRnode.toString(), 1);
                this.fUtil.Trace("Debug Left=" + LeftExp.toString(), 1);
                if (!this.fUtil.IsVarNode(LeftExp)) continue;
                this.fUtil.Trace("Debug LeftOp=" + LeftExp.getOperator(), 1);
                if (!this.fUtil.def_check(this.fLoopTable, (AssignStmt)IRnode)) continue;
                this.fUtil.Trace("Debug LeftOp2=" + LeftExp.getOperator(), 1);
                VarNode DefVarNode = (VarNode)LeftExp;
                VarNode UseVarNode = null;
                if (Op2 == 38) {
                    Exp1 = this.fUtil.SkipConv(RightExp.getExp1());
                    Exp2 = this.fUtil.SkipConv(RightExp.getExp2());
                    if (this.fUtil.IsVarNode(Exp1)) {
                        if (DefVarNode.getVar() != Exp1.getVar() || Exp2.getOperator() != 5) continue;
                        UseVarNode = (VarNode)Exp1;
                        ConstSym = ((ConstNode)Exp2).getConstSym();
                        if (!ConstSym.getSymType().isInteger()) continue;
                        inc = ConstSym.intValue();
                        ind_flag = true;
                    } else {
                        if (DefVarNode.getVar() != Exp2.getVar() || Exp1.getOperator() != 5) continue;
                        UseVarNode = (VarNode)Exp2;
                        ConstSym = ((ConstNode)Exp1).getConstSym();
                        if (!ConstSym.getSymType().isInteger()) continue;
                        inc = ConstSym.intValue();
                        ind_flag = true;
                    }
                } else {
                    if (Op2 != 39) continue;
                    Exp1 = this.fUtil.SkipConv(RightExp.getExp1());
                    Exp2 = this.fUtil.SkipConv(RightExp.getExp2());
                    if (this.fUtil.IsVarNode(Exp1)) {
                        if (DefVarNode.getVar() != Exp1.getVar() || Exp2.getOperator() != 5) continue;
                        UseVarNode = (VarNode)Exp1;
                        ConstSym = ((ConstNode)Exp2).getConstSym();
                        if (!ConstSym.getSymType().isInteger()) continue;
                        inc = ConstSym.intValue() * -1;
                        ind_flag = true;
                    } else {
                        if (DefVarNode.getVar() != Exp2.getVar() || Exp1.getOperator() != 5) continue;
                        UseVarNode = (VarNode)Exp2;
                        ConstSym = ((ConstNode)Exp1).getConstSym();
                        if (!ConstSym.getSymType().isInteger()) continue;
                        inc = ConstSym.intValue();
                        ind_flag = true;
                    }
                }
                if (inc == 0L) continue;
                BasicInduction IndTable = this.make_BasicindT((AssignStmt)IRnode, DefVarNode, UseVarNode, inc);
                this.make_ind(IndTable);
            }
        }
    }

    private BasicInduction make_BasicindT(AssignStmt pstmt, VarNode Def, VarNode Use, long inc) {
        BasicInduction IndTable = new BasicInduction(pstmt, Def, Use, inc);
        int InitDefCount = 0;
        VarNode InitDef = null;
        this.fUtil.Trace("---pass:make_BasicInduction", 1);
        this.fUtil.Trace("make_BasicInduction=" + Def.toString(), 5);
        this.fUtil.Trace("make_BasicInduction Parent=" + Def.getParent().toString(), 5);
        this.fLoopTable.IndList.add(IndTable);
        IndTable.InitConstFlag = false;
        IndTable.loop_ctr = false;
        IndTable.InitConstValue = 0L;
        UDList indUDList = (UDList)this.fResults.get("UDList", Use.getVar(), this.fSubpFlow);
        UDChain indUDChain = indUDList.getUDChain(Use);
        for (IR Node2 : indUDChain.getDefList()) {
            if (Node2 == UDChain.UNINITIALIZED || Node2.getOperator() != 22) continue;
            this.fUtil.Trace("make_BasicInduction :Node=" + Node2.toString(), 5);
            Exp ChildNode = ((AssignStmt)Node2).getLeftSide();
            if (ChildNode == Def || !this.fUtil.IsVarNode(ChildNode)) continue;
            this.fUtil.Trace("make_BasicInduction :ChildNode=" + ChildNode.toString(), 5);
            ++InitDefCount;
            InitDef = (VarNode)ChildNode;
        }
        if (InitDefCount != 1) {
            InitDef = null;
        }
        if (InitDef != null) {
            this.fUtil.Trace("InitDefB " + InitDef + " " + (BBlock)this.fResults.get("BBlockForNode", InitDef) + " UseB " + Use + " " + (BBlock)this.fResults.get("BBlockForNode", Use), 5);
            if (this.fUtil.dom_check((BBlock)this.fResults.get("BBlockForNode", InitDef), (BBlock)this.fResults.get("BBlockForNode", Use))) {
                this.fUtil.Trace("InitDef " + InitDef + " dominates Use " + Use, 5);
                Stmt opStmt = (Stmt)InitDef.getParent();
                if (opStmt.getOperator() == 22) {
                    Const ConstSym;
                    Exp RightExp = ((AssignStmt)opStmt).getRightSide();
                    if ((RightExp = this.fUtil.SkipConv(RightExp)).getOperator() == 5 && (ConstSym = ((ConstNode)RightExp).getConstSym()).getSymType().isInteger()) {
                        IndTable.InitConstValue = ConstSym.intValue();
                        IndTable.InitDefList.clear();
                        IndTable.InitConstFlag = true;
                    }
                }
            }
        }
        if (!IndTable.InitConstFlag) {
            SubpDefinition subp = this.fSubpFlow.getSubpDefinition();
            SymTable LocalSymTable = subp.getSubpSym().getSymTable();
            Var tmpVar = LocalSymTable.generateVar(Use.getType(), subp.getSubpSym());
            tmpVar.setSymType(Use.getType());
            VarNode tmpNode = this.hir.varNode(tmpVar);
            HIR LeftNode = this.fUtil.getTopVarNode(Use);
            this.fLoopTable.addConditionPart.add(this.hir.assignStmt((VarNode)tmpNode.copyWithOperands(), (Exp)LeftNode.copyWithOperands()));
            this.fLoopTable.addConditionDefList.add(tmpNode);
            this.fUtil.Trace("addConditionDefList=" + tmpNode.toString(), 5);
            IndTable.InitConstNode = tmpNode;
            indUDList = (UDList)this.fResults.get("UDList", Use.getVar(), this.fSubpFlow);
            indUDChain = indUDList.getUDChain(Use);
            for (IR Node3 : indUDChain.getDefList()) {
                if (Node3 == UDChain.UNINITIALIZED || this.fUtil.loop_body(this.fLoopTable, (HIR)Node3)) continue;
                IndTable.InitDefList.add(Node3);
            }
        }
        IndTable.loop_ctr = this.IsLoopControl(Use, inc);
        if (IndTable.loop_ctr) {
            this.fLoopTable.LoopCtrInduction = IndTable;
        }
        return IndTable;
    }

    private void make_ind(BasicInduction IndTable) {
        long ind_init = 0L;
        long ind_inc = 0L;
        Exp ind_Exp = null;
        VarNode DefVarNode = IndTable.DefVarNode;
        this.fUtil.Trace("make_ind Def" + DefVarNode.toString(), 5);
        DefUseList DUList = (DefUseList)this.fResults.get("DefUseList", DefVarNode.getVar(), this.fSubpFlow);
        this.fUtil.Trace("make_ind DefParent " + DefVarNode.getParent().toString(), 5);
        DefUseCell DUChain = DUList.getDefUseCell(this.fUtil.getParentASSIGN(DefVarNode));
        for (IR Use : DUChain.getUseList()) {
            if (!(Use instanceof VarNode)) continue;
            VarNode UseNode2 = (VarNode)Use;
            boolean ind_flag = false;
            this.fUtil.Trace("make_ind Loop Debug= " + UseNode2.toString(), 5);
            if (IndTable.UseVarNode == UseNode2 || !this.fUtil.loop_body(this.fLoopTable, UseNode2)) continue;
            this.fUtil.Trace("make_ind loop_body=true ", 5);
            HIR tmpHir = this.fUtil.getTopVarNode(UseNode2);
            HIR opStmt = (HIR)tmpHir.getParent();
            this.fUtil.Trace("make_ind loop_body:pearent Stmt " + ((Object)opStmt).toString(), 5);
            int op = opStmt.getOperator();
            switch (op) {
                case 38: {
                    Const ConstSym;
                    Exp Exp1 = this.fUtil.SkipConv(((Exp)opStmt).getExp1());
                    if (Exp1 == UseNode2) {
                        Exp1 = this.fUtil.SkipConv(((Exp)opStmt).getExp2());
                    }
                    if (Exp1.getOperator() != 5 || !(ConstSym = ((ConstNode)Exp1).getConstSym()).getSymType().isInteger()) break;
                    ind_flag = true;
                    ind_Exp = (Exp)opStmt;
                    ind_inc = 1L;
                    ind_init = ConstSym.intValue();
                    break;
                }
                case 39: {
                    Const ConstSym;
                    Exp Exp1 = this.fUtil.SkipConv(((Exp)opStmt).getExp1());
                    Exp Exp2 = this.fUtil.SkipConv(((Exp)opStmt).getExp2());
                    if (Exp1 != UseNode2 || Exp2.getOperator() != 5 || !(ConstSym = ((ConstNode)Exp2).getConstSym()).getSymType().isInteger()) break;
                    ind_flag = true;
                    ind_Exp = (Exp)opStmt;
                    ind_inc = 1L;
                    ind_init = 0 - ConstSym.intValue();
                    break;
                }
                case 41: {
                    Const ConstSym;
                    Exp Exp1;
                    Exp c1 = this.fUtil.SkipConv(((Exp)opStmt).getExp1());
                    if (c1 == UseNode2) {
                        c1 = this.fUtil.SkipConv(((Exp)opStmt).getExp2());
                    }
                    if (c1.getOperator() != 5 || !(ConstSym = ((ConstNode)c1).getConstSym()).getSymType().isInteger()) break;
                    ind_inc = ConstSym.intValue();
                    IR ExpParent = opStmt.getParent();
                    int opParent = ExpParent.getOperator();
                    switch (opParent) {
                        case 38: {
                            Exp1 = this.fUtil.SkipConv(((Exp)ExpParent).getExp1());
                            if (Exp1 == opStmt) {
                                Exp1 = this.fUtil.SkipConv(((Exp)ExpParent).getExp2());
                            }
                            if (Exp1.getOperator() != 5 || !(ConstSym = ((ConstNode)Exp1).getConstSym()).getSymType().isInteger()) break;
                            ind_flag = true;
                            ind_Exp = (Exp)ExpParent;
                            ind_init = ConstSym.intValue();
                            break;
                        }
                        case 39: {
                            Exp1 = this.fUtil.SkipConv(((Exp)ExpParent).getExp2());
                            if (Exp1.getOperator() != 5 || !(ConstSym = ((ConstNode)Exp1).getConstSym()).getSymType().isInteger()) break;
                            ind_flag = true;
                            ind_Exp = (Exp)ExpParent;
                            ind_init = 0 - ConstSym.intValue();
                            break;
                        }
                        case 17: 
                        case 22: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: {
                            ind_flag = true;
                            ind_Exp = (Exp)opStmt;
                            ind_init = 0L;
                        }
                    }
                    break;
                }
                case 17: 
                case 22: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    ind_flag = true;
                    ind_Exp = UseNode2;
                    ind_init = 0L;
                    ind_inc = 1L;
                }
            }
            if (!ind_flag) continue;
            this.make_indExpT(ind_Exp, ind_inc, ind_init, IndTable);
        }
    }

    private void make_indExpT(Exp ind_ExpNode, long ind_inc, long ind_init, BasicInduction indTable) {
        boolean ConstFlg;
        this.fUtil.Trace("make_indExpT " + ind_ExpNode + " inc " + ind_inc + " init " + ind_init, 4);
        long inc = 0L;
        long init = 0L;
        long last = 0L;
        if (indTable.InitConstFlag) {
            ConstFlg = true;
            long InitConstValue = indTable.InitConstValue;
        } else {
            ConstFlg = false;
            long InitConstValue = 0L;
        }
        this.fUtil.Trace("NodeOrder  Exp1= " + indTable.UseVarNode.toString(), 5);
        this.fUtil.Trace("NodeOrder  Exp2= " + ind_ExpNode.toString(), 5);
        init = this.fUtil.NodeOrder(indTable.UseVarNode, ind_ExpNode) < 0 ? ind_init + indTable.InitConstValue * ind_inc : ind_init + (indTable.InitConstValue + indTable.inc) * ind_inc;
        inc = ind_inc * indTable.inc;
        IndExp indExpTable = new IndExp();
        indExpTable.IndTable = indTable;
        indExpTable.setExpData(ind_ExpNode, inc, init, last, ConstFlg, indTable.InitConstNode);
        indExpTable.DebugIndExp(this.fUtil);
        indTable.indExpList.add(indExpTable);
    }

    private void reduction() {
        this.fUtil.Trace("---pass:reduction", 1);
        ListIterator Ie = this.fLoopTable.BBlockList.listIterator();
        while (Ie.hasNext()) {
            SetRefRepr lSetRefRepr;
            IR IRnode;
            BBlock CurrBlock = (BBlock)Ie.next();
            if (!this.fUtil.dom_check(CurrBlock, this.ExitBodyBBlock)) continue;
            SetRefReprList llist = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", CurrBlock);
            Iterator Ie1 = llist.iterator();
            while (Ie1.hasNext() && (IRnode = (lSetRefRepr = (SetRefRepr)Ie1.next()).getIR()) != null) {
                if (IRnode.getOperator() != 22) continue;
                Exp LeftExp = ((AssignStmt)IRnode).getLeftSide();
                Exp RightExp = ((AssignStmt)IRnode).getRightSide();
                LeftExp = this.fUtil.SkipConv(LeftExp);
                RightExp = this.fUtil.SkipConv(RightExp);
                if (!this.fUtil.IsVarNode(LeftExp) || this.fUtil.IsInduction(this.fLoopTable, (VarNode)LeftExp) || !this.fUtil.def_check(this.fLoopTable, (AssignStmt)IRnode)) continue;
                DefUseList DUList = (DefUseList)this.fResults.get("DefUseList", LeftExp.getVar(), this.fSubpFlow);
                this.fUtil.Trace("Assign=" + ((Object)this.fUtil.getParentASSIGN(LeftExp)).toString(), 5);
                DefUseCell DUChain = DUList.getDefUseCell(this.fUtil.getParentASSIGN(LeftExp));
                int useCount = 0;
                VarNode UseVarNode = null;
                for (IR Use : DUChain.getUseList()) {
                    if (!(Use instanceof VarNode) || !this.fUtil.loop_body(this.fLoopTable, (VarNode)Use)) continue;
                    UseVarNode = (VarNode)Use;
                    ++useCount;
                }
                if (useCount != 1 || this.getRightReductionVar(LeftExp, RightExp) != UseVarNode) continue;
                this.make_ReductionT((AssignStmt)IRnode, UseVarNode);
            }
        }
        this.InnerLoopReduction();
    }

    private void InnerLoopReduction() {
        LinkedList ReductionList = new LinkedList();
        LinkedList<Reduction> RemoveList = new LinkedList<Reduction>();
        ListIterator Ie = this.fLoopTable.InnerLoopList.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            this.addReductionList(ReductionList, lTable.ReductionADDList);
            this.addReductionList(ReductionList, lTable.ReductionMULList);
            this.addReductionList(ReductionList, lTable.ReductionSUBList);
        }
        ListIterator Ie1 = this.fLoopTable.BBlockList.listIterator();
        while (Ie1.hasNext()) {
            Reduction reduction;
            BBlock CurrBlock = (BBlock)Ie1.next();
            FlowAnalSymVector ddef = (FlowAnalSymVector)this.fResults.get("DDefined", CurrBlock);
            FlowAnalSymVector use = (FlowAnalSymVector)this.fResults.get("PUsed", CurrBlock);
            Set ddefsymset = ddef.flowAnalSyms();
            Set usesymset = use.flowAnalSyms();
            RemoveList.clear();
            ListIterator Ie2 = ReductionList.listIterator();
            while (Ie2.hasNext()) {
                reduction = (Reduction)Ie2.next();
                if (this.fResults.get("BBlockForNode", reduction.DefVarNode) == CurrBlock) continue;
                if (ddefsymset.contains(reduction.DefVarNode.getVar())) {
                    RemoveList.add(reduction);
                    continue;
                }
                if (!usesymset.contains(reduction.DefVarNode.getVar())) continue;
                RemoveList.add(reduction);
            }
            ListIterator Ie3 = RemoveList.listIterator();
            while (Ie3.hasNext()) {
                reduction = (Reduction)Ie3.next();
                ReductionList.remove(reduction);
            }
        }
        ListIterator Ie4 = ReductionList.listIterator();
        while (Ie4.hasNext()) {
            Reduction reduction = (Reduction)Ie4.next();
            switch (reduction.op) {
                case 38: {
                    this.fLoopTable.ReductionADDList.add(reduction);
                    break;
                }
                case 41: {
                    this.fLoopTable.ReductionMULList.add(reduction);
                    break;
                }
                case 39: {
                    this.fLoopTable.ReductionSUBList.add(reduction);
                }
            }
        }
    }

    private void addReductionList(LinkedList to, LinkedList from) {
        ListIterator Ie = from.listIterator();
        while (Ie.hasNext()) {
            Reduction fromReduction = (Reduction)Ie.next();
            boolean addFlag = true;
            ListIterator Ie1 = to.listIterator();
            while (Ie1.hasNext()) {
                Reduction toReduction = (Reduction)Ie1.next();
                if (fromReduction.DefVarNode.getVar() != toReduction.DefVarNode.getVar()) continue;
                to.remove(toReduction);
                addFlag = false;
                break;
            }
            if (!addFlag) continue;
            to.add(fromReduction);
        }
    }

    private VarNode getRightReductionVar(Exp LeftExp, Exp RightExp) {
        if (this.fUtil.IsVarNode(RightExp)) {
            if (this.fUtil.EQVar(LeftExp, (VarNode)RightExp)) {
                return (VarNode)RightExp;
            }
            return null;
        }
        int ChildCount = RightExp.getChildCount();
        if (ChildCount != 0) {
            for (int i = 1; i <= ChildCount; ++i) {
                HIR ChildNode = (HIR)RightExp.getChild(i);
                if (!(ChildNode instanceof Exp)) {
                    return null;
                }
                VarNode Var2 = this.getRightReductionVar(LeftExp, (Exp)ChildNode);
                if (Var2 == null) continue;
                return Var2;
            }
        }
        return null;
    }

    private void make_ReductionT(AssignStmt assignNode, VarNode RightExp) {
        int subCount = 0;
        int mulCount = 0;
        int addCount = 0;
        int nodeCount = 0;
        VarNode LeftExp = (VarNode)this.fUtil.SkipConv(assignNode.getLeftSide());
        HIR Var2 = this.fUtil.getTopVarNode(RightExp);
        for (HIR p = (HIR)Var2.getParent(); assignNode != p; p = (HIR)p.getParent()) {
            if (p.getOperator() == 38) {
                ++addCount;
            } else if (p.getOperator() == 41) {
                ++mulCount;
            } else if (p.getOperator() == 39) {
                ++subCount;
            }
            ++nodeCount;
        }
        if (addCount == nodeCount) {
            this.fLoopTable.ReductionADDList.add(new Reduction(assignNode, LeftExp, RightExp, 38));
        } else if (mulCount == nodeCount) {
            this.fLoopTable.ReductionMULList.add(new Reduction(assignNode, LeftExp, RightExp, 41));
        } else if (subCount == nodeCount && nodeCount == 1) {
            this.fLoopTable.ReductionSUBList.add(new Reduction(assignNode, LeftExp, RightExp, 39));
        }
    }

    private boolean IsLoopControl(VarNode node, long inc) {
        this.fUtil.Trace("---pass:IsLoopControl", 1);
        Exp Cond = this.fLoopTable.LoopStmt.getLoopStartCondition();
        if (Cond == null) {
            return false;
        }
        int op = Cond.getOperator();
        boolean result = false;
        boolean leftUse = false;
        IR0 Exp2 = null;
        switch (op) {
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                if (this.fUtil.EQVar(this.fUtil.SkipConv(Cond.getExp1()), node)) {
                    result = true;
                    leftUse = true;
                    Exp2 = this.fUtil.SkipConv(Cond.getExp2());
                    break;
                }
                if (this.fUtil.EQVar(this.fUtil.SkipConv(Cond.getExp2()), node)) {
                    leftUse = false;
                    result = true;
                    Exp2 = this.fUtil.SkipConv(Cond.getExp1());
                    break;
                }
                result = false;
            }
        }
        if (result) {
            if (Exp2.getOperator() == 5) {
                Const ConstSym = ((ConstNode)Exp2).getConstSym();
                if (!ConstSym.getSymType().isInteger()) {
                    result = false;
                } else {
                    this.fLoopTable.repeat_no_value = ConstSym.intValue();
                    this.fLoopTable.const_repeat_no = true;
                }
            } else {
                result = this.fLoopTable.fInv.IsInvariant((HIR)Exp2);
            }
            if (leftUse) {
                if ((op == 54 || op == 53) && inc > 0L) {
                    result = false;
                }
                if ((op == 56 || op == 55) && inc < 0L) {
                    result = false;
                }
            } else {
                if ((op == 54 || op == 53) && inc < 0L) {
                    result = false;
                }
                if ((op == 56 || op == 55) && inc > 0L) {
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean make_ref() {
        this.fUtil.Trace("---pass:make_ref", 1);
        boolean para_flag = true;
        LinkedList tmpArrayNodeList = new LinkedList();
        LinkedList stm_refP_DDEF = new LinkedList();
        LinkedList stm_refP_MOD = new LinkedList();
        LinkedList stm_refP_USE = new LinkedList();
        LinkedList stm_refP_EUSE = new LinkedList();
        ListIterator Ie = this.fLoopTable.InnerBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock CurrBlock = (BBlock)Ie.next();
            Ref_Table refTable = new Ref_Table(this.fSubpFlow, CurrBlock);
            this.fLoopTable.refList.add(refTable);
            refTable.ddef = (FlowAnalSymVector)this.fResults.get("DDefined", CurrBlock);
            refTable.ddef.vectorCopy(refTable.mod);
            refTable.use = (FlowAnalSymVector)this.fResults.get("PUsed", CurrBlock);
            refTable.euse = (FlowAnalSymVector)this.fResults.get("PExposed", CurrBlock);
            SetRefReprList llist = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", CurrBlock);
            for (SetRefRepr lSetRefRepr : llist) {
                ListIterator Ia;
                Ref_Array refArray;
                HIR tmpHirNode;
                IR stmt = lSetRefRepr.getIR();
                stm_refP_DDEF.clear();
                stm_refP_DDEF.clear();
                stm_refP_MOD.clear();
                stm_refP_USE.clear();
                stm_refP_EUSE.clear();
                tmpArrayNodeList.clear();
                this.ArrayAnalysis.getArrayList(stmt, tmpArrayNodeList);
                int op = stmt.getOperator();
                if (op == 22) {
                    tmpHirNode = this.fUtil.SkipConv(((AssignStmt)stmt).getLeftSide());
                    if (tmpHirNode.getOperator() == 17) {
                        this.fUtil.Trace("make refArray:" + ((Object)tmpHirNode).toString(), 5);
                        refArray = this.ArrayAnalysis.make_ref_Array((Exp)tmpHirNode, this.fLoopTable.IndList, this.fLoopTable.fInv);
                        refArray.DebugArrayRef(this.fUtil);
                        this.ArrayAnalysis.addaryelm(stm_refP_DDEF, refArray);
                        this.ArrayAnalysis.addaryelm(stm_refP_MOD, refArray);
                        tmpArrayNodeList.remove(tmpHirNode);
                        Ia = tmpArrayNodeList.listIterator();
                        while (Ia.hasNext()) {
                            refArray = this.ArrayAnalysis.make_ref_Array((Exp)Ia.next(), this.fLoopTable.IndList, this.fLoopTable.fInv);
                            this.ArrayAnalysis.addaryelm(stm_refP_USE, refArray);
                            this.ArrayAnalysis.addaryelm(stm_refP_EUSE, refArray);
                        }
                    }
                    tmpHirNode = this.fUtil.SkipConv(((AssignStmt)stmt).getRightSide());
                } else {
                    tmpHirNode = (HIR)stmt;
                }
                tmpArrayNodeList.clear();
                this.ArrayAnalysis.getArrayList(tmpHirNode, tmpArrayNodeList);
                Ia = tmpArrayNodeList.listIterator();
                while (Ia.hasNext()) {
                    refArray = this.ArrayAnalysis.make_ref_Array((Exp)Ia.next(), this.fLoopTable.IndList, this.fLoopTable.fInv);
                    this.ArrayAnalysis.addaryelm(stm_refP_USE, refArray);
                    this.ArrayAnalysis.addaryelm(stm_refP_EUSE, refArray);
                }
                this.ArrayAnalysis.addaryelmList(stm_refP_USE, refTable.useArrayList);
                this.ArrayAnalysis.addaryelmList(stm_refP_MOD, refTable.modArrayList);
                this.ArrayAnalysis.subaryelmList(refTable.ddefArrayList, stm_refP_EUSE);
                this.ArrayAnalysis.addaryelmList(stm_refP_EUSE, refTable.euseArrayList);
                this.ArrayAnalysis.addaryelmList(stm_refP_DDEF, refTable.ddefArrayList);
            }
        }
        return this.setPrivateVariables();
    }

    private boolean setPrivateVariables() {
        this.fUtil.Trace("---pass:setPrivateVariables", 1);
        boolean para_flag = true;
        ListIterator IeRef = this.fLoopTable.refList.listIterator();
        while (IeRef.hasNext()) {
            Ref_Table refTable = (Ref_Table)IeRef.next();
            Set symset = refTable.ddef.flowAnalSyms();
            for (Sym defVar : symset) {
                boolean dom_check;
                if (this.setLastPrivate(defVar, refTable.BasicBlock, dom_check = this.fUtil.dom_check(refTable.BasicBlock, this.ExitBodyBBlock))) continue;
                para_flag = false;
            }
        }
        ListIterator Ie = this.fLoopTable.InnerLoopList.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            Iterator Ie1 = lTable.varUnParalellLastPrivateList.listIterator();
            while (Ie1.hasNext()) {
                this.fLoopTable.varUnParalellLastPrivateList.add(Ie1.next());
                this.fLoopTable.setParaFlag(this.fUtil, false, "setPrivateVariables");
                para_flag = false;
            }
            Ie1 = lTable.Private.iterator();
            while (Ie1.hasNext()) {
                this.fLoopTable.Private.add(Ie1.next());
            }
            if (lTable.getParaFlag(this.fUtil, "setPrivateVariavles")) {
                Ie1 = lTable.addConditionDefList.iterator();
                while (Ie1.hasNext()) {
                    this.fLoopTable.Private.add(Ie1.next());
                }
            }
            for (VarNode varNode : lTable.LastPrivate) {
                BBlock vBBlock = (BBlock)this.fResults.get("BBlockForNode", varNode);
                BBlock eBBlock = this.fResults.getBBlockForLabel(lTable.LoopStmt.getLoopEndLabel());
                boolean dom_check = lTable.zero_check ? this.fUtil.dom_check(eBBlock, this.ExitBodyBBlock) : false;
                if (this.setLastPrivate(varNode.getVar(), vBBlock, dom_check)) continue;
                para_flag = false;
            }
        }
        return para_flag;
    }

    private boolean setLastPrivate(Sym defVar, BBlock pBBlock, boolean dom_check) {
        this.fUtil.Trace("setLastPrivate " + defVar.getName(), 2);
        DefUseList DUList = (DefUseList)this.fResults.get("DefUseList", defVar, this.fSubpFlow);
        List Cells = DUList.getDefUseCells();
        boolean para_flag = true;
        for (DefUseCell DUChain : Cells) {
            IR Node2 = DUChain.getDefNode();
            if (Node2 == DefUseCell.UNINITIALIZED || Node2.getOperator() != 22) continue;
            Exp ChildNode = ((AssignStmt)Node2).getLeftSide();
            ChildNode = this.fUtil.SkipConv(ChildNode);
            this.fUtil.Trace("DEBUG1-->case1-2=" + ChildNode.toString(), 5);
            if (!this.fUtil.IsScalar(ChildNode) || this.fResults.get("BBlockForNode", ChildNode) != pBBlock) continue;
            boolean privateExist = false;
            for (IR Use : DUChain.getUseList()) {
                SubpNode sNode;
                Subp sSym;
                String fname;
                int op;
                if (!(Use instanceof VarNode)) continue;
                HIR UseNode2 = (HIR)Use;
                if (!(Use instanceof VarNode) && (op = UseNode2.getOperator()) == 9 && this.predefinedFunctions.contains(fname = (sSym = (sNode = (SubpNode)UseNode2).getSubp()).getName())) continue;
                if (!this.fUtil.loop_body(this.fLoopTable, UseNode2)) {
                    if (dom_check) {
                        this.fUtil.Trace(" dom_check is true. Add to LastPrivate " + ChildNode.toStringWithChildren(), 2);
                        this.fLoopTable.LastPrivate.add(ChildNode);
                        privateExist = false;
                        break;
                    }
                    privateExist = false;
                    para_flag = false;
                    Var var = ((VarNode)ChildNode).getVar();
                    if (!this.fLoopTable.varUnParalellLastPrivateList.contains(var)) {
                        this.fLoopTable.varUnParalellLastPrivateList.add(var);
                    }
                    this.fLoopTable.setParaFlag(this.fUtil, false, "setLastPrivate");
                    continue;
                }
                privateExist = true;
            }
            if (privateExist) {
                if (this.fUtil.IsAutoVarNode(ChildNode)) {
                    this.fUtil.Trace(" privateExit is true. add to Private " + ChildNode.toStringWithChildren(), 2);
                    this.fLoopTable.Private.add(ChildNode);
                    continue;
                }
                this.fUtil.Trace(" privateExit is true. add to LastPrivate " + ChildNode.toStringWithChildren(), 2);
                this.fLoopTable.LastPrivate.add(ChildNode);
                continue;
            }
            if (!para_flag || this.fUtil.IsAutoVarNode(ChildNode)) continue;
            if (!dom_check) {
                privateExist = false;
                para_flag = false;
                Var var = ((VarNode)ChildNode).getVar();
                if (this.fLoopTable.varUnParalellLastPrivateList.contains(var)) continue;
                this.fLoopTable.varUnParalellLastPrivateList.add(var);
                continue;
            }
            this.fUtil.Trace(" dom_check is true. add to LastPrivate " + ChildNode.toStringWithChildren(), 2);
            this.fLoopTable.LastPrivate.add(ChildNode);
        }
        return para_flag;
    }

    private void make_BlockRef() {
        this.fUtil.Trace("make_BlockRef Entry " + this.EntryBodyBBlock.getBBlockNumber(), 5);
        Ref_Table AllRef = this.getBBlockRef(this.EntryBodyBBlock);
        this.fTraversedBBlocks = new HashSet();
        this.integrateBlockRef(this.EntryBodyBBlock, this.ExitBodyBBlock, AllRef);
        this.reg_unify(AllRef, this.getBBlockRef(this.ExitBodyBBlock));
        this.fUtil.Trace("ExitBBlock=" + this.ExitBodyBBlock.getBBlockNumber(), 5);
        AllRef.ddef.vectorCopy(this.fLoopTable.ControlRef.ddef);
        AllRef.mod.vectorCopy(this.fLoopTable.ControlRef.mod);
        AllRef.use.vectorCopy(this.fLoopTable.ControlRef.use);
        AllRef.euse.vectorCopy(this.fLoopTable.ControlRef.euse);
        this.fLoopTable.ControlRef.modArrayList = this.ArrayAnalysis.make_refArrayCellList(AllRef.modArrayList, 3);
        this.fLoopTable.ControlRef.useArrayList = this.ArrayAnalysis.make_refArrayCellList(AllRef.useArrayList, 2);
        this.fLoopTable.ControlRef.ddefArrayList = this.ArrayAnalysis.make_refArrayCellList(AllRef.ddefArrayList, 1);
        this.fLoopTable.ControlRef.euseArrayList = this.ArrayAnalysis.make_refArrayCellList(AllRef.euseArrayList, 4);
    }

    private void integrateBlockRef(BBlock StartBBlock, BBlock EndBBlock, Ref_Table refTable) {
        BBlock CurrBBlock = StartBBlock;
        this.fTraversedBBlocks.add(CurrBBlock);
        BBlock DomBBlock = EndBBlock;
        this.fUtil.Trace("---pass:integrateBlockRef", 1);
        refTable = this.getBBlockRef(StartBBlock);
        while (CurrBBlock != null) {
            DomBBlock = CurrBBlock.getImmediatePostdominatorForSubpFlow();
            this.fUtil.Trace("Loop StartBBlock=" + StartBBlock.getBBlockNumber(), 5);
            this.fUtil.Trace("Loop EndBBlock=" + EndBBlock.getBBlockNumber(), 5);
            this.fUtil.Trace("Loop Curr=" + CurrBBlock.getBBlockNumber(), 5);
            if (DomBBlock != null) {
                this.fUtil.Trace("Loop Dom=" + DomBBlock.getBBlockNumber(), 5);
            }
            if (this.fLoopTable.InnerBBlockList.contains(DomBBlock)) {
                if (!this.IsRedundant(CurrBBlock)) {
                    Ref_Table SuccALLRef = new Ref_Table(this.fSubpFlow, null);
                    List SuccList = CurrBBlock.getSuccList();
                    boolean SuccExist = false;
                    ListIterator Ie = SuccList.listIterator();
                    while (Ie.hasNext()) {
                        BBlock Succ = (BBlock)Ie.next();
                        if (Succ == DomBBlock) continue;
                        Ref_Table SuccRef = this.getBBlockRef(Succ);
                        this.integrateBlockRef(Succ, DomBBlock, SuccRef);
                        if (SuccExist) {
                            this.reg_fuse(SuccALLRef, SuccRef);
                            continue;
                        }
                        SuccExist = true;
                        this.reg_copy(SuccALLRef, SuccRef);
                    }
                    this.reg_unify(refTable, SuccALLRef);
                    this.reg_unify(refTable, this.getBBlockRef(DomBBlock));
                } else {
                    if (StartBBlock != CurrBBlock) {
                        this.reg_unify(refTable, this.getBBlockRef(CurrBBlock));
                    }
                    DomBBlock = CurrBBlock.getImmediatePostdominatorForSubpFlow();
                }
                CurrBBlock = DomBBlock;
                this.fTraversedBBlocks.add(CurrBBlock);
            } else {
                LoopTable ExpandLoop = this.Expand_Anal(this.fLoopTable, DomBBlock);
                if (ExpandLoop != null) {
                    this.reg_unify(refTable, ExpandLoop.ExpandRef);
                    CurrBBlock = this.fUtil.LoopNextBBlock(ExpandLoop);
                    this.fTraversedBBlocks.add(CurrBBlock);
                    this.reg_unify(refTable, this.getBBlockRef(CurrBBlock));
                } else {
                    CurrBBlock = EndBBlock;
                    break;
                }
            }
            if (DomBBlock != EndBBlock) continue;
        }
        this.fUtil.Trace("REF refddef ", 5);
        this.fUtil.Trace(refTable.ddef.toStringDescriptive(), 5);
        this.fUtil.Trace("REF refmod ", 5);
        this.fUtil.Trace(refTable.mod.toStringDescriptive(), 5);
        this.fUtil.Trace("EUSEF refeuse ", 5);
        this.fUtil.Trace(refTable.euse.toStringDescriptive(), 5);
    }

    LoopTable Expand_Anal(LoopTable pLoopTable, BBlock pBBlock) {
        LoopTable lTable2 = null;
        this.fUtil.Trace("---pass:Expand_Anal", 1);
        for (LoopTable lTable2 : this.fLoopTable.InnerLoopList) {
            if (!lTable2.BBlockList.contains(pBBlock)) continue;
        }
        if (lTable2 == null) {
            this.fUtil.Trace("---pass:Expand Error! ", 1);
            return null;
        }
        lTable2.ControlRef.mod.vectorCopy(lTable2.ExpandRef.mod);
        lTable2.ControlRef.use.vectorCopy(lTable2.ExpandRef.use);
        lTable2.ControlRef.euse.vectorCopy(lTable2.ExpandRef.euse);
        if (lTable2.zero_check) {
            this.fUtil.Trace("DEBUG Expand DDEF (COPY) " + lTable2.repeat_no_normalize, 1);
            lTable2.ControlRef.ddef.vectorCopy(lTable2.ExpandRef.ddef);
        } else {
            this.fUtil.Trace("DEBUG Expand DDEF (NULL) ", 1);
            lTable2.ExpandRef.ddef = new FlowAnalSymVectorImpl(this.fSubpFlow);
        }
        if (lTable2.getParaFlag(this.fUtil, "ExpandAnal")) {
            for (VarNode varNode : lTable2.Private) {
                FlowAnalSym varSym = (FlowAnalSym)((Object)varNode.getVar());
                lTable2.ExpandRef.ddef.remove(varSym);
                lTable2.ExpandRef.mod.remove(varSym);
                lTable2.ExpandRef.use.remove(varSym);
                lTable2.ExpandRef.euse.remove(varSym);
            }
        }
        this.ArrayAnalysis.ExpandArrayList(lTable2, lTable2.ExpandRef.modArrayList, lTable2.ControlRef.modArrayList, null, 3);
        this.ArrayAnalysis.ExpandArrayList(lTable2, lTable2.ExpandRef.useArrayList, lTable2.ControlRef.useArrayList, null, 2);
        this.ArrayAnalysis.ExpandArrayList(lTable2, lTable2.ExpandRef.ddefArrayList, lTable2.ControlRef.ddefArrayList, null, 1);
        this.ArrayAnalysis.ExpandArrayList(lTable2, lTable2.ExpandRef.euseArrayList, lTable2.ControlRef.euseArrayList, lTable2.ControlRef.ddefArrayList, 4);
        LinkedList tmpddefList = new LinkedList();
        this.ArrayAnalysis.ExpandArrayList(lTable2, tmpddefList, lTable2.ControlRef.ddefArrayList, null, 1);
        lTable2.ExpandRef.ddefArrayList = lTable2.zero_check ? tmpddefList : tmpddefList;
        return lTable2;
    }

    boolean IsRedundant(BBlock pBBlock) {
        BBlock SuccBBlock;
        List PredList;
        List SuccList = pBBlock.getSuccList();
        return SuccList.size() == 1 && (PredList = (SuccBBlock = (BBlock)SuccList.get(0)).getPredList()).size() == 1;
    }

    private void reg_unify(Ref_Table pre_ref, Ref_Table suc_ref) {
        this.fUtil.Trace("---pass:reg_unify", 1);
        FlowAnalSymVector tmpBit = this.fSubpFlow.flowAnalSymVector();
        LinkedList tmpList = new LinkedList();
        pre_ref.mod.vectorOr(suc_ref.mod, pre_ref.mod);
        pre_ref.use.vectorOr(suc_ref.use, pre_ref.use);
        suc_ref.euse.vectorSub(pre_ref.ddef, tmpBit);
        pre_ref.euse.vectorOr(tmpBit, pre_ref.euse);
        pre_ref.ddef.vectorOr(suc_ref.ddef, pre_ref.ddef);
        this.ArrayAnalysis.addaryelmList(suc_ref.modArrayList, pre_ref.modArrayList);
        this.ArrayAnalysis.addaryelmList(suc_ref.useArrayList, pre_ref.useArrayList);
        this.ArrayAnalysis.addaryelmList(suc_ref.euseArrayList, tmpList);
        this.fUtil.Trace("DEBUG EUSESIZE=" + tmpList.size(), 5);
        this.ArrayAnalysis.subaryelmList(pre_ref.ddefArrayList, tmpList);
        this.ArrayAnalysis.addaryelmList(tmpList, pre_ref.euseArrayList);
        this.ArrayAnalysis.addaryelmList(suc_ref.ddefArrayList, pre_ref.ddefArrayList);
    }

    private void reg_fuse(Ref_Table then_ref, Ref_Table else_ref) {
        this.fUtil.Trace("---pass:reg_fuse", 1);
        else_ref.mod.vectorOr(then_ref.mod, then_ref.mod);
        else_ref.use.vectorOr(then_ref.use, then_ref.use);
        else_ref.euse.vectorOr(then_ref.euse, then_ref.euse);
        else_ref.ddef.vectorAnd(then_ref.ddef, then_ref.ddef);
        this.ArrayAnalysis.addaryelmList(else_ref.modArrayList, then_ref.modArrayList);
        this.ArrayAnalysis.addaryelmList(else_ref.useArrayList, then_ref.useArrayList);
        this.ArrayAnalysis.addaryelmList(else_ref.euseArrayList, then_ref.euseArrayList);
        this.fUtil.Trace("reg_fuse Then DDEF size=" + then_ref.ddefArrayList.size(), 5);
        this.fUtil.Trace("reg_fuse else DDEF size=" + else_ref.ddefArrayList.size(), 5);
        this.ArrayAnalysis.mularyelmList(else_ref.ddefArrayList, then_ref.ddefArrayList);
        this.fUtil.Trace("reg_fuse Then DDEF size=" + then_ref.ddefArrayList.size(), 5);
        this.fUtil.Trace("reg_fuse else DDEF size=" + else_ref.ddefArrayList.size(), 5);
    }

    private void reg_copy(Ref_Table to_ref, Ref_Table from_ref) {
        from_ref.mod.vectorCopy(to_ref.mod);
        from_ref.use.vectorCopy(to_ref.use);
        from_ref.euse.vectorCopy(to_ref.euse);
        from_ref.ddef.vectorCopy(to_ref.ddef);
        to_ref.modArrayList = from_ref.modArrayList;
        to_ref.useArrayList = from_ref.useArrayList;
        to_ref.euseArrayList = from_ref.euseArrayList;
        to_ref.ddefArrayList = from_ref.ddefArrayList;
    }

    private Ref_Table getBBlockRef(BBlock pBBlock) {
        for (Ref_Table BBlockRef : this.fLoopTable.refList) {
            if (BBlockRef.BasicBlock != pBBlock) continue;
            return BBlockRef;
        }
        return null;
    }

    private void ParallelCheck() {
        this.fUtil.Trace("---pass:ParallelCheck", 1);
        this.fLoopTable.setParaFlag(this.fUtil, true, "ParallelCheck");
        for (Reduction red : this.fLoopTable.ReductionADDList) {
            this.fLoopTable.Private.remove(red.DefVarNode);
            this.fLoopTable.Private.remove(red.UseVarNode);
            this.fLoopTable.LastPrivate.remove(red.DefVarNode);
            this.fLoopTable.LastPrivate.remove(red.UseVarNode);
        }
        for (Reduction red : this.fLoopTable.ReductionSUBList) {
            this.fLoopTable.Private.remove(red.DefVarNode);
            this.fLoopTable.Private.remove(red.UseVarNode);
            this.fLoopTable.LastPrivate.remove(red.DefVarNode);
            this.fLoopTable.LastPrivate.remove(red.UseVarNode);
        }
        for (Reduction red : this.fLoopTable.ReductionMULList) {
            this.fLoopTable.Private.remove(red.DefVarNode);
            this.fLoopTable.Private.remove(red.UseVarNode);
            this.fLoopTable.LastPrivate.remove(red.DefVarNode);
            this.fLoopTable.LastPrivate.remove(red.UseVarNode);
        }
        FlowAnalSymVectorImpl mod_euse = new FlowAnalSymVectorImpl(this.fSubpFlow);
        this.fLoopTable.ControlRef.mod.vectorAnd(this.fLoopTable.ControlRef.euse, mod_euse);
        Set symset = mod_euse.flowAnalSyms();
        for (Var v : symset) {
            this.fUtil.Trace("---ParallelCheck: mod_euse:" + v.toString(), 5);
            if (this.GetInduction(v) != null || this.fUtil.IsReduction(this.fLoopTable, v)) continue;
            this.fLoopTable.setParaFlag(this.fUtil, false, "Check var mod:euse");
            this.fLoopTable.varResultList.add(v);
        }
        this.ArrayAnalysis.TraceArrayCellList("MOD", this.fLoopTable.ControlRef.modArrayList);
        this.ArrayAnalysis.TraceArrayCellList("USE", this.fLoopTable.ControlRef.useArrayList);
        this.ArrayAnalysis.TraceArrayCellList("DDEF", this.fLoopTable.ControlRef.ddefArrayList);
        this.ArrayAnalysis.TraceArrayCellList("EUSE", this.fLoopTable.ControlRef.euseArrayList);
        this.Judgement("true-dependence", this.fLoopTable.ControlRef.modArrayList, this.fLoopTable.ControlRef.euseArrayList, this.fLoopTable.mod_euseResultList);
        this.Judgement("anti-dependence", this.fLoopTable.ControlRef.useArrayList, this.fLoopTable.ControlRef.modArrayList, this.fLoopTable.use_modResultList);
        this.fUtil.Trace("[ARRAY]output-dependence:", 5);
        this.Judgement("output-dependence", this.fLoopTable.ControlRef.modArrayList, this.fLoopTable.ControlRef.modArrayList, this.fLoopTable.mod_modResultList);
        Iterator Ie = this.fLoopTable.ArrayLastPrivate.iterator();
        block4: while (Ie.hasNext()) {
            for (Exp tmp = (Exp)Ie.next(); tmp != null; tmp = tmp.getExp1()) {
                if (!this.fUtil.IsVarNode(tmp)) continue;
                this.fUtil.Trace("ArrayLastPrivate" + tmp.toString(), 5);
                this.fLoopTable.LastPrivate.add(tmp);
                continue block4;
            }
        }
    }

    private void Judgement(String JudgeName, LinkedList ArrayCellList1, LinkedList ArrayCellList2, LinkedList indResultList) {
        this.fUtil.Trace(JudgeName, 5);
        LinkedList refResultList = new LinkedList();
        for (RefArrayCell Cell1 : ArrayCellList1) {
            for (RefArrayCell Cell2 : ArrayCellList2) {
                if (Cell1.ArrayName != Cell2.ArrayName) continue;
                for (Ref_Array ref : Cell2.ArrayRef) {
                    LinkedList<Ref_Array> JudgeList = new LinkedList<Ref_Array>();
                    JudgeList.add(ref);
                    boolean mod_flg = Cell1.ArrayAnal == 3 && Cell2.ArrayAnal == 3;
                    refResultList.clear();
                    int refResult = this.ArrayAnalysis.refJudge(this.fLoopTable, Cell1.ArrayRef, Cell1.ArrayAnal, JudgeList, Cell2.ArrayAnal, refResultList, this.fLoopTable.ArrayLastPrivate);
                    if (refResult == -1) continue;
                    this.fUtil.Trace("refResult value =" + refResult, 1);
                    this.fUtil.Trace("refResult size =" + refResultList.size(), 1);
                    int indResult = this.ArrayAnalysis.indJudge(this.fLoopTable, refResultList, mod_flg, indResultList, this.fLoopTable.ArrayLastPrivate);
                    if (indResult != -1) {
                        this.fUtil.Trace("result size =" + indResultList.size(), 1);
                        this.fLoopTable.setParaFlag(this.fUtil, false, JudgeName);
                        return;
                    }
                    return;
                }
            }
        }
    }

    private void OpenMPCheck() {
        Exp LeftExp;
        this.fUtil.Trace("---pass:OpenMPCheck", 1);
        Stmt nextStmt = this.fLoopTable.LoopStmt.getLoopInitPart();
        int count = 0;
        while (nextStmt != null) {
            if (nextStmt.getOperator() == 35) {
                nextStmt = ((BlockStmt)nextStmt).getFirstStmt();
                continue;
            }
            if (nextStmt.getOperator() == 36) {
                nextStmt = nextStmt.getNextStmt();
                continue;
            }
            if (nextStmt.getOperator() != 22) {
                this.fUtil.Trace("ERROR1" + nextStmt.getOperator(), 5);
                this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (1)");
                return;
            }
            LeftExp = ((AssignStmt)nextStmt).getLeftSide();
            if (!this.fUtil.IsVarNode(LeftExp = this.fUtil.SkipConv(LeftExp))) {
                this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (2)");
                return;
            }
            if (this.GetInduction(LeftExp.getVar()) == null) {
                this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (3)");
                return;
            }
            nextStmt = nextStmt.getNextStmt();
            ++count;
        }
        if (count == 0 && this.fLoopTable.addInit == null) {
            this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (4)");
            return;
        }
        nextStmt = this.fLoopTable.LoopStmt.getLoopStepPart();
        count = 0;
        while (nextStmt != null) {
            if (nextStmt.getOperator() == 35) {
                nextStmt = ((BlockStmt)nextStmt).getFirstStmt();
                continue;
            }
            if (nextStmt.getOperator() == 36) {
                nextStmt = nextStmt.getNextStmt();
                return;
            }
            LeftExp = ((AssignStmt)nextStmt).getLeftSide();
            if (this.GetInduction((LeftExp = this.fUtil.SkipConv(LeftExp)).getVar()) == null) {
                this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (5)");
                return;
            }
            nextStmt = nextStmt.getNextStmt();
            ++count;
        }
        if (count == 0 && this.fLoopTable.addStep == null) {
            this.fLoopTable.setParaFlag(this.fUtil, false, "OpenMP (6)");
            return;
        }
    }

    private BasicInduction GetInduction(Var v) {
        for (BasicInduction IndTable : this.fLoopTable.IndList) {
            if (IndTable.DefVarNode.getVar() != v) continue;
            return IndTable;
        }
        return null;
    }
}

