/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.SymRoot;
import coins.aflow.BBlock;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import coins.lparallel.PreDefinedFunctions;
import coins.sym.Label;
import coins.sym.PointerType;
import coins.sym.Subp;
import coins.sym.Type;

public class CheckLoopBody {
    private LoopTable fLoopTable;
    private LoopUtil fUtil;
    private PreDefinedFunctions fPreDefined;
    private Stmt InitStmt;
    private Stmt StepStmt;
    private Stmt BodyStmt;
    protected SymRoot symRoot;

    public CheckLoopBody(LoopTable pLoopTable, LoopUtil pUtil) {
        this.fLoopTable = pLoopTable;
        this.fUtil = pUtil;
        this.fPreDefined = new PreDefinedFunctions(this.fUtil.fResults.flowRoot.symRoot.sourceLanguage);
        this.InitStmt = this.fLoopTable.LoopStmt.getLoopInitPart();
        this.BodyStmt = this.fLoopTable.LoopStmt.getLoopBodyPart();
        this.StepStmt = this.fLoopTable.LoopStmt.getLoopStepPart();
        this.symRoot = pUtil.fResults.flowRoot.symRoot;
    }

    public boolean HIR_CheckLoopBody() {
        this.fUtil.Trace("---pass:CheckLoopBody", 1);
        if (!this.CheckLoopBodyPart(this.BodyStmt)) {
            this.fUtil.Trace("--- return false", 2);
            return false;
        }
        if (!this.CheckLoopBodyPart(this.StepStmt)) {
            this.fUtil.Trace("--- return false", 2);
            return false;
        }
        this.fUtil.Trace("--- return true", 2);
        return true;
    }

    private boolean CheckLoopBodyPart(Stmt pstmt) {
        if (pstmt != null) {
            this.fUtil.Trace(" CheckLoopBodyPart " + pstmt.toString(), 2);
        }
        Stmt nextStmt = pstmt;
        block15: while (nextStmt != null) {
            if (this.fUtil.TraceFlag) {
                this.fUtil.Trace(" " + nextStmt.toString(), 4);
            }
            int op = nextStmt.getOperator();
            switch (op) {
                case 23: {
                    IfStmt stmtIF = (IfStmt)nextStmt;
                    if (!this.CheckEXP(stmtIF.getIfCondition())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtIF.getThenPart())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtIF.getElsePart())) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 25: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    if (!this.CheckLoopBodyPart(stmtLOOP.getConditionalInitPart())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtLOOP.getLoopInitPart())) {
                        return false;
                    }
                    if (!this.CheckEXP(stmtLOOP.getLoopStartCondition())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtLOOP.getLoopStepPart())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtLOOP.getLoopBodyPart())) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 24: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    if (!this.CheckEXP(stmtLOOP.getLoopStartCondition())) {
                        return false;
                    }
                    if (this.CheckLoopBodyPart(stmtLOOP.getLoopBodyPart())) continue block15;
                    return false;
                }
                case 26: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    if (!this.CheckLoopBodyPart(stmtLOOP.getLoopBodyPart())) {
                        return false;
                    }
                    if (this.CheckEXP(stmtLOOP.getLoopEndCondition())) continue block15;
                    return false;
                }
                case 21: {
                    if (((LabeledStmt)nextStmt).getStmt() != null) {
                        nextStmt = ((LabeledStmt)nextStmt).getStmt();
                        continue block15;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 28: {
                    Label lJumpLabel = ((JumpStmt)nextStmt).getLabel();
                    BBlock lJumpTarget = this.fUtil.fResults.getBBlockForLabel(lJumpLabel);
                    if (this.fLoopTable.BBlockList.contains(lJumpTarget)) {
                        this.fUtil.Trace(" Jump within the loop " + lJumpLabel.getName(), 1);
                        nextStmt = nextStmt.getNextStmt();
                        continue block15;
                    }
                    this.fUtil.Trace(" Jump exit from the loop " + lJumpLabel.getName(), 1);
                    return false;
                }
                case 32: {
                    SwitchStmt stmtSWITCH = (SwitchStmt)nextStmt;
                    if (!this.CheckEXP(stmtSWITCH.getSelectionExp())) {
                        return false;
                    }
                    if (!this.CheckLoopBodyPart(stmtSWITCH.getBodyStmt())) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 36: {
                    if (!this.CheckEXP((Exp)nextStmt.getChild1())) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 33: {
                    Exp funcExp = ((ExpStmt)nextStmt).getExp();
                    if (!this.CheckEXP(funcExp)) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 35: {
                    if (!this.CheckLoopBodyPart(((BlockStmt)nextStmt).getFirstStmt())) {
                        return false;
                    }
                    nextStmt = ((BlockStmt)nextStmt).getNextStmt();
                    continue block15;
                }
                case 22: {
                    if (!this.CheckASSIGN((AssignStmt)nextStmt)) {
                        return false;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block15;
                }
                case 34: {
                    return false;
                }
                case 15: {
                    return false;
                }
            }
            nextStmt = nextStmt.getNextStmt();
        }
        return true;
    }

    private boolean CheckASSIGN(AssignStmt pstmt) {
        Exp lLeft = this.fUtil.SkipConv(pstmt.getLeftSide());
        if (this.fUtil.IsVarNode(lLeft)) {
            this.fLoopTable.DefVarList.add(lLeft);
        }
        if (!this.CheckEXP(pstmt.getLeftSide())) {
            return false;
        }
        return this.CheckEXP(pstmt.getRightSide());
    }

    private boolean CheckEXP(Exp pExp) {
        Type PointedType;
        if (pExp == null) {
            return true;
        }
        this.fUtil.Trace(" CheckExp " + pExp.toStringShort(), 5);
        int op = pExp.getOperator();
        Type opType = pExp.getType();
        if (opType.getTypeKind() == 22 && op != 64 && op != 66 && op != 38 && op != 39 && (PointedType = ((PointerType)opType).getPointedType()).getTypeKind() != 23) {
            this.fUtil.Trace(" Pointer expression in loop", 1);
            return false;
        }
        switch (op) {
            case 9: {
                SubpNode sNode = (SubpNode)pExp;
                Subp sSym = sNode.getSubp();
                String fname = sSym.getName();
                fname = fname.intern();
                if (this.fPreDefined.contains(fname)) {
                    return true;
                }
                this.fUtil.Trace(" Subprogram call in loop", 1);
                return false;
            }
            case 7: {
                break;
            }
            case 8: {
                this.fUtil.Trace(" Parameter is used in loop", 2);
                return false;
            }
            case 17: {
                if (!this.CheckEXP(pExp.getExp1())) {
                    return false;
                }
                if (this.CheckEXP(pExp.getExp2())) break;
                return false;
            }
            case 5: {
                break;
            }
            case 36: {
                if (pExp.getChild1().getOperator() == 33) {
                    String lSubpName;
                    Exp lChildExp = (Exp)pExp.getChild1().getChild1();
                    this.fUtil.Trace(" lChild of CALL " + lChildExp.toStringShort(), 5);
                    if (lChildExp.getChild1().getOperator() == 64 && lChildExp.getChild1() instanceof SubpNode && this.fPreDefined.contains(lSubpName = ((SubpNode)lChildExp.getChild1()).getSymNodeSym().getName().intern())) {
                        this.fUtil.Trace(" call without side effect " + lSubpName, 4);
                        return true;
                    }
                } else {
                    if (this.CheckEXP((Exp)pExp.getChild1())) break;
                    return false;
                }
            }
            case 33: {
                String lSubpName;
                FunctionExp funcExp = (FunctionExp)pExp;
                Exp ExpSpec = funcExp.getFunctionSpec();
                this.fUtil.Trace(" funcExpSpec " + ExpSpec.toStringShort(), 5);
                if (ExpSpec.getOperator() == 64 && ExpSpec.getChild1() instanceof SubpNode && this.fPreDefined.contains(lSubpName = ((SubpNode)ExpSpec.getChild1()).getSymNodeSym().getName().intern())) {
                    this.fUtil.Trace(" predefined " + lSubpName, 4);
                    return true;
                }
                return this.CheckEXP(ExpSpec);
            }
            case 16: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                if (!this.CheckEXP(pExp.getExp1())) {
                    return false;
                }
                if (this.CheckEXP(pExp.getExp2())) break;
                return false;
            }
            case 67: {
                break;
            }
            case 38: 
            case 39: {
                Exp lChild1 = pExp.getExp1();
                if (lChild1 instanceof VarNode && this.symRoot.safeArray.contains(((VarNode)lChild1).getSymNodeSym())) {
                    if (this.CheckEXP(pExp.getExp2())) break;
                    return false;
                }
                if (lChild1.getOperator() == 66) {
                    if (this.CheckEXP(pExp.getExp1())) break;
                    return false;
                }
                if (!this.CheckEXP(pExp.getExp1())) {
                    return false;
                }
                if (this.CheckEXP(pExp.getExp2())) break;
                return false;
            }
            case 41: {
                if (!this.CheckEXP(pExp.getExp1())) {
                    return false;
                }
                if (this.CheckEXP(pExp.getExp2())) break;
                return false;
            }
            case 65: {
                if (this.CheckEXP(pExp.getExp1())) break;
                return false;
            }
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                if (this.CheckEXP(pExp.getExp1())) break;
                return false;
            }
            case 70: {
                if (this.CheckEXP(pExp.getExp1())) break;
                return false;
            }
            case 68: {
                if (this.CheckEXP(pExp.getExp1())) break;
                return false;
            }
            case 76: {
                break;
            }
            case 19: {
                this.fLoopTable.StructNodeHash.add(pExp);
                if (this.CheckEXP(pExp.getExp1())) break;
                return false;
            }
            case 20: {
                this.fUtil.Trace(" Pointer expression in loop", 1);
                return false;
            }
        }
        return true;
    }
}

