/*
 * Decompiled with CFR 0.152.
 */
package coins.lir2c;

import coins.backend.Data;
import coins.backend.Type;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.lir2c.AnaData;
import coins.lir2c.ConvValue;
import coins.lir2c.Convert;
import coins.lir2c.Decla;
import coins.lir2c.LirToC;

public class MakeDecl {
    public static String makeDeclAuto(Symbol sym) {
        ConvValue cv = new ConvValue();
        String prefix = "";
        String postfix = "";
        if (!(sym instanceof SymAuto)) {
            prefix = "//";
            String results = " illegal symbol (not SymAuto object) ";
            return prefix + results;
        }
        prefix = "    ";
        String results = "";
        String typestr = Type.toString(sym.type);
        if (typestr.equals("I8")) {
            prefix = prefix + "char";
        } else if (typestr.equals("I16")) {
            prefix = prefix + "short";
        } else if (typestr.equals("I32")) {
            prefix = prefix + "int";
        } else if (typestr.equals("I64")) {
            prefix = prefix + "long";
        } else if (typestr.equals("F32")) {
            prefix = prefix + "float";
        } else if (typestr.equals("F64")) {
            prefix = prefix + "double";
        } else if (typestr.equals("F128")) {
            prefix = prefix + "long double";
        } else {
            if (sym.boundary == 1) {
                prefix = prefix + "char";
            } else if (sym.boundary == 2) {
                prefix = prefix + "short";
            } else if (sym.boundary == 4) {
                prefix = prefix + "int";
            } else if (sym.boundary == 8) {
                prefix = prefix + "long";
            } else if (sym.boundary == 16) {
                prefix = prefix + "long double";
            } else {
                prefix = prefix + "//";
                results = " unknown type (too big?) ";
            }
            if (typestr.indexOf(65, 0) == 0) {
                String subtypestr = typestr.substring(1);
                int len_of_obj = Integer.parseInt(subtypestr);
                postfix = "[" + Integer.toString(len_of_obj / sym.boundary / 8) + "]";
            } else {
                prefix = prefix + "//";
                results = " unknown type (not I,F,A) ";
            }
        }
        results = results + " " + cv.replace(sym.name);
        return prefix + results + postfix;
    }

    public static Decla makeDeclStatic(Symbol sym, Data data) {
        String structStr = "";
        Decla dec = new Decla();
        ConvValue cv = new ConvValue();
        String prefix = "";
        String postfix = "";
        if (!(sym instanceof SymStatic)) {
            dec.indent = "// illegal symbol (not SymStatic object) ";
            return dec;
        }
        SymStatic symsta = (SymStatic)sym;
        prefix = "    ";
        String results = "";
        String typestr = Type.toString(sym.type);
        dec.indent = "";
        if (symsta.linkage.equals("LDEF")) {
            dec.storage = "static";
        }
        if (typestr.equals("I8")) {
            dec.type = "char";
        } else if (typestr.equals("I16")) {
            dec.type = "short";
        } else if (typestr.equals("I32")) {
            dec.type = "int";
        } else if (typestr.equals("I64")) {
            dec.type = "long";
        } else if (typestr.equals("F32")) {
            dec.type = "float";
        } else if (typestr.equals("F64")) {
            dec.type = "double";
        } else if (typestr.equals("F128")) {
            dec.type = "long double";
        } else {
            if (sym.boundary == 1) {
                dec.type = "char";
            } else if (sym.boundary == 2) {
                dec.type = "short";
            } else if (sym.boundary == 4) {
                dec.type = "int";
            } else if (sym.boundary == 8) {
                dec.type = "long";
            } else if (sym.boundary == 16) {
                dec.type = "long double";
            } else {
                dec.indent = "//";
                dec.indent = dec.indent + " unknown type (too big?) ";
            }
            if (typestr.indexOf(65, 0) == 0) {
                String subtypestr = typestr.substring(1);
                int len_of_obj = Integer.parseInt(subtypestr);
                dec.array = "[" + Integer.toString(len_of_obj / sym.boundary / 8) + "]";
            } else {
                dec.indent = "//";
                dec.indent = dec.indent + " unknown type (not I,F,A) ";
            }
        }
        dec.identifier = cv.replace(sym.name);
        structStr = AnaData.structStr(data);
        if (!structStr.equals("Z")) {
            LirNode lnode;
            if (structStr.equals("ZZ")) {
                int len = data.components.length;
                lnode = data.components[0];
                LirNode lnode2 = lnode.kid(0);
                int int_value = (int)((LirIconst)lnode2).value;
                dec.array = "[" + len + "][" + int_value / sym.boundary + "]";
            } else if (!structStr.equals("S")) {
                Convert conv;
                if (structStr.equals("LN")) {
                    conv = new Convert();
                    LirNode lnode2 = data.components[0];
                    dec.type = conv.lirToTypeStr(lnode2);
                    if (dec.array.equals("")) {
                        dec.initializer = LirToC.getInitializer(data);
                    } else {
                        dec.array = "[1]";
                        dec.initializer = LirToC.getInitializer(data);
                    }
                } else if (structStr.equals("Ln")) {
                    conv = new Convert();
                    LirNode lnode3 = data.components[0];
                    dec.type = conv.lirToTypeStr(lnode3);
                    int len2 = lnode3.nKids();
                    dec.array = "[" + len2 + "]";
                    dec.initializer = LirToC.getInitializer(data);
                } else if (structStr.equals("LS")) {
                    dec.type = "char";
                    dec.pointer = "*";
                    lnode = data.components[0];
                    int len2 = lnode.nKids();
                    dec.array = "[" + len2 + "]";
                    dec.initializer = LirToC.getInitializer(data);
                } else if (structStr.equals("LLn") || structStr.equals("LLN")) {
                    conv = new Convert();
                    int len = data.components.length;
                    LirNode lnode4 = data.components[0];
                    int len2 = lnode4.nKids();
                    dec.type = conv.lirToTypeStr(lnode4);
                    dec.array = "[" + len + "][" + len2 + "]";
                    dec.initializer = LirToC.getInitializer(data);
                } else if (structStr.equals("SS") || structStr.equals("LLS") || structStr.equals("LSn")) {
                    // empty if block
                }
            }
        }
        return dec;
    }
}

