/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.alias.AliasAnalHir1;
import coins.alias.RecordAlias;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.InfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.PrintStmtVisitor;
import coins.ir.hir.PrintVisitor;
import coins.ir.hir.Program;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.TestHir2;
import coins.sym.CharConst;
import coins.sym.IntConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.Var;
import java.util.ListIterator;

public class TestHir {
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public final FlowRoot flowRoot;
    protected HIR hir;
    protected Sym sym;

    public TestHir(HirRoot pHirRoot, FlowRoot pFlowRoot) {
        this.ioRoot = pHirRoot.ioRoot;
        this.symRoot = pHirRoot.symRoot;
        this.hirRoot = pHirRoot;
        this.flowRoot = pFlowRoot;
        System.out.println("\nTestHir (invoked by coins option testHir)");
        this.sym = this.symRoot.sym;
        this.hir = this.hirRoot.hir;
        AliasAnalHir1 lAliasAnal = new AliasAnalHir1(true, this.hirRoot);
        if (this.ioRoot.dbgHir.getLevel() >= 2) {
            // empty if block
        }
        if (this.ioRoot.dbgHir.getLevel() >= 1) {
            IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
            ListIterator lSubpDefIterator = lSubpDefList.iterator();
            while (lSubpDefIterator.hasNext()) {
                SubpDefinition lSubpDef = (SubpDefinition)lSubpDefIterator.next();
                Subp lSubp = lSubpDef.getSubpSym();
                System.out.println("\nTestHir " + lSubp.toString());
                RecordAlias lRecordAlias = new RecordAlias(lAliasAnal, lSubpDef, pFlowRoot.fSubpFlow);
                if (this.ioRoot.dbgHir.getLevel() >= 4) {
                    // empty if block
                }
                if (this.ioRoot.dbgHir.getLevel() >= 6) {
                    // empty if block
                }
                if (this.ioRoot.dbgHir.getLevel() >= 2) {
                    // empty if block
                }
                if (lSubp.getName() != "main") continue;
            }
            if (this.ioRoot.dbgHir.getLevel() >= 2) {
                TestHir2 lTestHir2 = new TestHir2(this.hirRoot);
            }
        }
    }

    void testSymTable() {
        CharConst lChar9 = this.symRoot.sym.charConst('9', this.symRoot.typeChar);
        IntConst lInt9 = this.symRoot.sym.intConst(9L, this.symRoot.typeInt);
        IntConst lInt9c = this.symRoot.sym.intConst(57L, this.symRoot.typeInt);
        CharConst lCharA = this.symRoot.sym.charConst('A', this.symRoot.typeChar);
        IntConst lIntA = this.symRoot.sym.intConst(65L, this.symRoot.typeInt);
        System.out.println("charConst('A') " + lCharA.toStringDetail() + " intConst((long)'A') " + lIntA.toStringDetail());
    }

    void testAdjustableDim() {
    }

    void testgetBlockStmt(SubpDefinition pSubpDef) {
        Stmt lHirBody = pSubpDef.getSubpSym().getHirBody();
        HirIterator lHirIterator = lHirBody.hirIterator(lHirBody);
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            this.ioRoot.printOut.print("\nHir " + IoRoot.toStringObject(lNode));
            if (!(lNode instanceof Stmt)) continue;
            this.ioRoot.printOut.print(" getBlockStmt " + IoRoot.toStringObject(((Stmt)lNode).getBlockStmt()));
        }
    }

    private void testHirModify(HIR pSubpBody) {
        Stmt lStmt;
        this.ioRoot.dbgHir.print(3, "testHirModify subpBody", ((Object)pSubpBody).toString());
        if (this.ioRoot.dbgHir.getLevel() >= 3 && pSubpBody.getOperator() == 21 && (lStmt = ((LabeledStmt)pSubpBody).getStmt()).getOperator() == 35) {
            BlockStmt lBlock1 = (BlockStmt)lStmt.copyWithOperands();
            this.ioRoot.dbgHir.println(3);
            this.ioRoot.dbgHir.print(3, "CopyWithOperands result", lStmt.toStringShort());
            lBlock1.print(0);
            BlockStmt lBlock2 = (BlockStmt)lStmt.copyWithOperandsChangingLabels(null);
            this.ioRoot.dbgHir.println(3);
            this.ioRoot.dbgHir.print(3, "CopyWithOperandsChangingLabel result", lStmt.toStringShort());
            LabeledStmt lStmt2 = this.hirRoot.hir.labeledStmt(this.symRoot.symTableCurrent.generateLabel(), lBlock2);
            lStmt2.print(0);
            ((BlockStmt)((LabeledStmt)pSubpBody).getStmt()).addLastStmt(lStmt2);
        }
    }

    private void testHirComponents(HIR pSubpBody) {
        this.ioRoot.printOut.println("\ntestHirComponents ");
        HirIterator lHirIterator = pSubpBody.hirIterator(pSubpBody);
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            if (lNode instanceof SubscriptedExp) {
                Exp lSubscriptExp = ((SubscriptedExp)lNode).getSubscriptExp();
                Exp lElemSizeExp = ((SubscriptedExp)lNode).getElemSizeExp();
                this.ioRoot.printOut.println(" SubscriptedExp " + ((Object)lNode).toString() + " SubscriptExp " + lSubscriptExp.toString() + " ElemSizeExp " + lElemSizeExp.toString());
                continue;
            }
            if (lNode instanceof LoopStmt) {
                this.ioRoot.printOut.println(" isSimpleWhileLoop " + ((Object)lNode).toString() + " " + ((LoopStmt)lNode).isSimpleWhileLoop());
                this.ioRoot.printOut.println(" isSimpleForLoop " + ((Object)lNode).toString() + " " + ((LoopStmt)lNode).isSimpleForLoop());
                this.ioRoot.printOut.println(" isSimpleRepeatLoop " + ((Object)lNode).toString() + " " + ((LoopStmt)lNode).isSimpleRepeatLoop());
                continue;
            }
            if (!(lNode instanceof ConstNode) || lNode.getType() != this.symRoot.typeBool) continue;
            this.ioRoot.printOut.println(" BoolConst " + ((Object)lNode).toString() + " getSym " + ((ConstNode)lNode).getSym().toString() + " getConstSym " + ((ConstNode)lNode).getConstSym().toString());
        }
    }

    private HIR testClone(HIR pHir) {
        HIR lHir = null;
        this.ioRoot.dbgHir.print(2, "testClone", ((Object)pHir).toString());
        if (this.ioRoot.dbgHir.getLevel() >= 2) {
            lHir = pHir.copyWithOperands();
        }
        lHir.print(1, true);
        return lHir;
    }

    private void testReplace(HIR pHir) {
        HIR lParent;
        this.ioRoot.dbgHir.print(2, "replaceTest", ((Object)pHir).toString());
        System.out.println("Before replace");
        pHir.print(1, true);
        Var lNewVar = this.symRoot.sym.defineVar("REPLVAR", this.symRoot.typeInt);
        lNewVar.setFlag(2, true);
        Var lNewVar2 = this.symRoot.sym.defineVar("REPLVAR2", this.symRoot.typeInt);
        lNewVar2.setFlag(2, true);
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pHir);
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            if (lNode != null) {
                lParent = (HIR)lNode.getParent();
                continue;
            }
            lParent = null;
        }
        System.out.println("\nAfter replacing VarNode");
        pHir.print(1, true);
        int lCount = 0;
        HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(pHir);
        while (lHirIterator2.hasNextStmt()) {
            Stmt lStmt = lHirIterator2.nextStmt();
            lParent = lStmt != null ? (HIR)lStmt.getParent() : null;
            if (lStmt instanceof BlockStmt) {
                for (Stmt lStmt2 = ((BlockStmt)lStmt).getFirstStmt(); lStmt2 != null; lStmt2 = lStmt2.getNextStmt()) {
                    if (!(lStmt2 instanceof AssignStmt)) continue;
                    AssignStmt lStmt3 = this.hirRoot.hir.assignStmt(this.hirRoot.hir.varNode(lNewVar2), this.hirRoot.hir.constNode(this.symRoot.sym.intConst(0L, this.symRoot.typeInt)));
                    lStmt2.replaceThisStmtWith(lStmt3);
                    ++lCount;
                    lStmt2 = lStmt3;
                }
            }
            if (lCount <= 0) continue;
        }
        System.out.println("\nAfter replacing AssignStmt");
        pHir.print(1, true);
    }

    private void testNodeIterator() {
    }

    private void testBBlockIterator() {
    }

    private void testInf(SubpDefinition pSubpDef) {
        if (this.ioRoot.dbgHir.getLevel() >= 4) {
            HIR lNode;
            this.ioRoot.printOut.println("\ntestInf. Add index as inf for InfStmt");
            HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
            while (lHirIterator.hasNext()) {
                lNode = lHirIterator.next();
                if (lNode instanceof InfStmt) {
                    lNode.addInf("coins_inf", this.hirRoot.hir.intConstNode(lNode.getIndex()));
                    continue;
                }
                if (!(lNode instanceof AssignStmt)) continue;
            }
            this.ioRoot.printOut.print("\n Print inf\n ");
            lHirIterator = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
            while (lHirIterator.hasNext()) {
                lNode = lHirIterator.next();
                if (lNode == null || lNode.getInfList() == null) continue;
                this.ioRoot.printOut.print("\n " + lNode.toStringDetail());
            }
        }
    }

    void testVisitor(SubpDefinition pSubpDef) {
        Subp lSubpSym = pSubpDef.getSubpSym();
        this.ioRoot.printOut.print("\ntest Stmt visitor (HirVisitorModel1)\n" + lSubpSym.getName());
        PrintStmtVisitor printStmtVisitor = new PrintStmtVisitor(this.hirRoot);
        printStmtVisitor.visit((HIR)this.hirRoot.programRoot);
        this.ioRoot.printOut.print("\ntest Node visitor (HirVisitorModel2)\n" + lSubpSym.getName());
        PrintVisitor printVisitor = new PrintVisitor(this.hirRoot);
        printVisitor.visit((HIR)this.hirRoot.programRoot);
    }

    void addStatements(SubpDefinition pSubpDef) {
        this.ioRoot.printOut.print("\naddStatements " + pSubpDef.getSubpSym().getName() + "\n");
        Stmt lSubpBody = pSubpDef.getHirBody();
        BlockStmt lSubpBodyBlock = null;
        if (lSubpBody instanceof BlockStmt) {
            lSubpBodyBlock = (BlockStmt)lSubpBody;
        } else if (lSubpBody instanceof LabeledStmt && ((LabeledStmt)lSubpBody).getStmt() instanceof BlockStmt) {
            lSubpBodyBlock = (BlockStmt)((LabeledStmt)lSubpBody).getStmt();
        }
        if (lSubpBodyBlock != null) {
            ReturnStmt lReturnStmt;
            Stmt lStmt = lSubpBodyBlock.getLastStmt();
            if (lStmt instanceof ReturnStmt) {
                lReturnStmt = (ReturnStmt)lStmt;
            } else {
                lReturnStmt = this.hirRoot.hir.returnStmt();
                lSubpBodyBlock.addLastStmt(lReturnStmt);
            }
            Var lBoolVar = this.symRoot.symTableCurrent.generateVar(this.symRoot.typeBool);
            AssignStmt lBoolAssign = this.hirRoot.hir.assignStmt(this.hir.varNode(lBoolVar), this.hir.constNode(this.sym.boolConst(true)));
            lReturnStmt.insertPreviousStmt(lBoolAssign);
        }
    }

    Exp reorderOperands(Exp pExp) {
        if (pExp == null || pExp.getChildCount() != 2) {
            return pExp;
        }
        Exp lChild1 = (Exp)pExp.getChild1();
        Exp lChild2 = (Exp)pExp.getChild2();
        Exp lNewChild1 = this.reorderOperands(lChild1);
        Exp lNewChild2 = this.reorderOperands(lChild2);
        if (lNewChild2.isEvaluable() && !lNewChild1.isEvaluable() && this.isCommutative(pExp)) {
            Exp lExp = this.hirRoot.hir.exp(pExp.getOperator(), lNewChild2, lNewChild1);
            return lExp;
        }
        if (lChild1 != lNewChild1 || lChild2 != lNewChild2) {
            Exp lExp = this.hirRoot.hir.exp(pExp.getOperator(), lNewChild1, lNewChild2);
            return lExp;
        }
        return pExp;
    }

    boolean isCommutative(Exp pExp) {
        if (pExp == null) {
            return false;
        }
        switch (pExp.getOperator()) {
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 48: {
                return true;
            }
        }
        return false;
    }
}

