/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.BlockStmtImpl;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.sym.Label;
import java.util.ListIterator;

public class StmtImpl
extends HIR_Impl
implements Stmt {
    protected Stmt fNextStmt = null;
    protected Stmt fPrevStmt = null;
    protected boolean fMultiBlock = false;
    private String fFileName = null;
    private int fLineNumber = 0;

    public StmtImpl() {
    }

    public StmtImpl(HirRoot pHirRoot) {
        super(pHirRoot, 21);
    }

    protected StmtImpl(HirRoot pHirRoot, int pOperator) {
        super(pHirRoot, pOperator);
        this.fType = this.hirRoot.symRoot.typeVoid;
    }

    public Stmt addNextStmt(Stmt pStatement) {
        Stmt lStmt;
        if (pStatement == null || pStatement == this) {
            return pStatement;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "\naddNextStmt " + pStatement.toStringShort() + " curr " + this.toStringShort());
        }
        if ((lStmt = pStatement).getParent() != null || lStmt.getNextStmt() != null || lStmt.getPreviousStmt() != null) {
            lStmt = (Stmt)lStmt.copyWithOperands();
        }
        if (this.fParentNode instanceof BlockStmt) {
            ((StmtImpl)lStmt).fParentNode = this.fParentNode;
            ((StmtImpl)lStmt).fNextStmt = this.fNextStmt;
            ((StmtImpl)lStmt).fPrevStmt = this;
            if (this.fNextStmt != null) {
                ((StmtImpl)this.fNextStmt).fPrevStmt = lStmt;
            }
            this.fNextStmt = lStmt;
            if (((BlockStmt)this.fParentNode).getLastStmt() == this) {
                ((BlockStmtImpl)this.fParentNode).setLastStmt(lStmt);
            }
        } else {
            HIR lParent2 = (HIR)this.getParent();
            Stmt lPrev2 = this.getPreviousStmt();
            Stmt lNext2 = this.getNextStmt();
            int lChildNum = this.getChildNumber();
            this.cutParentLink();
            this.fNextStmt = null;
            this.fPrevStmt = null;
            Stmt lCombinedStmt = this.combineStmt(lStmt, false);
            if (lParent2 != null && lChildNum > 0) {
                lParent2.replaceSource(lChildNum, lCombinedStmt);
            }
            ((StmtImpl)lCombinedStmt).fNextStmt = lNext2;
            ((StmtImpl)lCombinedStmt).fPrevStmt = lPrev2;
            if (lPrev2 != null) {
                ((StmtImpl)lPrev2).fNextStmt = lCombinedStmt;
            }
            if (lNext2 != null) {
                ((StmtImpl)lNext2).fPrevStmt = lCombinedStmt;
            }
        }
        ((StmtImpl)lStmt).printLinkage("addNextStmt");
        return lStmt;
    }

    public Stmt addNextStmt(Stmt pStatement, BlockStmt pBlock) {
        return this.addNextStmt(pStatement);
    }

    public Stmt getNextStmt() {
        return this.fNextStmt;
    }

    public Stmt getUpperStmt() {
        HIR lUpperNode;
        for (lUpperNode = (HIR)this.getParent(); lUpperNode != null && !lUpperNode.isStmt(); lUpperNode = (HIR)lUpperNode.getParent()) {
        }
        return (Stmt)lUpperNode;
    }

    public Stmt insertPreviousStmt(Stmt pStatement) {
        if (pStatement == null || pStatement == this) {
            return pStatement;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "\ninsertPreviousStmt " + pStatement.toStringShort() + " curr " + this.toStringShort());
        }
        if (this.fDbgLevel >= 6) {
            pStatement.print(3, true);
        }
        if (this.fPrevStmt != null) {
            return this.fPrevStmt.addNextStmt(pStatement);
        }
        Stmt lStmt = pStatement;
        if (lStmt.getParent() != null || lStmt.getNextStmt() != null || lStmt.getPreviousStmt() != null) {
            lStmt = (Stmt)lStmt.copyWithOperands();
        }
        if (this.fParentNode instanceof BlockStmt) {
            this.fPrevStmt = lStmt;
            ((StmtImpl)lStmt).fNextStmt = this;
            ((StmtImpl)lStmt).fPrevStmt = null;
            ((StmtImpl)lStmt).fParentNode = this.fParentNode;
            if (((BlockStmt)this.fParentNode).getFirstStmt() == this) {
                ((BlockStmtImpl)this.fParentNode).setFirstStmt(lStmt);
            }
        } else {
            HIR lParent2 = (HIR)this.getParent();
            Stmt lPrev2 = this.getPreviousStmt();
            Stmt lNext2 = this.getNextStmt();
            int lChildNum = this.getChildNumber();
            this.cutParentLink();
            this.fNextStmt = null;
            this.fPrevStmt = null;
            Stmt lCombinedStmt = lStmt.combineStmt(this, false);
            if (lParent2 != null && lChildNum > 0) {
                lParent2.replaceSource(lChildNum, lCombinedStmt);
            }
            ((StmtImpl)lCombinedStmt).fNextStmt = lNext2;
            ((StmtImpl)lCombinedStmt).fPrevStmt = lPrev2;
            if (lPrev2 != null) {
                ((StmtImpl)lPrev2).fNextStmt = lCombinedStmt;
            }
            if (lNext2 != null) {
                ((StmtImpl)lNext2).fPrevStmt = lCombinedStmt;
            }
        }
        ((StmtImpl)lStmt).printLinkage("insertPreviousStmt");
        return lStmt;
    }

    public Stmt insertPreviousStmt(Stmt pStatement, BlockStmt pBlock) {
        return this.insertPreviousStmt(pStatement);
    }

    public Stmt getPreviousStmt() {
        return this.fPrevStmt;
    }

    public Stmt combineStmt(Stmt pStmt, boolean pBeforeBranch) {
        Stmt lStmt;
        StmtImpl lLeadingStmt = this;
        Stmt lResult = null;
        if (pStmt == null || pStmt == this) {
            return this;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(4, "combineStmt", this.toStringShort() + " and " + pStmt.toStringShort() + " parent " + this.fParentNode);
        }
        if ((lStmt = pStmt).getParent() != null || lStmt.getNextStmt() != null || lStmt.getPreviousStmt() != null) {
            lStmt = (Stmt)lStmt.copyWithOperandsChangingLabels(null);
        }
        if (lLeadingStmt instanceof LabeledStmt) {
            LabeledStmt lLabeledStmt2 = (LabeledStmt)((Object)lLeadingStmt);
            if (lLabeledStmt2.getStmt() == null) {
                lLabeledStmt2.setStmt(lStmt);
            } else {
                lLabeledStmt2.getStmt().combineStmt(lStmt, pBeforeBranch);
            }
            lResult = lLabeledStmt2;
        } else if (lLeadingStmt.getOperator() == 35) {
            if (pBeforeBranch) {
                ((BlockStmt)((Object)lLeadingStmt)).addBeforeBranchStmt(lStmt);
            } else {
                ((BlockStmt)((Object)lLeadingStmt)).addLastStmt(lStmt);
            }
            lResult = lLeadingStmt;
        } else {
            HIR lParent2 = (HIR)lLeadingStmt.getParent();
            Stmt lPrev2 = lLeadingStmt.getPreviousStmt();
            Stmt lNext2 = lLeadingStmt.getNextStmt();
            int lChildNum = lLeadingStmt.getChildNumber();
            lLeadingStmt.cutParentLink();
            lLeadingStmt.fNextStmt = null;
            lLeadingStmt.fPrevStmt = null;
            lResult = this.hirRoot.hir.blockStmt(lLeadingStmt);
            if (pBeforeBranch) {
                ((BlockStmt)lResult).addBeforeBranchStmt(lStmt);
            } else {
                ((BlockStmt)lResult).addLastStmt(lStmt);
            }
            if (lParent2 != null && lChildNum > 0) {
                lParent2.replaceSource(lChildNum, lResult);
            }
            ((StmtImpl)lResult).fNextStmt = lNext2;
            ((StmtImpl)lResult).fPrevStmt = lPrev2;
            if (lPrev2 != null) {
                ((StmtImpl)lPrev2).fNextStmt = lResult;
            }
            if (lNext2 != null) {
                ((StmtImpl)lNext2).fPrevStmt = lResult;
            }
        }
        ((StmtImpl)lStmt).printLinkage("combinedStmt");
        ((StmtImpl)lResult).printLinkage("combinedResult");
        return lResult;
    }

    public Stmt traceLastStmt() {
        Stmt lStmt = this;
        while (lStmt.fNextStmt != null) {
            lStmt = lStmt.fNextStmt;
        }
        return lStmt;
    }

    public Stmt traceFirstStmt() {
        Stmt lStmt = this;
        while (lStmt.fPrevStmt != null) {
            lStmt = lStmt.fPrevStmt;
        }
        return lStmt;
    }

    public Stmt deleteThisStmt() {
        Stmt lNext = this.fNextStmt;
        Object lBlock = null;
        if (this.fDbgLevel > 2) {
            this.hirRoot.ioRoot.dbgHir.print(3, "deleteThisStmt", this.toString());
        }
        this.cutLabelLinkOfStmt(this);
        if (this.fPrevStmt != null) {
            ((StmtImpl)this.fPrevStmt).fNextStmt = this.fNextStmt;
        }
        if (this.fNextStmt != null) {
            ((StmtImpl)this.fNextStmt).fPrevStmt = this.fPrevStmt;
        }
        if (this.fParentNode instanceof BlockStmt) {
            if (((BlockStmt)this.fParentNode).getFirstStmt() == this) {
                ((BlockStmtImpl)this.fParentNode).setFirstStmt(this.fNextStmt);
            }
            if (((BlockStmt)this.fParentNode).getLastStmt() == this) {
                ((BlockStmtImpl)this.fParentNode).setLastStmt(this.fPrevStmt);
            }
        }
        if (this.isMultiBlock()) {
            this.adjustMultiBlockFlag();
        }
        if (this.fParentNode != null) {
            int childcount = this.fParentNode.getChildCount();
            for (int i = 1; i <= childcount; ++i) {
                if (this.fParentNode.getChild(i) != this) continue;
                this.fParentNode.setChild(i, null);
                break;
            }
        }
        if (this.fPrevStmt != null) {
            ((StmtImpl)this.fPrevStmt).printLinkage("prev of deleted node");
        }
        if (lNext != null) {
            ((StmtImpl)lNext).printLinkage("next of deleted node");
        }
        if (this.fDbgLevel > 4 && this.fParentNode != null && this.fParentNode instanceof BlockStmt) {
            this.hirRoot.ioRoot.dbgHir.print(5, " first stmt of block " + IoRoot.toStringObjectShort(this.fParentNode.getChild1()));
        }
        this.fNextStmt = null;
        this.fPrevStmt = null;
        return lNext;
    }

    public void cutLabelLinkOfStmt(Stmt pStmt) {
        HirIterator lIterator = pStmt.hirIterator(pStmt);
        while (lIterator.hasNextStmt()) {
            Stmt lStmt = lIterator.nextStmt();
            if (lStmt == null) continue;
            if (this.fDbgLevel > 2) {
                this.hirRoot.ioRoot.dbgHir.print(3, " cutLabelLinkOfStmt" + lStmt.toStringShort());
            }
            if (!(lStmt instanceof LabeledStmt)) continue;
            HirList lLabelDefList = (HirList)((LabeledStmt)lStmt).getLabelDefList();
            ListIterator lLabelIterator = lLabelDefList.iterator();
            while (lLabelIterator.hasNext()) {
                LabelDef lLabelDef = (LabelDef)lLabelIterator.next();
                if (lLabelDef == null) continue;
                Label lLabel = lLabelDef.getLabel();
                lLabel.setHirPosition(null);
                if (this.fDbgLevel <= 2) continue;
                this.hirRoot.ioRoot.dbgHir.print(3, "label " + lLabel.toStringShort());
            }
        }
    }

    public Stmt deleteNextStmt() {
        if (this.fNextStmt != null) {
            return this.fNextStmt.deleteThisStmt();
        }
        return null;
    }

    public Stmt deletePreviousStmt() {
        if (this.fPrevStmt != null) {
            return this.fPrevStmt.deleteThisStmt();
        }
        return null;
    }

    public void isolateThisStmt() {
        Stmt lNext = this.fNextStmt;
        Object lBlock = null;
        if (this.fPrevStmt != null) {
            ((StmtImpl)this.fPrevStmt).fNextStmt = null;
        }
        if (this.fNextStmt != null) {
            ((StmtImpl)this.fNextStmt).fPrevStmt = null;
        }
        this.fNextStmt = null;
        this.fPrevStmt = null;
        this.cutParentLink();
    }

    public Stmt replaceThisStmtWith(Stmt pStmt) {
        Stmt lResult = pStmt;
        if (pStmt == null) {
            this.deleteThisStmt();
        } else {
            if (this == pStmt) {
                return lResult;
            }
            if (this.fDbgLevel > 2) {
                this.hirRoot.ioRoot.dbgHir.print(3, "replaceThisStmtWith", pStmt.toString() + " this " + this.toString());
            }
            if (pStmt.getParent() == this || this.getParent() == pStmt) {
                this.hirRoot.ioRoot.msgRecovered.put(1112, "self recursion in replaceThisStmtWith " + this.toStringShort() + " " + pStmt.toStringShort());
                return lResult;
            }
            ((StmtImpl)pStmt).fNextStmt = this.fNextStmt;
            ((StmtImpl)pStmt).fPrevStmt = this.fPrevStmt;
            ((StmtImpl)pStmt).fParentNode = this.fParentNode;
            if (this.fPrevStmt != null) {
                ((StmtImpl)this.fPrevStmt).fNextStmt = pStmt;
            }
            if (this.fNextStmt != null) {
                ((StmtImpl)this.fNextStmt).fPrevStmt = pStmt;
            }
            if (this.fParentNode != null) {
                int childcount = this.fParentNode.getChildCount();
                for (int i = 1; i <= childcount; ++i) {
                    if (this.fParentNode.getChild(i) != this) continue;
                    this.fParentNode.setChild(i, pStmt);
                    break;
                }
            }
            this.fPrevStmt = null;
            this.fNextStmt = null;
        }
        this.cutParentLink();
        this.cutLabelLinkOfStmt(this);
        this.printLinkage("replaceThisStmtWith-result");
        return lResult;
    }

    public LabeledStmt attachLabel(Label pLabel) {
        LabeledStmt lLabeledStmt;
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "attachLabel", pLabel.toString() + " to " + this.toString());
        }
        if ((lLabeledStmt = this.getLabeledStmt()) == null) {
            lLabeledStmt = this.attachLabelAsFirstOne(pLabel);
        } else {
            IrList lLabelDefList = lLabeledStmt.getLabelDefList();
            if (!lLabelDefList.contains(pLabel)) {
                lLabelDefList.add(this.hirRoot.hir.labelDef(pLabel));
            }
        }
        pLabel.setHirPosition(lLabeledStmt);
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "return " + lLabeledStmt.toString());
        }
        return lLabeledStmt;
    }

    public LabeledStmt attachLabelAsFirstOne(Label pLabel) {
        LabeledStmt lLabeledStmt = this.getLabeledStmt();
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "attachLabelAsFirstOne", pLabel.toString() + " to " + this.toString());
        }
        if (lLabeledStmt == null) {
            Stmt lPrev = this.getPreviousStmt();
            Stmt lNext = this.getNextStmt();
            HIR lParent = (HIR)this.getParent();
            int lChildNumber = this.getChildNumber();
            lLabeledStmt = this.hirRoot.hir.labeledStmt(pLabel, this);
            ((StmtImpl)((Object)lLabeledStmt)).fPrevStmt = lPrev;
            if (lPrev != null) {
                ((StmtImpl)lPrev).fNextStmt = lLabeledStmt;
            }
            ((StmtImpl)((Object)lLabeledStmt)).fNextStmt = lNext;
            if (lNext != null) {
                ((StmtImpl)lNext).fPrevStmt = lLabeledStmt;
            }
            ((StmtImpl)((Object)lLabeledStmt)).fParentNode = lParent;
            if (lChildNumber > 0) {
                lParent.setChild(lChildNumber, lLabeledStmt);
            }
            this.fPrevStmt = null;
            this.fNextStmt = null;
        } else {
            IrList lLabelDefList = lLabeledStmt.getLabelDefList();
            if (!lLabelDefList.contains(pLabel)) {
                lLabelDefList.add(0, this.hirRoot.hir.labelDef(pLabel));
            } else if (lLabelDefList.getFirst() != pLabel) {
                lLabelDefList.remove(lLabelDefList.indexOf(pLabel));
                lLabelDefList.add(0, this.hirRoot.hir.labelDef(pLabel));
            }
        }
        if (pLabel != null) {
            pLabel.setHirPosition(lLabeledStmt);
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "return " + lLabeledStmt.toString());
        }
        return lLabeledStmt;
    }

    public IrList getLabelDefList() {
        LabeledStmt lLabeledStmt = this.getLabeledStmt();
        if (lLabeledStmt == null) {
            return null;
        }
        return lLabeledStmt.getLabelDefList();
    }

    public Label getLabel() {
        IrList lLabelDefList = this.getLabelDefList();
        if (lLabelDefList == null) {
            return null;
        }
        return ((LabelDef)lLabelDefList.getFirst()).getLabel();
    }

    public Stmt getStmtWithLabel(Label pLabel) {
        if (this.hirRoot.symRoot.subpCurrent != null) {
            return this.hirRoot.symRoot.subpCurrent.getStmtWithLabel(pLabel);
        }
        return null;
    }

    public LabeledStmt getLabeledStmt() {
        if (this.getOperator() == 21) {
            return (LabeledStmt)((Object)this);
        }
        if (this.fParentNode != null && this.fParentNode.getOperator() == 21) {
            return (LabeledStmt)this.fParentNode;
        }
        return null;
    }

    public LabeledStmt backTraceLabeledStmt() {
        return null;
    }

    public BlockStmt getBlockStmt() {
        Stmt lStmt = this;
        while (lStmt != null) {
            IR lParent;
            if (lStmt.getOperator() == 35) {
                if (this.fDbgLevel > 3) {
                    this.hirRoot.ioRoot.dbgHir.print(7, "getBlockStmt", ((Object)lStmt).toString());
                }
                return (BlockStmt)lStmt;
            }
            if (lStmt.fParentNode != null && lStmt.fParentNode.getOperator() == 35) {
                if (this.fDbgLevel > 3) {
                    this.hirRoot.ioRoot.dbgHir.print(8, "getBlockStmt", lStmt.fParentNode.toString());
                }
                return (BlockStmt)lStmt.fParentNode;
            }
            for (lParent = lStmt.getParent(); lParent != null && !(lParent instanceof Stmt); lParent = lParent.getParent()) {
            }
            if (lParent == null) {
                return null;
            }
            lStmt = (Stmt)lParent;
            if (this.fDbgLevel <= 3) continue;
            IoRoot cfr_ignored_0 = this.hirRoot.ioRoot;
            this.hirRoot.ioRoot.dbgHir.print(8, " parent " + IoRoot.toStringObject(lStmt));
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(8, "getBlockStmt", "null");
        }
        return null;
    }

    public boolean isMultiBlock() {
        return this.fMultiBlock;
    }

    public void adjustMultiBlockFlag() {
        if (this.fParentNode == null) {
            return;
        }
        if (this.fParentNode.getOperator() == 35) {
            ((StmtImpl)this.fParentNode).fMultiBlock = false;
            for (Stmt lStmt = ((BlockStmt)this.fParentNode).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                if (lStmt.getLabel() == null && !lStmt.isMultiBlock()) continue;
                ((StmtImpl)this.fParentNode).fMultiBlock = true;
                break;
            }
        }
    }

    public void adjustMultiBlockFlag(Stmt pStmt) {
        if (this.fParentNode == null || !pStmt.isMultiBlock()) {
            return;
        }
        ((StmtImpl)this.fParentNode).fMultiBlock = true;
    }

    public boolean isLoopStmt() {
        return false;
    }

    public boolean isBranchStmt() {
        switch (this.getOperator()) {
            case 28: 
            case 34: {
                return true;
            }
            case 21: {
                if (((LabeledStmt)((Object)this)).getStmt() == null) {
                    return false;
                }
                return ((LabeledStmt)((Object)this)).getStmt().isBranchStmt();
            }
        }
        return false;
    }

    public Stmt ancestorControlStmtOfConditionalExp(HIR pHir) {
        Stmt lContainingStmt;
        HIR lParent;
        Stmt lResult = null;
        HIR lHir = pHir;
        if (pHir == null) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(4, "ancestorControlStmtOfConditionalExp", pHir.toStringWithChildren());
        }
        if ((lParent = (lContainingStmt = lHir.getStmtContainingThisNode())) instanceof ExpStmt) {
            lParent = (HIR)lParent.getParent();
        }
        while (lParent instanceof LabeledStmt) {
            lParent = (HIR)lParent.getParent();
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, " lParent:" + lParent.toStringShort());
        }
        if (lParent instanceof IfStmt) {
            if (((IfStmt)lParent).getIfCondition().contains(lHir)) {
                lResult = (Stmt)lParent;
            }
        } else if (lParent instanceof LoopStmt) {
            if (lContainingStmt instanceof ExpStmt || lHir instanceof ExpStmt || lHir.getType() == this.hirRoot.symRoot.typeBool) {
                lResult = (Stmt)lParent;
            }
        } else if (lParent instanceof SwitchStmt && ((SwitchStmt)lParent).getSelectionExp().contains(lHir)) {
            lResult = (Stmt)lParent;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(4, " result " + lResult);
        }
        return lResult;
    }

    public void combineWithConditionalExp(Stmt pStmt, HIR pCond) {
    }

    public Object clone() throws CloneNotSupportedException {
        Stmt lTree;
        try {
            lTree = (Stmt)super.clone();
            if (this.fDbgLevel > 4) {
                this.hirRoot.ioRoot.dbgHir.print(9, "clone of Stmt " + lTree.toString());
            }
        }
        catch (CloneNotSupportedException e) {
            this.hirRoot.ioRoot.msgRecovered.put(1100, "CloneNotSupportedException(StmtImpl) " + this.toString());
            return null;
        }
        ((StmtImpl)lTree).fMultiBlock = this.fMultiBlock;
        ((StmtImpl)lTree).fNextStmt = null;
        ((StmtImpl)lTree).fPrevStmt = null;
        return lTree;
    }

    public final void setFileName(String pFileName) {
        this.fFileName = pFileName;
    }

    public final String getFileName() {
        if (this.fFileName != null) {
            return this.fFileName;
        }
        return this.hirRoot.ioRoot.getSourceFilePath();
    }

    public final void setLineNumber(int pLineNumber) {
        this.fLineNumber = pLineNumber;
    }

    public final int getLineNumber() {
        return this.fLineNumber;
    }

    public final void copyPosition(Stmt pStmt) {
        this.fFileName = ((StmtImpl)pStmt).fFileName;
        this.fLineNumber = ((StmtImpl)pStmt).fLineNumber;
    }

    public String toStringDetail() {
        BlockStmt lBlockStmt;
        String lString = super.toStringDetail();
        if (this.fFileName != null && this.hirRoot.ioRoot.dbgHir.getLevel() > 1) {
            lString = lString + " file " + this.fFileName;
        }
        if (this.fLineNumber > 0) {
            lString = lString + " line " + this.fLineNumber;
        }
        if (this.fDbgLevel >= 4 && (lBlockStmt = this.getBlockStmt()) != null) {
            lString = lString + " " + lBlockStmt.toString();
        }
        return lString;
    }

    public void printLinkage(String pHeader) {
        if (this.fDbgLevel >= 1) {
            Stmt lNext;
            Stmt lPrev;
            int lChildNum;
            HIR lParent = (HIR)this.getParent();
            if (lParent != null && !(lParent instanceof BlockStmt) && lParent.getChild(lChildNum = this.getChildNumber()) != this) {
                this.hirRoot.ioRoot.msgWarning.put(" Bad parent-link in " + pHeader + " for " + this.toStringShort() + " parent " + lParent.toStringShort() + " child " + lChildNum);
            }
            if ((lPrev = this.getPreviousStmt()) != null && lPrev.getNextStmt() != this) {
                this.hirRoot.ioRoot.msgWarning.put(" Bad previous-link in " + pHeader + " for " + this.toStringShort() + " prev " + lPrev.toStringShort());
            }
            if ((lNext = this.getNextStmt()) != null && lNext.getPreviousStmt() != this) {
                this.hirRoot.ioRoot.msgWarning.put(" Bad next-link in " + pHeader + " for " + this.toStringShort() + " next " + lNext.toStringShort());
            }
        }
        if (this.fDbgLevel >= 7) {
            this.hirRoot.ioRoot.dbgHir.print(1, " " + pHeader, this.toStringShort());
            this.hirRoot.ioRoot.dbgHir.printObject(1, "prev", this.fPrevStmt);
            this.hirRoot.ioRoot.dbgHir.printObject(1, "next", this.fNextStmt);
            this.hirRoot.ioRoot.dbgHir.printObject(1, "parent", this.getParent());
        }
    }
}

