/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirVisitor;
import coins.ir.hir.IndexedLoopStmt;
import coins.ir.hir.LoopStmtImpl;
import coins.ir.hir.Stmt;
import coins.sym.Label;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;

public class IndexedLoopStmtImpl
extends LoopStmtImpl
implements IndexedLoopStmt {
    protected Var fLoopIndex;
    protected Exp fStartValue;
    protected Exp fEndValue;
    protected Exp fStepValue;
    protected boolean fUpward;

    public IndexedLoopStmtImpl(HirRoot pHirRoot, Var pLoopIndex, Exp pStartValue, Exp pEndValue, Exp pStepValue, boolean pUpward, Stmt pLoopBody) {
        super(pHirRoot);
        Stmt lStepPart;
        Exp lCondition;
        Stmt lInitPart;
        Exp lEndValue;
        Exp lStepValue;
        this.fOperator = 27;
        Var lStepVar = null;
        Var lEndVar = null;
        HIR hir = pHirRoot.hir;
        Type lType = pLoopIndex.getSymType();
        int lTypeKind = lType.getTypeKind();
        SymTable lSymTable = pHirRoot.symRoot.symTableCurrentSubp;
        Label lLoopBackLabel = lSymTable.generateLabel();
        Label lLoopStepLabel = lSymTable.generateLabel();
        Label lLoopEndLabel = lSymTable.generateLabel();
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(5, "indexedLoopStmtImpl(", pLoopIndex.toString() + ", " + pStartValue.toString() + ", " + pEndValue.toString() + ", " + IoRoot.toStringObject(pStepValue) + " upward " + pUpward + ")");
        }
        if (lTypeKind <= 12 && lTypeKind >= 3) {
            int lStepOperator;
            int lCmpOperator;
            AssignStmt lInitStmt = this.hirRoot.hir.assignStmt(hir.varNode(pLoopIndex), pStartValue);
            if (pStepValue == null) {
                lStepValue = hir.constNode(pHirRoot.symRoot.intConst1);
            } else if (pStepValue instanceof ConstNode) {
                lStepValue = pStepValue;
            } else {
                lStepVar = lSymTable.generateVar(lType);
                lStepValue = hir.varNode(lStepVar);
            }
            if (pEndValue instanceof ConstNode) {
                lEndValue = pEndValue;
            } else {
                lEndVar = lSymTable.generateVar(lType);
                lEndValue = hir.varNode(lEndVar);
            }
            if (lStepVar == null && lEndVar == null) {
                lInitPart = lInitStmt;
            } else {
                lInitPart = hir.blockStmt(lInitStmt);
                if (lEndVar != null) {
                    ((BlockStmt)lInitPart).addLastStmt(hir.assignStmt(hir.varNode(lEndVar), pEndValue));
                }
                if (lStepVar != null) {
                    ((BlockStmt)lInitPart).addLastStmt(hir.assignStmt(hir.varNode(lStepVar), pStepValue));
                }
            }
            if (pUpward) {
                lCmpOperator = 56;
                lStepOperator = 38;
            } else {
                lCmpOperator = 54;
                lStepOperator = 39;
            }
            lCondition = hir.exp(lCmpOperator, hir.varNode(pLoopIndex), lEndValue);
            lStepPart = hir.assignStmt(hir.varNode(pLoopIndex), hir.exp(lStepOperator, hir.varNode(pLoopIndex), lStepValue));
        } else {
            int lStepOperator;
            Var lLoopIndexInt = lSymTable.generateVar(pHirRoot.symRoot.typeInt);
            Var lEndValueInt = lSymTable.generateVar(pHirRoot.symRoot.typeInt);
            Exp lStartValue = pStartValue.getType() == lType ? pStartValue : hir.convExp(lType, pStartValue);
            lEndValue = pEndValue.getType() == lType ? pEndValue : hir.convExp(lType, pEndValue);
            lStepValue = pStepValue == null ? hir.constNode(pHirRoot.symRoot.sym.floatConst(1.0, lType)) : (pStepValue.getType() == lType ? pStepValue : hir.convExp(lType, pStepValue));
            Exp lCountF = pUpward ? hir.exp(42, hir.exp(38, hir.exp(39, lEndValue, lStartValue), lStepValue), (Exp)lStepValue.copyWithOperands()) : hir.exp(42, hir.exp(38, hir.exp(39, lStartValue, lEndValue), lStepValue), (Exp)lStepValue.copyWithOperands());
            Exp lCountInt = hir.convExp(this.hirRoot.symRoot.typeInt, lCountF);
            lInitPart = this.hirRoot.hir.assignStmt(hir.varNode(pLoopIndex), pStartValue);
            ((BlockStmt)lInitPart).addLastStmt(hir.assignStmt(hir.varNode(lLoopIndexInt), hir.constNode(pHirRoot.symRoot.intConst1)));
            ((BlockStmt)lInitPart).addLastStmt(hir.assignStmt(hir.varNode(lEndValueInt), lCountInt));
            if (pStepValue != null && !(pStepValue instanceof ConstNode)) {
                lStepVar = lSymTable.generateVar(lType);
                ((BlockStmt)lInitPart).addLastStmt(hir.assignStmt(hir.varNode(lStepVar), lStepValue));
                lStepValue = hir.varNode(lStepVar);
            }
            if (pUpward) {
                int lCmpOperator = 56;
                lStepOperator = 38;
            } else {
                int lCmpOperator = 54;
                lStepOperator = 39;
            }
            lCondition = hir.exp(56, hir.varNode(lLoopIndexInt), hir.varNode(lEndValueInt));
            lStepPart = hir.blockStmt(hir.assignStmt(hir.varNode(pLoopIndex), hir.exp(lStepOperator, hir.varNode(pLoopIndex), lStepValue)));
            ((BlockStmt)lStepPart).addLastStmt(hir.assignStmt(hir.varNode(lLoopIndexInt), hir.exp(38, hir.varNode(lLoopIndexInt), hir.constNode(pHirRoot.symRoot.intConst1))));
        }
        this.setChildrenOfLoop(lInitPart, lLoopBackLabel, null, lCondition, pLoopBody, lLoopStepLabel, null, lStepPart, lLoopEndLabel, null);
        this.fLoopIndex = pLoopIndex;
        this.fStartValue = (Exp)pStartValue.copyWithOperands();
        this.fEndValue = (Exp)lEndValue.copyWithOperands();
        this.fStepValue = (Exp)lStepValue.copyWithOperands();
        this.fUpward = pUpward;
        this.fType = pHirRoot.symRoot.typeVoid;
    }

    public Var getLoopIndex() {
        return this.fLoopIndex;
    }

    public Exp getStartValue() {
        return this.fStartValue;
    }

    public Exp getEndValue() {
        return this.fEndValue;
    }

    public Exp getStepValue() {
        return this.fStepValue;
    }

    public boolean isUpward() {
        return this.fUpward;
    }

    public void accept(HirVisitor pVisitor) {
        pVisitor.atIndexedLoopStmt(this);
    }
}

