/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirIterator;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmtImpl;
import coins.sym.Label;
import coins.sym.SymTable;
import java.util.ListIterator;

public class HirModify
extends HIR_Impl {
    protected final IoRoot ioRoot;
    protected final HIR hir;

    public HirModify(HirRoot pHirRoot) {
        super(pHirRoot);
        this.ioRoot = pHirRoot.ioRoot;
        this.hir = pHirRoot.hir;
        this.fOperator = 73;
    }

    public void moveWithOperands(int pFromChild, IR pTo, int pNumber) {
        HIR lParent = (HIR)((HIR_Impl)pTo).fParentNode;
        if (lParent != null) {
            lParent.setChild(pFromChild, null);
        }
        this.fParentNode = pTo;
        ((HIR_Impl)pTo).setChild(pNumber, this);
    }

    public void changeLabelsInTree(HIR pTree, IrList pLabelCorrespondence) {
        IrList lOldLabelList = this.hir.irList();
        IrList lNewLabelList = this.hir.irList();
        Label lLoopBackLabel = null;
        Label lLoopStepLabel = null;
        Label lLoopEndLabel = null;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(4, "changeLabelsInTree", IoRoot.toStringObject(pTree));
        }
        if (pTree == null) {
            return;
        }
        lOldLabelList = (IrList)pLabelCorrespondence.get(0);
        lNewLabelList = (IrList)pLabelCorrespondence.get(1);
        if (lOldLabelList.isEmpty()) {
            return;
        }
        HirIterator lHirIterator = this.hir.hirIterator(pTree);
        while (lHirIterator.hasNext()) {
            Label lNewLabel;
            int lIndex;
            Label lOldLabel;
            HIR lNode = lHirIterator.next();
            if (lNode == null) continue;
            if (lNode.getOperator() == 21) {
                IrList lLabelDefListOrg = ((LabeledStmt)lNode).getLabelDefList();
                IrList lLabelDefListNew = this.hir.irList();
                ListIterator lListIterator = lLabelDefListOrg.iterator();
                while (lListIterator.hasNext()) {
                    lOldLabel = ((LabelDef)lListIterator.next()).getLabel();
                    lIndex = lOldLabelList.indexOf(lOldLabel);
                    if (lIndex < 0) continue;
                    lNewLabel = (Label)lNewLabelList.get(lIndex);
                    lLabelDefListNew.add(this.hir.labelDef(lNewLabel));
                    if (this.fDbgLevel <= 3) continue;
                    this.ioRoot.dbgHir.print(5, "change " + lNode.toStringShort(), lOldLabel.getName() + " to " + lNewLabel.getName());
                }
                ((LabeledStmt)lNode).setLabelDefList(lLabelDefListNew);
                continue;
            }
            if (lNode.getOperator() == 11) {
                lOldLabel = (Label)((LabelNode)lNode).getSymNodeSym();
                lIndex = lOldLabelList.indexOf(lOldLabel);
                if (lIndex < 0) continue;
                lNewLabel = (Label)lNewLabelList.get(lIndex);
                ((LabelNode)lNode).setSymNodeSym(lNewLabel);
                if (this.fDbgLevel <= 3) continue;
                this.ioRoot.dbgHir.print(5, "change " + lNode.toStringShort(), lOldLabel.getName() + " to " + lNewLabel.getName());
                continue;
            }
            if (!(lNode instanceof LoopStmtImpl)) continue;
            LoopStmtImpl lLoopStmt = (LoopStmtImpl)lNode;
            lIndex = lOldLabelList.indexOf(lLoopStmt.getLoopBackLabel());
            if (lIndex >= 0) {
                lLoopStmt.fLoopBackLabel = lLoopBackLabel = (Label)lNewLabelList.get(lIndex);
            }
            if ((lIndex = lOldLabelList.indexOf(lLoopStmt.getLoopStepLabel())) >= 0) {
                lLoopStmt.fLoopStepLabel = lLoopStepLabel = (Label)lNewLabelList.get(lIndex);
            }
            if ((lIndex = lOldLabelList.indexOf(lLoopStmt.getLoopEndLabel())) >= 0) {
                lLoopStmt.fLoopEndLabel = lLoopEndLabel = (Label)lNewLabelList.get(lIndex);
            }
            this.ioRoot.dbgHir.print(4, "change labels of LoopStmt", " back " + lLoopBackLabel + " step " + lLoopStepLabel + " end " + lLoopEndLabel);
        }
    }

    public IrList makeLabelCorrespondenceList(HIR pTree) {
        IrList lOldLabelList = this.hir.irList();
        IrList lNewLabelList = this.hir.irList();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(5, "makeLabelCorrespondenceList", IoRoot.toStringObject(pTree));
        }
        if (pTree == null) {
            return null;
        }
        SymTable lSubpSymTable = this.hirRoot.symRoot.subpCurrent.getSymTable();
        HirIterator lHirIterator = this.hir.hirIterator(pTree);
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            if (lNode == null || lNode.getOperator() != 21) continue;
            IrList lLabelDefList = ((LabeledStmt)lNode).getLabelDefList();
            ListIterator lListIterator = lLabelDefList.iterator();
            while (lListIterator.hasNext()) {
                Label lOldLabel = ((LabelDef)lListIterator.next()).getLabel();
                Label lNewLabel = lSubpSymTable.generateLabel();
                lOldLabelList.add(lOldLabel);
                lNewLabelList.add(lNewLabel);
                if (this.fDbgLevel <= 3) continue;
                this.ioRoot.dbgHir.print(5, "label org", lOldLabel.toString() + " new " + lNewLabel.toString());
            }
        }
        IrList lLabelCorrespondence = this.hir.irList();
        lLabelCorrespondence.add(lOldLabelList);
        lLabelCorrespondence.add(lNewLabelList);
        return lLabelCorrespondence;
    }

    public Label getNewLabel(Label pOldLabel, IrList pLabelCorrespondence) {
        IrList lOldLabelList = (IrList)pLabelCorrespondence.get(0);
        IrList lNewLabelList = (IrList)pLabelCorrespondence.get(1);
        int lIndex = lOldLabelList.indexOf(pOldLabel);
        Label lNewLabel = lIndex >= 0 ? (Label)lNewLabelList.get(lIndex) : pOldLabel;
        return lNewLabel;
    }
}

