/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HasStringObject;
import coins.HirRoot;
import coins.IoRoot;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirList;
import coins.ir.hir.HirVisitor;
import coins.sym.Sym;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class HirListImpl
extends HIR_Impl
implements HirList {
    private LinkedList fList;

    public HirListImpl(HirRoot pHirRoot, LinkedList pList) {
        super(pHirRoot);
        this.fOperator = 14;
        this.fList = pList == null ? new LinkedList() : pList;
        this.fType = this.hirRoot.symRoot.typeVoid;
    }

    public HirListImpl(HirRoot pHirRoot) {
        super(pHirRoot);
        this.fOperator = 14;
        this.fList = new LinkedList();
        this.fType = this.hirRoot.symRoot.typeVoid;
    }

    public void add(Object pElement) {
        if (pElement == null) {
            return;
        }
        this.fList.add(pElement);
        if (pElement instanceof HIR && ((HIR_Impl)pElement).getParent() == null) {
            ((HIR_Impl)pElement).setParent(this);
        }
        if (this.hirRoot.ioRoot.dbgHir.getLevel() > 1) {
            this.hirRoot.ioRoot.dbgHir.print(7, "HirList add", pElement.toString());
        }
    }

    public void add(int pInsertionPosition, Object pObjectToBeInserted) {
        this.fList.add(pInsertionPosition, pObjectToBeInserted);
        if (pObjectToBeInserted instanceof HIR && ((HIR_Impl)pObjectToBeInserted).getParent() == null) {
            ((HIR_Impl)pObjectToBeInserted).setParent(this);
        }
    }

    public Object getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.fList.get(0);
    }

    public Object get(int pIndex) {
        return this.fList.get(pIndex);
    }

    public void set(int pIndex, Object pElement) {
        this.fList.set(pIndex, pElement);
        if (pElement instanceof HIR && ((HIR)pElement).getParent() == null) {
            ((HIR_Impl)pElement).setParent(this);
        }
    }

    public boolean isEmpty() {
        return this.fList.isEmpty();
    }

    public int size() {
        return this.fList.size();
    }

    public boolean contains(Object pObject) {
        return this.fList.contains(pObject);
    }

    public int indexOf(Object pObject) {
        return this.fList.indexOf(pObject);
    }

    public Object remove(int pRemovePosition) {
        return this.fList.remove(pRemovePosition);
    }

    public boolean remove(Object pObject) {
        return this.fList.remove(pObject);
    }

    public void clear() {
        this.fList.clear();
    }

    public ListIterator iterator() {
        return this.fList.listIterator();
    }

    public Object clone() throws CloneNotSupportedException {
        HirListImpl lTree;
        Object lObject = null;
        try {
            lTree = (HirListImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.hirRoot.ioRoot.msgRecovered.put(1100, "CloneNotSupportedException(HirListImpl) " + e.getMessage() + " " + this.toString());
            return null;
        }
        if (this.fList != null) {
            LinkedList<Object> lList = new LinkedList<Object>();
            Iterator listIterator = this.fList.iterator();
            while (listIterator.hasNext()) {
                try {
                    lObject = listIterator.next();
                    if (lObject != null) {
                        HasStringObject lHasStringObject = (HasStringObject)lObject;
                        if (lHasStringObject.isHIR()) {
                            HIR lHir = (HIR)((Object)lHasStringObject);
                            HIR lElem = lHir.hirClone();
                            lList.add(lElem);
                            ((HIR_Impl)lElem).fParentNode = lTree;
                            continue;
                        }
                        if (lHasStringObject.isSym()) {
                            lList.add((Sym)((Object)lHasStringObject));
                            continue;
                        }
                        lList.add(lObject);
                        continue;
                    }
                    lList.add(null);
                }
                catch (ClassCastException e) {
                    lList.add(lObject);
                    IoRoot cfr_ignored_0 = this.hirRoot.ioRoot;
                    this.hirRoot.ioRoot.msgFatal.put(1103, "HirList.clone() ClassCastException " + e.getMessage() + " " + IoRoot.toStringObject(lObject));
                }
            }
            lTree.fList = lList;
            if (this.hirRoot.ioRoot.dbgHir.getLevel() > 1) {
                this.hirRoot.ioRoot.dbgHir.print(5, "HirList clone", lTree.toStringWithChildren());
            }
        }
        return lTree;
    }

    public HirList hirListClone() throws CloneNotSupportedException {
        return (HirList)this.clone();
    }

    public void print(int pIndent) {
        String lSpace = this.hirRoot.hir.getIndentSpace(pIndent);
        if (this.fList != null) {
            this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "(list " + this.getIndex());
            Iterator listIterator = this.fList.iterator();
            while (listIterator.hasNext()) {
                ((HasStringObject)listIterator.next()).print(pIndent + 1);
            }
            this.hirRoot.ioRoot.printOut.print(")");
        } else {
            this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "(list )");
        }
    }

    public void print(int pIndent, boolean pDetail) {
        String lSpace = this.hirRoot.hir.getIndentSpace(pIndent);
        if (this.fList != null) {
            this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "(list " + this.getIndex());
            int lListSize = this.fList.size();
            int lIndex = 0;
            for (HasStringObject lObject : this.fList) {
                if (lIndex > lListSize) break;
                ++lIndex;
                if (lObject instanceof HIR) {
                    ((HIR)((Object)lObject)).print(pIndent + 1, pDetail);
                    continue;
                }
                lObject.print(pIndent + 1);
            }
            this.hirRoot.ioRoot.printOut.print(")");
        } else {
            this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "(list )");
        }
    }

    public void accept(HirVisitor pVisitor) {
        pVisitor.atHirList(this);
    }
}

