/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TreeStructure {
    private Map fObjectToNode = new HashMap();

    public TreeStructure(Collection pCollection) {
        for (Object lObj : pCollection) {
            this.fObjectToNode.put(lObj, new Node(lObj));
        }
    }

    public TreeStructure() {
    }

    public Object parentOf(Object pObj) {
        Node lParent = ((Node)this.fObjectToNode.get((Object)pObj)).fParent;
        return lParent == null ? null : lParent.fObj;
    }

    public List childrenOf(Object pObj) {
        List lNodes = ((Node)this.fObjectToNode.get((Object)pObj)).fChildren;
        ListIterator<Object> lListIt = lNodes.listIterator();
        while (lListIt.hasNext()) {
            Node lNextNode = (Node)lListIt.next();
            lListIt.set(lNextNode.fObj);
        }
        return lNodes;
    }

    public List ancestorsOf(Object pObj) {
        ArrayList<Object> lAncestor = new ArrayList<Object>();
        Object lParent = pObj;
        while (lParent != null) {
            lAncestor.add(lParent);
            lParent = this.parentOf(lParent);
        }
        return lAncestor;
    }

    public boolean link(Object pParent, Object pChild) {
        this.inclusionCheck(pParent);
        this.inclusionCheck(pChild);
        Node lParentNode = (Node)this.fObjectToNode.get(pParent);
        List lChildrenOfParentNode = lParentNode.fChildren;
        Node lChildNode = (Node)this.fObjectToNode.get(pChild);
        if (!lChildrenOfParentNode.contains(lChildNode)) {
            lChildrenOfParentNode.add(lChildNode);
            lChildNode.fParent = lParentNode;
            return true;
        }
        return false;
    }

    private boolean inclusionCheck(Object pObj) {
        if (this.fObjectToNode.containsKey(pObj)) {
            return false;
        }
        this.fObjectToNode.put(pObj, new Node(pObj));
        return true;
    }

    private static class Node {
        Object fObj;
        Node fParent;
        List fChildren = new ArrayList();

        Node(Object pObj) {
            this.fObj = pObj;
        }
    }
}

