/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.flow.BitVectorImpl;
import coins.flow.ExpVector;
import coins.flow.ExpVectorIterator;
import coins.flow.ExpVectorIteratorImpl;
import coins.flow.SubpFlow;
import coins.sym.ExpId;
import java.util.HashSet;
import java.util.Set;

public class ExpVectorImpl
extends BitVectorImpl
implements ExpVector {
    public final SubpFlow fSubpFlow;
    private Set fExps;

    protected ExpVectorImpl(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
        this.fBitLength = this.fSubpFlow.getExpVectorBitCount();
        this.fLongWordLength = this.fBitLength / 64 + 1;
        this.fVectorWord = new long[this.fLongWordLength + 1];
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public Set exps() {
        this.fExps = new HashSet();
        ExpVectorIteratorImpl lExpVectIt = new ExpVectorIteratorImpl(this.fSubpFlow, this);
        while (lExpVectIt.hasNext()) {
            ExpId lExpId = lExpVectIt.nextExpId();
            if (lExpId == null) continue;
            this.fExps.add(lExpId);
        }
        return this.fExps;
    }

    public boolean contains(ExpId pExpId) {
        return this.isSet(pExpId.getIndex());
    }

    public static ExpVector expVectorFromSet(Set pExps, SubpFlow pSubpFlow) {
        ExpVector lExpVect = pSubpFlow.expVector();
        for (ExpId lExpId : pExps) {
            lExpVect.setBit(lExpId.getIndex());
        }
        return lExpVect;
    }

    public String toStringConcise() {
        return super.toString();
    }

    public String toStringShort() {
        Object lNextSym = null;
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("[");
        ExpVectorIterator lIterator = this.expVectorIterator();
        while (lIterator.hasNext()) {
            ExpId lFlowExpId = lIterator.nextExpId();
            if (lFlowExpId == null) continue;
            lBuffer.append(lFlowExpId.toStringShort() + ' ');
        }
        lBuffer.append("]");
        return lBuffer.toString();
    }

    public String toStringByName() {
        return this.exps().toString();
    }

    public String toStringDescriptive() {
        Object lNextSym = null;
        SubpFlow lSubpFlow = this.getSubpFlow();
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("[");
        ExpVectorIterator lIterator = this.expVectorIterator();
        while (lIterator.hasNext()) {
            ExpId lFlowExpId = lIterator.nextExpId();
            if (lFlowExpId == null) continue;
            lBuffer.append('\n' + lFlowExpId.toString());
        }
        lBuffer.append("]\n");
        return lBuffer.toString();
    }

    public ExpVectorIterator expVectorIterator() {
        return new ExpVectorIteratorImpl(this.fSubpFlow, this);
    }
}

