/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.flow.BBlock;
import coins.flow.BBlockNodeIterator;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;

public class BBlockHirNodeIteratorImpl
implements BBlockNodeIterator {
    public final FlowRoot flowRoot;
    private boolean fHeaderPassed = false;
    private boolean fEndLabelAppeared = false;
    protected int fDbgLevel;
    private BBlock fBBlock;
    protected int fNextNodeIndex;
    public final SubpFlow fSubpFlow;
    protected Stmt fNextStmt;
    protected boolean fJumpReturnAppeared;

    public BBlockHirNodeIteratorImpl(FlowRoot pFlowRoot, BBlock pBBlock) {
        this.flowRoot = pFlowRoot;
        this.fSubpFlow = this.flowRoot.fSubpFlow;
        this.fDbgLevel = pFlowRoot.ioRoot.dbgFlow.getLevel();
        this.fBBlock = pBBlock;
        if (pBBlock != null) {
            HIR lSubtree = (HIR)pBBlock.getIrLink();
            if (this.fDbgLevel > 3) {
                IoRoot cfr_ignored_0 = this.flowRoot.ioRoot;
                this.flowRoot.ioRoot.dbgFlow.print(4, "BBlockHirNodeIteratorImpl", " B" + pBBlock.getBBlockNumber() + " " + IoRoot.toStringObjectShort(lSubtree));
            }
            this.fBBlock = pBBlock;
            this.fNextNodeIndex = lSubtree.getIndex();
            while (this.fNextNodeIndex <= this.fSubpFlow.getIrIndexMax() && this.fSubpFlow.getIndexedNode(this.fNextNodeIndex) == null && !(this.fSubpFlow.getIndexedNode(this.fNextNodeIndex) instanceof LabeledStmt)) {
                ++this.fNextNodeIndex;
            }
            this.fJumpReturnAppeared = false;
        }
    }

    public IR next() {
        IR lNextNode = this.fSubpFlow.getIndexedNode(this.fNextNodeIndex);
        if (lNextNode instanceof LabeledStmt) {
            if (this.fHeaderPassed) {
                return null;
            }
            this.fHeaderPassed = true;
        }
        if (lNextNode != null && (lNextNode.getOperator() == 28 || lNextNode.getOperator() == 34)) {
            this.fJumpReturnAppeared = true;
        }
        ++this.fNextNodeIndex;
        if (this.fDbgLevel > 3) {
            IoRoot cfr_ignored_0 = this.flowRoot.ioRoot;
            this.flowRoot.ioRoot.dbgFlow.print(5, " next", IoRoot.toStringObjectShort(lNextNode));
        }
        return lNextNode;
    }

    public boolean hasNext() {
        if (this.fNextNodeIndex > this.fSubpFlow.getIrIndexMax()) {
            return false;
        }
        HIR lNode = (HIR)this.fSubpFlow.getIndexedNode(this.fNextNodeIndex);
        if (this.fJumpReturnAppeared && lNode instanceof Stmt) {
            return false;
        }
        if (!(lNode instanceof LabeledStmt)) {
            return true;
        }
        return !this.fHeaderPassed;
    }

    public HIR getNextExecutableNode() {
        HIR lNextNode = null;
        boolean lExecutable = false;
        lNextNode = (HIR)this.next();
        while (!lExecutable && this.hasNext()) {
            if (lNextNode != null) {
                switch (lNextNode.getOperator()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 21: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 73: {
                        lExecutable = false;
                        break;
                    }
                    default: {
                        lExecutable = true;
                    }
                }
            }
            lNextNode = (HIR)this.next();
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "getNextExecutableNode", lNextNode.toStringShort());
        }
        return lNextNode;
    }
}

