/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.AssignOrFuncStmt;
import coins.ffront.ComplexExp;
import coins.ffront.DeclManager;
import coins.ffront.ExecStmtManager;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HirUtility;
import coins.ffront.IntrinsicUtility;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.StmtFuncParamType;
import coins.ffront.StmtFuncType;
import coins.ffront.Token;
import coins.ffront.TypeUtility;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.VarNode;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class SubscrOrFunCallNode
extends Pair {
    private String ident;
    private IrList aParamList;
    HirUtility fHirUtil;
    TypeUtility fTypeUtil;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    IntrinsicUtility fIntrUtil;
    HIR hir;

    public SubscrOrFunCallNode(Token t, FirList list, FirToHir pfHir) {
        super(t, list, pfHir);
        this.fIntrUtil = pfHir.getIntrinsicUtility();
        this.hir = this.fHir.getHir();
    }

    public String getIdent() {
        return ((Token)this.left).getLexem();
    }

    public Exp makeExp() {
        this.ident = this.getIdent();
        this.fHirUtil = this.fHir.getHirUtility();
        this.fDeclMgr = this.fHir.getDeclManager();
        this.fESMgr = this.fHir.getExecStmtManager();
        this.fTypeUtil = this.fHir.getTypeUtility();
        Sym fSym = this.fDeclMgr.search(this.ident);
        if (this.fIntrUtil.isIntrinsicCall(this.ident) && (fSym == null || fSym.getSymKind() != 9)) {
            if (fSym != null && fSym.getSymKind() != 12) {
                fSym.remove();
            }
            this.dp("- makeExp: intrisic function call: " + this.ident);
            return this.fIntrUtil.makeIntrinsicCall(this.ident, (FirList)this.right);
        }
        if (fSym == null) {
            this.dp("- makeExp: implicit external function call: " + this.ident);
            return this.makeNewFunCall(this.fDeclMgr.getImplicitType(this.ident));
        }
        Type fSymType = fSym.getSymType();
        switch (fSym.getSymKind()) {
            case 9: {
                fSymType = ((PointerType)fSymType).getPointedType();
            }
            case 8: 
            case 10: {
                if (fSymType instanceof VectorType) {
                    this.dp("- makeExp: subscripted variable");
                    return this.makeSubscripted();
                }
                if (fSym instanceof Param) {
                    return this.makeParamFunCall((Param)fSym);
                }
                fSym.remove();
                this.dp("- makeExp: function call");
                return this.makeNewFunCall(fSymType);
            }
            case 12: {
                this.dp("- makeExp: makeFunCall");
                return this.makeFunCall(fSym);
            }
        }
        this.fHir.printMsgFatal("undefined : " + this.left);
        return null;
    }

    Exp makeParamFunCall(Param param) {
        IrList aParamList = this.makeArgList();
        IrList fParamTypeList = this.hir.irList();
        return this.hir.functionExp(this.hir.varNode(param), aParamList);
    }

    Exp makeNewFunCall(Type returnType) {
        HIR hir = this.fHir.getHir();
        Sym sym = this.fHir.getSym();
        IrList aParamList = this.makeArgList();
        IrList fParamTypeList = hir.irList();
        if (this.fTypeUtil.isComplexType(returnType)) {
            this.dp("- makeNewFunCall: complex type");
            String dummyName = this.fESMgr.getTempName();
            Type expType = returnType;
            Var dummyVar = sym.defineVar(dummyName, expType);
            VarNode dummyExp = hir.varNode(dummyVar);
            aParamList.add(0, hir.exp(64, dummyExp));
            String id = ((Token)this.left).changeLexem();
            Sym lSym = this.fDeclMgr.search(id);
            Subp lSubp = lSym == null ? this.fDeclMgr.defineSubp(id, this.fTypeUtil.getVoidType(), 2, null) : (Subp)lSym;
            ExpStmt stmt = hir.callStmt(this.fHirUtil.makeSubpExp(lSubp), aParamList);
            this.fESMgr.getCurrentStmt().addGeneratedStmt(stmt);
            return this.fHirUtil.makeComplexExp(hir.varNode(dummyVar));
        }
        Subp lSubp = this.fDeclMgr.defineSubp(this.ident, returnType, 2, null);
        return hir.functionExp(this.fHirUtil.makeSubpExp(lSubp), aParamList);
    }

    IrList makeAParams() {
        IrList aParamList = this.fHir.getHir().irList();
        if (this.right != null) {
            Iterator it = ((FirList)this.right).iterator();
            while (it.hasNext()) {
                Exp lExp = ((Node)it.next()).makeExp();
                aParamList.add(lExp);
            }
        }
        return aParamList;
    }

    IrList makeFParamTypes(FirList pList) {
        IrList fParamTypeList = this.fHir.getHir().irList();
        for (Token paramName : pList) {
            this.dp("makeFParamTypes#paramName: " + paramName.getLexem());
            fParamTypeList.add(this.fDeclMgr.searchType(paramName.getLexem()));
        }
        return fParamTypeList;
    }

    void registerFParams(FirList pList, IrList fParamList) {
        ListIterator fIt = fParamList.iterator();
        Iterator it = pList.iterator();
        int index = 0;
        while (it.hasNext()) {
            Token paramName = (Token)it.next();
            Type lType = (Type)fIt.next();
            this.fHir.getSym().defineParam(paramName.getLexem(), new StmtFuncParamType(lType, this, index++, this.fHir));
        }
    }

    public Exp getAParamAt(int index) {
        return (Exp)this.aParamList.get(index);
    }

    Exp makeSubscripted() {
        Exp base_exp = this.left.makeExp();
        Object index_exp = null;
        Exp[] di_exps = new Exp[7];
        Exp[] lb_exps = new Exp[7];
        Type type = base_exp.getType();
        this.dp("makeSubscripted: " + base_exp);
        this.dp("base type: " + type);
        FirList dims = (FirList)this.right;
        int dimnum = 0;
        int dimsize = 0;
        while (type instanceof VectorType && !this.fTypeUtil.isFortranCharacterType(type)) {
            if (((VectorType)type).getLowerBound() != 0L || ((VectorType)type).getLowerBoundExp() != null) {
                lb_exps[dimsize] = ((VectorType)type).getLowerBoundExp();
            }
            type = ((VectorType)type).getElemType();
            ++dimsize;
        }
        Iterator it = dims.iterator();
        while (it.hasNext()) {
            if (dimnum >= dimsize) {
                this.fHir.printMsgFatal("over dimmension size");
                return null;
            }
            di_exps[dimnum++] = ((Node)it.next()).makeExp();
        }
        while (dimnum-- > 0) {
            Exp iexp = di_exps[dimnum];
            if (lb_exps[dimnum] != null) {
                iexp = di_exps[dimnum];
            }
            base_exp = this.hir.subscriptedExp(base_exp, iexp);
        }
        if (type instanceof StructType) {
            base_exp = this.fHirUtil.makeComplexExp(base_exp);
        } else if (this.fTypeUtil.isFortranCharacterType(type)) {
            base_exp = this.fHirUtil.makeFortranCharacterExp(base_exp, this.fTypeUtil.getFortranCharacterLengthExp(type, this.left));
        }
        return base_exp;
    }

    Exp makeFunCall(Sym funcSym) {
        HIR hir = this.fHir.getHir();
        SubpType subpType = (SubpType)funcSym.getSymType();
        if (subpType instanceof StmtFuncType) {
            this.aParamList = this.makeAParams();
            AssignOrFuncStmt source = ((StmtFuncType)subpType).getSource();
            FirList fParams = (FirList)((SubscrOrFunCallNode)source.getLeft()).getRight();
            if (fParams == null) {
                fParams = new FirList(this.fHir);
            }
            IrList fParamTypeList = this.makeFParamTypes(fParams);
            Exp result = null;
            SymTable lSymTable = this.fTypeUtil.pushSymTable(null);
            this.registerFParams(fParams, fParamTypeList);
            result = source.getRight().makeExp();
            this.fTypeUtil.popSymTable();
            this.fESMgr.getCurrentStmt().setSymTable(lSymTable);
            return result;
        }
        IrList aParamList = this.makeArgList();
        Type fSymType = subpType;
        fSymType = fSymType.getReturnType();
        this.dp("- external function call: " + funcSym + "(type as " + fSymType + ")");
        if (fSymType instanceof StructType) {
            return this.makeNewFunCall(fSymType);
        }
        return hir.functionExp(this.fHirUtil.makeSubpExp((Subp)funcSym), aParamList);
    }

    public Exp makeArgAddr(FStmt pCallStmt) {
        Exp lExp = this.makeExp();
        if (lExp instanceof ComplexExp) {
            lExp = ((ComplexExp)lExp).getRealPart();
        }
        if (this.fIntrUtil.isIntrinsicCall(this.getIdent())) {
            return this.fHirUtil.makeArgAddr(pCallStmt, lExp);
        }
        Sym fSym = this.fDeclMgr.search(this.getIdent());
        if (fSym != null) {
            switch (fSym.getSymKind()) {
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    if (lExp instanceof FortranCharacterExp) {
                        lExp = ((FortranCharacterExp)lExp).fBody;
                    }
                    return this.fHir.getHir().exp(64, lExp);
                }
            }
            this.fHir.printMsgFatal("undefined " + this.left);
            return null;
        }
        this.fHir.printMsgFatal("undefined(not found) " + this.left);
        return null;
    }

    private IrList makeArgList() {
        IrList lParamList = this.fHir.getHir().irList();
        LinkedList<Exp> strparam_list = new LinkedList<Exp>();
        if (this.right != null) {
            for (Node lParam : (FirList)this.right) {
                Exp exp = lParam.makeExp();
                Exp lParamAddr = lParam.makeArgAddr(this.fESMgr.getCurrentStmt());
                if (lParamAddr != null) {
                    lParamList.add(lParamAddr);
                    if (!(exp instanceof FortranCharacterExp)) continue;
                    strparam_list.add(((FortranCharacterExp)exp).getLength());
                    continue;
                }
                this.fHir.printMsgFatal("error in actual argument");
            }
            for (Exp length : strparam_list) {
                lParamList.add(length);
            }
        }
        return lParamList;
    }

    void dp(String str) {
        this.fHir.dp(str);
    }
}

