/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BinaryNode;
import coins.ffront.FNumber;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.HasConstValue;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.SubscrOrFunCallNode;
import coins.ffront.Token;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.Type;

public class PowerNode
extends BinaryNode {
    HirUtility fHirUtil;

    public PowerNode(Node left, Node right, FirToHir pfHir) {
        super(0, left, right, pfHir);
        this.fHirUtil = this.fHir.getHirUtility();
    }

    public void print(int level, String spaces) {
        this.fHir.debugPrint(level, spaces + "binary: **\n");
        super.print(level, spaces);
    }

    public String toString() {
        return "PowerExp **";
    }

    public Exp makeExp() {
        Token rightToken;
        HIR hir = this.fHir.getHir();
        if (this.right instanceof Token && (rightToken = (Token)this.right).getKind() == 259) {
            String rightStringValue = rightToken.getLexem();
            int rightValue = Integer.parseInt(rightStringValue);
            switch (rightValue) {
                case 0: {
                    Exp lExp1 = this.left.makeExp();
                    Type exp1Type = lExp1.getType();
                    if (exp1Type.isInteger()) {
                        return this.fHirUtil.makeConstInt1Node();
                    }
                    return this.fHirUtil.makeConstReal1Node();
                }
                case 1: {
                    return this.left.makeExp();
                }
                case 2: {
                    return new BinaryNode(41, this.left, this.left, this.fHir).makeExp();
                }
                case 3: {
                    BinaryNode bExp = new BinaryNode(41, this.left, this.left, this.fHir);
                    return new BinaryNode(41, bExp, this.left, this.fHir).makeExp();
                }
                case 4: {
                    BinaryNode bExp = new BinaryNode(41, this.left, this.left, this.fHir);
                    return new BinaryNode(41, bExp, bExp, this.fHir).makeExp();
                }
            }
        }
        FirList paramList = new FirList(this.fHir);
        paramList.addedLast(this.left).addedLast(this.right);
        Token powerToken = new Token(0, "_power".intern(), 261);
        return new SubscrOrFunCallNode(powerToken, paramList, this.fHir).makeExp();
    }

    public FNumber getConstValue() {
        FNumber ln = null;
        FNumber rn = null;
        if (this.left instanceof HasConstValue) {
            ln = ((HasConstValue)((Object)this.left)).getConstValue();
        }
        if (this.right instanceof HasConstValue) {
            rn = ((HasConstValue)((Object)this.right)).getConstValue();
        }
        if (ln != null && rn != null) {
            FNumber v = ln;
            FNumber r = FNumber.make(1);
            int n = rn.intValue();
            for (int i = 0; i < n; ++i) {
                r = r.mul(v);
            }
            return r;
        }
        return null;
    }
}

