/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.F77Sym;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.sym.Type;

public class ImplicitManager
extends BaseManager {
    private Type[] implicitTable = new Type[26];
    private boolean[] implicitCheck = new boolean[26];

    public ImplicitManager(FirToHir fth) {
        super(fth);
    }

    void processImplicit(F77Sym f7Sym) {
        int i;
        for (i = 0; i < 26; ++i) {
            this.implicitTable[i] = this.symRoot.typeFloat;
            this.implicitCheck[i] = false;
        }
        for (i = 8; i <= 13; ++i) {
            this.implicitTable[i] = this.symRoot.typeInt;
        }
        FirList implicitList = f7Sym.implicitList;
        for (Pair p : implicitList) {
            if (p == null) {
                this.dp("implicit: all implicit type declaration will be error.");
                for (int i2 = 0; i2 < this.implicitTable.length; ++i2) {
                }
                break;
            }
            Type t = this.fTypeUtil.getType((Pair)p.getLeft());
            String s = ((Token)p.getRight()).getLexem();
            int n = s.length();
            for (int i3 = 0; i3 < n; ++i3) {
                int c = s.charAt(i3) - 97;
                if (this.implicitCheck[c]) {
                    this.printMsgFatal("already explicitly established : " + s.charAt(i3));
                    continue;
                }
                this.implicitCheck[c] = true;
                this.implicitTable[c] = t;
            }
        }
    }

    public Type getImplicitType(String id) {
        return this.implicitTable[id.charAt(0) - 97];
    }
}

