/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.DeclManager;
import coins.ffront.ExecStmtManager;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.Token;
import coins.ffront.TypeUtility;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.Stmt;
import coins.sym.Label;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import java.util.Iterator;

public class FStmt
implements Node {
    FirToHir fHir;
    int fLine;
    HIR hir;
    Token defLabel = null;
    Stmt stmt = null;
    FirList generatedStmts = null;
    HirUtility fHirUtil;
    TypeUtility fTypeUtil;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    SymTable fSymTable;

    public FStmt(int line, FirToHir pfHir) {
        this.fHir = pfHir;
        this.fLine = line;
        this.hir = this.fHir.getHirRoot().hir;
        this.fHirUtil = this.fHir.getHirUtility();
        this.fTypeUtil = this.fHir.getTypeUtility();
    }

    public void print(int level, String spaces) {
        if (this.defLabel != null) {
            this.defLabel.print(level, spaces);
        }
    }

    public String toString() {
        if (this.defLabel != null) {
            return this.defLabel.toString();
        }
        return "";
    }

    public void addLabel(Token t) {
        this.defLabel = t;
    }

    public void preprocess() {
        this.fDeclMgr = this.fHir.getDeclManager();
        this.fESMgr = this.fHir.getExecStmtManager();
        this.fTypeUtil = this.fHir.getTypeUtility();
        this.fHirUtil = this.fHir.getHirUtility();
    }

    public void process() {
        if (this.defLabel != null) {
            Label hLabel = this.fESMgr.makeLabel(this.defLabel.getLexem());
            if (this.generatedStmts == null) {
                this.generatedStmts = new FirList(this.fHir);
            }
            this.generatedStmts.addFirst(this.hir.labeledStmt(hLabel, null));
        }
    }

    public Exp makeExp() {
        this.fHir.printMsgFatal("Fatal Error: FStmt is not an Expression.");
        return null;
    }

    public Exp makeArgAddr(FStmt pFStmt) {
        this.fHir.printMsgFatal("Fatal Error: FStmt is not an Argument.");
        return null;
    }

    public String getLabelString() {
        if (this.defLabel == null) {
            return "";
        }
        return this.defLabel.getLexem();
    }

    public boolean hasNotLabel() {
        return this.defLabel == null;
    }

    public void addResultTo(BlockStmt block) {
        Stmt result = this.getResult();
        if (result != null) {
            Stmt stmt = (Stmt)result.copyWithOperands();
            stmt.setLineNumber(this.fLine);
            stmt.setFileName(this.fHir.fFileName);
            block.addLastStmt(stmt);
        }
    }

    void addGeneratedStmt(Stmt pStmt) {
        if (this.generatedStmts == null) {
            this.generatedStmts = new FirList(this.fHir);
        }
        this.generatedStmts.addedLast(pStmt);
    }

    void addGeneratedStmtFirst(Stmt pStmt) {
        if (this.generatedStmts == null) {
            this.generatedStmts = new FirList(this.fHir);
        }
        this.generatedStmts.addedFirst(pStmt);
    }

    SymTable mergeSymTable(SymTable dst, SymTable src) {
        SymIterator it = src.getSymIterator();
        while (it.hasNext()) {
            Sym sym = it.next();
            dst.linkSym(sym);
        }
        return dst;
    }

    SymTable setSymTable(SymTable table) {
        if (this.fSymTable == null) {
            this.fSymTable = table;
            return this.fSymTable;
        }
        return this.mergeSymTable(this.fSymTable, table);
    }

    public void setLineAndFileInfo(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        for (Stmt lStmt = pStmt; lStmt != null; lStmt = lStmt.getNextStmt()) {
            lStmt.setLineNumber(this.fLine);
            lStmt.setFileName(this.fHir.fFileName);
            if (!(lStmt instanceof BlockStmt)) continue;
            BlockStmt bstmt = (BlockStmt)lStmt;
            this.setLineAndFileInfo(bstmt.getFirstStmt());
        }
    }

    public Stmt getResult() {
        this.setLineAndFileInfo(this.stmt);
        if (this.generatedStmts == null && this.fSymTable == null) {
            return this.stmt;
        }
        BlockStmt blockStmt = this.hir.blockStmt(null);
        if (this.generatedStmts != null) {
            Iterator it = this.generatedStmts.iterator();
            while (it.hasNext()) {
                blockStmt.addLastStmt((Stmt)it.next());
            }
        }
        if (this.stmt != null) {
            blockStmt.addLastStmt(this.stmt);
        }
        if (this.fSymTable != null) {
            blockStmt.setSymTable(this.fSymTable);
        }
        this.setLineAndFileInfo(blockStmt);
        return blockStmt;
    }

    protected void dp(String str) {
        this.fHir.dp(str);
    }
}

