/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.Complex;
import coins.ffront.FComplex;
import coins.ffront.FDouble;
import coins.ffront.FFloat;
import coins.ffront.FInteger;

public abstract class FNumber {
    public abstract int intValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract Complex complexValue();

    public static FNumber make(int i) {
        return new FInteger(i);
    }

    public static FNumber make(float i) {
        return new FFloat(i);
    }

    public static FNumber make(double i) {
        return new FDouble(i);
    }

    public static FNumber make(double i, double j) {
        return new FComplex(i, j);
    }

    public static FNumber make(Complex c) {
        return new FComplex(c.real, c.img);
    }

    private FNumber invoke(String op, FNumber n) {
        FNumber type = this.higherType(n);
        FNumber a = type.to(this);
        FNumber b = type.to(n);
        Object[] o = new Object[]{b};
        Class[] c = new Class[]{a.getClass()};
        try {
            return (FNumber)a.getClass().getMethod(op, c).invoke((Object)a, o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public FNumber add(FNumber n) {
        return this.invoke("add", n);
    }

    public FNumber sub(FNumber n) {
        return this.invoke("sub", n);
    }

    public FNumber mul(FNumber n) {
        return this.invoke("mul", n);
    }

    public FNumber div(FNumber n) {
        return this.invoke("div", n);
    }

    public FNumber pow(FNumber n) {
        return this.invoke("pow", n);
    }

    public abstract FNumber to(FNumber var1);

    public abstract FNumber neg();

    protected FNumber higherType(FNumber n) {
        if (this.cmpType(n) > 0) {
            return n;
        }
        return this;
    }

    protected int cmpType(FNumber n) {
        int b;
        int a = this.checkType(this);
        if (a == (b = this.checkType(n))) {
            return 0;
        }
        if (a < b) {
            return 1;
        }
        return -1;
    }

    protected int checkType(FNumber n) {
        if (n instanceof FInteger) {
            return 1;
        }
        if (n instanceof FFloat) {
            return 2;
        }
        if (n instanceof FDouble) {
            return 3;
        }
        if (n instanceof FComplex) {
            return 4;
        }
        return -1;
    }

    void p(String str) {
        System.out.println(str);
    }
}

