/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.ffront.EntryStmt;
import coins.ffront.F77Hir;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.HeaderStmt;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.ffront.Triple;
import coins.ir.hir.HIR;
import coins.sym.Sym;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class F77Sym {
    private SymRoot symRoot;
    private Sym sym;
    private HirRoot hirRoot;
    private HIR hir;
    private IoRoot ioRoot;
    private F77Hir fHir;
    FirToHir fFirToHir;
    FirList dimensionList;
    FirList typedDeclList;
    FirList implicitList;
    FirList entryStmtList;
    FirList externalList;
    FirList dataList;
    FirList commonList;
    FirList equivList;
    FirList saveVarsList;
    Map formatMap;
    String programName = null;
    HeaderStmt programHeader;
    private static final HashMap TypeHash = new HashMap();

    public F77Sym(SymRoot sRoot, HirRoot hRoot, IoRoot iRoot, F77Hir fir) {
        this.symRoot = sRoot;
        this.sym = this.symRoot.sym;
        this.hirRoot = hRoot;
        this.hir = this.hirRoot.hir;
        this.ioRoot = iRoot;
        this.fHir = fir;
        this.fFirToHir = this.fHir.fFirToHir;
        this.initialize();
    }

    public void initialize() {
        this.programHeader = null;
        this.dimensionList = new FirList(this.fFirToHir);
        this.typedDeclList = new FirList(this.fFirToHir);
        this.implicitList = new FirList(this.fFirToHir);
        this.entryStmtList = new FirList(this.fFirToHir);
        this.externalList = new FirList(this.fFirToHir);
        this.dataList = new FirList(this.fFirToHir);
        this.commonList = new FirList(this.fFirToHir);
        this.equivList = new FirList(this.fFirToHir);
        this.saveVarsList = new FirList(this.fFirToHir);
        this.formatMap = new HashMap();
    }

    public void debugPrint(int level, String pMsg) {
        this.ioRoot.dbgToHir.print(level, pMsg);
    }

    public void print(int level) {
        level = 0;
        this.ioRoot.dbgToHir.print(level, "\nF77Sym\n");
        this.ioRoot.dbgToHir.print(level, "programHeader : \n");
        this.programHeader.print(level, "  ");
        this.ioRoot.dbgToHir.print(level, "dimensionList : \n");
        if (this.dimensionList != null) {
            this.dimensionList.print(level, "  ");
        }
        this.ioRoot.dbgToHir.print(level, "typedDeclList : \n");
        if (this.typedDeclList != null) {
            this.typedDeclList.print(level, "  ");
        }
    }

    public FirList list(Object pElem) {
        return new FirList(pElem, this.fFirToHir);
    }

    public FirList list() {
        return new FirList(this.fFirToHir);
    }

    public Pair pair(Node n1, Node n2) {
        return new Pair(n1, n2, this.fFirToHir);
    }

    public Token modifiedToken(Token t) {
        this.fHir.fLine = t.getLineNo();
        return t.addFHir(this.fFirToHir);
    }

    public void setProgramHeader(FStmt pHeader) {
        this.programHeader = (HeaderStmt)pHeader;
    }

    public Node funcStmt(Node pType, Token pIdent, FirList pArgs) {
        return new HeaderStmt(pIdent, pArgs, true, (Pair)pType, this.fHir.fLine, this.fFirToHir);
    }

    public Node subrStmt(Token pIdent, FirList pArgs) {
        return new HeaderStmt(pIdent, pArgs, false, null, this.fHir.fLine, this.fFirToHir);
    }

    public Node entryStmt(Token pIdent, FirList pArgs) {
        EntryStmt entryStmt = new EntryStmt(pIdent, pArgs, this.fHir.fLine, this.fFirToHir);
        this.entryStmtList.addLast(entryStmt);
        return entryStmt;
    }

    public Node programStmt(Token pName) {
        this.programName = pName.getLexem();
        return null;
    }

    public Node blockDataStmt(Node p1, Node p2) {
        return p1;
    }

    public FStmt declList(Node pType, FirList pList) {
        if (pType instanceof Token) {
            this.dimensionList.addAll(pList);
        } else {
            this.typedDeclList.addLast(this.pair(pType, pList));
        }
        return null;
    }

    public FStmt commonDecl(FirList p1) {
        this.commonList.addAll(p1);
        return null;
    }

    public FStmt equivalenceDecl(Node p1) {
        this.equivList.add(p1);
        return null;
    }

    public FStmt dataDecl(FirList p1) {
        this.dataList.add(p1);
        return null;
    }

    public FStmt implicitDecl(FirList p1) {
        this.implicitList.addAll(p1);
        return null;
    }

    public FStmt saveDecl(Node p1) {
        this.saveVarsList.addLast(p1);
        return null;
    }

    public FStmt parameterDecl(Node p1) {
        this.typedDeclList.addLast(p1);
        return null;
    }

    public FStmt externalDecl(Node p1) {
        this.externalList.addList((FirList)p1);
        return null;
    }

    public FStmt intrinsicDecl(Node p1) {
        this.ioRoot.dbgToHir.print(8, "functional_spec_stmt :INTRINSIC  intrinsic_decl\n");
        return null;
    }

    public Node arrayDecl(Token pIdent, Node pDim, Node pOptLength) {
        return new Triple(pIdent, pDim, pOptLength, this.fFirToHir);
    }

    public Node scalarDecl(Token pIdent, Node pOptLength) {
        return this.pair(pIdent, pOptLength);
    }

    public Node type(Token pType, Node pOptLength) {
        return this.pair(pType, pOptLength);
    }

    public Node block(Token p1, Node p2) {
        return this.pair(p1, p2);
    }

    public Node dim(Node p1, Node p2) {
        return this.pair(p1, p2);
    }

    public void registFormat(Token label, String formatstring) {
        this.formatMap.put(label.getLexem(), formatstring);
    }

    public Node impItem(Node p1, Node p2, Node p3) {
        String typename = ((Token)p1).getLexem();
        int kind = 0;
        if (typename == "none".intern()) {
            return null;
        }
        Integer i = (Integer)TypeHash.get(typename);
        if (i == null) {
            this.fFirToHir.printMsgFatal("at Implicit statement, '" + typename + "' is not typename");
        }
        kind = i;
        Token type = ((Token)p1).setKind(kind);
        this.modifiedToken(type);
        Iterator it = ((FirList)p3).iterator();
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            Token t = (Token)it.next();
            str.append(t.getLexem());
        }
        return this.pair(this.pair(p1, p2), ((Token)p1).copy(str.toString()));
    }

    public Node letterGroup(Token p1, Token p2) {
        char a1 = this.checkLetter(p1.getLexem());
        if (a1 == '/') {
            return null;
        }
        if (p2 == null) {
            return p1;
        }
        char a2 = this.checkLetter(p2.getLexem());
        if (a1 > a2) {
            this.fFirToHir.printMsgFatal("can't backwards order of letters in letter range");
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (char c = a1; c <= a2; c = (char)(c + '\u0001')) {
            str.append(c);
        }
        return p1.copy(str.toString().intern());
    }

    public char checkLetter(String letter) {
        if (letter.length() != 1) {
            return '/';
        }
        char a = letter.charAt(0);
        if ('a' > a || 'z' < a) {
            return '/';
        }
        return a;
    }

    void p(String str) {
        this.fFirToHir.debugPrint(0, str + "\n");
    }

    static {
        TypeHash.put("integer".intern(), new Integer(268));
        TypeHash.put("real".intern(), new Integer(269));
        TypeHash.put("doubleprecision".intern(), new Integer(271));
        TypeHash.put("complex".intern(), new Integer(270));
        TypeHash.put("logical".intern(), new Integer(272));
        TypeHash.put("character".intern(), new Integer(273));
    }
}

