/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.IoRoot;
import coins.ffront.Scanner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class F77Scanner
extends Scanner {
    IoRoot io_;
    private int fLineNum;
    private String fLineLabel;
    private String fLastLine = null;
    private String fLastLabel = null;
    private int fLastSkipNum;
    final String[] reserved_words_of_types = new String[]{"INTEGER", "REAL", "DOUBLEPRECISION", "COMPLEX", "LOGICAL", "CHARACTER", "DIMENSION"};
    final String[] reserved_words_use_with_types = new String[]{"FUNCTION"};
    final String[] reserved_words = new String[]{"BLOCKDATA", "COMMON", "DATA", "EQUIVALENCE", "EXTERNAL", "FORMAT", "IMPLICIT", "SAVE", "INTRINSIC", "PROGRAM", "FUNCTION", "SUBROUTINE", "RETURN", "PARAMETER", "ENTRY", "CALL", "CONTINUE", "STOP", "PAUSE", "ELSEIF", "ELSE", "ENDIF", "ENDDO", "END"};
    final String[] reserved_words_io = new String[]{"READ", "WRITE", "PRINT", "BACKSPACE", "ENDFILE", "REWIND", "OPEN", "CLOSE", "INQUIRE"};
    final String[] reserved_words2 = new String[]{"ASSIGN", "IF", "DO", "GOTO"};

    public F77Scanner(Reader in, IoRoot io) throws IOException, Exception {
        super(in);
        this.io_ = io;
        ByteArrayInputStream bais = new ByteArrayInputStream(this.f77pp(in));
        this.yyreset(new InputStreamReader(bais));
    }

    public F77Scanner(InputStream in, IoRoot io) throws IOException, Exception {
        this(new InputStreamReader(in), io);
    }

    protected void dp(String msg) {
        this.io_.dbgToHir.print(2, ";;" + msg + "\n");
    }

    protected byte[] f77pp(Reader rin) throws IOException, Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(baout));
        BufferedReader in = new BufferedReader(rin);
        String line = "";
        int line_no = 0;
        this.fLineNum = 0;
        this.fLastSkipNum = 0;
        try {
            while ((line = this.get_next_fortran_line(in)) != null) {
                String l = this.set_syntax(line);
                ++line_no;
                while (line_no < this.fLineNum) {
                    ++line_no;
                    out.newLine();
                    this.dp("EF(" + this.fLineNum + "): ");
                }
                out.write(l);
                out.newLine();
                this.dp("EF(" + this.fLineNum + "): " + l);
            }
        }
        catch (Exception e) {
            System.out.println("Error is occur at " + this.fLineNum + ": " + line);
            e.printStackTrace();
            throw e;
        }
        out.close();
        return baout.toByteArray();
    }

    String get_next_fortran_line(BufferedReader in) throws IOException, Exception {
        boolean cont = false;
        boolean first = true;
        String fline = "";
        while (true) {
            int endpos;
            String line;
            if (this.fLastLine != null) {
                line = this.fLastLine;
                this.fLastLine = null;
            } else {
                line = in.readLine();
                if (line == null) break;
            }
            if (this.is_comment_line(line)) {
                ++this.fLastSkipNum;
                continue;
            }
            int pos = this.get_line_label_and_pos(line);
            if (pos != 5 || !this.is_continue_line(line)) {
                if (!first) {
                    this.fLastLine = line;
                    break;
                }
            } else {
                cont = true;
                if (this.fLastLabel.length() > 0) {
                    throw new Exception("Label invalid with continuation line indicator :");
                }
            }
            if (pos == 5) {
                ++pos;
            }
            if ((endpos = line.length()) > 72) {
                endpos = 72;
            }
            fline = fline + line.substring(pos, endpos);
            first = false;
            this.fLineNum += this.fLastSkipNum + 1;
            this.fLastSkipNum = 0;
            if (cont) continue;
            this.fLineLabel = this.fLastLabel;
        }
        if (fline.length() > 0) {
            return fline;
        }
        return null;
    }

    private boolean is_comment_line(String line) {
        if (line.length() <= 0) {
            return true;
        }
        char c = line.charAt(0);
        if (c == ' ' || c == '\t') {
            for (int i = 1; i < line.length(); ++i) {
                c = line.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return false;
            }
            return true;
        }
        return !Character.isDigit(c);
    }

    private boolean is_continue_line(String line) {
        char c;
        return line.length() > 6 && (c = line.charAt(5)) != ' ' && c != '0';
    }

    private int get_line_label_and_pos(String line) throws Exception {
        int i;
        String label = "";
        for (i = 0; i < 5 && line.length() > i; ++i) {
            char c = line.charAt(i);
            if (Character.isDigit(c)) {
                label = label + c;
                continue;
            }
            if (c == '\t') break;
            if (c == ' ') continue;
            throw new Exception("Non-numeric character in label field :" + c);
        }
        this.fLastLabel = label.length() > 0 ? "" + Integer.parseInt(label) : "";
        return i;
    }

    protected String is_assign_stmt(String str) throws Exception {
        int i;
        int kakko = 0;
        boolean in_str = false;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '=' && !in_str) {
                if (kakko == 0) {
                    return "_let " + str;
                }
                return null;
            }
            if (str.charAt(i) == '\'') {
                in_str = !in_str;
                continue;
            }
            if (str.charAt(i) == '(' && !in_str) {
                ++kakko;
                continue;
            }
            if (str.charAt(i) != ')' || in_str) continue;
            --kakko;
        }
        if (str.startsWith("ASSIGN")) {
            char c;
            String num = "";
            for (i = 6; i < str.length() && Character.isDigit(c = str.charAt(i)); ++i) {
                num = num + c;
            }
            if (!str.substring(i).startsWith("TO")) {
                throw new Exception("assign statement error");
            }
            return "_ASSIGN " + num + " _TO " + str.substring(i + 2);
        }
        return null;
    }

    protected String is_typed_stmt(String str) {
        String ret = null;
        StringBuffer mod = null;
        for (int i = 0; i < this.reserved_words_of_types.length; ++i) {
            if (!str.startsWith(this.reserved_words_of_types[i])) continue;
            String type = this.reserved_words_of_types[i];
            int k = type.length();
            while (Character.isDigit(str.charAt(k)) || str.charAt(k) == '*') {
                if (mod == null) {
                    mod = new StringBuffer();
                }
                mod.append(str.charAt(k));
                ++k;
            }
            str = str.substring(k);
            for (int j = 0; j < this.reserved_words_use_with_types.length; ++j) {
                if (!str.startsWith(this.reserved_words_use_with_types[j])) continue;
                str = "_" + this.reserved_words_use_with_types[j] + " " + str.substring(this.reserved_words_use_with_types[j].length());
            }
            ret = "_" + type + ' ' + (mod == null ? "" : mod.toString() + " ") + str;
            break;
        }
        return ret;
    }

    protected String is_stmt(String str) {
        String ret = null;
        for (int t = 0; t < 2; ++t) {
            String[] words = t == 0 ? this.reserved_words_io : this.reserved_words;
            for (int i = 0; i < words.length; ++i) {
                if (!str.startsWith(words[i])) continue;
                return "_" + words[i] + " " + str.substring(words[i].length());
            }
        }
        return ret;
    }

    protected int get_close_paren_pos(String str) throws Exception {
        int n = 1;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '(') {
                ++n;
                continue;
            }
            if (c != ')' || --n != 0) continue;
            return i + 1;
        }
        if (n != 0) {
            throw new Exception("paren is not closed");
        }
        return 0;
    }

    protected String is_arith_if(String str) throws Exception {
        int n = 0;
        if (!str.startsWith("IF(")) {
            return null;
        }
        for (int i = this.get_close_paren_pos(str.substring(3)) + 3; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) continue;
            if (c == ',') {
                ++n;
                continue;
            }
            return null;
        }
        if (n == 2) {
            return "_ARITH_IF " + str.substring(2);
        }
        return null;
    }

    protected String is_if_stmt(String str) throws Exception {
        String ret = null;
        ret = this.is_arith_if(str);
        if (ret != null) {
            return ret;
        }
        if (str.startsWith("IF(")) {
            int i = this.get_close_paren_pos(str.substring(3));
            String sub = str.substring(i + 3);
            ret = this.is_goto_stmt(sub);
            if (ret != null) {
                return "_" + str.substring(0, i + 3) + ret;
            }
            ret = this.is_assign_stmt(sub);
            if (ret != null) {
                return "_" + str.substring(0, i + 3) + ret;
            }
            ret = this.is_stmt(sub);
            if (ret != null) {
                return "_" + str.substring(0, i + 3) + ret;
            }
            ret = this.is_arith_if(sub);
            if (ret != null) {
                return "_" + str.substring(0, i + 3) + ret;
            }
            if (str.lastIndexOf("THEN", str.length() - 4) != -1) {
                str = "_" + str.substring(0, str.length() - 4) + "_THEN";
            }
            return str;
        }
        if (str.startsWith("ELSEIF") && str.lastIndexOf("THEN", str.length() - 4) != -1) {
            return "_" + str.substring(0, str.length() - 4) + "_THEN";
        }
        return null;
    }

    protected String is_goto_stmt(String str) {
        String ret = null;
        if (str.startsWith("GOTO")) {
            char c = str.charAt(4);
            if (Character.isDigit(c)) {
                return "_GOTO " + str.substring(4);
            }
            if (c == '(') {
                return "_COMP_GOTO " + str.substring(4);
            }
            return "_ASSIGN_GOTO " + str.substring(4);
        }
        return ret;
    }

    protected String is_do_stmt(String str) {
        if (str.startsWith("DO")) {
            String num = "";
            boolean eq = false;
            boolean ch = false;
            for (int i = 2; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c)) {
                    if (ch) continue;
                    num = num + c;
                    continue;
                }
                if (Character.isLowerCase(c) || Character.isUpperCase(c)) {
                    ch = true;
                    continue;
                }
                if (c == '=') {
                    eq = true;
                    continue;
                }
                if (c != ',' || !eq) continue;
                return "_DO " + num + " " + str.substring(2 + num.length());
            }
        }
        return null;
    }

    protected String erase_whitespaces(String str) {
        int i;
        boolean in_str = false;
        int n = 0;
        StringBuffer buff = new StringBuffer();
        for (i = 0; i < str.length() && (str.charAt(i) != '!' || in_str); ++i) {
            char c;
            if (str.charAt(i) == '\'') {
                boolean bl = in_str = !in_str;
            }
            if (Character.isLowerCase(c = str.charAt(i)) && !in_str) {
                buff.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isWhitespace(c) && !in_str) continue;
            buff.append(c);
        }
        String ret = buff.toString();
        if (ret.startsWith("FORMAT(")) {
            i = 0;
            n = 0;
            while (n < "FORMAT(".length()) {
                if (!Character.isWhitespace(str.charAt(i))) {
                    ++n;
                }
                ++i;
            }
            return "FORMAT(" + str.substring(i);
        }
        return ret;
    }

    protected String set_syntax(String str) throws Exception {
        String label = this.fLineLabel;
        label = label.length() > 0 ? '@' + label + ' ' : "# ";
        boolean in_str = false;
        if ((str = this.erase_whitespaces(str)).length() == 0) {
            return "";
        }
        String ret = null;
        ret = this.is_do_stmt(str);
        if (ret == null && (ret = this.is_if_stmt(str)) == null && (ret = this.is_assign_stmt(str)) == null && (ret = this.is_typed_stmt(str)) == null && (ret = this.is_stmt(str)) == null && (ret = this.is_goto_stmt(str)) == null) {
            System.out.println('[' + str + ']');
            throw new Exception("can't solve stmt");
        }
        str = ret;
        if (str.startsWith("_ELSEIF") || str.startsWith("_ELSE")) {
            label = "";
        }
        if (str.startsWith("_ENDIF") && label != "#") {
            return "_ENDIF; " + label + " _CONTINUE;";
        }
        return label + str + ";";
    }

    public static void main(String[] str) throws FileNotFoundException, IOException, Exception {
        if (str.length > 0) {
            F77Scanner f77Scanner = new F77Scanner(new FileReader(str[0]), null);
        }
    }
}

