/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.ffront.ArithIfStmt;
import coins.ffront.AssignGotoStmt;
import coins.ffront.AssignLabelStmt;
import coins.ffront.AssignOrFuncStmt;
import coins.ffront.BinaryNode;
import coins.ffront.BlockIfStmt;
import coins.ffront.CallStmt;
import coins.ffront.CloseStmt;
import coins.ffront.ComplexConstNode;
import coins.ffront.ComputedGoto;
import coins.ffront.ConcatNode;
import coins.ffront.ContinueStmt;
import coins.ffront.DoListNode;
import coins.ffront.EndStmt;
import coins.ffront.F77Sym;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FormatStmt;
import coins.ffront.GotoStmt;
import coins.ffront.HeaderStmt;
import coins.ffront.IfStmt;
import coins.ffront.InquireStmt;
import coins.ffront.LabeledDoStmt;
import coins.ffront.Node;
import coins.ffront.OpenStmt;
import coins.ffront.OtherIOStmt;
import coins.ffront.Pair;
import coins.ffront.PauseStmt;
import coins.ffront.PowerNode;
import coins.ffront.Quad;
import coins.ffront.ReadStmt;
import coins.ffront.ReturnStmt;
import coins.ffront.StopStmt;
import coins.ffront.SubscrOrFunCallNode;
import coins.ffront.SubstringNode;
import coins.ffront.Token;
import coins.ffront.UnLabeledDoStmt;
import coins.ffront.UnaryNode;
import coins.ffront.WriteStmt;
import coins.ir.hir.HIR;
import coins.sym.Sym;

public class F77Hir {
    private SymRoot symRoot;
    private Sym sym;
    private HirRoot hirRoot;
    private HIR hir;
    private IoRoot ioRoot;
    private F77Sym fSym;
    int fLine;
    FirList programBody;
    FirList assignList = null;
    FirToHir fFirToHir;

    public F77Hir(SymRoot sRoot, HirRoot hRoot, IoRoot iRoot) {
        this.symRoot = sRoot;
        this.sym = this.symRoot.sym;
        this.hirRoot = hRoot;
        this.hir = this.hirRoot.hir;
        this.ioRoot = iRoot;
        this.fFirToHir = new FirToHir(sRoot, hRoot, iRoot);
    }

    public void setF77Sym(F77Sym fSym) {
        this.fSym = fSym;
    }

    public FirList getProgramBody() {
        return this.programBody;
    }

    public void addFirstStmt(FStmt pStmt) {
        this.programBody.addFirst(pStmt);
    }

    public int getLineNo() {
        return this.fLine;
    }

    public Node executableProgram(Node pUnit) {
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("ToHir", 4)) {
            this.fSym.print(4);
            this.programBody.print(4, "");
        }
        this.fFirToHir.makeHirFromFir(this.fSym, this);
        ((HIR)this.hirRoot.programRoot).setIndexNumberToAllNodes(0);
        this.initialize();
        return null;
    }

    private void initialize() {
        this.assignList = null;
        this.fSym.initialize();
    }

    public Node executableProgram(Node pExPrgrm, Node pUnit) {
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("ToHir", 4)) {
            this.fSym.print(4);
            this.programBody.print(4, "");
        }
        this.fFirToHir.makeHirFromFir(this.fSym, this);
        this.initialize();
        return null;
    }

    public Node mainProgram(FirList pBody) {
        this.programBody = pBody;
        Token mainToken = new Token(0, "main".intern(), 261, this.fFirToHir);
        this.fSym.setProgramHeader(new HeaderStmt(mainToken, null, false, null, this.fLine, this.fFirToHir));
        return this.programBody;
    }

    public Node funcSubProgram(FStmt pFuncStmt, FirList pBody) {
        this.programBody = pBody;
        this.fSym.setProgramHeader(pFuncStmt);
        return this.programBody;
    }

    public Node subrSubProgram(FStmt pSubrStmt, FirList pBody) {
        this.programBody = pBody;
        this.fSym.setProgramHeader(pSubrStmt);
        return this.programBody;
    }

    public Node blockDataSubp(Node p1) {
        this.programBody = (FirList)p1;
        return p1;
    }

    public FStmt endStmt(Token pLabel) {
        EndStmt lStmt = new EndStmt(this.fLine, this.fFirToHir);
        if (pLabel != null) {
            lStmt.addLabel(pLabel);
        }
        return lStmt;
    }

    public FStmt completeStmt(Token pLabel, FStmt pStmt) {
        if (pStmt instanceof FormatStmt) {
            if (pLabel != null && pStmt != null) {
                this.fSym.registFormat(pLabel, ((FormatStmt)pStmt).getLexem());
            }
        } else if (pLabel != null && pStmt != null) {
            pStmt.addLabel(pLabel);
        }
        return pStmt;
    }

    public Node blockDataSubProgram(Node p1, Node p2) {
        return p1;
    }

    public Node blockDataBody(Node p1, Node p2, Node p3) {
        return p1;
    }

    public FStmt format(Node p1) {
        FormatStmt stmt = new FormatStmt(p1, this.fLine, this.fFirToHir);
        return stmt;
    }

    public Node dataSeq(FirList p1, FirList p2) {
        return new Pair(p1, p2, this.fFirToHir);
    }

    public Node dataVal(Node p1, Node p2) {
        if (p1 == null) {
            return p2;
        }
        return new Pair(p1, p2, this.fFirToHir);
    }

    public Node value(char p1, Node p2) {
        if (p1 == '-') {
            return this.exprUnary(63, p2);
        }
        return p2;
    }

    public Node constItem(Token p1, Node p2) {
        return new Pair(p1, p2, this.fFirToHir);
    }

    public Node dataVarOne(Node p1) {
        return p1;
    }

    public Node dataVarDoList(Node p1, Node p2) {
        return new Pair(p1, p2, this.fFirToHir);
    }

    public FStmt doLabeled(Token pLabel, Node pDoSpec) {
        return new LabeledDoStmt(pLabel, pDoSpec, this.fLine, this.fFirToHir);
    }

    public FStmt doUnLabeled(Node p1, Node p2) {
        return new UnLabeledDoStmt(p1, p2, this.fLine, this.fFirToHir);
    }

    public FStmt ifStmt(Node pExp, FStmt pStmt) {
        return new IfStmt(pExp, pStmt, this.fLine, this.fFirToHir);
    }

    public FStmt blockIfStmt(Node pIfPart, FirList pOptElseIfs, FirList pOptElse) {
        return new BlockIfStmt(pIfPart, pOptElseIfs, pOptElse, this.fLine, this.fFirToHir);
    }

    public Node blockIfPart(Node pExp, FirList pTail) {
        return new Pair(pExp, pTail, this.fFirToHir);
    }

    public Node elseIfPart(Node pExp, FirList pTail) {
        return new Pair(pExp, pTail, this.fFirToHir);
    }

    public Node doSpec(Token pIdent, Node pExp1, Node pExp2, Node pOptStep) {
        return new Quad(pIdent, pExp1, pExp2, pOptStep, this.fFirToHir);
    }

    public FStmt assignOrFunc(Node pLeft, Node pRight) {
        return new AssignOrFuncStmt(pLeft, pRight, this.fLine, this.fFirToHir);
    }

    public FStmt assignLabel(Token pLabel, Token pIdent) {
        AssignLabelStmt assignStmt = new AssignLabelStmt(pLabel, pIdent, this.fLine, this.fFirToHir);
        if (this.assignList == null) {
            this.assignList = new FirList(this.fFirToHir);
        }
        this.assignList.addLast(assignStmt);
        return assignStmt;
    }

    public FStmt continueStmt() {
        return new ContinueStmt(this.fLine, this.fFirToHir);
    }

    public FStmt gotoStmt(Token pLabel) {
        return new GotoStmt(pLabel, this.fLine, this.fFirToHir);
    }

    public FStmt aGoto(Token pIdent, FirList pOptLabels) {
        return new AssignGotoStmt(pIdent, pOptLabels, this.fLine, this.fFirToHir);
    }

    public FStmt cGoto(FirList pLabels, Node pExp) {
        return new ComputedGoto(pLabels, pExp, this.fLine, this.fFirToHir);
    }

    public FStmt aIf(Node pNode, Token pMinusLab, Token pZeroLab, Token pPlusLab) {
        return new ArithIfStmt(pNode, pMinusLab, pZeroLab, pPlusLab, this.fLine, this.fFirToHir);
    }

    public FStmt call(Token pIdent, FirList pOptArgs) {
        return new CallStmt(pIdent, pOptArgs, this.fLine, this.fFirToHir);
    }

    public FStmt returnStmt(Node pOptExpr) {
        return new ReturnStmt(pOptExpr, this.fLine, this.fFirToHir);
    }

    public FStmt pause(Node p1) {
        return new PauseStmt(p1, this.fLine, this.fFirToHir);
    }

    public FStmt stop(Node p1) {
        return new StopStmt(p1, this.fLine, this.fFirToHir);
    }

    public Token argLabel(Token pLabel) {
        return pLabel;
    }

    public Token label(Token pIntConst) {
        return pIntConst.setKind(263);
    }

    public FStmt printStmt(Node pFormat, FirList pOptIoList) {
        this.ioRoot.dbgToHir.print(8, "PRINT format_spec opt_comma_io_list\n");
        FirList ciList = new FirList(new Pair(null, null, this.fFirToHir), this.fFirToHir);
        ciList.addLast(new Pair(null, pFormat, this.fFirToHir));
        return new WriteStmt(ciList, pOptIoList, this.fLine, this.fFirToHir);
    }

    public FStmt writeStmt(FirList pCiList, FirList pOptIoList) {
        return new WriteStmt(pCiList, pOptIoList, this.fLine, this.fFirToHir);
    }

    public FStmt readStmt(Node p1, Node p2) {
        return new ReadStmt((FirList)p1, (FirList)p2, this.fLine, this.fFirToHir);
    }

    public FStmt readFStmt(Node p1, Node p2) {
        return new ReadStmt(p1, (FirList)p2, this.fLine, this.fFirToHir);
    }

    public FStmt openStmt(FirList p1) {
        return new OpenStmt(p1, this.fLine, this.fFirToHir);
    }

    public FStmt closeStmt(FirList p1) {
        return new CloseStmt(p1, this.fLine, this.fFirToHir);
    }

    public FStmt backspace(FirList p1) {
        return new OtherIOStmt("f_back", p1, null, this.fLine, this.fFirToHir);
    }

    public FStmt backspaceF(Node p1) {
        return new OtherIOStmt("f_back", null, p1, this.fLine, this.fFirToHir);
    }

    public FStmt endfile(FirList p1) {
        return new OtherIOStmt("f_end", p1, null, this.fLine, this.fFirToHir);
    }

    public FStmt endfileF(Node p1) {
        return new OtherIOStmt("f_end", null, p1, this.fLine, this.fFirToHir);
    }

    public FStmt rewind(FirList p1) {
        return new OtherIOStmt("f_rew", p1, null, this.fLine, this.fFirToHir);
    }

    public FStmt rewindF(Node p1) {
        return new OtherIOStmt("f_rew", null, p1, this.fLine, this.fFirToHir);
    }

    public FStmt inquire(FirList p1) {
        return new InquireStmt(p1, this.fLine, this.fFirToHir);
    }

    public Node ioClause(Token pIdent, Node pExpr) {
        return new Pair(pIdent, pExpr, this.fFirToHir);
    }

    public Node ioItemExpr(Node pExpr) {
        return pExpr;
    }

    public Node ioItemDoList(FirList pList) {
        Node doSpec = (Node)pList.removeLast();
        return new DoListNode(pList, doSpec, this.fFirToHir);
    }

    public Node enclosed(Node pExp) {
        return new UnaryNode(16, pExp, this.fFirToHir);
    }

    public Node exprUnary(int op, Node pExp) {
        return new UnaryNode(op, pExp, this.fFirToHir);
    }

    public Node exprBinary(int op, Node e1, Node e2) {
        return new BinaryNode(op, e1, e2, this.fFirToHir);
    }

    public Node exprPower(Node pNode1, Node pNode2) {
        return new PowerNode(pNode1, pNode2, this.fFirToHir);
    }

    public Node exprCat(Node p1, Node p2) {
        return new ConcatNode(p1, p2, this.fFirToHir);
    }

    public Node leftName(Token pIdent, FirList argList) {
        return new SubscrOrFunCallNode(pIdent, argList, this.fFirToHir);
    }

    public Node leftNameSubstr(Token pIdent, FirList pArgs, Pair pSubstr) {
        if (pArgs == null) {
            return new SubstringNode((Node)pIdent, pSubstr, this.fFirToHir);
        }
        return new SubstringNode((Node)new SubscrOrFunCallNode(pIdent, pArgs, this.fFirToHir), pSubstr, this.fFirToHir);
    }

    public Pair substring(Node p1, Node p2) {
        return this.fSym.pair(p1, p2);
    }

    protected boolean checkConstNumber(Node node) {
        Token t;
        int kind;
        if (node instanceof Token && ((kind = (t = (Token)node).getKind()) == 257 || kind == 260 || kind == 259)) {
            return true;
        }
        if (node instanceof UnaryNode) {
            return this.checkConstNumber(((UnaryNode)node).getExp());
        }
        return false;
    }

    public Node constComplex(Node pReal, Node pImag) {
        if (!this.checkConstNumber(pReal) || !this.checkConstNumber(pImag)) {
            this.fFirToHir.printMsgFatal("Constant complex's each element must be constant, but :(" + pReal + ", " + pImag + ")");
        }
        return new ComplexConstNode(pReal, pImag, this.fFirToHir);
    }
}

