/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.CommonManager;
import coins.ffront.ComplexExp;
import coins.ffront.ConstManager;
import coins.ffront.EntryStmt;
import coins.ffront.EquivManager;
import coins.ffront.F77Sym;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HeaderStmt;
import coins.ffront.ImplicitManager;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.ProcessData;
import coins.ffront.Token;
import coins.ffront.Triple;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.HIR;
import coins.ir.hir.NullNode;
import coins.ir.hir.Program;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.sym.Elem;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class DeclManager
extends BaseManager {
    ImplicitManager fImplMgr;
    CommonManager fCommonMgr;
    EquivManager fEquivMgr;
    ConstManager fConstMgr;
    F77Sym f7Sym;
    Type functionType;
    HeaderStmt programHeader;
    Subp fSubp;
    SymTable fSymTable;
    SubpDefinition fSubpDef;
    BlockStmt fInitialPart;
    FirList fCharParamList;

    public DeclManager(FirToHir fth, F77Sym f7s) {
        super(fth);
        this.f7Sym = f7s;
        this.fImplMgr = new ImplicitManager(fth);
        this.fCommonMgr = new CommonManager(fth, this);
        this.fEquivMgr = new EquivManager(fth, this.fCommonMgr, this);
        this.fConstMgr = new ConstManager(fth, this);
        this.fInitialPart = this.hir.blockStmt(null);
        this.fCharParamList = new FirList(this.fHir);
    }

    public Type getImplicitType(String id) {
        return this.fImplMgr.getImplicitType(id);
    }

    public Type getDeclType(String pIdent) {
        this.printMsgFatal("unimplemented");
        return null;
    }

    ConstManager getConstManager() {
        return this.fConstMgr;
    }

    void processDecl() {
        this.dp("* processImplicit");
        this.fImplMgr.processImplicit(this.f7Sym);
        if (this.f7Sym.programHeader == null) {
            this.dp("BLOCK DATA statement");
        } else {
            this.dp("* programHeader");
            this.programHeader = this.f7Sym.programHeader;
            this.dp("* defineFunctionType");
            this.defineFunctionType();
            this.dp("* checkEntryStmt");
            this.checkEntryStmt();
            this.dp("* processProgramHeader");
            this.processProgramHeader();
        }
        this.dp("* processCommon");
        this.fCommonMgr.processCommon(this.programHeader == null ? "__BlockData" : this.programHeader.getLexem());
        this.dp("* processEquiv");
        this.fEquivMgr.processEquiv(this.programHeader == null ? "__BlockData" : this.programHeader.getLexem());
        this.dp("* processData");
        ProcessData pd = new ProcessData(this.fHir);
        pd.process();
        this.dp("* processSave");
        this.processSave();
    }

    void defineFunctionType() {
        String ident = this.programHeader.getLexem();
        Type type = null;
        Pair typePair = null;
        if (this.programHeader.isFunction()) {
            this.dp("- This program unit is function");
            typePair = this.programHeader.getTypePair();
            if (typePair == null) {
                type = this.searchType(ident);
                this.dp("type : " + type);
            } else {
                type = this.fTypeUtil.getType(typePair);
            }
        } else {
            this.dp("- This program unit is Subroutine");
            type = this.symRoot.typeVoid;
        }
        if (this.fTypeUtil.isComplexType(type)) {
            this.programHeader.changeToSubprogram();
            type = this.symRoot.typeVoid;
        }
        this.functionType = type;
        this.defineSubp(this.programHeader.getLexem(), type, 2, null);
    }

    void checkEntryStmt() {
        FirList entryStmtList = this.f7Sym.entryStmtList;
        if (entryStmtList.size() == 0) {
            return;
        }
        this.dp("This program unit has entrys");
        this.programHeader = this.f7Sym.programHeader;
        this.programHeader.addEntryStmt(entryStmtList);
        FirList paramList = this.programHeader.getArgs();
        for (EntryStmt eStmt : entryStmtList) {
            eStmt.addParamTo(paramList);
            this.dp("Entry : " + eStmt);
        }
        this.programHeader.change(paramList, entryStmtList);
        int entryCount = 1;
        for (EntryStmt eStmt : entryStmtList) {
            eStmt.makeSubp(entryCount++, paramList);
        }
    }

    void processProgramHeader() {
        String ident = this.programHeader.getLexem();
        Type type = this.functionType;
        this.fSubp = this.defineSubpWithoutClose(ident, type, 2);
        this.fSymTable = this.symRoot.symTableRoot.pushSymTable(this.fSubp);
        this.processTypeDecl();
        this.processExternal();
        this.processDimension();
        FirList lParams = this.programHeader.getArgs();
        IrList lParamTypeList = this.hir.irList();
        int countStar = 0;
        if (lParams != null) {
            Param param;
            String id;
            for (Object next : lParams) {
                id = ((Token)next).getLexem();
                if (id != "*") {
                    param = this.defineParam(id);
                    Type paramType = param.getSymType();
                    this.fSubp.addParam(param);
                    lParamTypeList.add(paramType);
                    this.dp("PARAM: " + param + " as " + paramType);
                    continue;
                }
                ++countStar;
            }
            for (Object next : this.fCharParamList) {
                id = ((Token)next).getLexem();
                this.sym.defineVar(this.characterLengthVarName(id), this.fTypeUtil.getIntType());
                param = this.sym.defineParam(id, this.fTypeUtil.getIntType());
                param.markAsCallByReference();
                this.fSubp.addParam(param);
                lParamTypeList.add(this.fTypeUtil.getIntType());
            }
        }
        if (countStar != 0) {
            this.dp("param/star: " + countStar);
            this.programHeader.setStar(countStar);
            type = this.symRoot.typeInt;
            this.fSubp.setReturnValueType(type);
        }
        if (this.programHeader.isFunction()) {
            Var returnVar = this.sym.defineVar(this.programHeader.getReturnVarString(), type);
            this.programHeader.setReturnVar(returnVar);
        }
        this.dp("subp => " + this.fSubp.toStringDetail());
        this.fSubpDef = this.hir.subpDefinition(this.fSubp, this.fSymTable);
        ((Program)this.hirRoot.programRoot).addSubpDefinition(this.fSubpDef);
        this.fSubp.closeSubpHeader();
    }

    Param defineParam(String id) {
        Param param;
        Sym lSym = this.symRoot.symTableCurrent.search(id);
        if (lSym instanceof Param) {
            param = (Param)lSym;
        } else {
            Type paramType;
            if (lSym == null) {
                paramType = this.sym.pointerType(this.getImplicitType(id));
            } else {
                paramType = lSym.getSymType();
                if (this.fTypeUtil.isFortranCharacterType(paramType)) {
                    this.fCharParamList.add(new Token(0, this.characterLengthVarName(id), this.fHir));
                }
                paramType = this.sym.pointerType(paramType);
                lSym.remove();
            }
            this.dp("[DECL] SubrParam: " + id + " as " + paramType);
            param = this.sym.defineParam(id, paramType);
            param.markAsCallByReference();
        }
        return param;
    }

    String characterLengthVarName(String id) {
        return (id + "_len").intern();
    }

    void declVariable(Type type, String ident) {
        if (this.search(ident) != null) {
            return;
        }
        Var v = this.sym.defineVar(ident, type);
        this.dp("- decl: " + ident + " as " + type.toString());
    }

    void declDimensionVariable(Type type, String ident, FirList dims) {
        Type vt = this.fTypeUtil.getArrayType(type, dims, this);
        Var v = this.sym.defineVar(ident, vt);
        this.dp("- decl vector: " + ident + " as " + vt.toString());
    }

    void declVariableWithLength(Type type, String ident, Token length) {
        if (!this.fTypeUtil.isFortranCharacterType(type)) {
            this.printMsgFatal("Declaration with length spec must be Character type: " + ident + " as " + type);
        }
        VectorType vt = this.sym.vectorType(this.fTypeUtil.getCharType(), length.makeExp());
        Var v = this.sym.defineVar(ident, vt);
        this.dp("- decl var with length spec: " + ident + " as " + vt.toString() + " / " + length.toString());
    }

    void declDimensionVariableWithLength(Type type, String ident, FirList dims, Token length) {
        if (!this.fTypeUtil.isFortranCharacterType(type)) {
            this.printMsgFatal("Declaration with length spec must be Character type: " + ident + " as " + type);
        }
        type = this.sym.vectorType(this.fTypeUtil.getCharType(), length.makeExp());
        Type vt = this.fTypeUtil.getArrayType(type, dims, this);
        Var v = this.sym.defineVar(ident, vt);
        this.dp("- decl vector: " + ident + " as " + vt.toString() + "/" + length);
    }

    void processTypeDecl() {
        this.dp("* processTypeDecl");
        for (Node declStmt : this.f7Sym.typedDeclList) {
            if (declStmt instanceof FirList) {
                this.fConstMgr.processParameterDeclStatement((FirList)declStmt);
                continue;
            }
            Pair oneDeclStmt = (Pair)declStmt;
            Iterator varIt = ((FirList)oneDeclStmt.getRight()).iterator();
            Type declType = this.fTypeUtil.getType((Pair)oneDeclStmt.getLeft());
            this.dp("declType: " + declType);
            if (declType instanceof VectorType && !this.fTypeUtil.isFortranCharacterType(declType)) {
                this.printMsgFatal("Declaration with length spec must be Character type: " + declType);
            }
            while (varIt.hasNext()) {
                Sym s;
                Pair oneDecl = (Pair)varIt.next();
                String ident = ((Token)oneDecl.getLeft()).getLexem();
                Node length = oneDecl.getRight();
                if (this.isDefinedSymbol(ident)) {
                    this.printMsgFatal("[Type decl] This symbol is already declared: " + ident);
                }
                if (length == null) {
                    this.dp("decl variable: " + ident);
                    this.declVariable(declType, ident);
                } else if (oneDecl instanceof Triple && ((Triple)oneDecl).getExtra() != null) {
                    Triple tr = (Triple)oneDecl;
                    this.dp("decl dimension variable with length spec: " + ident);
                    this.declDimensionVariableWithLength(declType, ident, (FirList)tr.getRight(), (Token)tr.getExtra());
                } else if (length instanceof FirList) {
                    this.dp("decl dimension variable: " + ident);
                    this.declDimensionVariable(declType, ident, (FirList)length);
                } else if (length instanceof Token) {
                    this.dp("decl variable with length spec: " + ident);
                    this.declVariableWithLength(declType, ident, (Token)length);
                } else {
                    this.printMsgFatal("unimplemented declaration type(unkown)" + ident + "\n");
                }
                if ((s = this.search(ident)) == null || !(s instanceof Subp) || this.functionType == this.symRoot.typeVoid || declType == this.functionType) continue;
                this.printMsgFatal("Return value must be same as Function type.");
            }
        }
    }

    void processExternal() {
        FirList externalList = this.f7Sym.externalList;
        for (Token idToken : externalList) {
            Type type;
            String id = idToken.getLexem();
            Sym lSym = this.search(id);
            if (lSym == null) {
                type = this.getImplicitType(id);
            } else {
                type = lSym.getSymType();
                lSym.remove();
            }
            Subp lSubp = this.defineSubp(id, type, 1, null);
            this.dp("external subp: " + lSubp);
        }
    }

    void processDimension() {
        this.dp("* processDimension");
        for (Pair p : this.f7Sym.dimensionList) {
            Type type;
            Sym s;
            String ident = ((Token)p.getLeft()).getLexem();
            FirList dims = (FirList)p.getRight();
            if (this.isDefinedSymbol(ident)) {
                VectorType vt;
                s = this.search(ident);
                if (s == null) {
                    this.printMsgFatal("[Dimension] Constant can't be array");
                }
                if ((type = s.getSymType()) instanceof VectorType && (vt = (VectorType)type).getElemType() != this.symRoot.typeChar) {
                    this.printMsgFatal("[Dimension] Invalid variable definitionat dimension statement : '" + ident + "'");
                    continue;
                }
            } else {
                s = this.searchOrAddVar(ident);
                type = this.getImplicitType(ident);
            }
            Type vtype = this.fTypeUtil.getArrayType(type, dims, this);
            if (s != null) {
                s.setSymType(vtype);
            } else {
                Var v = this.sym.defineVar(ident, vtype);
            }
            this.dp("- DIMENSION: " + ident + " as " + vtype);
        }
    }

    void processSave() {
        for (FirList varlist : this.f7Sym.saveVarsList) {
            Iterator nit;
            if (varlist == null || !(nit = varlist.iterator()).hasNext()) continue;
            while (nit.hasNext()) {
                Token t = (Token)nit.next();
                String name = t.getLexem();
                Var v = this.searchOrAddVar(name);
                v.setStorageClass(6);
            }
        }
    }

    boolean isBlockVariable(String ident) {
        if (this.fCommonMgr == null) {
            return false;
        }
        return this.fCommonMgr.isBlockVariable(ident);
    }

    Exp makeBlockVariableExp(String ident) {
        return this.fCommonMgr.makeExp(ident);
    }

    Sym symBlockVariable(String ident) {
        return this.fCommonMgr.symBlockVariable(ident);
    }

    boolean isEquivVariable(String ident) {
        if (this.fEquivMgr == null) {
            return false;
        }
        return this.fEquivMgr.isEquivVariable(ident);
    }

    Exp makeEquivVariableExp(String ident) {
        return this.fEquivMgr.makeExp(ident);
    }

    Sym symEquivVariable(String ident) {
        return this.fEquivMgr.symEquivVariable(ident);
    }

    public Var searchOrAddVar(String ident) {
        return this.searchOrAddVar(ident, null);
    }

    public Var searchOrAddVar(String ident, Type pType) {
        Sym lVar = this.search(ident);
        if (lVar instanceof Var) {
            if (pType != null && lVar.getSymType() != pType) {
                this.printMsgRecovered("unmatched type of " + ident);
            }
            return (Var)lVar;
        }
        if (pType == null) {
            pType = this.getImplicitType(ident);
        }
        Var v = this.sym.defineVar(ident, pType);
        return v;
    }

    boolean isParamIdent(String ident) {
        FirList args = this.programHeader.getArgs();
        if (args != null) {
            Iterator it = args.iterator();
            while (it.hasNext()) {
                String paramid = ((Token)it.next()).getLexem();
                if (paramid != ident) continue;
                return true;
            }
        }
        return false;
    }

    public Sym searchSymOrAddVar(String ident) {
        Sym lSym = this.search(ident);
        if (lSym == null) {
            Type type = this.getImplicitType(ident);
            lSym = this.sym.defineVar(ident, type);
        }
        if (this.isParamIdent(ident)) {
            return this.defineParam(ident);
        }
        return lSym;
    }

    public Sym search(String ident) {
        if (this.isEquivVariable(ident)) {
            return this.symEquivVariable(ident);
        }
        if (this.isBlockVariable(ident)) {
            return this.symBlockVariable(ident);
        }
        Sym s = this.symRoot.symTableCurrent.search(ident);
        if (s == null) {
            return null;
        }
        if (s.getSymKind() == 13) {
            return null;
        }
        return s;
    }

    public Type searchType(String ident) {
        Sym lVar = this.search(ident);
        if (lVar == null) {
            return this.getImplicitType(ident);
        }
        return lVar.getSymType();
    }

    public Subp defineSubp(String id, Type returnType, int visibility, IrList pParams) {
        Subp lSubp = this.defineSubpWithoutClose(id, returnType, visibility);
        if (pParams != null) {
            ListIterator it = pParams.iterator();
            while (it.hasNext()) {
                lSubp.addParam((Param)it.next());
            }
        }
        lSubp.closeSubpHeader();
        return lSubp;
    }

    public Subp defineSubpWithoutClose(String id, Type returnType, int visibility) {
        Subp lSubp = this.sym.defineSubp(id, returnType);
        lSubp.setVisibility(visibility);
        return lSubp;
    }

    Type getFunctionType() {
        return this.functionType;
    }

    public void setHirBody(BlockStmt blockStmt) {
        this.fSubpDef.setHirBody(blockStmt);
    }

    HeaderStmt getProgramHeader() {
        return this.programHeader;
    }

    void setProgramHeader(HeaderStmt pHeader) {
        this.programHeader = pHeader;
    }

    ExpListExp flattenExpList(ExpListExp e) {
        LinkedList list = new LinkedList();
        this.flattenExpList_r(list, e);
        return (ExpListExp)this.hir.expList(list);
    }

    void flattenExpList_r(List list, ExpListExp explist) {
        for (int i = 0; i < explist.length(); ++i) {
            Exp e = explist.getExp(i);
            if (e instanceof ExpListExp) {
                this.flattenExpList_r(list, (ExpListExp)e);
                continue;
            }
            list.add(e);
        }
    }

    void setInitialValue(Var v, Exp e) {
        this.setInitialValue(v, e, null);
    }

    void addInitialPart(Stmt stmt) {
        this.fInitialPart.addLastStmt((Stmt)stmt.copyWithOperands());
    }

    void setInitialValue(Var v, Exp e, String lexem) {
        this.dp("setInitialValue(v): " + v);
        this.dp("setInitialValue(e): " + v);
        HIR hir = this.fHir.getHir();
        v.setInitialValue(e);
        if (e instanceof ExpListExp) {
            ExpListExp el = (ExpListExp)e;
            el.setType(v.getSymType());
        }
        if (this.isBlockVariable(lexem)) {
            this.dp("initialize block var: " + lexem);
            this.printMsgFatal("Sorry, unsupport Initialize in BLOCK DATA statement.");
            this.fCommonMgr.setInitialValue(lexem, e);
        } else if (v.getStorageClass() == 6) {
            if (e instanceof FortranCharacterExp) {
                e = ((FortranCharacterExp)e).getBody();
            }
            SetDataStmt datacode = hir.setDataStmt(hir.varNode(v), e);
            this.fSubpDef.addInitiationStmt((Stmt)datacode.copyWithOperands());
        } else if (e instanceof FortranCharacterExp) {
            FortranCharacterExp fe = (FortranCharacterExp)e;
            this.addInitialPart(this.fHirUtil.makeCharacterAssignStmt(hir.exp(64, hir.varNode(v)), fe.getBody(), this.fTypeUtil.getFortranCharacterLengthExp(v.getSymType(), v.getName()), fe.getLength()));
        } else if (this.fTypeUtil.isComplexType(v.getSymType())) {
            ComplexExp ce = this.fHirUtil.makeComplexExpFromVar(v);
            this.addInitialPart(this.fHirUtil.makeAssignStmt(ce, e));
        } else if (e instanceof ExpListExp) {
            PointerType ptype = this.sym.pointerType(this.fTypeUtil.getVectorBaseType((VectorType)v.getSymType()));
            e = this.flattenExpList((ExpListExp)e);
            for (int i = 0; i < ((ExpListExp)e).length(); ++i) {
                Exp init_exp = ((ExpListExp)e).getExp(i);
                if (init_exp instanceof NullNode || init_exp == null) continue;
                this.dp("ptype: " + ptype);
                this.dp("idx: " + i);
                this.dp("int: " + init_exp);
                if (init_exp.getType() instanceof VectorType) {
                    VectorType base_type = (VectorType)this.fTypeUtil.getVectorBaseType((VectorType)v.getSymType());
                    this.dp("type->: " + base_type);
                    this.addInitialPart(this.fHirUtil.makeCharacterAssignStmt(hir.exp(64, hir.subscriptedExp(hir.undecayExp(hir.convExp(ptype, hir.exp(64, hir.varNode(v))), i), this.fHirUtil.makeIntConstNode(i))), hir.exp(64, init_exp), base_type.getElemCountExp(), ((VectorType)init_exp.getType()).getElemCountExp()));
                    continue;
                }
                this.addInitialPart(this.fHirUtil.makeAssignStmt(hir.subscriptedExp(hir.undecayExp(hir.convExp(ptype, hir.exp(64, hir.varNode(v))), i), this.fHirUtil.makeIntConstNode(i)), init_exp));
            }
        } else if (v instanceof Elem) {
            this.addInitialPart(this.fHirUtil.makeAssignStmt(this.makeEquivVariableExp(lexem), e));
        } else {
            this.addInitialPart(this.fHirUtil.makeAssignStmt(hir.varNode(v), e));
        }
    }

    Type getSymbolType(String name) {
        Var v = (Var)this.fSymTable.searchLocal(name, 8);
        if (v == null) {
            return this.fImplMgr.getImplicitType(name);
        }
        return v.getSymType();
    }

    boolean deleteFromSymbolTable(String name) {
        this.fSymTable.searchLocal(name, 8).remove();
        return true;
    }

    boolean isDefinedSymbol(String name) {
        return this.fSymTable.searchLocal(name, 8) != null || this.fConstMgr.isConstName(name);
    }

    Var defineVar(String lexem) {
        Var var = this.sym.defineVar(lexem, this.getImplicitType(lexem));
        return var;
    }

    String getProgramUnitName() {
        return this.programHeader.getLexem();
    }

    boolean isDefinedInLocal(Sym sym) {
        this.dp("isDefinedInLocal ==> " + sym);
        return this.fSymTable.searchLocal(sym.getName(), sym.getSymKind()) != null;
    }
}

