/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComputedGoto;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.Node;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.Type;

public class CallStmt
extends FStmt {
    private Token fIdent;
    private FirList fOptArgs;
    private IrList fParamList;
    private IrList fParamTypeList;
    boolean hasAltReturn = false;
    FirList fLabels = null;
    private Subp fSubp;

    public CallStmt(Token pIdent, FirList pOptArgs, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fIdent = pIdent;
        this.fOptArgs = pOptArgs;
        this.fLabels = new FirList(this.fHir);
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + " CallStmt" + "\n");
    }

    public String toString() {
        return super.toString() + " Call statement";
    }

    public void process() {
        this.preprocess();
        Sym sym = this.fHir.getSym();
        this.fParamList = this.hir.irList();
        this.fParamTypeList = this.hir.irList();
        if (this.fOptArgs != null) {
            for (Node lParam : this.fOptArgs) {
                Exp lParamAddr;
                if (lParam instanceof Token && ((Token)lParam).getLexem() == "*" || (lParamAddr = lParam.makeArgAddr(this)) == null) continue;
                this.fParamList.add(lParamAddr);
            }
            for (Node lParam : this.fOptArgs) {
                Exp e;
                if (lParam instanceof Token && ((Token)lParam).getKind() == 263 || !((e = lParam.makeExp()) instanceof FortranCharacterExp)) continue;
                this.fParamList.add(((FortranCharacterExp)e).getLength());
            }
        }
        Sym lSym = this.fDeclMgr.search(this.fIdent.getLexem());
        Type returnType = this.fTypeUtil.getVoidType();
        if (this.hasAltReturn) {
            returnType = this.fTypeUtil.getIntType();
        }
        this.fSubp = lSym == null ? this.fDeclMgr.defineSubp(this.fIdent.getLexem(), returnType, 2, null) : (lSym.getSymKind() == 12 ? (Subp)lSym : this.fDeclMgr.defineSubp(this.fIdent.getLexem(), returnType, 2, null));
        if (this.hasAltReturn) {
            FunctionExp subpExp = this.hir.functionExp(this.fHirUtil.makeSubpExp(this.fSubp), this.fParamList);
            this.stmt = new ComputedGoto(this.fLine, this.fHir).makeSwitchStmt(subpExp, this.fLabels);
        } else {
            this.stmt = this.hir.callStmt(this.fHirUtil.makeSubpExp(this.fSubp), this.fParamList);
        }
        super.process();
    }
}

