/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Pair;
import coins.ffront.Token;

public class AssignLabelStmt
extends FStmt {
    private static FirList assignLabels = null;
    Token fIdent;
    Token fLabel;

    public AssignLabelStmt(Token pLabel, Token pIdent, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fLabel = pLabel;
        this.fIdent = pIdent;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "Assign Label " + this.fLabel + " to " + this.fIdent + "\n");
    }

    public String toString() {
        return super.toString() + "Assign Label " + this.fLabel + " to " + this.fIdent;
    }

    public void process() {
        if (assignLabels == null) {
            assignLabels = new FirList(this.fHir);
            assignLabels.addFirst(new Pair(this.fIdent, new FirList(this.fHir).addedFirst(this.fLabel), this.fHir));
        } else {
            String ident = this.fIdent.getLexem();
            boolean found = false;
            for (Pair pair : assignLabels) {
                Token id = (Token)pair.getLeft();
                if (id.getLexem() != ident) continue;
                ((FirList)pair.getRight()).addFirst(this.fLabel);
                found = true;
                break;
            }
            if (!found) {
                assignLabels.addFirst(new Pair(this.fIdent, new FirList(this.fHir).addedFirst(this.fLabel), this.fHir));
            }
        }
        this.fLabel.setKind(259);
        this.stmt = this.fHirUtil.makeAssignStmt(this.fIdent.makeExp(), this.fLabel.makeExp());
        super.process();
    }
}

