/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.AssignLabelStmt;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HirSeq;
import coins.sym.Label;
import java.util.HashSet;
import java.util.Iterator;

public class AssignGotoStmt
extends FStmt {
    private Token fIdent;
    private FirList fLabels;

    public AssignGotoStmt(Token pIdent, FirList pLabels, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fIdent = pIdent;
        this.fLabels = pLabels;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "AssignGoto " + this.fIdent + "\n");
    }

    public String toString() {
        return super.toString() + "AssignGoto statement";
    }

    public void process() {
        IrList jumpList = this.hir.irList();
        BlockStmt switchBlock = this.hir.blockStmt(null);
        if (this.fLabels == null) {
            this.fLabels = new FirList(this.fHir);
            FirList assignList = this.fESMgr.getAssignList();
            for (AssignLabelStmt assignLabel : assignList) {
                if (assignLabel.fIdent.getLexem() != this.fIdent.getLexem()) continue;
                this.fLabels.addFirst(assignLabel.fLabel);
            }
        }
        Iterator it = this.fLabels.iterator();
        HashSet<String> dupcheck = new HashSet<String>();
        while (it.hasNext()) {
            Token labelToken = (Token)it.next();
            String labelString = labelToken.getLexem();
            if (dupcheck.contains(labelString)) continue;
            dupcheck.add(labelString);
            Label gotoLabel = this.fESMgr.makeLabel(labelString);
            Label switchLabel = this.fESMgr.makeNewLabel();
            HirSeq pair = this.hir.hirSeq(this.fHirUtil.makeIntConstNode(labelString), this.hir.labelNode(switchLabel));
            jumpList.add(pair);
            switchBlock.addLastStmt(this.hir.labeledStmt(switchLabel, null));
            switchBlock.addLastStmt(this.hir.jumpStmt(gotoLabel));
        }
        this.stmt = this.hir.switchStmt(this.fIdent.makeExp(), jumpList, null, switchBlock, this.fESMgr.makeNewLabel());
        super.process();
    }
}

