/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.SyntaxError;
import coins.backend.SyntaxErrorException;
import coins.backend.opt.JumpOpt;
import coins.backend.opt.SimpleOpt;
import coins.backend.sim.SimFuncTable;
import coins.backend.sim.SimulationData;
import coins.backend.util.ImList;
import coins.cfront.Cfront;
import coins.driver.CheckOptions;
import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.CompilerImplementation;
import coins.driver.PassStopException;
import coins.driver.StreamCopier;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.flow.FlowImpl;
import coins.hir2c.HirBaseToCImpl;
import coins.hir2lir.ConvToNewLIR;
import coins.hir2lir.ReformHir;
import coins.ir.hir.HIR;
import coins.ir.hir.SimplifyHir;
import coins.ir.hir.TestHir;
import coins.lir2c.LirToC;
import coins.lparallel.LoopPara;
import coins.mdf.MdfDriver;
import coins.opt.Opt;
import coins.simd.SimdDriver;
import coins.snapshot.SnapShot;
import coins.ssa.SsaDriver;
import coins.sym.TestSym;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Driver
implements CompilerImplementation {
    protected static final String VERBOSE_FLAG = "-v";
    protected static final String DEFAULT_PREPROCESSOR_NAME = "cpp";
    protected static final String DEFAULT_ASSEMBLER_NAME = "gas";
    protected static final String DEFAULT_LINKER_NAME = "gcc";
    protected static final String PREPROCESSOR_NAME_OPTION = "preprocessor";
    protected static final String ASSEMBLER_NAME_OPTION = "assembler";
    protected static final String LINKER_NAME_OPTION = "linker";
    protected static final String HIR_TO_C_OPTION = "hir2c";
    protected static final String DUMP_HIR_OPTION = "dumphir";
    protected static final String LIR_TO_C_OPTION = "lir2c";
    protected static final char HIR_TO_C_OPTION_DELIMITER = '/';
    protected static final char DUMP_HIR_OPTION_DELIMITER = '/';
    protected static final char LIR_TO_C_OPTION_DELIMITER = '/';
    protected static final char COINS_OPTION_DELIMITER = '/';
    protected static final String STOP_AFTER_HIR_TO_C_OPTION = "stopafterhir2c";
    protected static final String STOP_AFTER_LIR_TO_C_OPTION = "stopafterlir2c";
    protected static final String HIR_FLOW_ANAL_OPTION = "hirAnal";
    protected static final char FLOW_ANAL_OPTION_DELIMITER = '/';
    protected static final int MAX_OPTIMIZATION_LEVEL = 4;
    protected static final int DEFAULT_OPTIMIZATION_LEVEL = 1;
    protected static final String[] HIR_OPTIMIZATION_ARGS = new String[]{"noSimplify", "cf", "cf", "inline/cf/pre", "inline/loopexp/cf/cpf/pre"};
    protected static final String[] SSA_OPTIMIZATION_ARGS = new String[]{null, "prun/cpyp/cstp/dce/ebe/srd3", "prun/divex/cse/cstp/hli/osr/hli/cstp/cpyp/preqp/cstp/rpe/dce/srd3", "prun/divex/cse/cstp/hli/osr/hli/cstp/cpyp/preqp/cstp/rpe/dce/srd3", "prun/divex/cse/cstp/hli/osr/hli/cstp/cpyp/preqp/cstp/rpe/dce/srd3"};
    protected static final String[] LIR_OPTIMIZATION_ARGS = new String[]{null, "loopinversion", "loopinversion", "loopinversion", "loopinversion"};
    protected static final String HIR_OPT_OPTION = "hirOpt";
    protected static final String HIR_OPT_ARG_FROMC = "fromc";
    protected static final char OPT_OPTION_DELIMITER = '/';
    protected static final String TARGET_ARCH_OPTION = "target-arch";
    protected static final String TARGET_CONVENTION_OPTION = "target-convention";
    protected static final String CHECK_HIR_OPTION = "testHir";
    protected static final String CHECK_SYMBOL_TABLE_OPTION = "testSym";
    protected static final String OLD_LIR_OPTION = "oldlir";
    protected static final String NEW_LIR_OPTION = "newlir";
    protected static final String DEFAULT_LIR_OPTION = "newlir";
    protected static final String OUT_NEW_LIR_OPTION = "out-newlir";
    protected Properties defaultSettings;
    protected static final String DEFAULT_SETTING = "settings";
    protected static final String DEFAULT_LINKER_OPTIONS_PROPERTY = "defaultLinkerOptions";
    protected static final String SYSTEM_INCLUDE_PATH_PROPERTY = "systemIncludePath";
    protected static final String SSA_OPTION = "ssa-opt";
    protected static final String MACRO_DATA_FLOW_OPTION = "mdf";
    protected static final String PARALLEL_DO_ALL = "parallelDoAll";
    protected static final String OPENMP_OPTION = "OpenMP";
    protected static final String COARSE_GRAIN_PARALLEL = "coarseGrainParallel";
    protected static final String CG_PARALLEL = "cgParallel";
    protected static final String SIMULATE_OPTION = "simulate";
    protected static final String DEBUG_OPTION = "debug";
    protected FlowRoot hirFlowRoot = null;
    protected String myName = "Driver";

    private void traceCommandLine(String[] commandArray, Trace trace, int level) {
        StringBuffer buffer = new StringBuffer();
        int size = commandArray.length;
        buffer.append(commandArray[0]);
        for (int i = 1; i < size; ++i) {
            buffer.append(" " + commandArray[i]);
        }
        trace.trace(this.myName, level, buffer.toString());
    }

    private String[] concatLists(List list1, List list2) {
        int i;
        int size1 = list1.size();
        int size2 = list2.size();
        String[] result = new String[size1 + size2];
        for (i = 0; i < size1; ++i) {
            result[i] = (String)list1.get(i);
        }
        for (i = 0; i < size2; ++i) {
            result[size1 + i] = (String)list2.get(i);
        }
        return result;
    }

    private List evaluateCommandName(String name) {
        int size = name.length();
        char quote = ' ';
        StringBuffer s = new StringBuffer();
        boolean escaped = false;
        ArrayList<String> result = new ArrayList<String>();
        name = name.trim();
        block4: for (int i = 0; i < size; ++i) {
            if (escaped) {
                escaped = false;
                s.append(name.charAt(i));
                continue;
            }
            if (Character.isWhitespace(name.charAt(i))) {
                if (quote == ' ') {
                    if (s.length() <= 0) continue;
                    result.add(s.toString());
                    s = new StringBuffer();
                    continue;
                }
                s.append(name.charAt(i));
                continue;
            }
            char c = name.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote == ' ') {
                        quote = c;
                        continue block4;
                    }
                    if (quote == c) {
                        quote = ' ';
                        continue block4;
                    }
                    s.append(c);
                    continue block4;
                }
                case '\\': {
                    escaped = true;
                    continue block4;
                }
                default: {
                    s.append(name.charAt(i));
                }
            }
        }
        if (s.length() > 0) {
            result.add(s.toString());
        }
        return result;
    }

    protected String[] makeCommandLine(String name, List options) {
        List list = this.evaluateCommandName(name);
        return this.concatLists(list, options);
    }

    protected int runProgram(String[] commandLine, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        int exitStatus;
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        if (trace.shouldTrace(this.myName, 5000)) {
            this.traceCommandLine(commandLine, spec.getTrace(), 5000);
        }
        if (spec.isSet(VERBOSE_FLAG)) {
            StringBuffer message = new StringBuffer("% " + commandLine[0]);
            for (int i = 1; i < commandLine.length; ++i) {
                message.append(" " + commandLine[i]);
            }
            io.msgNote.put(message.toString());
        }
        Process p = Runtime.getRuntime().exec(commandLine);
        StreamCopier t1 = new StreamCopier(in, p.getOutputStream());
        StreamCopier t2 = new StreamCopier(p.getInputStream(), out);
        StreamCopier t3 = new StreamCopier(p.getErrorStream(), System.err);
        t1.start();
        t2.start();
        t3.start();
        while (true) {
            try {
                t1.join();
                p.getOutputStream().close();
                exitStatus = p.waitFor();
                t2.join();
                t3.join();
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        p.destroy();
        return exitStatus;
    }

    protected int runProgram(String command, List arguments, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        int size = arguments.size();
        String[] commandLine = new String[size + 1];
        commandLine[0] = command;
        for (int i = 0; i < size; ++i) {
            commandLine[i + 1] = (String)arguments.get(i);
        }
        return this.runProgram(commandLine, in, out, io);
    }

    protected int runProgram(List commandStrings, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        int size = commandStrings.size();
        String commandName = (String)commandStrings.get(0);
        List arguments = size == 1 ? new ArrayList() : commandStrings.subList(1, size);
        return this.runProgram(commandName, arguments, in, out, io);
    }

    protected void setSystemIncludePathOptions(CompileSpecification spec, List options) {
        String s = this.defaultSettings.getProperty(SYSTEM_INCLUDE_PATH_PROPERTY);
        if (s != null && !s.equals("")) {
            options.addAll(this.separateDelimitedList(s, ' '));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(File sourceFile, Suffix suffix, OutputStream out, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        List options = spec.getPreprocessorOptions();
        this.setSystemIncludePathOptions(spec, options);
        options.add(sourceFile.getPath());
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        String commandName = DEFAULT_PREPROCESSOR_NAME;
        if (coinsOptions.isSet(PREPROCESSOR_NAME_OPTION)) {
            commandName = coinsOptions.getArg(PREPROCESSOR_NAME_OPTION);
        }
        String[] commandLine = this.makeCommandLine(commandName, options);
        try {
            if (this.runProgram(commandLine, null, out, io) != 0) {
                throw new PassException(sourceFile, PREPROCESSOR_NAME_OPTION, "Error(s) in preprocessor.");
            }
        }
        finally {
            out.close();
        }
    }

    private HIR readHIR(File sourceFile, HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            return (HIR)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            io.msgError.put(sourceFile + ": class not found: " + e.getMessage());
            throw new PassException(sourceFile, this.myName, "class not found: " + e.getMessage());
        }
    }

    protected void makeHirFromSource(File sourceFile, HirRoot hirRoot, Suffix suffix, InputStream in, IoRoot io) throws IOException, PassException {
        if (suffix.getLanguageName().equals("C")) {
            new Cfront(sourceFile, suffix, in, io, hirRoot).makeHirFromCSource();
        } else if (suffix.getLanguageName().equals("HIR")) {
            hirRoot.programRoot = this.readHIR(sourceFile, hirRoot, in, io);
        } else {
            io.msgError.put(sourceFile + ": Unknown programming language: " + suffix.getLanguageName());
            throw new PassException(this.myName, "Unknown language " + suffix.getLanguageName());
        }
    }

    protected FlowRoot makeHIRFlowAnalysis(HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        Trace trace = io.getCompileSpecification().getTrace();
        trace.trace(this.myName, 5000, "makeHIRFlowAnalysis");
        if (this.hirFlowRoot == null) {
            this.hirFlowRoot = new FlowRoot(hirRoot);
        }
        FlowRoot flowRoot = this.hirFlowRoot;
        FlowImpl lFlow = new FlowImpl(flowRoot);
        CompileSpecification lSpec = io.getCompileSpecification();
        String lFlowArg = lSpec.getCoinsOptions().getArg(HIR_FLOW_ANAL_OPTION);
        if (this.includedInDelimitedList("cfg", '/', lFlowArg)) {
            flowRoot.setFlowAnalOption(4, true);
        }
        if (this.includedInDelimitedList(MACRO_DATA_FLOW_OPTION, '/', lFlowArg)) {
            flowRoot.setFlowAnalOption(5, true);
        }
        if (this.includedInDelimitedList("dfg", '/', lFlowArg)) {
            flowRoot.setFlowAnalOption(13, true);
        }
        if (lFlowArg.length() == 0) {
            flowRoot.setFlowAnalOption(13, true);
        }
        lFlow.doHir();
        if (lSpec.getTrace().shouldTrace("HIR", 3)) {
            System.out.println("HIR after flow analysis.");
            hirRoot.ir.print(0);
        }
        return flowRoot;
    }

    protected void optimizeHirBeforeFlowAnalysis(HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "optimizeHirBeforeFlowAnalysis");
    }

    protected void basicHIROptimizations(HirRoot hirRoot, FlowRoot hirFlowRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        new Opt(hirFlowRoot).doHir();
    }

    protected void optimizeHirAfterFlowAnalysis(HirRoot hirRoot, FlowRoot hirFlowRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "optimizeHirAfterFlowAnalysis");
        this.basicHIROptimizations(hirRoot, hirFlowRoot, symRoot, io);
    }

    protected ImList makeNewLirFromHir(HirRoot hirRoot, IoRoot io, File sourceFile, OutputStream out, boolean isLirOutput) throws PassException {
        CompileSpecification spec = io.getCompileSpecification();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "Make new LIR from HIR");
        if (trace.shouldTrace("HIR", 1)) {
            trace.trace("HIR", 1, "HIR before HirToNewLir conversion");
            ((HIR)hirRoot.programRoot).print(0, true);
        }
        if (trace.shouldTrace("Sym", 2)) {
            trace.trace("Sym", 2, "Sym before HirToNewLir conversion ");
            hirRoot.symRoot.symTable.printSymTableAll(hirRoot.symRoot.symTableRoot);
            hirRoot.symRoot.symTableConst.printSymTable();
        }
        ConvToNewLIR newconvert = new ConvToNewLIR(sourceFile, out, hirRoot);
        ImList sexp = newconvert.doConvert((HIR)hirRoot.programRoot);
        if (isLirOutput) {
            newconvert.print(sexp);
        }
        return sexp;
    }

    protected boolean includedInDelimitedList(String term, char delimiter, String list) {
        int i;
        while ((i = list.indexOf(delimiter)) != -1) {
            if (term.equals(list.substring(0, i))) {
                return true;
            }
            list = list.substring(i + 1);
        }
        return term.equals(list);
    }

    protected List separateDelimitedList(String s, char delimiter) {
        int i;
        ArrayList<String> l = new ArrayList<String>();
        while ((i = s.indexOf(delimiter)) != -1) {
            l.add(s.substring(0, i));
            s = s.substring(i + 1);
        }
        l.add(s);
        return l;
    }

    private List initTimingList(CoinsOptions coinsOptions, String option, char delimiter) {
        if (coinsOptions.isSet(option)) {
            return this.separateDelimitedList(coinsOptions.getArg(option), delimiter);
        }
        return new ArrayList();
    }

    private List initHirToCTimingList(CoinsOptions coinsOptions) {
        return this.initTimingList(coinsOptions, HIR_TO_C_OPTION, '/');
    }

    private List initDumpHirTimingList(CoinsOptions coinsOptions) {
        return this.initTimingList(coinsOptions, DUMP_HIR_OPTION, '/');
    }

    private List initLirToCTimingList(CoinsOptions coinsOptions) {
        return this.initTimingList(coinsOptions, LIR_TO_C_OPTION, '/');
    }

    protected boolean matchHirToCTiming(String timing, List hirToCTimings, CoinsOptions coinsOptions) {
        if (coinsOptions.isSet(HIR_TO_C_OPTION)) {
            return hirToCTimings.contains(timing);
        }
        return false;
    }

    protected boolean matchDumpHirTiming(String timing, List dumpHirTimings, CoinsOptions coinsOptions) {
        if (coinsOptions.isSet(DUMP_HIR_OPTION)) {
            return dumpHirTimings.contains(timing);
        }
        return false;
    }

    protected void callHirBaseToC(HirRoot hirRoot, SymRoot symRoot, IoRoot io, OutputStream out) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "callHirBaseToC");
        HirBaseToCImpl HirToC = new HirBaseToCImpl(hirRoot, symRoot, new PrintStream(out), trace);
        HirToC.Converter();
    }

    protected void dumpHirBase(HirRoot hirRoot, SymRoot symRoot, IoRoot io, ObjectOutputStream out) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "dumpHirBase");
        try {
            out.writeObject(hirRoot.programRoot);
        }
        catch (NotSerializableException e) {
            String message = "Failed to dump HIR (" + e.getMessage() + " is not serializable).";
            io.msgError.put(message);
            throw new PassException(io.getSourceFile(), DUMP_HIR_OPTION, message);
        }
    }

    protected void checkHirToCStopCondition(String timing, List hirToCTimings, CoinsOptions coinsOptions, File source) throws IOException, PassException {
        if (coinsOptions.isSet(STOP_AFTER_HIR_TO_C_OPTION)) {
            hirToCTimings.remove(timing);
            if (hirToCTimings.size() == 0) {
                throw new PassStopException(source, "HIR to C", "Stop after HIR to C");
            }
        }
    }

    protected boolean makeCSourceFromHirBase(String timing, List hirToCTimings, HirRoot hirRoot, SymRoot symRoot, IoRoot io, OutputStream out) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (coinsOptions.isSet(HIR_TO_C_OPTION)) {
            trace.trace(this.myName, 5000, "makeCSourceFromHirBase(" + timing + "): " + coinsOptions.getArg(HIR_TO_C_OPTION));
        } else {
            trace.trace(this.myName, 5000, "makeCSourceFromHirBase(" + timing + ")");
        }
        if (this.matchHirToCTiming(timing, hirToCTimings, coinsOptions)) {
            this.callHirBaseToC(hirRoot, symRoot, io, out);
            this.checkHirToCStopCondition(timing, hirToCTimings, coinsOptions, io.getSourceFile());
            return true;
        }
        return false;
    }

    protected boolean makeCSourceFromHirBase(String timing, List hirToCTimings, HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (coinsOptions.isSet(HIR_TO_C_OPTION)) {
            trace.trace(this.myName, 5000, "makeCSourceFromHirBase(" + timing + "): " + coinsOptions.getArg(HIR_TO_C_OPTION));
        } else {
            trace.trace(this.myName, 5000, "makeCSourceFromHirBase(" + timing + ")");
        }
        if (this.matchHirToCTiming(timing, hirToCTimings, coinsOptions)) {
            File source = io.getSourceFile();
            String sourcePath = source.getPath();
            String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
            String dest = root.concat("-hir-" + timing + ".c");
            FileOutputStream out = new FileOutputStream(new File(dest));
            this.callHirBaseToC(hirRoot, symRoot, io, out);
            this.checkHirToCStopCondition(timing, hirToCTimings, coinsOptions, source);
            return true;
        }
        return false;
    }

    protected boolean dumpHirBase(String timing, List dumpHirTimings, HirRoot hirRoot, SymRoot symRoot, IoRoot io, ObjectOutputStream out) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (coinsOptions.isSet(DUMP_HIR_OPTION)) {
            trace.trace(this.myName, 5000, "dumpHirBase(" + timing + "): " + coinsOptions.getArg(DUMP_HIR_OPTION));
        } else {
            trace.trace(this.myName, 5000, "dumpHirBase(" + timing + ")");
        }
        if (this.matchDumpHirTiming(timing, dumpHirTimings, coinsOptions)) {
            this.dumpHirBase(hirRoot, symRoot, io, out);
            return true;
        }
        return false;
    }

    protected boolean dumpHirBase(String timing, List dumpHirTimings, HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (coinsOptions.isSet(DUMP_HIR_OPTION)) {
            trace.trace(this.myName, 5000, "dumpHirBase(" + timing + "): " + coinsOptions.getArg(DUMP_HIR_OPTION));
        } else {
            trace.trace(this.myName, 5000, "dumpHirBase(" + timing + ")");
        }
        if (this.matchDumpHirTiming(timing, dumpHirTimings, coinsOptions)) {
            File source = io.getSourceFile();
            String sourcePath = source.getPath();
            String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
            String dest = root.concat("-c-" + timing + ".hir");
            FileOutputStream out = new FileOutputStream(new File(dest));
            ObjectOutputStream oout = new ObjectOutputStream(out);
            this.dumpHirBase(hirRoot, symRoot, io, oout);
            oout.close();
            return true;
        }
        return false;
    }

    protected boolean matchLirToCTiming(String timing, List lirToCTimings, CoinsOptions coinsOptions) {
        if (coinsOptions.isSet(LIR_TO_C_OPTION)) {
            return lirToCTimings.contains(timing);
        }
        return false;
    }

    protected void callLirToC(Module unit, IoRoot io, String dest) throws IOException, PassException {
        LirToC lir2c = new LirToC(unit, dest);
        lir2c.invoke();
    }

    protected void checkLirToCStopCondition(String timing, List lirToCTimings, CoinsOptions coinsOptions, File source) throws IOException, PassException {
        if (coinsOptions.isSet(STOP_AFTER_LIR_TO_C_OPTION)) {
            lirToCTimings.remove(timing);
            if (lirToCTimings.size() == 0) {
                throw new PassStopException(source, "LIR to C", "Stop after LIR to C");
            }
        }
    }

    protected boolean makeCSourceFromLir(String timing, List lirToCTimings, Module unit, IoRoot io, String dest) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "makeCSourceFromLir");
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (this.matchLirToCTiming(timing, lirToCTimings, coinsOptions)) {
            this.callLirToC(unit, io, dest);
            this.checkLirToCStopCondition(timing, lirToCTimings, coinsOptions, io.getSourceFile());
            return true;
        }
        return false;
    }

    protected void testSym(HirRoot pHirRoot, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        if (coinsOptions.isSet(DEBUG_OPTION) || coinsOptions.isSet(CHECK_SYMBOL_TABLE_OPTION)) {
            new TestSym(pHirRoot);
        }
    }

    protected void testHir(HirRoot hirRoot, FlowRoot hirFlowRoot, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        if (coinsOptions.isSet(DEBUG_OPTION) || coinsOptions.isSet(CHECK_HIR_OPTION)) {
            new TestHir(hirRoot, hirFlowRoot);
        }
    }

    protected boolean makeCSourceFromLir(String timing, List lirToCTimings, Module unit, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        trace.trace(this.myName, 5000, "makeCSourceFromLir");
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        if (this.matchLirToCTiming(timing, lirToCTimings, coinsOptions)) {
            File source = io.getSourceFile();
            String sourcePath = source.getPath();
            String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
            String dest = root.concat("-lir-" + timing + ".c");
            this.callLirToC(unit, io, dest);
            this.checkLirToCStopCondition(timing, lirToCTimings, coinsOptions, source);
            return true;
        }
        return false;
    }

    protected ImList makeLIRFromLIRSource(InputStream in, IoRoot io) throws IOException, PassException {
        Object tmp;
        try {
            tmp = ImList.readSexp(new PushbackReader(new InputStreamReader(in)));
            if (tmp == null || !(tmp instanceof ImList)) {
                throw new SyntaxErrorException("Bad New LIR.");
            }
        }
        catch (SyntaxError e) {
            throw new SyntaxErrorException(e.getMessage());
        }
        return (ImList)tmp;
    }

    protected void checkLIROptionsIntegrity(File sourceFile, boolean useOldLir, boolean useNewLir, boolean isLirOutput, boolean skipHIR, IoRoot io) throws PassException {
        Trace trace = io.getCompileSpecification().getTrace();
        trace.trace(this.myName, 5000, "checkLIROptionsIntegrity: useOldLir = " + useOldLir + " useNewLir = " + useNewLir + " isLirOutput = " + isLirOutput + " skipHIR = " + skipHIR);
        if (useOldLir) {
            PassException e = new PassException(sourceFile.getPath(), "COINS option oldlir is obsoleted");
            io.msgError.put(e.getMessage());
            throw e;
        }
    }

    protected void setOptimizationOptions(CompileSpecification spec, CoinsOptions coinsOptions, boolean useNewLir) {
        if (spec.isSet("-O")) {
            int optLevel;
            List argList = (List)spec.getArg("-O");
            if (argList.size() == 0) {
                optLevel = 1;
            } else {
                optLevel = 0;
                Iterator i = argList.iterator();
                while (i.hasNext()) {
                    int l = Integer.parseInt((String)i.next());
                    if (l <= optLevel) continue;
                    optLevel = l;
                }
            }
            if (optLevel > 4) {
                optLevel = 4;
            }
            if (HIR_OPTIMIZATION_ARGS[optLevel] != null) {
                coinsOptions.set(HIR_OPT_OPTION, HIR_OPTIMIZATION_ARGS[optLevel]);
            }
            if (SSA_OPTIMIZATION_ARGS[optLevel] != null && useNewLir) {
                coinsOptions.set(SSA_OPTION, SSA_OPTIMIZATION_ARGS[optLevel]);
            }
            if (LIR_OPTIMIZATION_ARGS[optLevel] != null && useNewLir) {
                coinsOptions.set(LIR_OPTIMIZATION_ARGS[optLevel]);
            }
        }
    }

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        List hirToCTimings = this.initHirToCTimingList(coinsOptions);
        List dumpHirTimings = this.initDumpHirTimingList(coinsOptions);
        List lirToCTimings = this.initLirToCTimingList(coinsOptions);
        Trace trace = spec.getTrace();
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        boolean useOldLir = coinsOptions.isSet(OLD_LIR_OPTION);
        boolean useNewLir = coinsOptions.isSet("newlir");
        if (!useOldLir && !useNewLir) {
            if ("newlir".equals(OLD_LIR_OPTION)) {
                useOldLir = true;
                coinsOptions.set(OLD_LIR_OPTION);
            } else {
                useNewLir = true;
                coinsOptions.set("newlir");
            }
        }
        boolean skipHIR = suffix.getLanguageName().equals("LIR");
        boolean isLirOutput = false;
        if (suffix.getSuffixOption() != null) {
            trace.trace(this.myName, 5000, "suffix option: " + suffix.getSuffixOption());
            isLirOutput = suffix.getSuffixOption().equals(OUT_NEW_LIR_OPTION);
        }
        CheckOptions lCheckOptions = new CheckOptions(spec, io);
        lCheckOptions.isOptionsAreCorrect();
        Object lirFlowRoot = null;
        ImList sexp = null;
        SnapShot snap = null;
        if (spec.getCoinsOptions().isSet("snapshot")) {
            snap = new SnapShot(sourceFile, "coins snapsnot");
        }
        this.checkLIROptionsIntegrity(sourceFile, useOldLir, useNewLir, isLirOutput, skipHIR, io);
        this.setOptimizationOptions(spec, coinsOptions, useNewLir);
        trace.trace(this.myName, 5000, "equivalent COINS options: " + coinsOptions.toString());
        if (!skipHIR) {
            this.makeHirFromSource(sourceFile, hirRoot, suffix, in, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(hirRoot, "Generated HIR");
            }
            this.optimizeHirBeforeFlowAnalysis(hirRoot, symRoot, io);
            this.makeCSourceFromHirBase("new", hirToCTimings, hirRoot, symRoot, io);
            this.dumpHirBase("new", dumpHirTimings, hirRoot, symRoot, io);
            this.hirFlowRoot = coinsOptions.isSet(HIR_FLOW_ANAL_OPTION) ? this.makeHIRFlowAnalysis(hirRoot, symRoot, io) : new FlowRoot(hirRoot);
            this.makeCSourceFromHirBase("flo", hirToCTimings, hirRoot, symRoot, io);
            this.dumpHirBase("flo", dumpHirTimings, hirRoot, symRoot, io);
            this.optimizeHirAfterFlowAnalysis(hirRoot, this.hirFlowRoot, symRoot, io);
            this.makeCSourceFromHirBase("opt", hirToCTimings, hirRoot, symRoot, io);
            this.dumpHirBase("opt", dumpHirTimings, hirRoot, symRoot, io);
            LoopPara lLoopPara = new LoopPara();
            if (coinsOptions.isSet(PARALLEL_DO_ALL)) {
                String lParallelArg = coinsOptions.getArg(PARALLEL_DO_ALL);
                if (lParallelArg != null && this.includedInDelimitedList(OPENMP_OPTION, '/', lParallelArg)) {
                    trace.trace(this.myName, 5000, "Do-all loop parallelization generating OpenMP");
                    lLoopPara.hir2OpenMP(hirRoot, symRoot, io);
                } else if (lParallelArg.charAt(0) >= '0' && lParallelArg.charAt(0) <= '9') {
                    trace.trace(this.myName, 5000, "Do-all loop parallelization generating Machine code");
                    ReformHir lReformHir = new ReformHir(hirRoot);
                } else {
                    io.msgRecovered.put("Unknown option value " + lParallelArg + " for parallelDoAll. Ignore the option.");
                }
            } else if (coinsOptions.isSet(COARSE_GRAIN_PARALLEL) || coinsOptions.isSet(CG_PARALLEL) || coinsOptions.isSet(MACRO_DATA_FLOW_OPTION)) {
                trace.trace(this.myName, 5000, "Coarse grain parallelization generating OpenMP");
                MdfDriver mdfDriver = new MdfDriver(hirRoot, io, spec);
                mdfDriver.hir2OpenMP(hirRoot, symRoot, io, lLoopPara);
            } else if (coinsOptions.isSet(SIMULATE_OPTION)) {
                trace.trace(this.myName, 5000, "Generation of simulation code for profiling");
                ReformHir lReformHir = new ReformHir(hirRoot);
            }
            this.testSym(hirRoot, io);
            this.testHir(hirRoot, this.hirFlowRoot, io);
            SimplifyHir lSimplifyHir = new SimplifyHir(hirRoot, false);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(hirRoot, "Optimized HIR");
            }
            sexp = this.makeNewLirFromHir(hirRoot, io, sourceFile, out, isLirOutput);
            if (isLirOutput) {
                trace.trace(this.myName, 5000, "LIR file is created. Quitting compile.");
                return;
            }
        } else {
            sexp = this.makeLIRFromLIRSource(in, io);
        }
        if (spec.getCoinsOptions().isSet(SIMULATE_OPTION)) {
            CoinsOptions coinsopt = spec.getCoinsOptions();
            String simv = coinsopt.getArg(SIMULATE_OPTION);
            int simulateCount = 0;
            int simulateMem = 0;
            if (simv == null) {
                simulateCount = 2;
            } else if (simv.equals("")) {
                simulateCount = 2;
            } else {
                Map lOptionMap = coinsopt.parseArgument(simv, '/', '.');
                List lKeyList = (List)lOptionMap.get("item_key_list");
                Iterator lIter = lKeyList.iterator();
                while (lIter.hasNext()) {
                    String lOpt = ((String)lIter.next()).intern();
                    if (lOpt == "memAccess") {
                        simulateMem = 1;
                        continue;
                    }
                    if (lOpt == "function") {
                        ++simulateCount;
                        continue;
                    }
                    if (lOpt != "bblock") continue;
                    simulateCount += 2;
                }
            }
            Root root = new Root(spec, new PrintWriter(System.out, true));
            root.setSimulationData(new SimulationData());
            String targetName = coinsOptions.getArg(TARGET_ARCH_OPTION);
            String targetConvention = coinsOptions.getArg(TARGET_CONVENTION_OPTION);
            trace.trace(this.myName, 5000, "target name = " + targetName);
            Module unit = Module.loadSLir(sexp, targetName, targetConvention, root);
            this.makeCSourceFromLir("new", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Generated LIR");
            }
            unit.basicOptimization();
            this.makeCSourceFromLir("opt", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Optimized LIR");
            }
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.generateXml();
            }
            unit.generateCodeWith(out, new String[]{"+BeforeCodeGeneration", "LateRewriting", "+AfterLateRewriting", "ToMachineCode", "+AfterToMachineCode"});
            if (trace.shouldTrace("Sym", 1)) {
                trace.trace("Sym", 1, "\nSym after code generation (ACG)");
                symRoot.symTable.printSymTableAllDetail();
            }
            ((SimulationData)root.simulationData()).setACGModule(unit);
            unit = Module.loadSLir(sexp, targetName, targetConvention, root);
            this.makeCSourceFromLir("new", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Generated LIR");
            }
            unit.basicOptimization();
            this.makeCSourceFromLir("opt", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Optimized LIR");
            }
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.generateXml();
            }
            unit.generateCodeWith(out, new String[]{"+BeforeCodeGeneration"});
            if (trace.shouldTrace("Sym", 1)) {
                trace.trace("Sym", 1, "\nSym after code generation ");
                symRoot.symTable.printSymTableAllDetail();
            }
            ((SimulationData)root.simulationData()).setBCGModule(unit);
            CoinsOptions copt = spec.getCoinsOptions();
            this.getHostArchitectureParameters(copt);
            String hostarch = copt.getArg("simulate-host-arch");
            String hostspec = copt.getArg("simulate-host-spec");
            unit = Module.loadSLir(sexp, hostarch, hostspec, root);
            this.makeCSourceFromLir("new", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Generated LIR");
            }
            unit.basicOptimization();
            this.makeCSourceFromLir("opt", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Optimized LIR");
            }
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.generateXml();
            }
            unit.generateCodeWith(out, new String[]{"+BeforeCodeGeneration"});
            ((SimulationData)root.simulationData()).setBCGhostModule(unit);
            if (trace.shouldTrace("Sym", 1)) {
                trace.trace("Sym", 1, "\nSym before code generation host");
                symRoot.symTable.printSymTableAllDetail();
            }
            SimFuncTable simfunctable = ((SimulationData)root.simulationData()).SetupSimFuncTable(simulateCount, simulateMem);
            simfunctable.symbolTable(root, simfunctable.acg, "Target");
            simfunctable.symbolTable(root, simfunctable.bcghost, "Host");
            if (spec.getCoinsOptions().isSet("simulateLog")) {
                System.out.println("Simulattion LIR ( before ):");
                ImList.printIt(root.debOut, unit.toSexp());
            }
            simfunctable.analyze(root, targetName, hostarch, simulateCount, simulateMem);
            if (spec.getCoinsOptions().isSet("simulateLog")) {
                System.out.println("Simulattion LIR (after ):");
                ImList.printIt(root.debOut, unit.toSexp());
            }
            unit.generateCodeWith(out, new String[]{"LateRewriting", "+AfterLateRewriting", "ToMachineCode", "+AfterToMachineCode", "ConvToAsm"});
        } else {
            Root root = new Root(spec, new PrintWriter(System.out, true));
            String targetName = coinsOptions.getArg(TARGET_ARCH_OPTION);
            String targetConvention = coinsOptions.getArg(TARGET_CONVENTION_OPTION);
            trace.trace(this.myName, 5000, "target name = " + targetName);
            Module unit = Module.loadSLir(sexp, targetName, targetConvention, root);
            this.makeCSourceFromLir("new", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Generated LIR");
            }
            if (spec.getCoinsOptions().isSet(SSA_OPTION)) {
                unit.apply(new SsaDriver(unit, io, spec));
                unit.apply(SimpleOpt.trig);
                unit.apply(JumpOpt.trig);
            } else {
                unit.basicOptimization();
            }
            if (spec.getCoinsOptions().isSet("simd")) {
                unit.apply(new SimdDriver(unit, io, spec));
            }
            this.makeCSourceFromLir("opt", lirToCTimings, unit, io);
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.shot(unit, "Optimized LIR");
            }
            if (spec.getCoinsOptions().isSet("snapshot")) {
                snap.generateXml();
            }
            unit.generateCode(out);
            if (trace.shouldTrace("Sym", 1)) {
                trace.trace("Sym", 1, "\nSym after code generation ");
                symRoot.symTable.printSymTableAllDetail();
            }
        }
    }

    public void assemble(File sourceFile, Suffix suffix, InputStream in, File out, IoRoot io) throws IOException, PassException {
        String[] commandLine;
        Trace trace = io.getCompileSpecification().getTrace();
        trace.trace(this.myName, 5000, "assemble");
        List options = io.getCompileSpecification().getAssemblerOptions();
        options.add("-o");
        options.add(out.getPath());
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        String commandName = DEFAULT_ASSEMBLER_NAME;
        if (coinsOptions.isSet(ASSEMBLER_NAME_OPTION)) {
            commandName = coinsOptions.getArg(ASSEMBLER_NAME_OPTION);
        }
        if (this.runProgram(commandLine = this.makeCommandLine(commandName, options), in, (OutputStream)io.msgOut, io) != 0) {
            throw new PassException(sourceFile, ASSEMBLER_NAME_OPTION, "Error(s) in assembler.");
        }
    }

    protected void setDefaultLinkerOptions(CompileSpecification spec, List options) {
        String s = this.defaultSettings.getProperty(DEFAULT_LINKER_OPTIONS_PROPERTY);
        if (s != null && !s.equals("")) {
            options.addAll(this.separateDelimitedList(s, ' '));
        }
    }

    public void link(File out, IoRoot io) throws IOException, PassException {
        String[] commandLine;
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        List options = spec.getLinkerOptions();
        options.add(0, "-o");
        options.add(1, out.getPath());
        this.setDefaultLinkerOptions(spec, options);
        trace.trace(this.myName, 5000, "link(1)");
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        String commandName = DEFAULT_LINKER_NAME;
        if (coinsOptions.isSet(LINKER_NAME_OPTION)) {
            commandName = coinsOptions.getArg(LINKER_NAME_OPTION);
        }
        if (this.runProgram(commandLine = this.makeCommandLine(commandName, options), null, (OutputStream)io.msgOut, io) != 0) {
            throw new PassException(LINKER_NAME_OPTION, "Error(s) in linker.");
        }
    }

    private void loadDefaultSettings(CompileSpecification spec) {
        this.defaultSettings = new Properties();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        File libDir = coinsOptions.getLibDir();
        File settingFile = new File(libDir, DEFAULT_SETTING);
        if (settingFile.exists()) {
            try {
                this.defaultSettings.load(new FileInputStream(settingFile));
            }
            catch (IOException e) {
                spec.getWarning().warning("Couldn't load the default setting file: " + settingFile.getPath());
            }
        }
    }

    private void getHostArchitectureParameters(CoinsOptions copt) {
        String lbconv;
        String lbname;
        String lbopt = copt.getArg("simulate-host");
        if (lbopt == null) {
            lbname = "x86";
            lbconv = "standard";
        } else {
            int lbdi = lbopt.indexOf(45);
            if (lbdi == -1) {
                lbname = lbopt;
                lbconv = "standard";
            } else {
                lbname = lbopt.substring(0, lbdi);
                lbconv = lbopt.substring(lbdi + 1);
            }
        }
        copt.set("simulate-host-arch", lbname);
        copt.set("simulate-host-spec", lbconv);
        String dummy1 = copt.getArg("simulate-host-arch");
        String dummy2 = copt.getArg("simulate-host-spec");
    }

    protected void go(String[] args) {
        try {
            CommandLine spec = new CommandLine(args);
            this.loadDefaultSettings(spec);
            Root.init(spec);
            int status = new CompilerDriver(spec).go(this);
            System.exit(status);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new Driver().go(args);
    }
}

