/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.CompileStatus;
import coins.driver.CompileThread;
import coins.driver.CompilerImplementation;
import coins.driver.SuffixFactory;
import coins.driver.TemporaryFileManager;
import coins.driver.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class CompilerDriver {
    private static final File DEFAULT_TEMP_DIR = new File("/tmp");
    private static final String PARALLEL_COMPILE_OPTION = "compile-parallel";
    private static final String FACTORY_CLASS_NAME = "coins.driver.SuffixFactory";
    private CompileSpecification fSpec;
    private TemporaryFileManager fTemporaryFileManager;

    private void initializeSuffixFactory() {
        CoinsOptions lCoinsOptions = this.fSpec.getCoinsOptions();
        String lSuffixFilePathOption = "suffix";
        Trace lTrace = this.fSpec.getTrace();
        if (lCoinsOptions.isSet(lSuffixFilePathOption)) {
            lTrace.trace("Driver", 9, "Using -coins:suffix option for suffix rules");
            String lSuffixFileName = lCoinsOptions.getArg(lSuffixFilePathOption);
            SuffixFactory.initialize(new File(lSuffixFileName), this.fSpec);
        } else {
            String lSuffixFileName = "suffixes";
            File lSuffixFile = new File(lCoinsOptions.getLibDir(), lSuffixFileName);
            if (lSuffixFile.isFile()) {
                lTrace.trace("Driver", 9, "Using libdir/suffixes for suffix rules");
                SuffixFactory.initialize(lSuffixFile, this.fSpec);
            } else {
                String lFile = FACTORY_CLASS_NAME + File.separator + lSuffixFileName;
                try {
                    lTrace.trace("Driver", 9, "Trying attached file for suffix rules");
                    Class<?> lClass = Class.forName(FACTORY_CLASS_NAME);
                    InputStream lIn = CompilerDriver.getAttachedFileInputStream(lClass, lSuffixFileName);
                    SuffixFactory.initialize(lIn, lFile, this.fSpec);
                }
                catch (IOException lIOException) {
                    this.fSpec.getWarning().warning("Driver", "Cannot read suffix database file (" + lFile + "). Using default setting: " + lIOException.getMessage());
                    SuffixFactory.defaultInitialize(this.fSpec);
                }
                catch (ClassNotFoundException lClassNotFoundException) {
                    throw new NoClassDefFoundError(lClassNotFoundException.getMessage());
                }
            }
        }
    }

    private static String searchClass(Class clazz, String cpe) throws IOException {
        File d = new File(cpe);
        String cname = clazz.getName();
        if (d.isDirectory()) {
            File f = new File(cpe + File.separator + cname.replace('.', File.separatorChar) + ".class");
            if (f.isFile()) {
                return cpe;
            }
            return null;
        }
        JarFile jf = new JarFile(cpe);
        if (jf.getJarEntry(cname.replace('.', '/') + ".class") != null) {
            return cpe;
        }
        Manifest manifest = jf.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes ma = manifest.getMainAttributes();
        String classpath = ma.getValue("Class-Path");
        if (classpath == null) {
            return null;
        }
        String[] path = classpath.split("\\s+");
        for (int i = 0; i < path.length; ++i) {
            String s = CompilerDriver.searchClass(clazz, path[i]);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private static InputStream getAttachedFileInputStream(String cpe, Class clazz, String path) throws IOException {
        File d = new File(cpe);
        String cname = clazz.getName();
        int i = cname.lastIndexOf(46);
        String pname = i == -1 ? "" : cname.substring(0, i);
        if (d.isDirectory()) {
            File p = new File(cpe + File.separator + pname.replace('.', File.separatorChar) + File.separator + path);
            return new FileInputStream(p);
        }
        JarFile jf = new JarFile(cpe);
        String fname = pname.replace('.', '/') + '/' + path.replace(File.separatorChar, '/');
        JarEntry ze = jf.getJarEntry(fname);
        if (ze == null) {
            throw new FileNotFoundException(fname);
        }
        return jf.getInputStream(ze);
    }

    public static InputStream getAttachedFileInputStream(Class clazz, String path) throws ClassNotFoundException, IOException {
        int i;
        String classpath = System.getProperty("java.class.path");
        while ((i = classpath.indexOf(":")) != -1) {
            String segment = classpath.substring(0, i);
            if ((segment = CompilerDriver.searchClass(clazz, segment)) != null) {
                return CompilerDriver.getAttachedFileInputStream(segment, clazz, path);
            }
            classpath = classpath.substring(i + 1);
        }
        if ((classpath = CompilerDriver.searchClass(clazz, classpath)) != null) {
            return CompilerDriver.getAttachedFileInputStream(classpath, clazz, path);
        }
        throw new ClassNotFoundException(clazz.getName());
    }

    public CompilerDriver(CompileSpecification spec) {
        this.fSpec = spec;
        this.fTemporaryFileManager = new TemporaryFileManager();
        this.initializeSuffixFactory();
    }

    private void preserveTemporaryFiles() {
        Collection lTemporaryFiles = this.fTemporaryFileManager.getTemporaryFiles();
        if (lTemporaryFiles.size() > 0) {
            System.err.println("Following temporary files are preserved:");
            for (File lFile : lTemporaryFiles) {
                System.err.println("  " + lFile.getAbsolutePath());
            }
        }
    }

    private void cleanup() {
        CoinsOptions lCoinsOptions = this.fSpec.getCoinsOptions();
        if (!lCoinsOptions.isSet("debug")) {
            if (!lCoinsOptions.isSet("preserveFiles")) {
                this.fSpec.getTrace().trace("Driver", 5000, "cleaning up...");
                this.fTemporaryFileManager.cleanupTemporaryFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int go(CompilerImplementation implementation) {
        CompileStatus status = new CompileStatus();
        if (this.fSpec.isSet("-help")) {
            this.fSpec.showHelp(System.out, implementation);
            return 0;
        }
        this.fSpec.getTrace().trace("Driver", 5000, this.fSpec.toString());
        try {
            Iterator i = this.fSpec.getSourceFiles().iterator();
            this.fSpec.getTrace().trace("Driver", 5000, "go(1)");
            if (i.hasNext()) {
                CompileThread lThread;
                this.fSpec.getTrace().trace("Driver", 5000, "go(2)");
                CompileStatus staus = new CompileStatus();
                ArrayList<CompileThread> lThreads = new ArrayList<CompileThread>();
                while (i.hasNext()) {
                    lThread = new CompileThread((String)i.next(), this.fSpec, this.fTemporaryFileManager, implementation, status, false);
                    lThread.start();
                    if (this.fSpec.getCoinsOptions().isSet(PARALLEL_COMPILE_OPTION)) {
                        lThreads.add(lThread);
                        continue;
                    }
                    lThread.join();
                }
                i = lThreads.iterator();
                while (i.hasNext()) {
                    ((Thread)i.next()).join();
                }
                if (status.isLinkingRequired()) {
                    lThread = new CompileThread("", this.fSpec, this.fTemporaryFileManager, implementation, status, true);
                    lThread.start();
                    lThread.join();
                } else {
                    this.fSpec.getTrace().trace("Driver", 5000, "Linking is cancelled.\n");
                }
            } else {
                System.err.println("No input files.");
                status.setABEND();
            }
        }
        catch (InterruptedException lInterruptedException) {
            status.setABEND();
        }
        finally {
            this.cleanup();
        }
        return status.getExitStatus();
    }
}

