/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.driver.Warning;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CoinsOptions {
    public static final String DEFAULT_LIBDIR_NAME_AT_HOME = "coins";
    public static final String DEFAULT_LIBDIR = ".";
    public static final String DEFAULT_PROPERTY_FILENAME = "properties";
    public static final String DEBUG = "debug";
    public static final String PRESERVE_FILES = "preserveFiles";
    public static final String LIBDIR = "libdir";
    public static final String PROPERTY_FILE = "property";
    public static final String SUFFIX_FILE_PATH = "suffix";
    public static final String SUFFIX_OPTION = "suffixoption";
    public static final String TRACE = "trace";
    private static final char OPTION_DELIMITER = ',';
    private static final char VALUE_DELIMITER = '=';
    private Properties fOptions;
    private final File fLibDir;
    protected String fArgumentString;

    private void parseArgument(String pArgumentString, Properties pTable) {
        String lArgument = pArgumentString.trim();
        int lIndex = 0;
        int lLen = lArgument.length();
        while (lIndex < lLen) {
            String lValue;
            String lOption;
            String lNextOption;
            int lOptionDelimiterIndex = lArgument.indexOf(44, lIndex);
            if (lOptionDelimiterIndex == -1) {
                lNextOption = lArgument.substring(lIndex);
                lIndex = lLen;
            } else {
                lNextOption = lArgument.substring(lIndex, lOptionDelimiterIndex);
                lIndex = lOptionDelimiterIndex + 1;
            }
            int lValueDelimiterIndex = lNextOption.indexOf(61);
            if (lValueDelimiterIndex == -1) {
                lOption = lNextOption;
                lValue = "";
            } else {
                lOption = lNextOption.substring(0, lValueDelimiterIndex);
                lValue = lNextOption.substring(lValueDelimiterIndex + 1);
            }
            pTable.setProperty(lOption, lValue);
        }
    }

    private String searchLibDirAtHome() {
        String dpath = System.getProperty("user.home") + File.separator + DEFAULT_LIBDIR_NAME_AT_HOME;
        File d = new File(dpath);
        if (d.isDirectory()) {
            return dpath;
        }
        return null;
    }

    private File libDir(Properties pOptions) {
        String lLibDirName = pOptions.getProperty(LIBDIR);
        File lLibDir = lLibDirName != null ? new File(lLibDirName) : ((lLibDirName = this.searchLibDirAtHome()) != null ? new File(lLibDirName) : new File(DEFAULT_LIBDIR));
        return lLibDir;
    }

    private Properties parsePropertyFile(File pPropertyFile, Warning pWarning) {
        Properties lProperties = new Properties();
        try {
            FileInputStream pIn = new FileInputStream(pPropertyFile);
            lProperties.load(pIn);
        }
        catch (IOException lIOException) {
            pWarning.warning("Driver", "Cannot read property file (" + pPropertyFile.getAbsolutePath() + "): " + lIOException.getMessage());
        }
        return lProperties;
    }

    private void mergeTables(Properties dest, Properties src) {
        Enumeration<?> pEnumeration = src.propertyNames();
        while (pEnumeration.hasMoreElements()) {
            String lKey = (String)pEnumeration.nextElement();
            dest.setProperty(lKey, src.getProperty(lKey));
        }
    }

    public CoinsOptions(String argumentString) {
        this.fArgumentString = argumentString;
        this.fOptions = new Properties();
        this.parseArgument(argumentString, this.fOptions);
        this.fLibDir = this.libDir(this.fOptions);
    }

    public void readPropertyFile(Warning pWarning) {
        String lPropertyPath = this.fOptions.getProperty(PROPERTY_FILE);
        File lPropertyFile = lPropertyPath == null ? new File(this.fLibDir, DEFAULT_PROPERTY_FILENAME) : new File(lPropertyPath);
        Properties lProperties = this.fOptions;
        this.fOptions = this.parsePropertyFile(lPropertyFile, pWarning);
        this.mergeTables(this.fOptions, lProperties);
    }

    public synchronized boolean isSet(String pOption) {
        return this.fOptions.getProperty(pOption) != null;
    }

    public synchronized String getArg(String pOption) {
        return this.fOptions.getProperty(pOption);
    }

    public synchronized void set(String pOption) {
        this.fOptions.setProperty(pOption, "");
    }

    public synchronized void set(String pOption, String pArg) {
        this.fOptions.setProperty(pOption, pArg);
    }

    public synchronized File getLibDir() {
        return this.fLibDir;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Enumeration<Object> e = this.fOptions.keys();
        if (e.hasMoreElements()) {
            s.append("-coins:");
            do {
                String key = (String)e.nextElement();
                s.append(key);
                String arg = this.fOptions.getProperty(key);
                if (!arg.equals("")) {
                    s.append("=" + arg);
                }
                if (!e.hasMoreElements()) continue;
                s.append(",");
            } while (e.hasMoreElements());
        }
        return s.toString();
    }

    public Map parseArgument(String pArgument, char pCategoryDelimiter, char pValueDelimiter) {
        Hashtable lTable = new Hashtable();
        ArrayList lKeyList = new ArrayList();
        String lArgument = pArgument.trim();
        int lIndex = 0;
        int lLen = lArgument.length();
        while (lIndex < lLen) {
            String lNextArg;
            int lCategoryDelimiterIndex = lArgument.indexOf(pCategoryDelimiter, lIndex);
            if (lCategoryDelimiterIndex == -1) {
                lNextArg = lArgument.substring(lIndex);
                lIndex = lLen;
            } else {
                lNextArg = lArgument.substring(lIndex, lCategoryDelimiterIndex);
                lIndex = lCategoryDelimiterIndex + 1;
            }
            this.parseItem(lNextArg, lTable, pValueDelimiter, lKeyList);
        }
        lTable.put("item_key_list", lKeyList);
        return lTable;
    }

    private void parseItem(String pTraceSpec, Map pTable, char pValueDelimiter, List pKeyList) {
        int lLevelDelimiterIndex = pTraceSpec.indexOf(pValueDelimiter);
        if (lLevelDelimiterIndex == -1) {
            pTable.put(pTraceSpec, "");
            pKeyList.add(pTraceSpec);
        } else {
            String lCategory = pTraceSpec.substring(0, lLevelDelimiterIndex);
            String lValueString = pTraceSpec.substring(lLevelDelimiterIndex + 1);
            pTable.put(lCategory, lValueString);
            pKeyList.add(lCategory);
        }
    }

    public Set getOptionKeys() {
        Map lOptionMap = this.parseArgument(this.fArgumentString, ',', '=');
        Set lOptionKeys = lOptionMap.keySet();
        return lOptionKeys;
    }
}

