/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

final class KeywordTable {
    char[][] names;
    int[] tokenIds;
    int num = 0;
    private static final int MAX = 32;
    private final char[] cbuf = new char[32];

    KeywordTable(int n) {
        this.names = new char[n][];
        this.tokenIds = new int[n];
    }

    void append(String name, int id) {
        int len = name.length();
        if (len > 32) {
            throw new RuntimeException("too long keyword");
        }
        char[] c = new char[len];
        name.getChars(0, len, c, 0);
        this.names[this.num] = c;
        this.tokenIds[this.num] = id;
        ++this.num;
    }

    int lookup(StringBuffer key) {
        int len = key.length();
        if (len > 32) {
            return -1;
        }
        key.getChars(0, len, this.cbuf, 0);
        int low = 0;
        int high = this.num - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            char[] candidate = this.names[mid];
            int cond = KeywordTable.compare(candidate, candidate.length, this.cbuf, len);
            if (cond == 0) {
                return this.tokenIds[mid];
            }
            if (cond < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -1;
    }

    private static int compare(char[] str1, int len1, char[] str2, int len2) {
        int n = Math.min(len1, len2);
        for (int i = 0; i < n; ++i) {
            char c1 = str1[i];
            char c2 = str2[i];
            if (c1 < c2) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        return 0;
    }
}

