/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ParseString;
import coins.casttohir.ToHir;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.ElemNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.InfStmt;
import coins.ir.hir.InfStmtImpl;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Program;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.StmtImpl;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.IntConst;
import coins.sym.StringConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.HashSet;
import java.util.ListIterator;

abstract class ToHirVisit {
    protected final ToHir toHir;
    protected final HIR hir;
    protected final Sym sym;
    protected BlockStmt nowBlock;
    public final int fDbgLevel;

    protected ToHirVisit(ToHir tohir) {
        this.toHir = tohir;
        this.hir = tohir.hirRoot.hir;
        this.sym = tohir.hirRoot.sym;
        this.fDbgLevel = tohir.hirRoot.ioRoot.dbgToHir.getLevel();
        tohir.hirRoot.ioRoot.dbgToHir.print(1, "ToHirVisit\n");
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "Vi", mes);
    }

    protected boolean inInitBlock() {
        return this.nowBlock == null || this.nowBlock.getFlag(4);
    }

    public final void visitProgram() {
        this.visitProgram((Program)this.toHir.hirRoot.programRoot);
    }

    final void visitProgram(Program program) {
        this.toHir.symRoot.symTableCurrent = this.toHir.symRoot.symTableRoot;
        this.toHir.symRoot.subpCurrent = null;
        IR ir = program.getInitiationPart();
        if (ir != null && ir.getOperator() == 35) {
            this.visitStmt((Stmt)ir);
        }
        ListIterator i = program.getSubpDefinitionList().iterator();
        while (i.hasNext()) {
            SubpDefinition subpdef = (SubpDefinition)i.next();
            this.toHir.symRoot.subpCurrent = subpdef.getSubpSym();
            this.toHir.symRoot.symTableCurrent = subpdef.getSubpSym().getSymTable();
            this.visitStmt(subpdef.getInitiationPart());
            this.visitStmt(subpdef.getHirBody());
        }
    }

    final void visitStmt(Stmt s) {
        if (s == null) {
            return;
        }
        this.toHir.nowFile = s.getFileName();
        this.toHir.nowLine = s.getLineNumber();
        if (this.fDbgLevel > 3) {
            this.message(8, "{" + s + "}\t" + this.toHir.nowFile + "(" + this.toHir.nowLine + ")");
        }
        switch (s.getOperator()) {
            case 35: {
                SymTable oldsymtable = this.toHir.symRoot.symTableCurrent;
                if (((BlockStmt)s).getSymTable() != null) {
                    this.toHir.symRoot.symTableCurrent = ((BlockStmt)s).getSymTable();
                }
                this.atBlock((BlockStmt)s);
                this.toHir.symRoot.symTableCurrent = oldsymtable;
                break;
            }
            case 21: {
                this.atLabeledStmt((LabeledStmt)s);
                break;
            }
            case 22: {
                this.atAssignStmt((AssignStmt)s);
                break;
            }
            case 23: {
                this.atIf((IfStmt)s);
                break;
            }
            case 24: {
                this.atWhile((LoopStmt)s);
                break;
            }
            case 25: {
                this.atFor((LoopStmt)s);
                break;
            }
            case 26: {
                this.atUntil((LoopStmt)s);
                break;
            }
            case 28: {
                this.atJump((JumpStmt)s);
                break;
            }
            case 32: {
                this.atSwitch((SwitchStmt)s);
                break;
            }
            case 34: {
                this.atReturn((ReturnStmt)s);
                break;
            }
            case 36: {
                this.atExpStmt((ExpStmt)s);
                break;
            }
            case 71: {
                this.atSetDataStmt((SetDataStmt)s);
                break;
            }
            case 4: {
                this.atInfStmt((InfStmt)s);
                break;
            }
            case 37: {
                break;
            }
            default: {
                this.toHir.fatal("not supported statement: " + s);
            }
        }
    }

    protected void atBlock(BlockStmt s) {
        BlockStmt oldblock = this.nowBlock;
        this.nowBlock = s;
        Stmt now = s.getFirstStmt();
        while (now != null) {
            Stmt next = ((StmtImpl)now).getNextStmt();
            this.visitStmt(now);
            now = next;
        }
        this.nowBlock = oldblock;
    }

    protected void atLabeledStmt(LabeledStmt s) {
        this.visitStmt(s.getStmt());
    }

    protected void atAssignStmt(AssignStmt s) {
        Exp old = s.getLeftSide();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setLeftSide(now);
        }
        if ((now = this.visitExp(old = s.getRightSide())) != old) {
            s.setRightSide(now);
        }
    }

    protected void atIf(IfStmt s) {
        this.visitStmt(s.getThenPart());
        this.visitStmt(s.getElsePart());
        Exp old = s.getIfCondition();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setIfCondition(now);
        }
    }

    protected void atWhile(LoopStmt s) {
        this.visitStmt(s.getLoopBodyPart());
        Exp old = s.getLoopStartCondition();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setLoopStartCondition(now);
        }
    }

    protected void atFor(LoopStmt s) {
        this.visitStmt(s.getLoopInitPart());
        this.visitStmt(s.getLoopBodyPart());
        this.visitStmt(s.getLoopStepPart());
        Exp old = s.getLoopStartCondition();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setLoopStartCondition(now);
        }
    }

    protected void atUntil(LoopStmt s) {
        this.visitStmt(s.getLoopBodyPart());
        Exp old = s.getLoopEndCondition();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setLoopEndCondition(now);
        }
    }

    protected void atJump(JumpStmt s) {
    }

    protected void atSwitch(SwitchStmt s) {
        this.visitStmt(s.getBodyStmt());
        Exp old = s.getSelectionExp();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setSelectionExp(now);
        }
    }

    protected void atReturn(ReturnStmt s) {
        Exp old = s.getReturnValue();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setReturnValue(now);
        }
    }

    protected void atExpStmt(ExpStmt s) {
        Exp old = s.getExp();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setExp(now);
        }
    }

    protected void atSetDataStmt(SetDataStmt s) {
        Exp old = s.getLeftSide();
        Exp now = this.visitExp(old);
        if (now != old) {
            s.setLeftSide(now);
        }
        if ((now = this.visitExp(old = s.getRightSide())) != old) {
            s.setRightSide(now);
        }
    }

    final Exp visitExp(Exp e) {
        if (e == null) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.message(8, "<" + e + ">");
        }
        switch (e.getOperator()) {
            case 5: {
                return this.atConst((ConstNode)e);
            }
            case 7: {
                return this.atVar((VarNode)e);
            }
            case 9: {
                return this.atSubp((SubpNode)e);
            }
            case 12: {
                return this.atElem((ElemNode)e);
            }
            case 17: {
                return this.atSubs(e);
            }
            case 19: {
                return this.atQual(e);
            }
            case 20: {
                return this.atArrow(e);
            }
            case 33: {
                return this.atCall((FunctionExp)e);
            }
            case 38: {
                return this.atAdd(e);
            }
            case 39: {
                return this.atSub(e);
            }
            case 41: {
                return this.atMul(e);
            }
            case 42: {
                return this.atDiv(e);
            }
            case 43: {
                return this.atMod(e);
            }
            case 46: {
                return this.atAnd(e);
            }
            case 47: {
                return this.atOr(e);
            }
            case 48: {
                return this.atXor(e);
            }
            case 51: {
                return this.atCmpEq(e);
            }
            case 52: {
                return this.atCmpNe(e);
            }
            case 53: {
                return this.atCmpGt(e);
            }
            case 54: {
                return this.atCmpGe(e);
            }
            case 55: {
                return this.atCmpLt(e);
            }
            case 56: {
                return this.atCmpLe(e);
            }
            case 58: {
                return this.atLShift(e);
            }
            case 59: {
                return this.atARShift(e);
            }
            case 60: {
                return this.atRShift(e);
            }
            case 62: {
                return this.atNot(e);
            }
            case 63: {
                return this.atNeg(e);
            }
            case 64: {
                return this.atAddr(e);
            }
            case 65: {
                return this.atConv(e);
            }
            case 66: {
                return this.atDecay(e);
            }
            case 67: {
                return this.atUndecay(e);
            }
            case 68: {
                return this.atContents(e);
            }
            case 22: {
                return this.atAssign(e);
            }
            case 76: {
                return this.atOffset(e);
            }
            case 77: {
                return this.atLgAnd(e);
            }
            case 78: {
                return this.atLgOr(e);
            }
            case 79: {
                return this.atSelect(e);
            }
            case 80: {
                return this.atComma(e);
            }
            case 81: {
                return this.atEqZero(e);
            }
            case 82: {
                return this.atPre(38, e);
            }
            case 83: {
                return this.atPre(39, e);
            }
            case 84: {
                return this.atPost(38, e);
            }
            case 85: {
                return this.atPost(39, e);
            }
            case 86: {
                return this.atAddAssign(e);
            }
            case 87: {
                return this.atSubAssign(e);
            }
            case 88: {
                return this.atMulAssign(e);
            }
            case 89: {
                return this.atDivAssign(e);
            }
            case 90: {
                return this.atModAssign(e);
            }
            case 91: {
                return this.atLShiftAssign(e);
            }
            case 92: {
                return this.atRShiftAssign(e);
            }
            case 93: {
                return this.atAndAssign(e);
            }
            case 94: {
                return this.atOrAssign(e);
            }
            case 95: {
                return this.atXorAssign(e);
            }
            case 96: {
                return this.atExpList((ExpListExp)e);
            }
            case 97: {
                return this.atExpRepeat(e);
            }
            case 73: {
                return e;
            }
        }
        this.toHir.fatal("unexpected operator: " + e);
        return null;
    }

    protected Exp atConst(ConstNode e) {
        return e;
    }

    protected Exp atVar(VarNode e) {
        return e;
    }

    protected Exp atSubp(SubpNode e) {
        return e;
    }

    protected Exp atElem(ElemNode e) {
        return e;
    }

    protected Exp atSubs(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atIndex(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atQual(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atArrow(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCall(FunctionExp e) {
        Exp old = e.getFunctionSpec();
        Exp now = this.visitExp(old);
        if (now != old) {
            e.setFunctionSpec(now);
        }
        HirList actuallist = (HirList)e.getParamList();
        ListIterator i = actuallist.iterator();
        while (i.hasNext()) {
            old = (Exp)i.next();
            now = this.visitExp(old);
            if (now == old) continue;
            i.set(now);
            now.setParent(actuallist);
        }
        return e;
    }

    protected Exp atAdd(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atSub(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atMul(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atDiv(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atMod(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atAnd(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atOr(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atXor(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpEq(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpNe(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpGt(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpGe(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpLt(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atCmpLe(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atLShift(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atARShift(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atRShift(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atNot(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atNeg(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atAddr(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atConv(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atDecay(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atUndecay(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atContents(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atOffset(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atLgAnd(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atLgOr(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atSelect(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild(3)))) != old) {
            e.setChild(3, now);
        }
        return e;
    }

    protected Exp atComma(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atEqZero(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atPre(int op, Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atPost(int op, Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        return e;
    }

    protected Exp atAddAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atSubAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atMulAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atDivAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atModAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atLShiftAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atRShiftAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atAndAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atOrAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atXorAssign(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected Exp atExpList(ExpListExp e) {
        Exp old;
        int i = 0;
        while ((old = e.getExp(i)) != null) {
            Exp now = this.visitExp(old);
            if (now != old) {
                e.setExp(i, now);
            }
            ++i;
        }
        return e;
    }

    protected Exp atExpRepeat(Exp e) {
        IR old = e.getChild1();
        Exp now = this.visitExp((Exp)old);
        if (now != old) {
            e.setChild1(now);
        }
        if ((now = this.visitExp((Exp)(old = e.getChild2()))) != old) {
            e.setChild2(now);
        }
        return e;
    }

    protected SubpDefinition atSubpDefinition(SubpDefinition s) {
        SubpDefinition lSubpDefinition = s;
        Subp lSubp = lSubpDefinition.getSubpSym();
        this.message(3, "\n atSubpDefinition " + lSubp.getName());
        ((HIR_Impl)this.hir).hirRoot.symRoot.symTableCurrent = lSubp.getSymTable();
        ((HIR_Impl)this.hir).hirRoot.symRoot.symTableCurrentSubp = lSubp.getSymTable();
        ((HIR_Impl)this.hir).hirRoot.symRoot.subpCurrent = lSubp;
        this.visitStmt(lSubpDefinition.getInitiationPart());
        this.visitStmt(lSubpDefinition.getHirBody());
        ((HIR_Impl)this.hir).hirRoot.symRoot.symTableCurrent = ((HIR_Impl)this.hir).hirRoot.symRoot.symTableRoot;
        ((HIR_Impl)this.hir).hirRoot.symRoot.subpCurrent = null;
        return lSubpDefinition;
    }

    protected InfStmt atInfStmt(InfStmt pInf) {
        String lPragmaBody;
        IrList lInfList = pInf.getInfList();
        if (lInfList == null) {
            return pInf;
        }
        if (((InfStmtImpl)pInf).fReformed) {
            this.message(4, "\natInfStmt reformed " + pInf);
            return pInf;
        }
        String lPragmaKind = pInf.getInfKind();
        Object lBodyItem = lInfList.get(1);
        this.message(4, "\natInfStmt " + lPragmaKind + " " + lBodyItem);
        if (lBodyItem instanceof IrList && ((IrList)lBodyItem).size() == 1 && ((IrList)lBodyItem).get(0) instanceof String) {
            lPragmaBody = (String)((IrList)lBodyItem).get(0);
        } else if (lBodyItem instanceof String) {
            lPragmaBody = (String)lBodyItem;
        } else {
            String lSubKind;
            this.message(4, " already processed " + pInf);
            String lInfKind = pInf.getInfKind();
            if (lInfKind == "optControl" && (lSubKind = pInf.getInfSubkindOf("optControl")) == "safeArray") {
                IrList lItemList = pInf.getInfList("optControl");
                int lIndex = 0;
                ListIterator lIt = lItemList.iterator();
                while (lIt.hasNext()) {
                    Object lItem;
                    if (lIndex > 0 && (lItem = lIt.next()) instanceof Var) {
                        this.message(4, " add to safeArray " + ((Sym)lItem).getName());
                        ((SymImpl)this.sym).symRoot.safeArray.add(lItem);
                    }
                    ++lIndex;
                }
            }
            return pInf;
        }
        this.message(4, "body " + lPragmaBody);
        InfStmt lResult = null;
        if (lPragmaKind != "" && lPragmaBody != "") {
            HashSet<String> lDelimiters = new HashSet<String>();
            HashSet<String> lSpaces = new HashSet<String>();
            HashSet<String> lIdSpChars = new HashSet<String>();
            lDelimiters.add("(");
            lDelimiters.add(")");
            lDelimiters.add(",");
            lDelimiters.add(";");
            lSpaces.add(" ");
            lSpaces.add("\t");
            lIdSpChars.add("_");
            lIdSpChars.add("$");
            ParseString lParseString = new ParseString(lPragmaBody, lDelimiters, lSpaces, lIdSpChars);
            IrListImpl lIrList = new IrListImpl(this.toHir.hirRoot);
            while (lParseString.hasNext()) {
                String lItem = lParseString.getNextToken();
                this.message(4, " item " + lItem + " kind " + lParseString.getTokenKind());
                IrList lList = this.processPragmaItem(lParseString, lItem, lIrList);
                if (lList == null || lList == lIrList) continue;
                this.message(4, "\n add list " + lList + " to list " + lIrList);
                lIrList.add(lList);
                lList = null;
            }
            this.message(4, "\n lIrList " + ((Object)lIrList).toString() + " size " + lIrList.size());
            if (!lIrList.isEmpty()) {
                this.message(4, " 1stElem " + lIrList.get(0) + " " + lIrList.get(0).getClass());
            }
            lResult = lIrList.size() == 1 && lIrList.get(0) instanceof IrList ? this.hir.infStmt(lPragmaKind.intern(), (IrList)lIrList.get(0)) : this.hir.infStmt(lPragmaKind.intern(), lIrList);
        } else {
            IrListImpl lIrList = new IrListImpl(this.toHir.hirRoot);
            if (lPragmaBody != "") {
                lIrList.add(this.sym.stringConst(lPragmaBody));
            }
            lResult = this.hir.infStmt(lPragmaKind.intern(), lIrList);
        }
        this.message(4, "\n lResult " + lResult.toString() + " " + lResult.getInfList(lPragmaKind));
        if (lResult.getInfList(lPragmaKind) instanceof IrList) {
            pInf.replaceThisStmtWith(lResult);
        }
        ((InfStmtImpl)pInf).fReformed = true;
        return lResult;
    }

    IrList processPragmaItem(ParseString pParseString, String pNextItem, IrList pList) {
        this.message(5, " processPragmaItem " + pNextItem + " kind " + pParseString.getTokenKind() + " pList " + pList.toStringShort());
        if (pNextItem == "(") {
            IrListImpl lInnerList = new IrListImpl(this.toHir.hirRoot);
            boolean lExpectComma = false;
            while (pParseString.hasNext()) {
                String lListItem = pParseString.getNextToken();
                if (lExpectComma && lListItem == ",") {
                    lListItem = pParseString.getNextToken();
                    lExpectComma = false;
                }
                if (lListItem == ")") break;
                IrList lList = this.processPragmaItem(pParseString, lListItem, lInnerList);
                if (lList != null && lList != lInnerList && lList != pList) {
                    this.message(4, "\n add list " + lList.getIndex() + " to list " + pList.getIndex());
                    lInnerList.add(lList);
                    lList = null;
                }
                lExpectComma = true;
            }
            pList.add(lInnerList);
        } else if (pNextItem != ")") {
            int lKind = pParseString.getTokenKind();
            if (lKind == 1) {
                Sym lSym = ((SymImpl)this.sym).symRoot.symTableCurrent.search(pNextItem);
                if (lSym != null) {
                    this.message(4, " add " + lSym);
                    pList.add(lSym);
                } else {
                    this.message(4, " unknown name " + pNextItem);
                    pList.add(pNextItem);
                }
            } else if (lKind == 3) {
                long lValue = Long.parseLong(pNextItem, 10);
                IntConst lConst = lValue <= Integer.MAX_VALUE ? this.sym.intConst(pNextItem, ((SymImpl)this.sym).symRoot.typeInt) : this.sym.intConst(pNextItem, ((SymImpl)this.sym).symRoot.typeLong);
                this.message(4, " add " + lConst);
                pList.add(lConst);
            } else {
                StringConst lConst = this.sym.stringConst(pNextItem);
                this.message(4, " add " + lConst);
                pList.add(lConst);
            }
        }
        this.message(5, " pList " + pList + " size " + pList.size());
        return pList;
    }
}

