/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.SideEffectBuffer;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirCast;
import coins.casttohir.ToHirSym;
import coins.casttohir.ToHirVisit;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.ElemNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.Elem;
import coins.sym.PointerType;
import coins.sym.Type;
import java.util.ListIterator;

public class ToHirBase
extends ToHirVisit {
    private final ToHirSym toSym;
    private final ToHirCast toCast;
    private final SideEffectBuffer buffer;
    private final Type integralOffset;
    private ToHirBase child;

    public ToHirBase(ToHir tohir) {
        super(tohir);
        this.message(1, "ToHirBase\n");
        this.toSym = new ToHirSym(tohir);
        this.toCast = new ToHirCast(tohir);
        this.buffer = new SideEffectBuffer(tohir);
        long offsetsize = tohir.symRoot.typeOffset.getSizeValue();
        Type type = tohir.symRoot.typeInt.getSizeValue() == offsetsize ? tohir.symRoot.typeInt : (tohir.symRoot.typeChar.getSizeValue() == offsetsize ? tohir.symRoot.typeChar : (tohir.symRoot.typeShort.getSizeValue() == offsetsize ? tohir.symRoot.typeShort : (tohir.symRoot.typeLong.getSizeValue() == offsetsize ? tohir.symRoot.typeLong : (this.integralOffset = tohir.symRoot.typeLongLong.getSizeValue() == offsetsize ? tohir.symRoot.typeLongLong : null))));
        if (this.integralOffset == null) {
            tohir.error("There is no integral type which matches to the offset type");
        }
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "B1", mes);
    }

    private ToHirBase sureChild() {
        if (this.child == null) {
            this.child = new ToHirBase(this.toHir);
        }
        return this.child;
    }

    protected void atIf(IfStmt s) {
        this.visitStmt(s.getThenPart());
        this.visitStmt(s.getElsePart());
        this.visitExpAsIfCondition(s);
        this.buffer.addToStmtPrev(s, false);
    }

    protected void atWhile(LoopStmt s) {
        this.visitStmt(s.getLoopBodyPart());
        Exp cond = s.getLoopStartCondition();
        if (cond != null) {
            switch (cond.getOperator()) {
                case 77: 
                case 78: {
                    s.setLoopStartCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addFirstStmt(ifstmt);
                    this.atIf(ifstmt);
                    break;
                }
                default: {
                    cond = this.visitExp(cond);
                    if (this.buffer.isEmpty()) {
                        s.setLoopStartCondition(cond);
                        break;
                    }
                    s.setLoopStartCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addFirstStmt(ifstmt);
                    this.buffer.addToStmtPrev(ifstmt, false);
                }
            }
        }
    }

    protected void atFor(LoopStmt s) {
        this.visitStmt(s.getLoopInitPart());
        this.visitStmt(s.getLoopBodyPart());
        this.visitStmt(s.getLoopStepPart());
        Exp cond = s.getLoopStartCondition();
        if (cond != null) {
            switch (cond.getOperator()) {
                case 77: 
                case 78: {
                    s.setLoopStartCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addFirstStmt(ifstmt);
                    this.atIf(ifstmt);
                    break;
                }
                default: {
                    cond = this.visitExp(cond);
                    if (this.buffer.isEmpty()) {
                        s.setLoopStartCondition(cond);
                        break;
                    }
                    s.setLoopStartCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addFirstStmt(ifstmt);
                    this.buffer.addToStmtPrev(ifstmt, false);
                }
            }
        }
    }

    protected void atUntil(LoopStmt s) {
        this.visitStmt(s.getLoopBodyPart());
        Exp cond = s.getLoopEndCondition();
        if (cond != null) {
            switch (cond.getOperator()) {
                case 77: 
                case 78: {
                    s.setLoopEndCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addLastStmt(ifstmt);
                    this.atIf(ifstmt);
                    break;
                }
                default: {
                    cond = this.visitExp(cond);
                    if (this.buffer.isEmpty()) {
                        s.setLoopEndCondition(cond);
                        break;
                    }
                    s.setLoopEndCondition(this.toHir.newTrueNode());
                    IfStmt ifstmt = this.toHir.newIfStmt(cond, null, this.hir.jumpStmt(s.getLoopEndLabel()));
                    this.buffer.getBlockStmt(s.getLoopBodyPart()).addLastStmt(ifstmt);
                    this.buffer.addToStmtPrev(ifstmt, false);
                }
            }
        }
    }

    protected void atSwitch(SwitchStmt s) {
        this.visitStmt(s.getBodyStmt());
        s.setSelectionExp(this.toCast.iPromotion(this.visitExpAsSequencePoint(s.getSelectionExp())));
        this.buffer.addToStmtPrev(s, false);
    }

    protected void atReturn(ReturnStmt s) {
        if (s.getReturnValue() != null) {
            Exp e1 = this.visitExpAsSequencePoint(s.getReturnValue());
            s.setReturnValue(e1);
            s.setType(e1.getType());
        }
        this.buffer.addToStmtPrev(s, false);
    }

    protected void atExpStmt(ExpStmt s) {
        this.visitExpAsExpStmt(s.getExp());
        this.buffer.addToStmtPrev(s, false);
        s.deleteThisStmt();
    }

    protected void atSetDataStmt(SetDataStmt s) {
        if (this.fDbgLevel >= 4) {
            this.toHir.debug.print(4, "atSetData " + s.toString());
        }
        s.getRightSide().fold();
        Exp lRightSideOld = s.getRightSide();
        Exp lRightSideNew = this.visitExp(lRightSideOld);
        if (lRightSideNew != lRightSideOld) {
            s.setRightSide(lRightSideNew);
        }
    }

    protected Exp visitExpAsSequencePoint(Exp e) {
        Exp visitedexp = this.visitExp(e);
        if (!this.buffer.isEmptyNext()) {
            VarNode tempvar = this.toHir.newTempVarNode(visitedexp.getType());
            this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tempvar.copyWithOperands(), visitedexp));
            this.buffer.moveNextToPrev();
            return tempvar;
        }
        return visitedexp;
    }

    protected void visitExpAsExpStmt(Exp e) {
        e.setParent(null);
        Exp visitedexp = this.visitExp(e);
        if (visitedexp != null) {
            this.buffer.addPrev(this.toHir.newExpStmt(visitedexp));
        }
        this.buffer.moveNextToPrev();
    }

    private void visitExpAsIfCondition(IfStmt s1) {
        Exp cond1 = s1.getIfCondition();
        LabeledStmt then1 = s1.getThenPart();
        LabeledStmt else1 = s1.getElsePart();
        this.sureChild();
        switch (cond1.getOperator()) {
            case 77: {
                IfStmt s2 = this.toHir.newIfStmt(cond1.getExp2(), null, null);
                if (then1 != null && then1.getStmt() != null) {
                    s1.replaceThenPart(s2.getThenPart());
                    s2.replaceThenPart(then1);
                }
                if (else1 != null && else1.getStmt() != null) {
                    s2.getElsePart().setStmt(this.hir.jumpStmt(else1.getLabel()));
                }
                this.child.visitExpAsIfCondition(s2);
                this.child.buffer.addPrev(s2);
                s1.getThenPart().setStmt(this.child.buffer.toStmt());
                s1.setIfCondition(cond1.getExp1());
                this.visitExpAsIfCondition(s1);
                return;
            }
            case 78: {
                IfStmt s2 = this.toHir.newIfStmt(cond1.getExp2(), null, null);
                if (then1 != null && then1.getStmt() != null) {
                    s2.getThenPart().setStmt(this.hir.jumpStmt(then1.getLabel()));
                }
                if (else1 != null && else1.getStmt() != null) {
                    s1.replaceElsePart(s2.getElsePart());
                    s2.replaceElsePart(else1);
                }
                this.child.visitExpAsIfCondition(s2);
                this.child.buffer.addPrev(s2);
                s1.getElsePart().setStmt(this.child.buffer.toStmt());
                s1.setIfCondition(cond1.getExp1());
                this.visitExpAsIfCondition(s1);
                return;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                s1.setIfCondition(this.child.visitExp(cond1));
                this.buffer.add(this.child.buffer);
                return;
            }
            case 5: {
                return;
            }
        }
        this.toHir.fatal("visitExpAsIfCondition");
    }

    protected Exp atSubs(Exp e) {
        super.atSubs(e);
        e.setChild2(this.toCast.cast(this.integralOffset, e.getExp2()));
        return e;
    }

    protected Exp atCall(FunctionExp e) {
        e.setFunctionSpec(this.visitExp(e.getFunctionSpec()));
        this.sureChild();
        IrList actuallist = e.getParamList();
        ListIterator actualiter = actuallist.iterator();
        while (actualiter.hasNext()) {
            Exp actualexp = (Exp)actualiter.next();
            Exp newexp = this.child.visitExpAsSequencePoint(actualexp);
            if (newexp == actualexp) continue;
            actualiter.set(newexp);
            newexp.setParent(actuallist);
        }
        if (!this.child.buffer.isEmpty()) {
            this.buffer.add(this.child.buffer);
            Exp lvalue = this.getLvalueNode(e, e.getType());
            if (lvalue != null) {
                this.buffer.addPrev(this.toHir.newAssignStmt((Exp)lvalue.copyWithOperands(), e));
                return lvalue;
            }
        }
        return e;
    }

    protected Exp atAdd(Exp e) {
        if (this.fDbgLevel >= 4) {
            this.toHir.debug.print(4, "atAdd " + e.toString());
        }
        super.atAdd(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        if (t1.getTypeKind() == 22 && this.toHir.isIntegral(t2)) {
            if (this.fDbgLevel >= 4) {
                this.toHir.debug.print(4, " pointer addition " + e1.toString() + " " + e2.toString());
            }
            Type ptd = ((PointerType)t1).getPointedType();
            e.setChild2(this.hir.exp(41, (Exp)ptd.getSizeExp().copyWithOperands(), this.hir.convExp(this.integralOffset, e2)));
            e.setFlag(2, false);
        } else {
            Type t = e.getType();
            e.setChildren(this.toCast.cast(t, e1), this.toCast.cast(t, e2));
        }
        return e;
    }

    protected Exp atSub(Exp e) {
        return this.atAdd(e);
    }

    protected Exp atMul(Exp e) {
        super.atMul(e);
        Type t = e.getType();
        Exp e1 = this.toCast.cast(t, e.getExp1());
        Exp e2 = this.toCast.cast(t.getTypeKind() == 14 ? this.integralOffset : t, e.getExp2());
        e.setChildren(e1, e2);
        return e;
    }

    protected Exp atDiv(Exp e) {
        return this.atMul(e);
    }

    protected Exp atMod(Exp e) {
        return this.atMul(e);
    }

    protected Exp atAnd(Exp e) {
        return this.atMul(e);
    }

    protected Exp atOr(Exp e) {
        return this.atMul(e);
    }

    protected Exp atXor(Exp e) {
        return this.atMul(e);
    }

    protected Exp atCmpEq(Exp e) {
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        Type t = this.toCast.getCompareType(e1.getType(), e2.getType());
        e.setChild1(this.toCast.cast(t, this.visitExpAsSequencePoint(e1)));
        e.setChild2(this.toCast.cast(t, this.visitExpAsSequencePoint(e2)));
        return e;
    }

    protected Exp atCmpNe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpGt(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpGe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpLt(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpLe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atLShift(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Exp e2 = this.visitExp(e.getExp2());
        e.setChildren(this.toCast.iPromotion(e1), this.toCast.iPromotion(e2));
        return e;
    }

    protected Exp atRShift(Exp e) {
        Exp e1 = this.toCast.iPromotion(this.visitExp(e.getExp1()));
        Exp e2 = this.toCast.iPromotion(this.visitExp(e.getExp2()));
        if (!e1.getType().isUnsigned()) {
            e = this.hir.exp(59, e1, e2);
        } else {
            e.setChildren(e1, e2);
        }
        return e;
    }

    protected Exp atNot(Exp e) {
        super.atNot(e);
        e.setChild1(this.toCast.iPromotion(e.getExp1()));
        return e;
    }

    protected Exp atNeg(Exp e) {
        super.atNeg(e);
        e.setChild1(this.toCast.iPromotion(e.getExp1()));
        return e;
    }

    protected Exp atAssign(Exp e) {
        super.atAssign(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        Type t1 = e1.getType();
        e.setType(t1);
        if (e2 == e1 || e2 == null) {
            return e.getParent() != null ? e1 : null;
        }
        Exp e2tmp = this.toCast.assignCast(t1, e2);
        if (e2tmp == null) {
            this.toHir.error("invalid assignment from '" + e2.getType() + "' to '" + t1 + "'");
            return e;
        }
        e2 = e2tmp;
        if (e.getParent() == null) {
            this.buffer.addPrev(this.toHir.newAssignStmt(e1, e2));
            return null;
        }
        switch (e1.getOperator()) {
            case 7: 
            case 8: {
                this.buffer.addPrev(this.toHir.newAssignStmt((Exp)e1.copyWithOperands(), e2));
                return e1;
            }
        }
        switch (e2.getOperator()) {
            case 5: 
            case 7: 
            case 8: {
                this.buffer.addPrev(this.toHir.newAssignStmt(e1, (Exp)e2.copyWithOperands()));
                return e2;
            }
        }
        VarNode tempvar = this.toHir.newTempVarNode(t1);
        this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tempvar.copyWithOperands(), e2));
        this.buffer.addPrev(this.toHir.newAssignStmt(e1, (Exp)tempvar.copyWithOperands()));
        return tempvar;
    }

    protected Exp atOffset(Exp e) {
        super.atOffset(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        Type t1 = e1.getType();
        Type ptd1 = ((PointerType)t1).getPointedType();
        Exp offset = this.hir.exp(39, e1, e2);
        offset.setType(this.toHir.symRoot.typeOffset);
        Exp ptrsize = (Exp)ptd1.getSizeExp().copyWithOperands();
        ptrsize.setType(this.toHir.symRoot.typeOffset);
        e = this.hir.exp(42, offset, ptrsize);
        e.setType(this.toHir.symRoot.typeInt);
        return e;
    }

    protected Exp atLgAnd(Exp e) {
        e.getParent().print(10);
        this.toHir.fatal("atLgAnd");
        return e;
    }

    protected Exp atLgOr(Exp e) {
        return this.atLgAnd(e);
    }

    protected Exp atSelect(Exp e) {
        Stmt elsestmt;
        Stmt thenstmt;
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        Exp e3 = (Exp)e.getChild(3);
        this.sureChild();
        Exp lvalue = this.getLvalueNode(e, e.getType());
        if (lvalue == null) {
            this.child.visitExpAsExpStmt(e2);
            thenstmt = this.child.buffer.toStmt();
            this.child.visitExpAsExpStmt(e3);
            elsestmt = this.child.buffer.toStmt();
        } else {
            this.child.visitExpAsExpStmt(this.hir.exp(22, (Exp)lvalue.copyWithOperands(), e2));
            thenstmt = this.child.buffer.toStmt();
            this.child.visitExpAsExpStmt(this.hir.exp(22, (Exp)lvalue.copyWithOperands(), e3));
            elsestmt = this.child.buffer.toStmt();
        }
        IfStmt ifstmt = this.toHir.newIfStmt(e1, thenstmt, elsestmt);
        this.visitExpAsIfCondition(ifstmt);
        this.buffer.addPrev(ifstmt);
        return lvalue;
    }

    protected Exp atComma(Exp e) {
        Exp e1 = e.getExp1();
        this.sureChild();
        this.child.visitExpAsExpStmt(e1);
        this.buffer.add(this.child.buffer);
        Exp e2 = e.getExp2();
        e2.setParent(e.getParent());
        return this.visitExp(e2);
    }

    protected Exp atPre(int op, Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        this.buffer.addPrev(this.newOpAssignStmt(op, e1, this.toHir.new1Node()));
        return e.getParent() != null ? e1 : null;
    }

    protected Exp atPost(int op, Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        this.buffer.addNext(this.newOpAssignStmt(op, e1, this.toHir.new1Node()));
        return e.getParent() != null ? e1 : null;
    }

    private Exp atOpAssign(int op, Exp e) {
        Exp e1 = this.getLittleOverheadLvalueNode(this.visitExp(e.getExp1()));
        Exp e2 = this.visitExp(e.getExp2());
        this.buffer.addPrev(this.newOpAssignStmt(op, e1, e2));
        return e.getParent() != null ? e1 : null;
    }

    protected Exp atAddAssign(Exp e) {
        return this.atOpAssign(38, e);
    }

    protected Exp atSubAssign(Exp e) {
        return this.atOpAssign(39, e);
    }

    protected Exp atMulAssign(Exp e) {
        return this.atOpAssign(41, e);
    }

    protected Exp atDivAssign(Exp e) {
        return this.atOpAssign(42, e);
    }

    protected Exp atModAssign(Exp e) {
        return this.atOpAssign(43, e);
    }

    protected Exp atLShiftAssign(Exp e) {
        return this.atOpAssign(58, e);
    }

    protected Exp atRShiftAssign(Exp e) {
        if (e.getExp1().getType().isUnsigned()) {
            return this.atOpAssign(60, e);
        }
        return this.atOpAssign(59, e);
    }

    protected Exp atAndAssign(Exp e) {
        return this.atOpAssign(46, e);
    }

    protected Exp atOrAssign(Exp e) {
        return this.atOpAssign(47, e);
    }

    protected Exp atXorAssign(Exp e) {
        return this.atOpAssign(48, e);
    }

    private Exp getLvalueNode(Exp e, Type t) {
        IR parent = e.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getOperator() == 22) {
            Exp e1 = ((Exp)parent).getExp1();
            e1 = this.getLittleOverheadLvalueNode(e1);
            ((HIR)parent).setChild1(e1);
            return e1;
        }
        return this.toHir.newTempVarNode(t);
    }

    private Exp getLittleOverheadLvalueNode(Exp e) {
        switch (e.getOperator()) {
            case 7: 
            case 8: {
                return e;
            }
            case 68: {
                Exp e1 = e.getExp1();
                switch (e1.getOperator()) {
                    case 7: 
                    case 8: {
                        return e;
                    }
                }
                VarNode tmpvar = this.toHir.newTempVarNode(e1.getType());
                this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tmpvar.copyWithOperands(), e1));
                return this.hir.contentsExp(tmpvar);
            }
            case 19: {
                Exp e1 = e.getExp1();
                Elem elem = e.getExp2().getElem();
                if (!elem.isBitField()) break;
                switch (e1.getOperator()) {
                    case 7: 
                    case 8: {
                        return e;
                    }
                }
                VarNode tmpvar = this.toHir.newTempVarNode(this.sym.pointerType(e1.getType()));
                this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tmpvar.copyWithOperands(), this.toHir.addrExp(e1)));
                return this.hir.pointedExp(tmpvar, (ElemNode)e.getExp2());
            }
            case 20: {
                Exp e1 = e.getExp1();
                Elem elem = e.getExp2().getElem();
                if (!elem.isBitField()) break;
                switch (e1.getOperator()) {
                    case 7: 
                    case 8: {
                        return e;
                    }
                }
                VarNode tmpvar = this.toHir.newTempVarNode(e1.getType());
                this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tmpvar.copyWithOperands(), e1));
                return this.hir.pointedExp(tmpvar, (ElemNode)e.getExp2());
            }
        }
        VarNode tmpvar = this.toHir.newTempVarNode(this.sym.pointerType(e.getType()));
        this.buffer.addPrev(this.toHir.newAssignStmt((Exp)tmpvar.copyWithOperands(), this.toHir.addrExp(e)));
        return this.hir.contentsExp(tmpvar);
    }

    private Stmt newOpAssignStmt(int op, Exp e1, Exp e2) {
        Exp opexp;
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        if (t1.getTypeKind() != 22) {
            Type uactype = this.toCast.getUacType(t1, t2);
            opexp = this.hir.exp(op, this.toCast.cast(uactype, (Exp)e1.copyWithOperands()), this.toCast.cast(uactype, e2));
        } else {
            Type pointedtype = ((PointerType)t1).getPointedType();
            opexp = this.hir.exp(op, (Exp)e1.copyWithOperands(), this.hir.exp(41, (Exp)pointedtype.getSizeExp().copyWithOperands(), this.hir.convExp(this.toHir.symRoot.typeOffset, e2)));
        }
        return this.toHir.newAssignStmt((Exp)e1.copyWithOperands(), this.toCast.assignCast(t1, opexp));
    }
}

