/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ToHir;
import coins.ir.IR;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import java.util.LinkedList;
import java.util.ListIterator;

public class SideEffectBuffer {
    private ToHir toHir;
    private LinkedList prevList;
    private LinkedList nextList;

    SideEffectBuffer(ToHir tohir) {
        this.toHir = tohir;
        this.prevList = new LinkedList();
        this.nextList = new LinkedList();
    }

    boolean isEmpty() {
        return this.prevList.isEmpty() && this.nextList.isEmpty();
    }

    boolean isEmptyPrev() {
        return this.prevList.isEmpty();
    }

    boolean isEmptyNext() {
        return this.nextList.isEmpty();
    }

    SideEffectBuffer addPrev(HIR s) {
        this.prevList.addLast(s);
        return this;
    }

    SideEffectBuffer addNext(HIR s) {
        this.nextList.addFirst(s);
        return this;
    }

    void add(SideEffectBuffer child) {
        this.prevList.addAll(child.prevList);
        this.nextList.addAll(0, child.nextList);
        child.prevList.clear();
        child.nextList.clear();
    }

    void addPrev(SideEffectBuffer child) {
        this.prevList.addAll(child.prevList);
        this.prevList.addAll(child.nextList);
        child.prevList.clear();
        child.nextList.clear();
    }

    void addNext(SideEffectBuffer child) {
        this.nextList.addAll(0, child.nextList);
        this.nextList.addAll(0, child.prevList);
        child.prevList.clear();
        child.nextList.clear();
    }

    void moveNextToPrev() {
        this.prevList.addAll(this.nextList);
        this.nextList.clear();
    }

    Stmt toStmt() {
        this.prevList.addAll(this.nextList);
        this.nextList.clear();
        switch (this.prevList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Stmt)this.prevList.removeFirst();
            }
        }
        BlockStmt block = this.toHir.newBlockStmt(null);
        while (this.prevList.size() != 0) {
            block.addLastStmt((Stmt)this.prevList.removeFirst());
        }
        return block;
    }

    Exp toExp(Exp e) {
        if (this.prevList.size() == 0) {
            return e;
        }
        Exp comma = (Exp)this.prevList.removeFirst();
        while (this.prevList.size() != 0) {
            comma = this.toHir.hir.exp(80, comma, (Exp)this.prevList.removeFirst());
        }
        return this.toHir.hir.exp(80, comma, e);
    }

    final void addToStmtPrev(Stmt s, boolean reserve) {
        if (this.prevList.size() != 0) {
            Stmt insertpoint = this.getInsertPoint(s);
            ListIterator i = this.prevList.listIterator();
            while (i.hasNext()) {
                Stmt stmt;
                Object object = i.next();
                if (object instanceof Stmt) {
                    stmt = (Stmt)object;
                } else if (object instanceof Exp) {
                    stmt = this.toHir.newExpStmt((Exp)object);
                } else {
                    this.toHir.fatal("addToStmtPrev");
                    return;
                }
                if (reserve) {
                    stmt = (Stmt)stmt.copyWithOperands();
                } else {
                    i.remove();
                }
                insertpoint.insertPreviousStmt(stmt, null);
            }
        }
    }

    final void addToStmtNext(Stmt s, boolean reserve) {
        if (this.nextList.size() != 0) {
            Stmt insertpoint = this.getInsertPoint(s);
            ListIterator i = this.nextList.listIterator(this.nextList.size());
            while (i.hasPrevious()) {
                Stmt stmt = (Stmt)i.previous();
                if (reserve) {
                    stmt = (Stmt)stmt.copyWithOperands();
                } else {
                    i.remove();
                }
                insertpoint.addNextStmt(stmt);
            }
        }
    }

    private Stmt getInsertPoint(Stmt s) {
        IR parent = s.getParent();
        if (parent != null) {
            if (parent.getOperator() == 35) {
                return s;
            }
            int childcount = parent.getChildCount();
            for (int i = 1; i <= childcount; ++i) {
                if (parent.getChild(i) != s) continue;
                parent.setChild(i, this.toHir.newBlockStmt(s));
                return s;
            }
        }
        this.toHir.fatal("getInsertPoint  PARENT=" + parent + "  CHILD=" + s);
        return s;
    }

    final void addToBlockLast(Stmt s, boolean reserve) {
        if (this.prevList.size() != 0) {
            BlockStmt blockstmt = this.getBlockStmt(s);
            ListIterator i = this.prevList.listIterator();
            while (i.hasNext()) {
                Stmt stmt = (Stmt)i.next();
                if (reserve) {
                    stmt = (Stmt)stmt.copyWithOperands();
                } else {
                    i.remove();
                }
                blockstmt.addLastStmt(stmt);
            }
        }
    }

    final void addToBlockFirst(Stmt s, boolean reserve) {
        if (this.nextList.size() != 0) {
            BlockStmt blockstmt = this.getBlockStmt(s);
            ListIterator i = this.nextList.listIterator(this.nextList.size());
            while (i.hasPrevious()) {
                Stmt stmt = (Stmt)i.previous();
                if (reserve) {
                    stmt = (Stmt)stmt.copyWithOperands();
                } else {
                    i.remove();
                }
                blockstmt.addFirstStmt(stmt);
            }
        }
    }

    BlockStmt getBlockStmt(Stmt s) {
        switch (s.getOperator()) {
            case 35: {
                return (BlockStmt)s;
            }
            case 21: {
                Stmt labeledstmt = ((LabeledStmt)s).getStmt();
                if (labeledstmt == null || labeledstmt.getOperator() != 35) {
                    labeledstmt = this.toHir.newBlockStmt(labeledstmt);
                    ((LabeledStmt)s).setStmt(labeledstmt);
                }
                return (BlockStmt)labeledstmt;
            }
        }
        IR parent = s.getParent();
        if (parent != null) {
            int childcount = parent.getChildCount();
            for (int i = 1; i <= childcount; ++i) {
                if (parent.getChild(i) != s) continue;
                BlockStmt blockstmt = this.toHir.newBlockStmt(s);
                parent.setChild(i, blockstmt);
                return blockstmt;
            }
        }
        this.toHir.fatal("getBlockStmt  PARENT=" + parent + "  CHILD=" + s);
        return null;
    }
}

