/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.util.NumberSet;

public class VectorSet
implements NumberSet {
    private static final int MAXNUM = 65536;
    private short[] check;
    private short[] list;
    private int nelem;

    public VectorSet(int max) {
        if (max > 65536) {
            throw new Error("Too big");
        }
        this.nelem = 0;
        this.check = new short[max];
        this.list = new short[max];
    }

    public int size() {
        return this.nelem;
    }

    public void clear() {
        this.nelem = 0;
    }

    public void add(int x) {
        if (x < 0 || x >= this.check.length) {
            return;
        }
        if (this.check[x] < this.nelem && this.list[this.check[x]] == x) {
            return;
        }
        if (this.nelem >= this.list.length) {
            return;
        }
        this.list[this.nelem] = (short)x;
        this.check[x] = (short)this.nelem++;
    }

    public void addAll(NumberSet x) {
        x.addAllTo(this);
    }

    public void addAllTo(NumberSet x) {
        for (int i = 0; i < this.nelem; ++i) {
            x.add(this.list[i]);
        }
    }

    public void remove(int x) {
        if (x < 0 || x >= this.check.length) {
            return;
        }
        short p = this.check[x];
        if (p < this.nelem && this.list[p] == x) {
            this.list[p] = this.list[--this.nelem];
            this.check[this.list[p]] = p;
        }
    }

    public void removeAll(NumberSet x) {
        x.removeAllFrom(this);
    }

    public void removeAllFrom(NumberSet x) {
        for (int i = 0; i < this.nelem; ++i) {
            x.remove(this.list[i]);
        }
    }

    public boolean contains(int x) {
        if (x < 0 || x >= this.check.length) {
            return false;
        }
        short p = this.check[x];
        return p < this.nelem && this.list[p] == x;
    }

    public NumberSet.Iterator iterator() {
        return new Iterator(this);
    }

    public void toArray(int[] a) {
        int j = 0;
        for (int i = 0; i < this.nelem; ++i) {
            a[j++] = this.list[i];
        }
    }

    public void copy(NumberSet x) {
        this.clear();
        this.addAll(x);
    }

    public boolean equals(Object x) {
        if (!(x instanceof VectorSet)) {
            return false;
        }
        VectorSet v = (VectorSet)x;
        if (v.nelem != this.nelem) {
            return false;
        }
        for (int i = 0; i < this.nelem; ++i) {
            if (v.contains(this.list[i])) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this;
    }

    public static class Iterator
    implements NumberSet.Iterator {
        VectorSet set;
        int ptr;

        public Iterator(VectorSet x) {
            this.set = x;
            this.ptr = this.set.nelem;
        }

        public boolean hasNext() {
            return this.ptr > 0;
        }

        public int next() {
            if (this.ptr > 0) {
                return this.set.list[--this.ptr];
            }
            return -1;
        }
    }
}

