/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.SyntaxError;
import coins.backend.util.QuotedString;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;

public class ImList {
    private Object elem;
    private ImList next;
    public static final ImList Empty = new ImList(null, null);

    public ImList(Object content, ImList tail) {
        this.elem = content;
        this.next = tail;
    }

    public ImList(Object content) {
        this.elem = content;
        this.next = Empty;
    }

    public static ImList list() {
        return Empty;
    }

    public static ImList list(Object obj) {
        return new ImList(obj);
    }

    public static ImList list(Object obj1, Object obj2) {
        return new ImList(obj1, new ImList(obj2));
    }

    public static ImList list(Object obj1, Object obj2, Object obj3) {
        return new ImList(obj1, new ImList(obj2, new ImList(obj3)));
    }

    public static ImList list(Object obj1, Object obj2, Object obj3, Object obj4) {
        return new ImList(obj1, new ImList(obj2, new ImList(obj3, new ImList(obj4))));
    }

    public static ImList list(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        return new ImList(obj1, new ImList(obj2, new ImList(obj3, new ImList(obj4, new ImList(obj5)))));
    }

    public static ImList list(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        return new ImList(obj1, new ImList(obj2, new ImList(obj3, new ImList(obj4, new ImList(obj5, new ImList(obj6))))));
    }

    public ImList next() {
        return this.next;
    }

    public ImList next2nd() {
        return this.next.next;
    }

    public ImList next3rd() {
        return this.next.next.next;
    }

    public Object elem() {
        return this.elem;
    }

    public Object elem2nd() {
        return this.next.elem;
    }

    public Object elem3rd() {
        return this.next.next.elem;
    }

    public Object elem4th() {
        return this.next.next.next.elem;
    }

    public Object elem5th() {
        return this.next.next.next.next.elem;
    }

    public Object elem6th() {
        return this.next.next.next.next.next.elem;
    }

    public Object lastElem() {
        Object obj = null;
        ImList p = this;
        while (!p.atEnd()) {
            obj = p.elem();
            p = p.next();
        }
        return obj;
    }

    public ImList next(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ImList p = this;
        while (!p.atEnd() && n-- != 0) {
            p = p.next();
        }
        return p;
    }

    public Object elem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ImList p = this;
        while (!p.atEnd()) {
            if (n-- == 0) {
                return p.elem();
            }
            p = p.next();
        }
        return null;
    }

    public boolean atEnd() {
        return this == Empty;
    }

    public boolean isEmpty() {
        return this == Empty;
    }

    public ImList append(ImList addendum) {
        if (addendum == Empty) {
            return this;
        }
        if (this == Empty) {
            return addendum;
        }
        return new ImList(this.elem, this.next.append(addendum));
    }

    public int length() {
        int n = 0;
        ImList p = this;
        while (p != Empty) {
            ++n;
            p = p.next;
        }
        return n;
    }

    public ImList locate(Object obj) {
        ImList p = this;
        while (!p.atEnd()) {
            if (p.elem == obj) {
                return p;
            }
            p = p.next();
        }
        return null;
    }

    public ImList makeCopy() {
        ImList list = Empty;
        ImList p = this;
        while (!p.atEnd()) {
            list = new ImList(p.elem, list);
            p = p.next();
        }
        return list.destructiveReverse();
    }

    public ImList scanOpt() {
        ImList list = this;
        while (!(list.atEnd() || list.elem instanceof String && ((String)list.elem).charAt(0) == '&')) {
            list = list.next();
        }
        return list;
    }

    public ImList destructiveReverse() {
        ImList p = this;
        ImList q = Empty;
        while (p != Empty) {
            ImList w = p.next;
            p.next = q;
            q = p;
            p = w;
        }
        return q;
    }

    public ImList destructiveReverse(ImList tail) {
        ImList p = this;
        ImList q = tail;
        while (p != Empty) {
            ImList w = p.next;
            p.next = q;
            q = p;
            p = w;
        }
        return q;
    }

    public static Object readSexp(Reader rdr) throws IOException, SyntaxError {
        return ImList.readSexp(new PushbackReader(rdr));
    }

    public static Object readSexp(PushbackReader prd) throws IOException, SyntaxError {
        StringBuffer buf;
        block20: {
            int c = ImList.skipSpaces(prd);
            if (c < 0) {
                return null;
            }
            if (c == 39) {
                return new ImList("'", new ImList(ImList.readSexp(prd), Empty));
            }
            if (c == 96) {
                return new ImList("`", new ImList(ImList.readSexp(prd), Empty));
            }
            if (c == 44) {
                return new ImList(",", new ImList(ImList.readSexp(prd), Empty));
            }
            if (c == 40) {
                ImList ptr = Empty;
                while (true) {
                    if ((c = ImList.skipSpaces(prd)) < 0) {
                        throw new SyntaxError("Unexpected EOF");
                    }
                    if (c == 41) break;
                    prd.unread(c);
                    ptr = new ImList(ImList.readSexp(prd), ptr);
                }
                return ptr.destructiveReverse();
            }
            if (c == 41) {
                throw new SyntaxError("Invalid )");
            }
            if (c == 34) {
                StringBuffer buf2 = new StringBuffer();
                block8: while ((c = prd.read()) >= 0 && c != 34) {
                    if (c == 92) {
                        c = prd.read();
                        if (c < 0) break;
                        switch (c) {
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            default: {
                                if (48 > c || c > 55) break;
                                int val = 0;
                                for (int i = 0; i < 3 && 48 <= c && c <= 55; ++i) {
                                    val = val * 8 + c;
                                    c = prd.read();
                                }
                                if (c < 0) break block8;
                                prd.unread(c);
                            }
                        }
                    }
                    buf2.append((char)c);
                }
                return new QuotedString(buf2.toString());
            }
            buf = new StringBuffer();
            do {
                buf.append((char)c);
                c = prd.read();
                if (c < 0) break block20;
            } while (!Character.isWhitespace((char)c) && c != 41 && c != 40);
            prd.unread(c);
        }
        return buf.toString().intern();
    }

    /*
     * Unable to fully structure code
     */
    private static int skipSpaces(PushbackReader prd) throws IOException {
        block0: while (true) {
            if ((c = prd.read()) >= 0 && Character.isWhitespace((char)c)) {
                continue;
            }
            if (c != 59) {
                return c;
            }
            while (true) {
                if ((c = prd.read()) >= 0 && c != 10) ** break;
                continue block0;
            }
            break;
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof ImList)) {
            return false;
        }
        if (this == (ImList)x) {
            return true;
        }
        ImList p = this;
        ImList q = (ImList)x;
        while (p != Empty && q != Empty) {
            if (!p.elem.equals(q.elem)) {
                return false;
            }
            p = p.next;
            q = q.next;
        }
        return p == q;
    }

    public String toString() {
        return "(" + this.toStringWOParen() + ")";
    }

    public String toStringWOParen() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        ImList p = this;
        while (p != Empty) {
            if (!first) {
                buf.append(" ");
            }
            if (p.elem == null) {
                buf.append("<null>");
            } else {
                buf.append(p.elem.toString());
            }
            first = false;
            p = p.next;
        }
        return buf.toString();
    }

    public void printIt(PrintWriter writer) {
        new PrettyPrinter(writer).printIt(this);
    }

    public void printIt(PrintWriter writer, int width) {
        new PrettyPrinter(writer, width).printIt(this);
    }

    public void printIt(PrintWriter writer, int width, int indent) {
        new PrettyPrinter(writer, width, indent).printIt(this);
    }

    public static void printIt(PrintWriter writer, Object obj) {
        new PrettyPrinter(writer).printIt(obj);
    }

    public static void main(String[] args) {
        try {
            Object obj = ImList.readSexp(new InputStreamReader(System.in));
            System.out.println("Pretty Printer Output:");
            new PrettyPrinter(new PrintWriter(System.out)).printIt(obj);
        }
        catch (IOException e) {
            throw new Error("IOexception");
        }
        catch (SyntaxError e) {
            throw new Error("Syntax error");
        }
    }

    private static class PrettyPrinter {
        static final int DEFAULT_WIDTH = 80;
        private PrintWriter writer;
        private int width;
        private int col;
        private int step = 2;

        PrettyPrinter(PrintWriter writer) {
            this(writer, 80);
        }

        PrettyPrinter(PrintWriter writer, int width) {
            this.writer = writer;
            this.width = width;
            this.col = 0;
        }

        PrettyPrinter(PrintWriter writer, int width, int indent) {
            this.writer = writer;
            this.width = width;
            this.col = indent;
        }

        int lengthOf(Object obj) {
            return obj.toString().length();
        }

        void printSpace(PrintWriter writer, int n) {
            for (int i = 0; i < n; ++i) {
                writer.print(" ");
            }
        }

        void printIt(Object obj) {
            this.printItX(obj);
            this.writer.println();
            this.writer.flush();
        }

        void printItX(ImList list) {
            if (this.col + this.lengthOf(list) < this.width) {
                this.writer.print(list.toString());
                this.col += this.lengthOf(list);
                return;
            }
            this.writer.print("(");
            ++this.col;
            int topCol = this.col;
            boolean tol = true;
            boolean prelist = false;
            ImList p = list;
            while (!p.atEnd()) {
                Object obj = p.elem();
                if (!tol) {
                    if (prelist || obj instanceof ImList || this.col + 1 + this.lengthOf(obj) >= this.width) {
                        this.writer.println();
                        this.col = topCol + this.step;
                        this.printSpace(this.writer, this.col);
                    } else {
                        this.writer.print(" ");
                        ++this.col;
                    }
                }
                this.printItX(obj);
                prelist = obj instanceof ImList;
                tol = false;
                p = p.next();
            }
            this.writer.print(")");
            ++this.col;
        }

        void printItX(Object obj) {
            if (obj instanceof ImList) {
                this.printItX((ImList)obj);
            } else {
                String s = obj.toString();
                if (s.charAt(0) == '(') {
                    this.writer.print("!");
                }
                this.writer.print(s);
                this.col += s.length();
            }
        }
    }
}

