/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.tools;

import coins.backend.Op;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.tools.RegisterDescription2Java;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Tmd2Java {
    static final String PROTOFILE = "tmd.java.proto";
    static final int ANYTYPE = -1;
    static String targetName;
    static PrintWriter out;
    static BufferedReader proto;
    static boolean defFileOnly;
    static boolean printExpanded;
    static RegisterDescription2Java regDesc;
    static Map definitions;
    static Map macros;
    static RuleSet rewriting;
    static RuleSet instSel;
    static BiList javaMacros;
    static int emCounter;
    static BiList typeRegsetList;
    static final String STATE = "State";
    static final String CODEGENERATOR = "CodeGenerator";
    static final String DEFEMIT = "defemit";
    static final String DEFBUILD = "defbuild";
    static final String IMPORT = "import";
    static String usage;

    private Tmd2Java() {
    }

    static void printBeautifully(ImList list) {
        PrintWriter wrt = new PrintWriter(System.out);
        while (!list.atEnd()) {
            ImList.printIt(wrt, list.elem());
            list = list.next();
        }
    }

    static boolean isNumber(String s) {
        int i;
        int k = 0;
        int n = s.length();
        if (k < n && (s.charAt(0) == '-' || s.charAt(0) == '+')) {
            k = 1;
        }
        for (i = k; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return i > k;
    }

    static void doDefRule(ImList form) throws SyntaxError {
        instSel.addProd("rule", (String)form.elem2nd(), form.elem3rd(), form.next3rd());
    }

    static void doDefRewrite(ImList form) throws SyntaxError {
        rewriting.addProd("rewrite", "_rewr", form.elem2nd(), form.next2nd());
    }

    static void doDefPattern(ImList form) throws SyntaxError {
        rewriting.addProd("pattern", (String)form.elem2nd(), form.elem3rd(), form.next3rd());
    }

    static String expandDefMacro(String kind, PushbackReader rdr) throws SyntaxError, IOException {
        Object obj = ImList.readSexp(rdr);
        if (!(obj instanceof ImList)) {
            throw new SyntaxError("missing () after %" + kind);
        }
        ImList form = (ImList)obj;
        String name = (String)form.elem();
        JavaMacro em = new JavaMacro(kind, name, form.next());
        javaMacros.add(em);
        return em.methodHeader();
    }

    static ImList readSexpList(PushbackReader rdr, ImList tail) throws IOException, SyntaxError {
        Object obj;
        if (tail == null) {
            tail = ImList.Empty;
        }
        ImList list = ImList.Empty;
        while ((obj = ImList.readSexp(rdr)) != null && obj != "%%") {
            list = new ImList(obj, list);
        }
        return list.destructiveReverse(tail);
    }

    static Object replaceSubstr(Object x, String fv, Object val) throws SyntaxError {
        if (fv.charAt(0) != '@') {
            return x;
        }
        if (x instanceof String) {
            String str = (String)x;
            int at = str.indexOf(fv);
            if (at < 0) {
                return x;
            }
            return (str.substring(0, at) + val.toString() + str.substring(at + fv.length())).intern();
        }
        if (x instanceof QuotedString) {
            String str = ((QuotedString)x).body;
            int at = str.indexOf(fv);
            if (at < 0) {
                return x;
            }
            return new QuotedString(str.substring(0, at) + val.toString() + str.substring(at + fv.length()));
        }
        return x;
    }

    static ImList replaceList(ImList body, Object fv, Object val, ImList tail) throws SyntaxError {
        if (fv instanceof String) {
            return Tmd2Java.replaceList(body, ImList.list(fv), ImList.list(val), tail);
        }
        if (fv instanceof ImList) {
            if (((ImList)fv).length() != ((ImList)val).length()) {
                throw new SyntaxError("foreach parameter list unmatch");
            }
        } else {
            throw new SyntaxError("bad parameter list");
        }
        return Tmd2Java.replaceListAux(body, (ImList)fv, (ImList)val, tail);
    }

    static ImList replaceListAux(ImList body, ImList fpl, ImList apl, ImList tail) throws SyntaxError {
        if (body.atEnd()) {
            return tail;
        }
        tail = Tmd2Java.replaceListAux(body.next(), fpl, apl, tail);
        Object x = body.elem();
        if (x instanceof ImList) {
            x = Tmd2Java.replaceListAux((ImList)x, fpl, apl, ImList.Empty);
        } else {
            String fp;
            ImList p = fpl;
            ImList q = apl;
            while (!p.atEnd()) {
                fp = (String)p.elem();
                if (fp == x) {
                    return Tmd2Java.desugar(ImList.list(q.elem())).append(tail);
                }
                p = p.next();
                q = q.next();
            }
            p = fpl;
            q = apl;
            while (!p.atEnd()) {
                fp = (String)p.elem();
                if (fp.charAt(0) == '@') {
                    x = Tmd2Java.replaceSubstr(x, fp, q.elem());
                }
                p = p.next();
                q = q.next();
            }
        }
        return new ImList(x, tail);
    }

    static ImList replaceLoop(ImList body, Object cv, ImList vals) throws SyntaxError {
        if (vals.atEnd()) {
            return ImList.Empty;
        }
        return Tmd2Java.replaceList(body, cv, vals.elem(), Tmd2Java.replaceLoop(body, cv, vals.next()));
    }

    static ImList expandForeach(ImList sexp) throws SyntaxError {
        try {
            if (sexp.elem() != "foreach") {
                throw new Error("Can't happen");
            }
            if (!(sexp.elem3rd() instanceof ImList)) {
                throw new SyntaxError("values not list:");
            }
            return Tmd2Java.replaceLoop(sexp.next3rd(), sexp.elem2nd(), Tmd2Java.desugar((ImList)sexp.elem3rd()));
        }
        catch (SyntaxError e) {
            throw new SyntaxError(e.getMessage() + ": " + sexp);
        }
    }

    static ImList expandMacro(ImList form) throws SyntaxError {
        String name = (String)form.elem();
        ImList def = (ImList)macros.get(name);
        if (def == null) {
            throw new Error("?");
        }
        ImList formal = ((ImList)def.elem()).next();
        def = def.next();
        return Tmd2Java.replaceList(def, formal, form.next(), ImList.Empty);
    }

    static ImList expandIf(ImList form) throws SyntaxError {
        if (form.length() != 3 && form.length() != 4) {
            throw new SyntaxError("Bad @if");
        }
        if (Tmd2Java.evalCond(form.elem2nd())) {
            return (ImList)form.elem3rd();
        }
        if (form.length() < 4) {
            return ImList.Empty;
        }
        return (ImList)form.elem4th();
    }

    static boolean evalCond(Object x) throws SyntaxError {
        ImList xx = Tmd2Java.desugar(ImList.list(x));
        if (xx.isEmpty()) {
            return false;
        }
        if (xx.elem() == ImList.Empty) {
            return false;
        }
        return xx.elem() != "nil";
    }

    static ImList expandEq(ImList form) throws SyntaxError {
        if ((form = Tmd2Java.desugar(form)).length() != 3) {
            throw new SyntaxError("bad eq");
        }
        return ImList.list(form.elem2nd().equals(form.elem3rd()) ? "t" : "nil");
    }

    static ImList expandNe(ImList form) throws SyntaxError {
        if ((form = Tmd2Java.desugar(form)).length() != 3) {
            throw new SyntaxError("bad ne");
        }
        return ImList.list(form.elem2nd().equals(form.elem3rd()) ? "nil" : "t");
    }

    static ImList expandDefined(ImList form) throws SyntaxError {
        if ((form = Tmd2Java.desugar(form)).length() != 2) {
            throw new SyntaxError("bad defined");
        }
        return ImList.list(Tmd2Java.isMacro(form.elem2nd()) ? "t" : "nil");
    }

    static ImList expandNot(ImList form) throws SyntaxError {
        if (form.length() != 2) {
            throw new SyntaxError("bad not");
        }
        return ImList.list(Tmd2Java.evalCond(form.elem2nd()) ? "nil" : "t");
    }

    static boolean isMacro(Object name) {
        return macros.get(name) != null;
    }

    static void registerMacroDef(ImList form) throws SyntaxError {
        ImList cform;
        Object o = form.elem2nd();
        if (o instanceof ImList && (cform = (ImList)o).elem() instanceof String) {
            macros.put((String)cform.elem(), form.next());
            return;
        }
        throw new SyntaxError("bad formed defmacro: " + form);
    }

    static ImList expandInclude(ImList form, ImList tail) throws SyntaxError {
        if (form.length() != 2) {
            throw new SyntaxError("include: must have one and only one arg");
        }
        if (!(form.elem2nd() instanceof QuotedString)) {
            throw new SyntaxError("include: expecting quoted string ");
        }
        QuotedString file = (QuotedString)form.elem2nd();
        try {
            PushbackReader rdr = new PushbackReader(new FileReader(file.body));
            return Tmd2Java.readSexpList(rdr, tail);
        }
        catch (FileNotFoundException e) {
            throw new Error("include: file " + file + " not found");
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    static ImList desugar(ImList list) throws SyntaxError {
        ImList append = ImList.Empty;
        while (!list.atEnd()) {
            Object obj = list.elem();
            list = list.next();
            if (obj instanceof ImList) {
                ImList form = (ImList)obj;
                if (form.elem() == "foreach") {
                    list = Tmd2Java.expandForeach(form).append(list);
                    continue;
                }
                if (form.elem() == "defmacro") {
                    Tmd2Java.registerMacroDef(form);
                    continue;
                }
                if (form.elem() == "include") {
                    list = Tmd2Java.expandInclude(form, list);
                    continue;
                }
                if (form.elem() == "@if") {
                    list = Tmd2Java.expandIf(form).append(list);
                    continue;
                }
                if (form.elem() == "@eq") {
                    list = Tmd2Java.expandEq(form).append(list);
                    continue;
                }
                if (form.elem() == "@ne") {
                    list = Tmd2Java.expandNe(form).append(list);
                    continue;
                }
                if (form.elem() == "@not") {
                    list = Tmd2Java.expandNot(form).append(list);
                    continue;
                }
                if (form.elem() == "@defined") {
                    list = Tmd2Java.expandDefined(form).append(list);
                    continue;
                }
                if (Tmd2Java.isMacro(form.elem())) {
                    list = Tmd2Java.expandMacro(form).append(list);
                    continue;
                }
                append = new ImList(Tmd2Java.desugar(form), append);
                continue;
            }
            append = new ImList(obj, append);
        }
        return append.destructiveReverse();
    }

    static void doDef(ImList form) throws SyntaxError {
        if (form.elem2nd() instanceof String) {
            definitions.put((String)form.elem2nd(), form.elem3rd());
        }
        regDesc.doDef(form);
    }

    static void doDefStart(ImList form) throws SyntaxError {
        if (form.length() != 2 || !(form.elem2nd() instanceof String)) {
            throw new SyntaxError("Malformed defstart");
        }
        instSel.setStartSym((String)form.elem2nd());
    }

    static void doDefRegset(ImList form) throws SyntaxError {
        if ((form = form.next()).elem() instanceof ImList) {
            while (!form.atEnd()) {
                Tmd2Java.doDefRegsetPair((ImList)form.elem());
                form = form.next();
            }
        } else {
            Tmd2Java.doDefRegsetPair(form);
        }
    }

    static void doDefRegsetPair(ImList pair) throws SyntaxError {
        if (pair.length() != 2) {
            throw new SyntaxError("defregset: not a pair");
        }
        Nonterm reg = instSel.nonterm((String)pair.elem());
        reg.setDefaultRegset((String)pair.elem2nd());
    }

    static void doDefRegsetVar(ImList form) throws SyntaxError {
        if ((form = form.next()).elem() instanceof ImList) {
            while (!form.atEnd()) {
                Tmd2Java.doDefRegsetVarPair((ImList)form.elem());
                form = form.next();
            }
        } else {
            Tmd2Java.doDefRegsetVarPair(form);
        }
    }

    static void doDefRegsetVarPair(ImList pair) throws SyntaxError {
        if (pair.length() != 2) {
            throw new SyntaxError("defregsetvar: not a pair");
        }
        int type = Type.decode((String)pair.elem());
        typeRegsetList.add(ImList.list(new Integer(type), (String)pair.elem2nd()));
    }

    static boolean isVarOp(int op) {
        return op == 56 || op == 61;
    }

    static String readLine(PushbackReader rdr) throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = rdr.read()) >= 0 && ch != 10) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    static String readWhites(PushbackReader rdr) throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = rdr.read()) >= 0) {
            if (ch == 10 || !Character.isWhitespace((char)ch)) {
                rdr.unread(ch);
                break;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    static String readToken(PushbackReader rdr) throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = rdr.read()) >= 0) {
            if (!Character.isLetterOrDigit((char)ch)) {
                rdr.unread(ch);
                break;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    static void parseTmd(PushbackReader rdr) throws SyntaxError, IOException {
        String line;
        String mode;
        ImList stMethods;
        ImList cgMethods;
        ImList imports;
        ImList javaList;
        ImList list;
        block58: {
            String word;
            list = Tmd2Java.desugar(Tmd2Java.readSexpList(rdr, null));
            if (printExpanded) {
                Tmd2Java.printBeautifully(list);
            }
            javaList = ImList.Empty;
            imports = ImList.Empty;
            cgMethods = ImList.Empty;
            stMethods = ImList.Empty;
            mode = IMPORT;
            while (true) {
                String head;
                line = Tmd2Java.readWhites(rdr);
                int ch = rdr.read();
                if (ch < 0) break block58;
                if (ch != 37) {
                    rdr.unread(ch);
                    line = line + Tmd2Java.readLine(rdr);
                    javaList = new ImList(line, javaList);
                    continue;
                }
                word = Tmd2Java.readToken(rdr);
                if (word.equals(DEFEMIT)) {
                    head = Tmd2Java.expandDefMacro(DEFEMIT, rdr);
                    line = line + head + Tmd2Java.readLine(rdr);
                    javaList = new ImList(line, javaList);
                    continue;
                }
                if (word.equals(DEFBUILD)) {
                    head = Tmd2Java.expandDefMacro(DEFBUILD, rdr);
                    line = line + head + Tmd2Java.readLine(rdr);
                    javaList = new ImList(line, javaList);
                    continue;
                }
                Tmd2Java.readLine(rdr);
                if (mode == IMPORT) {
                    imports = javaList;
                } else if (mode == STATE) {
                    stMethods = javaList;
                } else if (mode == CODEGENERATOR) {
                    cgMethods = javaList;
                }
                if (word.equals(STATE)) {
                    mode = STATE;
                    javaList = stMethods;
                    continue;
                }
                if (!word.equals(CODEGENERATOR)) break;
                mode = CODEGENERATOR;
                javaList = cgMethods;
            }
            throw new SyntaxError("Unknown %" + word);
        }
        if (mode == IMPORT) {
            imports = javaList;
        } else if (mode == STATE) {
            stMethods = javaList;
        } else if (mode == CODEGENERATOR) {
            cgMethods = javaList;
        }
        imports = imports.destructiveReverse();
        stMethods = stMethods.destructiveReverse();
        cgMethods = cgMethods.destructiveReverse();
        while (!list.atEnd()) {
            block59: {
                Object obj = list.elem();
                try {
                    if (obj instanceof ImList) {
                        ImList form = (ImList)obj;
                        if (form.elem() == "def") {
                            Tmd2Java.doDef(form);
                            break block59;
                        }
                        if (defFileOnly) break block59;
                        if (form.elem() == "defstart") {
                            Tmd2Java.doDefStart(form);
                            break block59;
                        }
                        if (form.elem() == "defrule") {
                            Tmd2Java.doDefRule(form);
                            break block59;
                        }
                        if (form.elem() == "defregset") {
                            Tmd2Java.doDefRegset(form);
                            break block59;
                        }
                        if (form.elem() == "defregsetvar") {
                            Tmd2Java.doDefRegsetVar(form);
                            break block59;
                        }
                        if (form.elem() == "defrewrite") {
                            Tmd2Java.doDefRewrite(form);
                            break block59;
                        }
                        if (form.elem() == "defpattern") {
                            Tmd2Java.doDefPattern(form);
                            break block59;
                        }
                        throw new SyntaxError("unknown: " + form);
                    }
                    throw new SyntaxError("unknown: " + obj);
                }
                catch (SyntaxError e) {
                    throw new SyntaxError(e.getMessage() + " at: " + obj);
                }
            }
            list = list.next();
        }
        if (defFileOnly) {
            return;
        }
        if (instSel.startSym() == null) {
            instSel.setStartSym("void");
        }
        instSel.startSym().setUsed();
        instSel.checkGrammar();
        instSel.prepare();
        instSel.printProductions(out);
        rewriting.setStartSym("_rewr");
        rewriting.startSym().setUsed();
        rewriting.startSym().setDefined();
        rewriting.checkGrammar();
        rewriting.prepare();
        rewriting.printProductions(out);
        while ((line = proto.readLine()) != null) {
            JavaMacro em;
            JavaMacro em2;
            BiLink p;
            int n;
            for (n = 0; n < line.length() && Character.isWhitespace(line.charAt(n)); ++n) {
            }
            String indent = line.substring(0, n);
            String trim = line.substring(n);
            if (trim.startsWith("$decl")) {
                if (trim.substring(5).startsWith("-rewrite")) {
                    rewriting.genParameters(out, indent);
                    continue;
                }
                instSel.genParameters(out, indent);
                continue;
            }
            if (trim.startsWith("$tables")) {
                instSel.genRuleTable(out, indent, Tmd2Java.getPass(trim, 7));
                continue;
            }
            if (trim.startsWith("$chains")) {
                if (trim.substring(7).startsWith("-rewrite")) {
                    rewriting.genChainRuleAction(out, indent);
                    continue;
                }
                instSel.genChainRuleAction(out, indent);
                continue;
            }
            if (trim.startsWith("$rules")) {
                if (trim.substring(6).startsWith("-rewrite")) {
                    rewriting.genRuleAction(out, indent, Tmd2Java.getPass(trim, 13));
                    continue;
                }
                instSel.genRuleAction(out, indent, Tmd2Java.getPass(trim, 6));
                continue;
            }
            if (trim.startsWith("$regsettype")) {
                BiLink q = typeRegsetList.first();
                while (!q.atEnd()) {
                    ImList pair = (ImList)q.elem();
                    out.println(indent + "case " + pair.elem() + ": return " + "\"" + pair.elem2nd() + "\";");
                    q = q.next();
                }
                continue;
            }
            if (trim.startsWith("$import")) {
                ImList p2 = imports;
                while (!p2.atEnd()) {
                    out.println(indent + (String)p2.elem());
                    p2 = p2.next();
                }
                continue;
            }
            if (trim.startsWith("$state")) {
                ImList p3 = stMethods;
                while (!p3.atEnd()) {
                    out.println(indent + Tmd2Java.replaceDollars((String)p3.elem()));
                    p3 = p3.next();
                }
                continue;
            }
            if (trim.startsWith("$codegenerator")) {
                ImList p4 = cgMethods;
                while (!p4.atEnd()) {
                    out.println(indent + Tmd2Java.replaceDollars((String)p4.elem()));
                    p4 = p4.next();
                }
                continue;
            }
            if (trim.startsWith("$buildmac")) {
                boolean first = true;
                p = javaMacros.first();
                while (!p.atEnd()) {
                    em2 = (JavaMacro)p.elem();
                    if (em2.kind == DEFBUILD && !em2.forLirNode()) {
                        out.println(indent + (first ? "" : "else ") + "if (name == \"" + em2.name + "\")");
                        out.println(indent + "  return " + em2.invokeCode("form", null) + ";");
                        first = false;
                    }
                    p = p.next();
                }
                continue;
            }
            if (trim.startsWith("$buildlir")) {
                BiLink p5 = javaMacros.first();
                while (!p5.atEnd()) {
                    em = (JavaMacro)p5.elem();
                    if (em.kind == DEFBUILD && em.forLirNode()) {
                        out.println(indent + "case Op." + em.name + ":");
                        out.println(indent + "  return " + em.invokeCode("node", null) + ";");
                    }
                    p5 = p5.next();
                }
                continue;
            }
            if (trim.startsWith("$emitlist")) {
                boolean first = true;
                p = javaMacros.first();
                while (!p.atEnd()) {
                    em2 = (JavaMacro)p.elem();
                    if (em2.kind == DEFEMIT && !em2.forLirNode()) {
                        out.println(indent + (first ? "" : "else ") + "if (name == \"" + em2.name + "\")");
                        out.println(indent + "  return " + em2.invokeCode("form", null) + ";");
                        first = false;
                    }
                    p = p.next();
                }
                continue;
            }
            if (trim.startsWith("$emitlir")) {
                BiLink p6 = javaMacros.first();
                while (!p6.atEnd()) {
                    em = (JavaMacro)p6.elem();
                    if (em.kind == DEFEMIT && em.forLirNode()) {
                        out.println(indent + "case Op." + em.name + ":");
                        out.println(indent + "  return " + em.invokeCode("node", null) + ";");
                    }
                    p6 = p6.next();
                }
                continue;
            }
            out.println(Tmd2Java.replaceDollars(line));
        }
        out.flush();
    }

    private static int getPass(String s, int n) {
        if (s.length() < n) {
            return 0;
        }
        switch (s.charAt(n)) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
        }
        return 0;
    }

    static String quote(String x) {
        if (x == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int n = x.length();
        for (int i = 0; i < n; ++i) {
            if (x.charAt(i) == '\"') {
                buf.append('\\');
            }
            buf.append(x.charAt(i));
        }
        buf.append('\"');
        return buf.toString();
    }

    static int parseDollar(String x) throws SyntaxError {
        if (x.charAt(0) != '$') {
            throw new SyntaxError(x + ": $n expected");
        }
        return Integer.parseInt(x.substring(1));
    }

    static void listString1(StringBuffer buf, Object obj) {
        if (obj instanceof ImList) {
            ImList form = (ImList)obj;
            if (form.length() <= 5) {
                buf.append("ImList.list(");
                boolean first = true;
                ImList p = form;
                while (!p.atEnd()) {
                    if (!first) {
                        buf.append(",");
                    }
                    Tmd2Java.listString1(buf, p.elem());
                    first = false;
                    p = p.next();
                }
                buf.append(")");
            } else {
                buf.append("new ImList(");
                Tmd2Java.listString1(buf, form.elem());
                buf.append(", ");
                Tmd2Java.listString1(buf, form.next());
                buf.append(")");
            }
        } else if (obj instanceof QuotedString) {
            buf.append(obj.toString());
        } else if (obj instanceof String) {
            buf.append("\"" + obj + "\"");
        } else if (obj instanceof Integer) {
            buf.append("new Integer(" + obj + ")");
        } else {
            throw new Error("can't print list.");
        }
    }

    static String listString(Object obj) {
        if (obj == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        Tmd2Java.listString1(buf, obj);
        return buf.toString();
    }

    static String replaceDollars(String str) {
        StringBuffer buf = new StringBuffer();
        int ptr = 0;
        int pos = 0;
        while ((pos = str.indexOf("$", ptr)) >= 0) {
            Object value;
            String name;
            buf.append(str.substring(ptr, pos));
            if (str.substring(pos).startsWith("$target")) {
                ptr = pos + 7;
                buf.append(targetName);
                continue;
            }
            if (str.substring(pos).startsWith("$defined(")) {
                ptr = pos + 9;
                name = str.substring(ptr, pos = str.indexOf(")", ptr));
                value = definitions.get(name);
                if (value == null) {
                    value = macros.get(name);
                }
                buf.append(value != null ? "true" : "false");
                ptr = pos + 1;
                continue;
            }
            if (str.substring(pos).startsWith("$def(")) {
                ptr = pos + 5;
                name = str.substring(ptr, pos = str.indexOf(")", ptr));
                value = definitions.get(name);
                if (value == null) {
                    System.err.println("Symbol `" + name + "' undefined");
                }
                buf.append(Tmd2Java.listString(value));
                ptr = pos + 1;
                continue;
            }
            ptr = pos + 1;
            buf.append("$");
        }
        buf.append(str.substring(ptr));
        return buf.toString();
    }

    public static void main(String[] argv) {
        String protoFile = PROTOFILE;
        String packageName = "coins.backend.gen";
        int ap = 0;
        while (argv[ap].startsWith("-")) {
            if (argv[ap].equals("-p")) {
                protoFile = argv[++ap];
                ++ap;
                continue;
            }
            if (argv[ap].equals("-k")) {
                packageName = argv[++ap];
                ++ap;
                continue;
            }
            if (argv[ap].equals("-d")) {
                ++ap;
                defFileOnly = true;
                continue;
            }
            if (argv[ap].equals("-t")) {
                targetName = argv[++ap];
                ++ap;
                continue;
            }
            if (argv[ap].equals("-x")) {
                ++ap;
                printExpanded = true;
                continue;
            }
            if (argv[ap].startsWith("-D")) {
                String def;
                if (argv[ap].length() > 2) {
                    def = argv[ap].substring(2);
                } else {
                    if (++ap >= argv.length) {
                        throw new Error(usage);
                    }
                    def = argv[ap];
                }
                ++ap;
                String name = def;
                ImList body = ImList.Empty;
                int at = def.indexOf("=");
                if (at >= 0) {
                    name = def.substring(0, at);
                    body = ImList.list(def.substring(at + 1));
                }
                macros.put(name, new ImList(ImList.list(name), body));
                continue;
            }
            throw new Error(usage);
        }
        if (argv.length != ap + 1) {
            throw new Error(usage);
        }
        if (!argv[ap].endsWith(".tmd")) {
            throw new Error(".tmd expected");
        }
        if (targetName == null) {
            targetName = argv[ap].substring(0, argv[ap].indexOf(".tmd"));
        }
        String cgfile = "CodeGenerator_" + targetName + ".java";
        String rdfile = "MachineParams_" + targetName + ".java";
        try {
            PushbackReader rdr = new PushbackReader(new FileReader(argv[ap]));
            if (!defFileOnly) {
                out = new PrintWriter(new FileOutputStream(cgfile));
                proto = new BufferedReader(new FileReader(protoFile));
            }
            regDesc = new RegisterDescription2Java(targetName, rdfile, packageName);
            Tmd2Java.parseTmd(rdr);
            regDesc.close();
        }
        catch (SyntaxError e) {
            throw new Error(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new Error(e.getMessage());
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    static {
        defFileOnly = false;
        printExpanded = false;
        definitions = new HashMap();
        macros = new HashMap();
        rewriting = new RuleSet("rewriting");
        instSel = new RuleSet("instSel");
        javaMacros = new BiList();
        emCounter = 0;
        typeRegsetList = new BiList();
        usage = "Usage: java Tmd2Java [-d][-p protofile][-t targetname][-x][-Dmacro[=value]] target.tmd";
    }

    static class JavaMacro {
        String kind;
        String name;
        ImList args;
        int number;
        int opCode;

        JavaMacro(String kind, String name, ImList args) {
            this.kind = kind;
            this.name = name;
            this.args = args;
            this.number = ++emCounter;
            this.opCode = Op.toCode(name);
        }

        boolean forLirNode() {
            return this.opCode >= 0;
        }

        String methodHeader() {
            StringBuffer buf = new StringBuffer();
            buf.append((this.kind == Tmd2Java.DEFEMIT ? "String" : "Object") + " jmac" + this.number);
            buf.append("(");
            if (this.forLirNode()) {
                buf.append("LirNode " + this.args.elem());
            } else {
                ImList p = this.args;
                while (!p.atEnd()) {
                    String arg = (String)p.elem();
                    if (arg.charAt(0) == '=') {
                        buf.append("Object ");
                        buf.append(arg.substring(1));
                    } else {
                        if (this.kind == Tmd2Java.DEFEMIT) {
                            buf.append("String ");
                        } else {
                            buf.append("Object ");
                        }
                        buf.append(arg);
                    }
                    if (!p.next().atEnd()) {
                        buf.append(", ");
                    }
                    p = p.next();
                }
            }
            buf.append(")");
            return buf.toString();
        }

        String invokeCode(String listvar, String flag) {
            StringBuffer buf = new StringBuffer();
            buf.append("jmac" + this.number);
            buf.append("(");
            if (this.forLirNode()) {
                buf.append(listvar);
            } else {
                int num = 1;
                ImList p = this.args;
                while (!p.atEnd()) {
                    String arg = (String)p.elem();
                    if (num > 1) {
                        buf.append(", ");
                    }
                    if (arg.charAt(0) == '=') {
                        buf.append(listvar + ".elem(" + num + ")");
                    } else if (this.kind == Tmd2Java.DEFEMIT) {
                        buf.append("emitObject(" + listvar + ".elem(" + num + "))");
                    } else {
                        buf.append(listvar + ".elem(" + num + ")");
                    }
                    ++num;
                    p = p.next();
                }
            }
            buf.append(")");
            return buf.toString();
        }
    }

    static class RuleSet {
        private Map nontermTable = new HashMap();
        BiList nonterms = new BiList();
        private Map patternTable = new HashMap();
        BiList patterns = new BiList();
        BiList productions = new BiList();
        private int nextNonterm = 0;
        private int nextGen = 1;
        private int nextProd = 1;
        private String mode;
        private Nonterm startSym;
        private Prod[] sortedRules;
        static final int INIT_CHUNK = 100;
        static final int TOO_MANY_RULES_THRESH = 360;

        RuleSet(String mode) {
            this.mode = mode;
            Nonterm dontcare = this.nonterm("_");
            dontcare.setUsed();
            dontcare.setDefined();
        }

        int nnonterms() {
            return this.nextNonterm;
        }

        Nonterm startSym() {
            return this.startSym;
        }

        void setStartSym(String sym) {
            this.startSym = this.nonterm(sym);
        }

        Nonterm nonterm(String name) {
            Nonterm nt;
            if (name == null) {
                name = "_" + this.nextGen++;
            }
            if ((nt = (Nonterm)this.nontermTable.get(name)) == null) {
                nt = new Nonterm(name, this.nextNonterm++);
                this.nontermTable.put(name, nt);
                this.nonterms.add(nt);
            }
            return nt;
        }

        OpPattern pattern(int op, int type, Nonterm[] kids) {
            return this.internOpPattern(new OpPattern(op, type, kids));
        }

        OpPattern pattern(int op, int type, Object value) {
            return this.internOpPattern(new OpPattern(op, type, value));
        }

        OpPattern internOpPattern(OpPattern pat) {
            OpPattern p = (OpPattern)this.patternTable.get(pat);
            if (p != null) {
                return p;
            }
            this.patternTable.put(pat, pat);
            this.patterns.add(pat);
            return pat;
        }

        Prod addProd(OpPattern rhs) {
            Nonterm lhs = this.nonterm(null);
            Prod prod = new Prod(this.nextProd++, lhs, rhs);
            lhs.setRhs(rhs);
            this.productions.add(prod);
            return prod;
        }

        Prod addProd(String kind, String lhs, Object rhs, ImList tail) throws SyntaxError {
            Nonterm left = this.nonterm(lhs);
            Pattern right = rhs instanceof String ? this.nonterm((String)rhs) : this.parsePattern(rhs);
            Prod prod = new Prod(kind, this.nextProd++, left, right, tail);
            this.productions.add(prod);
            return prod;
        }

        Pattern parsePattern(Object obj) throws SyntaxError {
            if (obj instanceof String) {
                if (Tmd2Java.isNumber((String)obj)) {
                    return this.parsePattern(ImList.list("INTCONST", "_", obj));
                }
                return this.nonterm((String)obj);
            }
            if (obj instanceof ImList) {
                ImList p = (ImList)obj;
                int op = Op.toCode((String)p.elem());
                if (op < 0) {
                    throw new SyntaxError("Unknown opcode: " + (String)p.elem());
                }
                p = p.next();
                int type = -1;
                if (Op.isTyped(op) && !p.atEnd()) {
                    String typestr = (String)p.elem();
                    if (typestr != "_") {
                        type = Type.decode(typestr);
                    }
                    p = p.next();
                }
                Object value = null;
                switch (op) {
                    case 2: {
                        if (!p.atEnd()) {
                            value = new Long((String)p.elem());
                        }
                        return this.pattern(op, type, value);
                    }
                    case 3: {
                        if (!p.atEnd()) {
                            value = new Double((String)p.elem());
                        }
                        return this.pattern(op, type, value);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        if (!p.atEnd()) {
                            value = (QuotedString)p.elem();
                        }
                        return this.pattern(op, type, value);
                    }
                }
                Nonterm[] kids = new Nonterm[p.length()];
                int i = 0;
                while (!p.atEnd()) {
                    Pattern kid = this.parsePattern(p.elem());
                    Nonterm nt = kid.lhs();
                    if (nt == null) {
                        nt = this.addProd((OpPattern)((OpPattern)kid)).lhs;
                    }
                    kids[i++] = nt;
                    p = p.next();
                }
                return this.pattern(op, type, kids);
            }
            throw new SyntaxError("Neither Symbol nor Cons");
        }

        void checkGrammar() {
            BiLink p = this.nonterms.first();
            while (!p.atEnd()) {
                Nonterm symbol = (Nonterm)p.elem();
                if (!symbol.defined) {
                    System.err.println("** Warning: nonterminal " + symbol.name + " not defined");
                }
                if (!symbol.used) {
                    System.err.println("** Warning: nonterminal " + symbol.name + " not used");
                }
                p = p.next();
            }
        }

        void prepare() {
            this.sortedRules = new Prod[this.productions.length()];
            int j = 0;
            BiLink p = this.productions.first();
            while (!p.atEnd()) {
                Prod rule = (Prod)p.elem();
                this.sortedRules[j++] = rule;
                p = p.next();
            }
            Arrays.sort(this.sortedRules);
        }

        void printProductions(PrintWriter out) {
            out.println("/*");
            out.println("Productions:");
            BiLink p = this.productions.first();
            while (!p.atEnd()) {
                Prod rule = (Prod)p.elem();
                out.println(" " + rule.toString());
                p = p.next();
            }
            out.println("*/");
            out.println("/*");
            out.println("Sorted Productions:");
            for (int i = 0; i < this.sortedRules.length; ++i) {
                out.println(" " + this.sortedRules[i]);
            }
            out.println("*/");
        }

        void genParameters(PrintWriter out, String indent) {
            Nonterm nt;
            out.println(indent + "static final int NNONTERM = " + this.nnonterms() + ";");
            out.println(indent + "static final int NRULES = " + this.sortedRules.length + " + 1;");
            out.println(indent + "static final int START_NT = " + this.startSym().value + ";");
            out.println();
            BiLink p = this.nonterms.first();
            while (!p.atEnd()) {
                nt = (Nonterm)p.elem();
                out.println(indent + "static final int NT_" + nt.name + " = " + nt.value + ";");
                p = p.next();
            }
            out.println();
            out.println(indent + "String nontermName(int nt) {");
            out.println(indent + "  switch (nt) {");
            p = this.nonterms.first();
            while (!p.atEnd()) {
                nt = (Nonterm)p.elem();
                out.println(indent + "  case NT_" + nt.name + ": return \"" + nt.name + "\";");
                p = p.next();
            }
            out.println(indent + "  default: return null;");
            out.println(indent + "  }");
            out.println(indent + "};");
        }

        private static void initOne(String indent, Prod prod) {
            out.print(indent + "rulev[" + prod.number + "] = new Rule(" + prod.number + ", " + (prod.rhs instanceof Nonterm ? "true, " : "false, ") + (prod.kind == "derived" ? "true, " : "false, ") + prod.lhs.value + ", " + Tmd2Java.quote(prod.toString()) + ", " + Tmd2Java.listString(prod.code) + ", " + Tmd2Java.listString(prod.value) + ", " + Tmd2Java.listString(prod.clobber) + ", " + prod.eqregs + ", " + prod.useAfterDef + ", " + prod.hasDelaySlot() + ", " + "new int[]{");
            if (prod.rhs instanceof OpPattern) {
                OpPattern pat = (OpPattern)prod.rhs;
                for (int k = 0; k < pat.kids.length; ++k) {
                    if (k != 0) {
                        out.print(",");
                    }
                    out.print(pat.kids[k].value);
                }
            } else {
                out.print(((Nonterm)prod.rhs).value);
            }
            out.print("}, ");
            if (prod.regsets == null) {
                out.print("null");
            } else {
                out.print("new String[]{");
                for (int k = 0; k < prod.regsets.length; ++k) {
                    if (k != 0) {
                        out.print(", ");
                    }
                    out.print(Tmd2Java.quote(prod.regsets[k]));
                }
                out.print("}");
            }
            out.println(");");
        }

        void genRuleTable(PrintWriter out, String indent, int pass) {
            switch (pass) {
                case 0: {
                    for (int i = 0; i < this.sortedRules.length; ++i) {
                        RuleSet.initOne(indent, this.sortedRules[i]);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.sortedRules.length; i += 100) {
                        out.println(indent + "rrinit" + i + "();");
                    }
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < this.sortedRules.length) {
                        out.println(indent + "static private void rrinit" + i + "() {");
                        for (int j = 0; j < 100 && i < this.sortedRules.length; ++j, ++i) {
                            RuleSet.initOne(indent + "  ", this.sortedRules[i]);
                        }
                        out.println(indent + "}");
                    }
                    break;
                }
            }
        }

        void genChainRuleAction(PrintWriter out, String indent) throws SyntaxError {
            int prent = -1;
            for (int i = 0; i < this.sortedRules.length && this.sortedRules[i].rhs instanceof Nonterm; ++i) {
                Nonterm rhs = (Nonterm)this.sortedRules[i].rhs;
                if (rhs.value != prent) {
                    if (prent >= 0) {
                        out.println(indent + "  break;");
                    }
                    prent = rhs.value;
                    out.println(indent + "case NT_" + rhs.name + ":");
                }
                if (this.sortedRules[i].cond != null) {
                    out.print(indent + "  if (" + this.sortedRules[i].expandCond("t") + ") ");
                } else {
                    out.print(indent + "  ");
                }
                if (this.mode == "rewriting") {
                    out.println("record(NT_" + this.sortedRules[i].lhs.name + ", " + this.sortedRules[i].number + ");");
                    continue;
                }
                out.println("record(NT_" + this.sortedRules[i].lhs.name + ", " + this.sortedRules[i].cost1 + " + cost1, " + this.sortedRules[i].cost2 + " + cost2, " + this.sortedRules[i].number + ");");
            }
            if (prent >= 0) {
                out.println(indent + "  break;");
            }
        }

        void genRuleAction(PrintWriter out, String indent, int pass) throws SyntaxError {
            if (this.sortedRules.length < 360) {
                if (pass == 2) {
                    return;
                }
                pass = 0;
            }
            boolean genSubroutine = false;
            int i = 0;
            while (i < this.sortedRules.length) {
                int type;
                if (!(this.sortedRules[i].rhs instanceof OpPattern)) {
                    ++i;
                    continue;
                }
                OpPattern rhs = (OpPattern)this.sortedRules[i].rhs;
                int op = rhs.op;
                if (pass == 2) {
                    out.println(indent + "private void rract" + op + "(LirNode t, State kids[]) {");
                } else {
                    out.println(indent + "case Op." + Op.toName(rhs.op) + ":");
                }
                if (pass == 1) {
                    out.println(indent + "  rract" + op + "(t, kids);");
                }
                boolean reached = true;
                int j = i;
                while (i < this.sortedRules.length && ((OpPattern)this.sortedRules[i].rhs).op == op) {
                    int ii;
                    if (pass == 1) {
                        ++i;
                        continue;
                    }
                    rhs = (OpPattern)this.sortedRules[i].rhs;
                    type = rhs.type;
                    String subindent = indent;
                    if (type >= 0) {
                        out.println(indent + "  if (t.type == " + rhs.type + ") {");
                        subindent = indent + "  ";
                    }
                    for (ii = i; ii < this.sortedRules.length && ((OpPattern)this.sortedRules[ii].rhs).type == type && ((OpPattern)this.sortedRules[ii].rhs).op == op; ++ii) {
                    }
                    if (pass == 2 && ii - i > 100) {
                        genSubroutine = true;
                        while (i < ii) {
                            out.println(subindent + "  rract" + op + "_" + i + "(t, kids);");
                            i += 100;
                        }
                        i = ii;
                    } else {
                        while (i < ii) {
                            reached = this.genForPattern(this.sortedRules[i], subindent);
                            ++i;
                        }
                    }
                    if (type < 0) continue;
                    out.println(indent + "  }");
                    reached = true;
                }
                if (pass == 2) {
                    out.println(indent + "}");
                } else if (reached) {
                    out.println(indent + "  break;");
                }
                if (!genSubroutine) continue;
                i = j;
                while (i < this.sortedRules.length && ((OpPattern)this.sortedRules[i].rhs).op == op) {
                    int ii;
                    rhs = (OpPattern)this.sortedRules[i].rhs;
                    type = rhs.type;
                    for (ii = i; ii < this.sortedRules.length && ((OpPattern)this.sortedRules[ii].rhs).type == type && ((OpPattern)this.sortedRules[ii].rhs).op == op; ++ii) {
                    }
                    if (ii - i > 100) {
                        while (i < ii) {
                            out.println(indent + "private void rract" + op + "_" + i + "(LirNode t, State kids[]) {");
                            for (int k = 0; k < 100 && i < ii; ++k, ++i) {
                                this.genForPattern(this.sortedRules[i], indent + "  ");
                            }
                            out.println(indent + "}");
                        }
                        continue;
                    }
                    i = ii;
                }
            }
        }

        boolean genForPattern(Prod rule, String indent) throws SyntaxError {
            int k;
            boolean ifexist = false;
            OpPattern rhs = (OpPattern)rule.rhs;
            out.print(indent + "  ");
            if (Tmd2Java.isVarOp(rhs.op)) {
                out.print("if (kids.length == " + rhs.kids.length + ") ");
                ifexist = true;
            }
            for (k = 0; k < rhs.kids.length; ++k) {
                if (rhs.kids[k].name == "_") continue;
                out.print("if (kids[" + k + "].rule[NT_" + rhs.kids[k].name + "] != 0) ");
                ifexist = true;
            }
            if (rhs.value != null) {
                switch (rhs.op) {
                    case 2: {
                        out.print("if (((LirIconst)t).value == " + rhs.value + ") ");
                        ifexist = true;
                        break;
                    }
                    case 3: {
                        out.print("if (((LirFconst)t).value == " + rhs.value + ") ");
                        ifexist = true;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        out.print("if (((LirSymRef)t).symbol.name == " + rhs.value + ") ");
                        ifexist = true;
                        break;
                    }
                    default: {
                        throw new Error("constant field in " + Op.toName(rhs.op));
                    }
                }
            }
            if (rule.phase != null) {
                out.print("if (");
                boolean first = true;
                ImList p = rule.phase;
                while (!p.atEnd()) {
                    String name = (String)p.elem();
                    if (!first) {
                        out.print(" || ");
                    }
                    out.print("phase == \"" + name + "\"");
                    first = false;
                    p = p.next();
                }
                if (first) {
                    out.print("false");
                }
                out.print(") ");
                ifexist = true;
            }
            if (rule.cond != null) {
                out.print("if (" + rule.expandCond("t") + ") ");
                ifexist = true;
            }
            if (this.mode == "rewriting") {
                if (rule.lhs.name == "_rewr") {
                    rule.genRewriteCode("t", indent + "  ");
                    if (!ifexist) {
                        return false;
                    }
                } else {
                    out.print("record(NT_" + rule.lhs.name);
                    out.println(", " + rule.number + ");");
                }
            } else {
                out.print("record(NT_" + rule.lhs.name + ", " + rule.cost1);
                for (k = 0; k < rhs.kids.length; ++k) {
                    out.print(" + kids[" + k + "].cost1[NT_" + rhs.kids[k].name + "]");
                }
                out.print(", " + rule.cost2);
                for (k = 0; k < rhs.kids.length; ++k) {
                    out.print(" + kids[" + k + "].cost2[NT_" + rhs.kids[k].name + "]");
                }
                out.println(", " + rule.number + ");");
            }
            return true;
        }
    }

    static class Prod
    implements Comparable {
        final String kind;
        final Nonterm lhs;
        final Pattern rhs;
        final int number;
        final int cost1;
        final int cost2;
        final String cond;
        final ImList code;
        final ImList value;
        final ImList clobber;
        final boolean useAfterDef;
        final String[] regsets;
        final long eqregs;
        final ImList replaceto;
        final ImList phase;

        Prod(int number, Nonterm lhs, Pattern rhs) {
            this.kind = "derived";
            this.lhs = lhs;
            this.rhs = rhs;
            lhs.setDefined();
            this.number = number;
            this.cost2 = 0;
            this.cost1 = 0;
            this.cond = null;
            this.code = null;
            this.value = null;
            this.clobber = null;
            this.regsets = null;
            this.eqregs = 0L;
            this.replaceto = null;
            this.phase = null;
            this.useAfterDef = false;
            if (rhs instanceof OpPattern) {
                ((OpPattern)rhs).setLhs(lhs);
            }
            rhs.setUsed();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Prod(String kind, int number, Nonterm lhs, Pattern rhs, ImList tail) throws SyntaxError {
            this.kind = kind;
            this.lhs = lhs;
            this.rhs = rhs;
            this.number = number;
            lhs.setDefined();
            int cost1 = 0;
            int cost2 = 0;
            String cond = null;
            ImList code = null;
            ImList value = null;
            ImList clobber = null;
            ImList phase = null;
            boolean useAfterDef = false;
            ImList replaceto = null;
            Nonterm[] rnts = rhs.realSubgoals();
            String[] regsets = new String[1 + rnts.length];
            regsets[0] = lhs.defaultRegset;
            for (int i = 0; i < rnts.length; ++i) {
                regsets[1 + i] = rnts[i].defaultRegset;
            }
            long eqregs = 0L;
            while (!tail.atEnd()) {
                if (!(tail.elem() instanceof ImList)) throw new SyntaxError("unknown rule attribute: " + tail.elem());
                ImList p = (ImList)tail.elem();
                if (p.elem() == "cost" && kind == "rule") {
                    cost1 = Integer.parseInt((String)p.elem2nd());
                    cost2 = p.length() >= 3 ? Integer.parseInt((String)p.elem3rd()) : cost1;
                } else if (p.elem() == "cond") {
                    cond = p.elem2nd() instanceof QuotedString ? ((QuotedString)p.elem2nd()).body : (String)p.elem2nd();
                } else if (p.elem() == "code" && kind == "rule") {
                    code = p.next();
                } else if (p.elem() == "value" && kind == "rule") {
                    value = p.next();
                } else if (p.elem() == "clobber" && kind == "rule") {
                    clobber = p.next();
                } else if (p.elem() == "regset" && kind == "rule") {
                    p = p.next();
                    while (!p.atEnd()) {
                        ImList form = (ImList)p.elem();
                        String dollar = (String)form.elem();
                        int n = Tmd2Java.parseDollar(dollar);
                        if (n > rnts.length) {
                            throw new SyntaxError(dollar + ": no such nonterm");
                        }
                        regsets[n] = (String)form.elem2nd();
                        p = p.next();
                    }
                } else if (p.elem() == "use-after-def") {
                    useAfterDef = true;
                } else if (p.elem() == "eqreg" && kind == "rule") {
                    if ((p = p.next()).elem() instanceof ImList) {
                        while (!p.atEnd()) {
                            eqregs = this.doEqreg((ImList)p.elem(), eqregs, rnts);
                            p = p.next();
                        }
                    } else {
                        eqregs = this.doEqreg(p, eqregs, rnts);
                    }
                } else if (p.elem() == "to" && kind != "rule") {
                    replaceto = p.next();
                } else {
                    if (p.elem() != "phase" || kind == "rule") throw new SyntaxError("unknown rule attribute: " + p.elem());
                    phase = p.next();
                }
                tail = tail.next();
            }
            this.checkDollar(code, rnts.length);
            this.checkDollar(value, rnts.length);
            this.cost1 = cost1;
            this.cost2 = cost2;
            this.cond = cond;
            this.code = code;
            this.value = value;
            this.clobber = clobber;
            this.regsets = regsets;
            this.eqregs = eqregs;
            this.replaceto = replaceto;
            this.phase = phase;
            this.useAfterDef = useAfterDef;
            rhs.setUsed();
        }

        private void checkDollar(ImList list, int max) throws SyntaxError {
            if (list == null) {
                return;
            }
            ImList p = list;
            while (!p.atEnd()) {
                if (p.elem() instanceof String) {
                    String s = (String)p.elem();
                    if (s.charAt(0) == '$' && s.charAt(1) != '$' && s.charAt(1) != 'L' && Integer.parseInt(s.substring(1)) > max) {
                        throw new SyntaxError(s + ": no such nonterm");
                    }
                } else if (p.elem() instanceof ImList) {
                    this.checkDollar((ImList)p.elem(), max);
                }
                p = p.next();
            }
        }

        private long doEqreg(ImList form, long eqregs, Nonterm[] rnts) throws SyntaxError {
            if (form.length() != 2) {
                throw new SyntaxError("eqreg: expecting pair");
            }
            String to = (String)form.elem();
            int n = Tmd2Java.parseDollar(to);
            if (n > rnts.length) {
                throw new SyntaxError(to + ": no such nonterm");
            }
            if (n >= 64) {
                throw new SyntaxError(to + ": too many leaves");
            }
            eqregs |= (long)(1 << n);
            String from = (String)form.elem2nd();
            if (Tmd2Java.parseDollar(from) != 0) {
                throw new SyntaxError(from + ": must be $0");
            }
            return eqregs;
        }

        boolean hasDelaySlot() {
            if (this.code != null) {
                ImList p = this.code;
                while (!p.atEnd()) {
                    ImList op;
                    if (p.elem() instanceof ImList && (op = (ImList)p.elem()).elem() == "delayslot") {
                        return true;
                    }
                    p = p.next();
                }
            }
            return false;
        }

        String expandCond(String basevar) throws SyntaxError {
            return this.expandJava(this.cond, basevar);
        }

        String expandJava(String template, String basevar) throws SyntaxError {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < template.length(); ++i) {
                if (template.charAt(i) == '$') {
                    int nth;
                    if ((nth = template.charAt(++i) - 48) == 0) {
                        buf.append(basevar);
                        continue;
                    }
                    buf.append(this.rhs.getNth(basevar, nth));
                    continue;
                }
                buf.append(template.charAt(i));
            }
            return buf.toString();
        }

        void genRewriteCode(String basevar, String indent) throws SyntaxError {
            try {
                if (this.replaceto == null || this.replaceto.atEnd()) {
                    out.println(" return null;");
                } else {
                    out.println(" {");
                    out.println(indent + "  rewritten = true;");
                    String subindent = indent + "  ";
                    ImList p = this.replaceto;
                    while (!p.next().atEnd()) {
                        this.genRewriteStmt(p.elem(), basevar, subindent);
                        p = p.next();
                    }
                    out.println(subindent + "return " + this.genRewriteExpr(p.elem(), basevar) + ";");
                    out.println(indent + "}");
                }
            }
            catch (SyntaxError e) {
                throw new SyntaxError(e.getMessage() + " at: (to " + this.replaceto + ")");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void genRewriteStmt(Object form, String basevar, String indent) throws SyntaxError {
            if (form instanceof QuotedString) {
                out.println(indent + this.expandJava(((QuotedString)form).body, basevar) + ";");
                return;
            } else {
                if (!(form instanceof ImList)) return;
                ImList list = (ImList)form;
                if (list.atEnd()) {
                    throw new SyntaxError("empty list");
                }
                if (list.elem() == "let") {
                    ImList p = list.next();
                    while (!p.atEnd()) {
                        if (!(p.elem() instanceof ImList)) {
                            throw new SyntaxError("missing var-value pair at let");
                        }
                        ImList v = (ImList)p.elem();
                        out.println(indent + "LirNode " + v.elem() + " = " + this.genRewriteExpr(v.elem2nd(), basevar) + ";");
                        p = p.next();
                    }
                    return;
                } else if (list.elem() == "set!") {
                    if (list.length() != 3) {
                        throw new SyntaxError("bad set!");
                    }
                    out.println(indent + list.elem2nd() + " = " + this.genRewriteExpr(list.elem3rd(), basevar) + ";");
                    return;
                } else if (list.elem() == "pre") {
                    out.println(indent + "{");
                    ImList p = list.next();
                    while (!p.atEnd()) {
                        out.println(indent + "pre.add(" + this.genRewriteExpr(p.elem(), basevar) + ");");
                        p = p.next();
                    }
                    out.println(indent + "}");
                    return;
                } else if (list.elem() == "post") {
                    out.println(indent + "{");
                    ImList p = list.next();
                    while (!p.atEnd()) {
                        out.println(indent + "post.add(" + this.genRewriteExpr(p.elem(), basevar) + ");");
                        p = p.next();
                    }
                    out.println(indent + "}");
                    return;
                } else if (list.elem() == "if") {
                    out.println(indent + "if (" + this.genRewriteExpr(list.elem2nd(), basevar) + ")");
                    if (list.length() == 3) {
                        this.genRewriteStmt(list.elem3rd(), basevar, indent + "  ");
                        return;
                    } else {
                        if (list.length() != 4) throw new SyntaxError("bad if");
                        this.genRewriteStmt(list.elem3rd(), basevar, indent + "  ");
                        out.println(indent + "else");
                        this.genRewriteStmt(list.elem4th(), basevar, indent + "  ");
                    }
                    return;
                } else if (list.elem() == "prog") {
                    out.println(indent + "{");
                    ImList p = list.next();
                    while (!p.atEnd()) {
                        this.genRewriteStmt(p.elem(), basevar, indent + "  ");
                        p = p.next();
                    }
                    out.println(indent + "}");
                    return;
                } else {
                    if (list.elem() != "eval") throw new SyntaxError("unknown: " + list.elem());
                    out.println(indent + this.expandJava(((QuotedString)list.elem2nd()).body, basevar) + ";");
                }
            }
        }

        String genRewriteExpr(Object form, String basevar) throws SyntaxError {
            if (form instanceof ImList) {
                return this.genReplaceList((ImList)form, basevar);
            }
            if (form instanceof String) {
                return this.genReplaceString((String)form, basevar);
            }
            if (form instanceof QuotedString) {
                return this.genReplaceString(((QuotedString)form).body, basevar);
            }
            throw new SyntaxError("Neither string nor list");
        }

        String genReplaceList(ImList p, String basevar) throws SyntaxError {
            String mnemonic = (String)p.elem();
            if (mnemonic == "eval") {
                return this.expandJava(((QuotedString)p.elem2nd()).body, basevar);
            }
            if (mnemonic == "norescan") {
                return "noRescan(" + this.genRewriteExpr(p.elem2nd(), basevar) + ")";
            }
            int op = Op.toCode(mnemonic);
            if (op < 0) {
                throw new SyntaxError("Unknown opcode: " + mnemonic);
            }
            p = p.next();
            int type = 0;
            if (Op.isTyped(op)) {
                type = Type.decode((String)p.elem());
                p = p.next();
            }
            switch (op) {
                case 2: {
                    return "lir.iconst(" + type + ", " + this.genRewriteExpr(p.elem(), basevar) + ")";
                }
                case 3: {
                    return "lir.fconst(" + type + ", " + this.genRewriteExpr(p.elem(), basevar) + ")";
                }
                case 4: 
                case 5: 
                case 6: {
                    return "lir.node(Op." + mnemonic + ", " + type + ", " + this.genReplaceSym(p.elem(), basevar) + ")";
                }
                case 8: {
                    return "lir.node(Op." + mnemonic + ", " + type + ", " + this.genReplaceLabel(p.elem(), basevar) + ")";
                }
            }
            StringBuffer buf = new StringBuffer();
            buf.append("lir.node(Op." + mnemonic + ", " + type);
            while (!p.atEnd()) {
                buf.append(", " + this.genRewriteExpr(p.elem(), basevar));
                p = p.next();
            }
            buf.append(")");
            return buf.toString();
        }

        String genReplaceSym(Object form, String basevar) throws SyntaxError {
            if (form instanceof QuotedString) {
                return "func.getSymbol(\"" + ((QuotedString)form).body + "\")";
            }
            return this.genRewriteExpr(form, basevar);
        }

        String genReplaceLabel(Object form, String basevar) throws SyntaxError {
            if (form instanceof QuotedString) {
                return "func.internLabel(\"" + ((QuotedString)form).body + "\")";
            }
            return this.genRewriteExpr(form, basevar);
        }

        String genReplaceString(String str, String basevar) throws SyntaxError {
            if (str.charAt(0) == '$') {
                int nth = Integer.parseInt(str.substring(1));
                return this.rhs.getNth(basevar, nth);
            }
            return str;
        }

        public String toString() {
            return this.number + ": " + this.lhs.toString() + " -> " + this.rhs.toString();
        }

        public int compareTo(Object o) {
            Prod x = (Prod)o;
            int diff = 0;
            if (this.rhs instanceof Nonterm) {
                if (!(x.rhs instanceof Nonterm)) {
                    return -1;
                }
                diff = ((Nonterm)this.rhs).value - ((Nonterm)x.rhs).value;
                if (diff != 0) {
                    return diff;
                }
            } else {
                if (x.rhs instanceof Nonterm) {
                    return 1;
                }
                diff = ((OpPattern)this.rhs).op - ((OpPattern)x.rhs).op;
                if (diff != 0) {
                    return diff;
                }
                diff = ((OpPattern)this.rhs).type - ((OpPattern)x.rhs).type;
                if (diff != 0) {
                    return diff;
                }
            }
            return this.number - x.number;
        }
    }

    static class OpPattern
    extends Pattern {
        final int op;
        final int type;
        final Nonterm[] kids;
        final Object value;
        private Nonterm lhs;

        OpPattern(int op, int type, Nonterm[] kids) {
            this.op = op;
            this.type = type;
            this.kids = kids;
            this.value = null;
        }

        OpPattern(int op, int type, Object value) {
            this.op = op;
            this.type = type;
            this.kids = new Nonterm[0];
            this.value = value;
        }

        public int hashCode() {
            int v = (this.op << 8) + this.type << 16;
            for (int i = 0; i < this.kids.length; ++i) {
                v += this.kids[i].hashCode();
            }
            if (this.value != null) {
                v += this.value.hashCode();
            }
            return v;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpPattern)) {
                return false;
            }
            OpPattern p = (OpPattern)obj;
            if (this.op != p.op || this.type != p.type || this.kids.length != p.kids.length) {
                return false;
            }
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] == p.kids[i]) continue;
                return false;
            }
            if (this.value == null) {
                return p.value == null;
            }
            return this.value.equals(p.value);
        }

        void setUsed() {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].setUsed();
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("(" + Op.toName(this.op) + " " + (this.type == -1 ? "_" : Type.toString(this.type)));
            for (int i = 0; i < this.kids.length; ++i) {
                buf.append(" " + this.kids[i].toString());
            }
            if (this.value != null) {
                buf.append(" " + this.value.toString());
            }
            buf.append(")");
            return buf.toString();
        }

        Nonterm lhs() {
            return this.lhs;
        }

        void setLhs(Nonterm lhs) {
            this.lhs = lhs;
        }

        private int countSubgoals() {
            int n = 0;
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i].rhs() != null) {
                    n += this.kids[i].rhs().countSubgoals();
                    continue;
                }
                ++n;
            }
            return n;
        }

        private int fillSubgoals(Nonterm[] v, int ptr) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i].rhs() != null) {
                    ptr = this.kids[i].rhs().fillSubgoals(v, ptr);
                    continue;
                }
                v[ptr++] = this.kids[i];
            }
            return ptr;
        }

        Nonterm[] realSubgoals() {
            Nonterm[] v = new Nonterm[this.countSubgoals()];
            this.fillSubgoals(v, 0);
            return v;
        }

        String getNth(String parent, int n) throws SyntaxError {
            if (n == 0) {
                return parent;
            }
            int[] np = new int[]{n};
            String s = this.getNth1(parent, np);
            if (s == null) {
                throw new SyntaxError("$" + n + ": too big");
            }
            return s;
        }

        private String getNth1(String parent, int[] n) {
            for (int i = 0; i < this.kids.length; ++i) {
                String s = parent + ".kid(" + i + ")";
                if (this.kids[i].rhs() == null) {
                    n[0] = n[0] - 1;
                    if (n[0] != 0) continue;
                    return s;
                }
                String r = this.kids[i].rhs().getNth1(s, n);
                if (r == null) continue;
                return r;
            }
            return null;
        }
    }

    static class Nonterm
    extends Pattern {
        final String name;
        final int value;
        boolean defined;
        boolean used;
        private OpPattern rhs;
        String defaultRegset;

        Nonterm(String name, int value) {
            this.name = name;
            this.value = value;
        }

        void setDefaultRegset(String regset) {
            this.defaultRegset = regset;
        }

        void setRhs(OpPattern rhs) {
            this.rhs = rhs;
        }

        void setDefined() {
            this.defined = true;
        }

        void setUsed() {
            this.used = true;
        }

        Nonterm[] realSubgoals() {
            return new Nonterm[]{this};
        }

        Nonterm lhs() {
            return this;
        }

        OpPattern rhs() {
            return this.rhs;
        }

        String getNth(String parent, int n) throws SyntaxError {
            if (n == 0 || n == 1) {
                return parent;
            }
            throw new SyntaxError("$" + n + ": too big");
        }

        public String toString() {
            return this.name;
        }
    }

    static abstract class Pattern {
        Pattern() {
        }

        abstract Nonterm lhs();

        abstract void setUsed();

        abstract Nonterm[] realSubgoals();

        abstract String getNth(String var1, int var2) throws SyntaxError;
    }
}

