/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sim;

import coins.backend.CantHappenException;
import coins.backend.Function;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.Type;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.gen.CodeGenerator;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sim.SimFuncTableElem;
import coins.backend.sim.TypicalPattern;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimFuncTable {
    public Module acg;
    public Module bcg;
    public Module bcghost;
    public int nelems;
    public ArrayList ftable;
    public Hashtable hostglobalsymbol;
    public int ihostglobalsymbol;
    public Hashtable targetglobalsymbol;
    public int itargetglobalsymbol;
    public String logfuncname;
    public Symbol logfuncsymbol;
    public Symbol counterArray;
    public Symbol icounterArray;
    private int counterType;
    private int typeAddress;
    private int counterSize;
    private int counterLength;
    public Symbol memAccessSymbol;
    public String fsfuncname;
    public Symbol fsfuncsymbol;
    public String symbolFileName;
    public TypicalPattern tp = new TypicalPattern();
    private int[] markersbaseindex;
    private int[] markerslineno;
    private String[] markersfuncname;

    SimFuncTable(Module acg, Module bcg, Module bcghost, int simCount, int simMem) {
        this.acg = acg;
        this.bcg = bcg;
        this.bcghost = bcghost;
        BiList elembcg = bcg.elements;
        BiList elembcghost = bcghost.elements;
        BiList elemacg = acg.elements;
        BiLink pbcg = elembcg.first();
        BiLink pbcghost = elembcghost.first();
        BiLink pacg = elemacg.first();
        Function fbcghost = null;
        Function facg = null;
        this.tp = new TypicalPattern();
        this.ftable = new ArrayList();
        this.nelems = 0;
        while (!pbcg.atEnd()) {
            block7: {
                if (!(pbcg.elem() instanceof Function)) break block7;
                Function fbcg = (Function)pbcg.elem();
                String funcname = fbcg.symbol.name;
                while (true) {
                    block8: {
                        block9: {
                            if (pbcghost.atEnd()) break block8;
                            if (!(pbcghost.elem() instanceof Function)) break block9;
                            fbcghost = (Function)pbcghost.elem();
                            if (funcname == fbcghost.symbol.name) break block8;
                        }
                        pbcghost = pbcghost.next();
                        continue;
                    }
                    if (!pbcghost.atEnd()) break;
                    pbcghost = elembcghost.first();
                }
                while (true) {
                    block10: {
                        block11: {
                            if (pacg.atEnd()) break block10;
                            if (!(pacg.elem() instanceof Function)) break block11;
                            facg = (Function)pacg.elem();
                            if (funcname == facg.symbol.name) break block10;
                        }
                        pacg = pacg.next();
                        continue;
                    }
                    if (!pacg.atEnd()) break;
                    pacg = elemacg.first();
                }
                this.ftable.add(new SimFuncTableElem(funcname, facg, fbcg, fbcghost, simCount, simMem));
                ++this.nelems;
            }
            pbcg = pbcg.next();
        }
    }

    private static String stem(String old) {
        int pos = old.indexOf(46);
        return pos >= 0 ? old.substring(0, pos) : old;
    }

    private static boolean isIdentifier(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static String createIdentifier(String filename) {
        char[] str = filename.toCharArray();
        StringBuffer buf = new StringBuffer("_");
        for (int i = 0; i < str.length; ++i) {
            if (SimFuncTable.isIdentifier(str[i])) {
                buf.append(str[i]);
                continue;
            }
            if (str[i] == '_') {
                buf.append("__");
                continue;
            }
            buf.append("_");
            buf.append(new Integer(str[i]));
            buf.append("_");
        }
        return buf.toString();
    }

    public void setTypicalPattern(TypicalPattern Type2) {
        this.tp = Type2;
    }

    public void analyze(Root root, String targetName, String hostName, int simCount, int simMem) {
        this.markersbaseindex = new int[this.nelems + 1];
        LirFactory lir = this.bcghost.newLir;
        this.typeAddress = this.bcghost.targetMachine.typeAddress;
        this.counterType = Type.type(2, 32L);
        this.counterSize = Type.bytes(this.counterType);
        this.counterLength = 0;
        for (int i = 0; i < this.nelems; ++i) {
            this.markersbaseindex[i] = this.counterLength;
            SimFuncTableElem sfte = (SimFuncTableElem)this.ftable.get(i);
            this.counterLength += sfte.imarkersacg;
            if (!root.isOptionSet("simulatemarklog")) continue;
            System.out.println("mark:" + new Integer(this.markersbaseindex[i]) + ":" + new Integer(sfte.imarkersacg));
        }
        this.markersbaseindex[this.nelems] = this.counterLength;
        this.markerslineno = new int[this.counterLength];
        this.markersfuncname = new String[this.counterLength];
        String vecName = ("__" + SimFuncTable.createIdentifier(SimFuncTable.stem(this.bcghost.name)) + "_countervec").intern();
        String ivecName = ("__" + SimFuncTable.createIdentifier(SimFuncTable.stem(this.bcghost.name)) + "_icountervec").intern();
        this.counterArray = this.bcghost.addSymbol(vecName, 0, Type.type(1, 0L), 8, ".bss", "XDEF", null);
        this.bcghost.addData(this.counterArray, lir.node(63, 0, lir.iconst(this.typeAddress, this.counterLength * this.counterSize)));
        this.icounterArray = this.bcghost.addSymbol(ivecName, 0, Type.type(2, 32L), 4, ".rodata", "XDEF", null);
        this.bcghost.addData(this.icounterArray, lir.node(2, Type.type(2, 32L), this.counterLength));
        String memAccessName = ("__" + SimFuncTable.createIdentifier(SimFuncTable.stem(this.bcghost.name)) + "_memaccessmoduleid").intern();
        this.memAccessSymbol = this.bcghost.addSymbol(memAccessName, 0, 2, 4, ".bss", "XREF", null);
        this.bcghost.addData(this.memAccessSymbol, lir.node(63, 0, lir.iconst(this.typeAddress, Type.bytes(Type.type(2, 32L)))));
        this.logfuncname = "__coins_sim_log_9".intern();
        this.logfuncsymbol = this.bcghost.addSymbol(this.logfuncname, 0, 0, 4, ".text", "XREF", null);
        this.fsfuncname = "__coins_sim_fslog_4".intern();
        this.fsfuncsymbol = this.bcghost.addSymbol(this.fsfuncname, 0, 0, 4, ".text", "XREF", null);
        for (int i = 0; i < this.nelems; ++i) {
            ImList logsexp;
            LirNode loglir;
            String loglineno;
            ImList elem;
            Enumeration keys;
            String profmodes;
            SimFuncTableElem sfte = (SimFuncTableElem)this.ftable.get(i);
            if (root.isOptionSet("simulatemarklog")) {
                System.out.println("markers: " + sfte.name + ":" + new Integer(this.markersbaseindex[i]));
            }
            Dominators dom = (Dominators)sfte.acg.require(Dominators.analyzer);
            for (int j = 0; j < sfte.iacgbb; ++j) {
                ArrayList tmp = sfte.memsacgbb;
                ImList bb = (ImList)tmp.get(j);
                int ilmemsacg = (Integer)bb.elem();
                ArrayList lmemsacg = (ArrayList)bb.elem2nd();
                Hashtable memshash = sfte.memsbcghosthash;
                for (int k = 0; k < ilmemsacg; ++k) {
                    ImList mems;
                    ImList llmems = (ImList)lmemsacg.get(k);
                    String memid = (String)llmems.elem();
                    String name = (String)llmems.elem2nd();
                    LirNode node = (LirNode)llmems.elem3rd();
                    String slvalue = (String)llmems.elem4th();
                    profmodes = (String)llmems.elem6th();
                    if (root.isOptionSet("simulatelog")) {
                        System.out.println("A:" + new Integer(j) + ":" + memid + ":" + name + ":" + slvalue + ":" + node.toString());
                    }
                    if ((mems = (ImList)memshash.get(memid)) == null) continue;
                    memshash.put(memid, ImList.list(mems.elem(), mems.elem2nd(), mems.elem3rd(), mems.elem4th(), mems.elem6th(), "yes"));
                    if (!root.isOptionSet("simulatelog")) continue;
                    System.out.println("H:" + memid + ":" + (String)mems.elem() + ":" + ((LirNode)mems.elem2nd()).toString() + ":" + ((LirNode)((BiLink)mems.elem3rd()).elem()).toString() + ":" + (Integer)mems.elem4th() + ":" + profmodes);
                }
            }
            Hashtable memshash = sfte.memsbcghosthash;
            Enumeration e = keys = memshash.keys();
            while (e.hasMoreElements()) {
                String memid = (String)e.nextElement();
                ImList memsinfo = (ImList)memshash.get(memid);
                String profmodes2 = (String)memsinfo.elem5th();
                String used = (String)memsinfo.elem6th();
                if (!used.equals("no") || !profmodes2.equals("TRUE")) continue;
                String name = (String)memsinfo.elem();
                LirNode node = (LirNode)memsinfo.elem2nd();
                BiLink insp = (BiLink)memsinfo.elem3rd();
                Integer ibb = (Integer)memsinfo.elem4th();
                ArrayList mems0 = (ArrayList)sfte.memsbcghost.get(ibb);
                mems0.add(ImList.list(node, insp, ibb, "yes"));
            }
            if (root.isOptionSet("simulatelog")) {
                for (int j = 0; j < sfte.ibcghostbb; ++j) {
                    ArrayList tmp = sfte.memsbcghost;
                    ArrayList lmemsbcghost = (ArrayList)tmp.get(j);
                    int ilmemsbcghost = lmemsbcghost.size();
                    for (int k = 0; k < ilmemsbcghost; ++k) {
                        Integer sj = new Integer(j);
                        ImList il = (ImList)lmemsbcghost.get(k);
                        System.out.println(sj + ":" + ((LirNode)il.elem()).toString() + ":" + ((LirNode)((BiLink)il.elem2nd()).elem()).toString() + ":" + (Integer)il.elem3rd() + ":" + (String)il.elem4th());
                    }
                }
            }
            if (this.bcghost.root.isOptionSet("simulateLog")) {
                if (root.isOptionSet("simulatemarklog")) {
                    System.out.println("marker list:");
                }
                for (int k = 0; k < sfte.iacgbb; ++k) {
                    if (sfte.markersacg.get(k) instanceof ImList) {
                        ImList lmarker = (ImList)sfte.markersacg.get(k);
                        while (lmarker.elem() != null) {
                            if (lmarker.elem() instanceof String) {
                                lmarker = lmarker.next();
                                continue;
                            }
                            elem = (ImList)lmarker.elem();
                            lmarker = lmarker.next();
                            System.out.println(" " + elem.elem() + ":" + elem.elem2nd() + ":" + elem.elem3rd());
                            ImList elem2 = (ImList)sfte.markersbcghost.get(elem.elem());
                            Integer logi = (Integer)elem2.elem();
                            loglineno = (String)elem2.elem2nd();
                            loglir = (LirNode)((BiLink)elem2.elem3rd()).elem();
                            logsexp = (ImList)loglir.toSexp();
                            System.out.println("  " + logi + ":" + loglineno + ":" + logsexp.toString());
                        }
                    }
                    if (!(sfte.markersacg.get(k) instanceof String)) continue;
                    System.out.println("  " + new Integer(k) + ":" + "no markers");
                }
            }
            if (this.bcghost.root.isOptionSet("simulateLog")) {
                System.out.println("marker list(1):");
                for (int k = 0; k < sfte.iacgbb; ++k) {
                    if (sfte.markersacg.get(k) instanceof ImList) {
                        ImList lmarker = (ImList)sfte.markersacg.get(k);
                        while (lmarker.elem() != null) {
                            if (lmarker.elem() instanceof String) {
                                lmarker = lmarker.next();
                                continue;
                            }
                            elem = (ImList)lmarker.elem();
                            lmarker = lmarker.next();
                            System.out.println(" " + elem.elem() + ":" + elem.elem2nd() + ":" + elem.elem3rd());
                            ImList elem2 = (ImList)sfte.markersbcghost.get(elem.elem());
                            Integer logi = (Integer)elem2.elem();
                            loglineno = (String)elem2.elem2nd();
                            loglir = (LirNode)((BiLink)elem2.elem3rd()).elem();
                            logsexp = (ImList)loglir.toSexp();
                            System.out.println("  " + logi + ":" + loglineno + ":" + logsexp.toString());
                        }
                    }
                    if (!(sfte.markersacg.get(k) instanceof String)) continue;
                    System.out.println("  " + new Integer(k) + ":" + "no markers");
                }
            }
            if (sfte == null) {
                for (int j = 0; j < sfte.iacgbb; ++j) {
                    if (!(sfte.markersacg.get(j) instanceof String)) continue;
                    BasicBlk elem2 = (BasicBlk)sfte.acgbb.get(j);
                    block12: do {
                        BasicBlk domb = dom.immDominator(elem2);
                        for (int k = 0; k < sfte.iacgbb; ++k) {
                            if ((BasicBlk)sfte.acgbb.get(k) != domb) continue;
                            if (sfte.markersacg.get(k) instanceof ImList) {
                                sfte.markersacg.set(j, sfte.markersacg.get(k));
                                ++sfte.imarkersacg;
                                continue block12;
                            }
                            elem2 = domb;
                            continue block12;
                        }
                    } while (sfte.markersacg.get(j) instanceof String);
                }
            }
            if (this.bcghost.root.isOptionSet("simulateLog")) {
                System.out.println("marker list(2):");
                for (int k = 0; k < sfte.iacgbb; ++k) {
                    if (sfte.markersacg.get(k) instanceof ImList) {
                        ImList lmarker = (ImList)sfte.markersacg.get(k);
                        while (lmarker.elem() != null) {
                            if (lmarker.elem() instanceof String) {
                                lmarker = lmarker.next();
                                continue;
                            }
                            elem = (ImList)lmarker.elem();
                            lmarker = lmarker.next();
                            System.out.println(" " + elem.elem() + ":" + elem.elem2nd() + ":" + elem.elem3rd());
                            ImList elem2 = (ImList)sfte.markersbcghost.get(elem.elem());
                            Integer logi = (Integer)elem2.elem();
                            loglineno = (String)elem2.elem2nd();
                            loglir = (LirNode)((BiLink)elem2.elem3rd()).elem();
                            logsexp = (ImList)loglir.toSexp();
                            System.out.println("  " + logi + ":" + loglineno + ":" + logsexp.toString());
                        }
                    }
                    if (!(sfte.markersacg.get(k) instanceof String)) continue;
                    System.out.println("  " + new Integer(k) + ":" + "no markers");
                }
            }
            if (simMem != 0) {
                Hashtable memsbhash = sfte.memsbcghosthash;
                ArrayList<ImList> pendings = new ArrayList<ImList>();
                int ipendings = 0;
                for (int j = 0; j < sfte.iacgbb; ++j) {
                    ImList bb = (ImList)sfte.memsacgbb.get(j);
                    int ilmemsacg = (Integer)bb.elem();
                    ArrayList lmemsacg = (ArrayList)bb.elem2nd();
                    for (int k = 0; k < ilmemsacg; ++k) {
                        String marker;
                        ImList lmems = (ImList)lmemsacg.get(k);
                        String memid = (String)lmems.elem();
                        profmodes = (String)lmems.elem6th();
                        if (!profmodes.equals("TRUE")) continue;
                        if (!memid.equals("-1")) {
                            ImList llmems = (ImList)memsbhash.get(memid);
                            BiLink insp = (BiLink)llmems.elem3rd();
                            LirNode node = (LirNode)llmems.elem2nd();
                            String slvalue = (String)lmems.elem4th();
                            this.setmemlogsA(insp, node, slvalue, sfte, "x86", root, i);
                            continue;
                        }
                        LirNode node = (LirNode)lmems.elem3rd();
                        String slvalue = (String)lmems.elem4th();
                        if (!(sfte.markersacg.get(j) instanceof ImList)) continue;
                        ImList markers = (ImList)sfte.markersacg.get(j);
                        if (markers.elem() != null) {
                            ImList ile = (ImList)markers.elem();
                            marker = (String)ile.elem();
                        } else {
                            marker = null;
                        }
                        Hashtable lbcghosthash = sfte.markersbcghost;
                        ImList val = (ImList)lbcghosthash.get(marker);
                        int ib = (Integer)val.elem();
                        BiLink insp = (BiLink)val.elem3rd();
                        if (this.tp.analyze(node, targetName, root)) {
                            this.setmemlogsB(insp, ib, node, slvalue, sfte, targetName, root, i);
                            continue;
                        }
                        pendings.add(ImList.list((Integer)val.elem(), node, targetName));
                        ++ipendings;
                    }
                }
                int ipendingbb = -1;
                for (int j = 0; j < ipendings; ++j) {
                    ImList list = (ImList)pendings.get(j);
                    int ip = (Integer)list.elem();
                    if (ip == ipendingbb) continue;
                    ipendingbb = ip;
                    this.setmemlogsC(ip, (LirNode)list.elem2nd(), sfte, targetName, root, i);
                }
                if (root.isOptionSet("simulateLog")) {
                    System.out.println("Simulation LIR (memAccess)");
                    ImList.printIt(root.debOut, sfte.bcghost.toSexp());
                }
            }
            CodeGenerator targetCG = this.acg.targetMachine.getTargetCG();
            int framesize = sfte.acg.frameSize();
            for (int j = 0; j < sfte.ibcghostbb; ++j) {
                BasicBlk elem3 = (BasicBlk)sfte.bcghostbb.get(j);
                BiLink insp = elem3.instrList().first();
                while (!insp.atEnd()) {
                    LirNode node = (LirNode)insp.elem();
                    if (node.opCode == 54) {
                        this.setframesize(true, insp, sfte, framesize, simCount);
                    } else if (node.opCode == 55) {
                        this.setframesize(false, insp, sfte, framesize, simCount);
                    }
                    insp = insp.next();
                }
            }
            if (root.isOptionSet("simulateLog")) {
                System.out.println("Simulation LIR (FramePointer)");
                ImList.printIt(root.debOut, sfte.bcghost.toSexp());
            }
            if (simCount == 0) continue;
            if (this.bcghost.root.isOptionSet("simulateLog")) {
                System.out.println("marker list(3):");
                for (int k = 0; k < sfte.iacgbb; ++k) {
                    if (sfte.markersacg.get(k) instanceof ImList) {
                        ImList lmarker = (ImList)sfte.markersacg.get(k);
                        while (lmarker.elem() != null) {
                            if (lmarker.elem() instanceof String) {
                                lmarker = lmarker.next();
                                continue;
                            }
                            ImList elem4 = (ImList)lmarker.elem();
                            lmarker = lmarker.next();
                            System.out.println(" " + elem4.elem() + ":" + elem4.elem2nd() + ":" + elem4.elem3rd());
                            ImList elem2 = (ImList)sfte.markersbcghost.get(elem4.elem());
                            Integer logi = (Integer)elem2.elem();
                            String loglineno2 = (String)elem2.elem2nd();
                            LirNode loglir2 = (LirNode)((BiLink)elem2.elem3rd()).elem();
                            ImList logsexp2 = (ImList)loglir2.toSexp();
                            System.out.println("  " + logi + ":" + loglineno2 + ":" + logsexp2.toString());
                        }
                    }
                    if (!(sfte.markersacg.get(k) instanceof String)) continue;
                    System.out.println("  " + new Integer(k) + ":" + "no markers");
                }
            }
            int iacgbblim = simCount == 1 ? 1 : sfte.iacgbb;
            int jmarker = 0;
            for (int j = 0; j < iacgbblim; ++j) {
                ArrayList sftemarkersacg = sfte.markersacg;
                if (!(sftemarkersacg.get(j) instanceof ImList)) continue;
                ImList markers = (ImList)sftemarkersacg.get(j);
                while (markers.elem() != null) {
                    if (!(markers.elem() instanceof String)) {
                        ImList minfo = (ImList)markers.elem();
                        String marker = (String)minfo.elem();
                        String lineno = (String)minfo.elem2nd();
                        String simon = (String)minfo.elem3rd();
                        if (simon.equals("TRUE")) {
                            ImList bmarker = (ImList)sfte.markersbcghost.get(marker);
                            int ibb = (Integer)bmarker.elem();
                            BiLink binsp = (BiLink)bmarker.elem3rd();
                            this.setmarkerlogs(ibb, j, jmarker, marker, lineno, binsp, sfte, root, i);
                        }
                        ++jmarker;
                    }
                    markers = markers.next();
                }
            }
            if (!root.isOptionSet("simulatemarklog")) continue;
            System.out.println("     : " + new Integer(jmarker));
        }
        if (root.traceOK("simulatedump", 1)) {
            root.debOut.println("External-LIR Format:");
            ImList.printIt(root.debOut, this.bcghost.toSexp());
        }
        this.symbolFileName = SimFuncTable.createIdentifier(SimFuncTable.stem(this.bcghost.name)) + "_symbols.tbl";
        this.symbolFileOut(this.symbolFileName, this.acg, this.bcghost);
    }

    public void symbolTable(Root root, Module module, String kind) {
        ImList symSexp = (ImList)module.toSexp();
        Hashtable<String, ImList> globalsymbol = new Hashtable<String, ImList>();
        int iglobalsymbol = 0;
        String modName = ((QuotedString)symSexp.elem2nd()).body;
        ImList body = symSexp.next().next();
        ImList me = (ImList)body.elem();
        while (me != null) {
            if (((String)me.elem()).equals("FUNCTION")) {
                String funcName = ((QuotedString)me.elem2nd()).body;
                ImList lbody = me.next().next();
                SimFuncTableElem sfte = null;
                for (int k = 0; k < this.nelems; ++k) {
                    sfte = (SimFuncTableElem)this.ftable.get(k);
                    if (sfte.name.equals(funcName)) break;
                }
                Hashtable<String, ImList> localsymbol = new Hashtable<String, ImList>();
                int ilocalsymbol = 0;
                ImList le = (ImList)lbody.elem();
                while (le != null) {
                    if (((String)le.elem()).equals("SYMTAB")) {
                        ImList syms = le.next();
                        ImList e = (ImList)syms.elem();
                        while (e != null) {
                            String name = ((QuotedString)e.elem()).body;
                            String storage = (String)e.elem2nd();
                            if (!storage.equals("REG")) {
                                String stype = (String)e.elem3rd();
                                String segment = (String)e.elem4th();
                                String linkage = e.elem5th() instanceof QuotedString ? ((QuotedString)e.elem5th()).body : (String)e.elem5th();
                                String newname = name.intern();
                                if (localsymbol.get(newname) == null) {
                                    ImList symelem = ImList.list(new Integer(ilocalsymbol), storage, stype, segment, linkage);
                                    localsymbol.put(newname, symelem);
                                    ++ilocalsymbol;
                                    if (root.isOptionSet("profsymlog")) {
                                        System.out.println(newname + ":" + storage + ":" + stype + ":" + segment + ":" + linkage);
                                    }
                                }
                            }
                            syms = syms.next();
                            e = (ImList)syms.elem();
                        }
                    }
                    if (kind.equals("Host")) {
                        sfte.hostlocalsymbol = localsymbol;
                        sfte.ihostlocalsymbol = ilocalsymbol;
                    } else {
                        sfte.targetlocalsymbol = localsymbol;
                        sfte.itargetlocalsymbol = ilocalsymbol;
                    }
                    lbody = lbody.next();
                    le = (ImList)lbody.elem();
                }
            } else if (((String)me.elem()).equals("SYMTAB")) {
                ImList syms = me.next();
                ImList e = (ImList)syms.elem();
                while (e != null) {
                    String name = ((QuotedString)e.elem()).body.intern();
                    String storage = (String)e.elem2nd();
                    if (!storage.equals("REG")) {
                        String stype = (String)e.elem3rd();
                        String segment = (String)e.elem4th();
                        String linkage = e.elem5th() instanceof QuotedString ? ((QuotedString)e.elem5th()).body : (String)e.elem5th();
                        if (globalsymbol.get(name) == null) {
                            ImList symelem = ImList.list(new Integer(iglobalsymbol), storage, stype, segment, linkage);
                            globalsymbol.put(name, symelem);
                            ++iglobalsymbol;
                            if (root.isOptionSet("profsymlog")) {
                                System.out.println(name + ":" + new Integer(iglobalsymbol - 1) + ":" + storage + ":" + stype + ":" + segment + ":" + linkage);
                            }
                        }
                    }
                    syms = syms.next();
                    e = (ImList)syms.elem();
                }
                if (kind.equals("Host")) {
                    this.hostglobalsymbol = globalsymbol;
                    this.ihostglobalsymbol = iglobalsymbol;
                } else {
                    this.targetglobalsymbol = globalsymbol;
                    this.itargetglobalsymbol = iglobalsymbol;
                }
            } else if (!((String)me.elem()).equals("DATA") && root.isOptionSet("profsymlog")) {
                System.out.println(me.toString());
            }
            body = body.next();
            me = (ImList)body.elem();
        }
    }

    private void symbolFileOut(String fileName, Module acg, Module bcghost) {
        SimFuncTableElem sfte;
        int i;
        PrintWriter out;
        try {
            out = new PrintWriter(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new CantHappenException();
        }
        out.println("# symbol table for " + acg.name);
        out.println("Target,0,0,0,0,0");
        out.println("Global,0,0,0,0,0");
        SimFuncTable.symbolOut(out, this.targetglobalsymbol, this.itargetglobalsymbol);
        int findexbase = 0;
        for (i = 0; i < this.nelems; ++i) {
            sfte = (SimFuncTableElem)this.ftable.get(i);
            out.println("Function," + sfte.name + "," + i + "," + new Integer(this.markersbaseindex[i + 1] - findexbase) + ",0,0");
            SimFuncTable.symbolOut(out, sfte.targetlocalsymbol, sfte.itargetlocalsymbol);
            findexbase = this.markersbaseindex[i + 1];
        }
        out.println("Host,0,0,0,0,0");
        out.println("Global,0,0,0,0,0");
        SimFuncTable.symbolOut(out, this.hostglobalsymbol, this.ihostglobalsymbol);
        for (i = 0; i < this.nelems; ++i) {
            sfte = (SimFuncTableElem)this.ftable.get(i);
            out.println("Function," + sfte.name + "," + i + "," + "0,0,0");
            SimFuncTable.symbolOut(out, sfte.hostlocalsymbol, sfte.ihostlocalsymbol);
        }
        out.println("Markers," + this.counterLength + ",0,0,0,0");
        for (i = 0; i < this.counterLength; ++i) {
            out.println(i + "," + this.markerslineno[i] + ",0,0,0,0");
        }
        out.flush();
    }

    private static void symbolOut(PrintWriter out, Hashtable symbol, int isymbol) {
        Enumeration keys = symbol.keys();
        ImList[] stable = new ImList[isymbol];
        Enumeration e = keys;
        while (e.hasMoreElements()) {
            String symName = (String)e.nextElement();
            ImList elem = (ImList)symbol.get(symName);
            int index = (Integer)elem.elem();
            stable[index] = ImList.list(symName, elem);
        }
        for (int i = 0; i < isymbol; ++i) {
            ImList eelem = (ImList)stable[i].elem2nd();
            out.println(i + "," + stable[i].elem() + "," + eelem.elem2nd() + "," + eelem.elem3rd() + "," + eelem.elem4th() + "," + eelem.elem5th());
        }
    }

    public void transcode() {
    }

    private void setmarkerlogs(int ibcg, int ibb, int iacg, String marker, String lineno, BiLink insp, SimFuncTableElem sfte, Root root, int fi) {
        LirFactory lir = sfte.bcghost.newLir;
        int ln = new Integer(lineno);
        int index = this.markersbaseindex[fi] + iacg;
        if (root.isOptionSet("simulatemarklog")) {
            System.out.println("index: " + marker + ":" + new Integer(fi) + ":" + new Integer(ibb) + ":" + new Integer(this.markersbaseindex[fi]) + ":" + new Integer(iacg));
        }
        this.markerslineno[index] = ln;
        LirNode s = lir.node(48, this.counterType, lir.node(47, this.counterType, lir.node(10, this.typeAddress, lir.node(4, this.typeAddress, this.counterArray), lir.iconst(this.typeAddress, index * this.counterSize))), lir.node(10, this.counterType, lir.node(47, this.counterType, lir.node(10, this.typeAddress, lir.node(4, this.typeAddress, this.counterArray), lir.iconst(this.typeAddress, index * this.counterSize))), lir.iconst(this.counterType, 1L)));
        insp.addBefore(s);
        if (root.traceOK("simulatedump", 1)) {
            System.out.println("marker(" + new Integer(iacg) + "," + marker + "):lineno(" + lineno + "):" + ((LirNode)insp.elem()).toString());
        }
    }

    private void setmemlogsC(int ip, LirNode node, SimFuncTableElem sfte, String targetName, Root root, int fi) {
        if (root.traceOK("simulateignoredump", 1)) {
            System.out.println(" ignore:" + node.toString());
        }
    }

    private void setmemlogsB(BiLink insp, int ib, LirNode node, String slvalue, SimFuncTableElem sfte, String targetName, Root root, int fi) {
        BasicBlk elem = (BasicBlk)sfte.bcghostbb.get(ib);
        if (root.isOptionSet("simulatelog")) {
            System.out.println("LOG(TARGET):" + node.toString());
        }
        this.setmemlogsA1(insp, node, slvalue, sfte, targetName, root, "target", fi);
    }

    private void setmemlogsA(BiLink insp, LirNode node, String slvalue, SimFuncTableElem sfte, String targetName, Root root, int fi) {
        if (root.isOptionSet("simulatelog")) {
            System.out.println("LOG(HOST):" + node.toString());
        }
        this.setmemlogsA1(insp, node, slvalue, sfte, targetName, root, "host", fi);
    }

    private void setmemlogsA1(BiLink insp, LirNode node, String slvalue, SimFuncTableElem sfte, String targetName, Root root, String hosttarget, int fi) {
        LirNode knode = node.kid(0);
        int typeid = node.type;
        switch (knode.opCode) {
            case 4: 
            case 5: {
                String rname = ((LirSymRef)knode).symbol.name;
                this.addlogfunc(0, insp, sfte, fi, rname, hosttarget, typeid, slvalue, "", "");
                if (!root.isOptionSet("simulatelog")) break;
                System.out.println("call _coins_simlog1frame_" + hosttarget + "(" + Type.toString(typeid) + "," + rname + "," + slvalue + ")");
                break;
            }
            case 6: {
                String rname = ((LirSymRef)knode).symbol.name;
                if (this.tp.frameregister(rname, targetName)) {
                    this.addlogfunc(1, insp, sfte, fi, rname, hosttarget, typeid, slvalue, "ADD", new Long(0L));
                    if (!root.isOptionSet("simulatelog")) break;
                    System.out.println("call _coins_simlog2frame_" + hosttarget + "(" + Type.toString(typeid) + "," + "ADD," + rname + ",0," + slvalue + ")");
                    break;
                }
                String calc = knode.toString();
                this.addlogfunc(2, insp, sfte, fi, rname, hosttarget, typeid, slvalue, knode, "");
                if (!root.isOptionSet("simulatelog")) break;
                System.out.println("call _coins_simlog2directaccess_" + hosttarget + "(" + Type.toString(typeid) + "," + calc + "." + slvalue + ")");
                break;
            }
            case 10: 
            case 11: {
                String opcode = knode.opCode == 10 ? "ADD" : "SUB";
                LirNode rnode = knode.kid(0);
                if (rnode.opCode != 6) {
                    String calc = knode.toString();
                    this.addlogfunc(3, insp, sfte, fi, "", hosttarget, typeid, slvalue, knode, "");
                    if (!root.isOptionSet("simulatelog")) break;
                    System.out.println("call _coins_simlog2directaccess_" + hosttarget + "(" + Type.toString(typeid) + "," + calc + "." + slvalue + ")");
                    break;
                }
                LirNode onode = knode.kid(1);
                String rname = ((LirSymRef)rnode).symbol.name;
                if (this.tp.frameregister(rname, targetName)) {
                    if (onode.opCode == 2) {
                        String offset = new Long(((LirIconst)onode).value).toString();
                        this.addlogfunc(4, insp, sfte, fi, rname, hosttarget, typeid, slvalue, opcode, onode);
                        if (!root.isOptionSet("simulatelog")) break;
                        System.out.println("call _coins_simlog3dframe_" + hosttarget + "(" + Type.toString(typeid) + "," + opcode + "," + rname + "." + offset + "," + slvalue + ")");
                        break;
                    }
                    String calc = knode.toString();
                    this.addlogfunc(5, insp, sfte, fi, rname, hosttarget, typeid, slvalue, knode, opcode);
                    if (!root.isOptionSet("simulatelog")) break;
                    System.out.println("call _coins_simlog2directaccess_" + hosttarget + "(" + Type.toString(typeid) + "," + opcode + "," + calc + "." + slvalue + ")");
                    break;
                }
                String calc = knode.toString();
                this.addlogfunc(6, insp, sfte, fi, rname, hosttarget, typeid, slvalue, knode, opcode);
                if (!root.isOptionSet("simulatelog")) break;
                System.out.println("call _coins_simlog2directaccess_" + hosttarget + "(" + Type.toString(typeid) + "," + opcode + "," + calc + "." + slvalue + ")");
                break;
            }
            default: {
                String calc = knode.toString();
                this.addlogfunc(7, insp, sfte, fi, "", hosttarget, typeid, slvalue, knode, "");
                if (!root.isOptionSet("simulatelog")) break;
                System.out.println("call _coins_simlog2directaccess_" + hosttarget + "(" + Type.toString(typeid) + "," + calc + "." + slvalue + ")");
            }
        }
    }

    private void addlogfunc(int kind, BiLink insp, SimFuncTableElem sfte, int funcindex, String name, String hosttarget, int typeid, String slvalue, Object option, Object option2) {
        long gl;
        long ni;
        ImList il;
        LirFactory lir = sfte.bcghost.newLir;
        long ki = kind;
        long fi = funcindex;
        long ti = typeid;
        long ht = !hosttarget.equals("host") ? 0L : 1L;
        long sl = slvalue.equals("false") ? 0L : 1L;
        int i32 = Type.type(2, 32L);
        if (hosttarget.equals("host")) {
            if (sfte.hostlocalsymbol.get(name) != null) {
                il = (ImList)sfte.hostlocalsymbol.get(name);
                ni = ((Integer)il.elem()).intValue();
                gl = 1L;
            } else if (this.hostglobalsymbol.get(name) != null) {
                il = (ImList)this.hostglobalsymbol.get(name);
                ni = ((Integer)il.elem()).intValue();
                gl = 0L;
            } else {
                ni = -1L;
                gl = 0L;
            }
        } else if (sfte.targetlocalsymbol.get(name) != null) {
            il = (ImList)sfte.targetlocalsymbol.get(name);
            ni = ((Integer)il.elem()).intValue();
            gl = 1L;
        } else if (this.targetglobalsymbol.get(name) != null) {
            il = (ImList)this.targetglobalsymbol.get(name);
            ni = ((Integer)il.elem()).intValue();
            gl = 0L;
        } else {
            ni = -1L;
            gl = 0L;
        }
        LirNode[] argv = new LirNode[9];
        argv[0] = lir.node(47, i32, lir.node(4, i32, this.memAccessSymbol));
        argv[1] = lir.node(2, i32, ki);
        argv[2] = lir.node(2, i32, ht);
        argv[3] = lir.node(2, i32, ti);
        argv[4] = lir.node(2, i32, fi);
        argv[5] = lir.node(2, i32, ni);
        argv[6] = lir.node(2, i32, sl);
        argv[7] = lir.node(2, i32, gl);
        switch ((int)ki) {
            case 0: {
                argv[8] = lir.node(2, i32, 0L);
                break;
            }
            case 1: {
                String addsub = (String)option;
                long asi = addsub.equals("ADD") ? 0L : 1L;
                long offset = (Long)option2;
                argv[7] = lir.node(2, i32, asi);
                argv[8] = lir.node(2, i32, offset);
                break;
            }
            case 2: {
                LirNode knode = (LirNode)option;
                argv[7] = lir.makeCopy(knode);
                argv[8] = lir.node(2, i32, 0L);
                break;
            }
            case 3: {
                LirNode knode = (LirNode)option;
                argv[7] = lir.makeCopy(knode);
                argv[8] = lir.node(2, i32, 0L);
                break;
            }
            case 4: {
                String opcode = (String)option;
                long as1 = opcode.equals("ADD") ? 0L : 1L;
                LirIconst onode = (LirIconst)option2;
                argv[7] = lir.node(2, i32, as1);
                argv[8] = lir.makeCopy(onode);
                break;
            }
            case 5: {
                String opcode = (String)option;
                long as1 = opcode.equals("ADD") ? 0L : 1L;
                LirNode onode = (LirNode)option2;
                argv[7] = lir.node(2, i32, as1);
                argv[8] = lir.makeCopy(onode);
                break;
            }
            case 6: {
                LirNode enode = (LirNode)option;
                argv[7] = lir.makeCopy(enode);
                argv[8] = lir.node(2, i32, 0L);
                break;
            }
            case 7: {
                LirNode enode = (LirNode)option;
                argv[7] = lir.makeCopy(enode);
                argv[8] = lir.node(2, i32, 0L);
            }
        }
        Object retval = null;
        LirNode[] emptyVector = new LirNode[]{};
        LirNode newstatement = lir.node(53, 0, lir.node(4, i32, this.logfuncsymbol), lir.node(61, 0, argv), lir.node(61, 0, emptyVector));
        insp.addBefore(newstatement);
    }

    private void setframesize(boolean proepi, BiLink insp, SimFuncTableElem sfte, int framesize, int simCount) {
        LirFactory lir = sfte.bcghost.newLir;
        int i32 = Type.type(2, 32L);
        LirNode[] argv = new LirNode[4];
        long proorepi = proepi ? 0L : 1L;
        argv[0] = lir.node(2, i32, proorepi);
        argv[1] = lir.node(2, i32, framesize);
        long mainornot = sfte.name.equals("main") ? 1L : 0L;
        argv[2] = lir.node(2, i32, mainornot);
        argv[3] = lir.node(2, i32, simCount);
        Object retval = null;
        LirNode[] emptyVector = new LirNode[]{};
        LirNode newstatement = lir.node(53, 0, lir.node(4, i32, this.fsfuncsymbol), lir.node(61, 0, argv), lir.node(61, 0, emptyVector));
        if (proepi) {
            insp.addAfter(newstatement);
        } else {
            insp.addBefore(newstatement);
        }
    }
}

