/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sched;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Root;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.gen.CodeGenerator;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.sched.DependGraph;
import coins.backend.sched.DependNode;
import coins.backend.sched.Pipelining;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.driver.CompileSpecification;
import java.io.PrintWriter;

public class Schedule {
    public static final TriggerB before = new TriggerB();
    public static final TriggerA after = new TriggerA();
    static final int MAX_LATENCY = 100;
    Root root;
    CodeGenerator codeGen;
    Function func;
    LirFactory lir;
    PrintWriter debOut;
    boolean isX86;
    Pipelining pipe = null;
    boolean isPipelining = false;

    public static void attach(CompileSpecification spec, Root root) {
        root.addHook("+AfterToMachineCode", after);
        if (spec.getCoinsOptions().isSet("schedule")) {
            root.addHook("+AfterFirstInstSel", before);
        }
    }

    private Schedule() {
    }

    public void schedule(Function f, String mode) {
        this.func = f;
        this.lir = f.newLir;
        this.root = f.root;
        this.debOut = this.root.debOut;
        this.codeGen = this.func.module.targetMachine.getTargetCG();
        this.isX86 = this.root.spec.getCoinsOptions().getArg("target-arch").equals("x86");
        FlowGraph flowGraph = this.func.flowGraph();
        if (this.root.spec.getCoinsOptions().isSet("pipelining0") && mode == "After") {
            if (this.pipe == null) {
                this.pipe = new Pipelining(this);
            }
            this.codeGen.prepareCodeInfo(this.func);
            this.pipe.pipelining0(flowGraph);
        }
        if (this.root.spec.getCoinsOptions().isSet("pipelining") && mode == "Before") {
            this.isPipelining = true;
            if (this.pipe == null) {
                this.pipe = new Pipelining(this);
            }
        }
        this.codeGen.prepareCodeInfo(this.func);
        BiLink p = flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            block22: {
                BiList instrListSeg;
                BiList instrList;
                DependGraph dg;
                BasicBlk blk;
                block21: {
                    BiList succ;
                    blk = (BasicBlk)p.elem();
                    dg = new DependGraph(this.func);
                    instrList = new BiList();
                    boolean hasPARALLEL = false;
                    BiLink q = blk.instrList().first();
                    while (!q.atEnd()) {
                        LirNode ins = (LirNode)q.elem();
                        if (ins.opCode == 65 || ins.opCode == 66) {
                            instrList.add(ins);
                        } else {
                            DependNode dn = new DependNode(ins, this);
                            dg.add(dn);
                            switch (ins.opCode) {
                                case 54: {
                                    dn.setLatency(100);
                                    break;
                                }
                                case 55: {
                                    break;
                                }
                                case 49: 
                                case 50: {
                                    dg.hasBranch(dn);
                                }
                                default: {
                                    ImList info = this.codeGen.codeInfo(ins);
                                    dn.setLatency((Integer)info.elem2nd());
                                    dn.setMachineCodeSize((Integer)info.elem3rd());
                                    if (!((Boolean)info.elem()).booleanValue()) break;
                                    dn.letHaveDelaySlot();
                                }
                            }
                            if (ins.opCode == 56) {
                                BiList instrListSeg2;
                                hasPARALLEL = true;
                                if (this.root.traceOK("TMD", 1)) {
                                    this.debOut.println("\nDependent graph of a segment before scheduling\n");
                                    this.debOut.println(dg);
                                }
                                BiList biList = instrListSeg2 = mode == "After" ? dg.scheduleInst() : dg.scheduleLir();
                                if (this.root.traceOK("TMD", 1)) {
                                    this.debOut.println("\nList of Lir nodes after scheduling\n");
                                    this.debOut.println(instrListSeg2);
                                }
                                instrList.addAll(instrListSeg2);
                                dg.newSegment();
                            }
                        }
                        q = q.next();
                    }
                    if (this.root.traceOK("TMD", 1)) {
                        this.debOut.println("\nDependent graph of a basic block before scheduling\n");
                        this.debOut.println(dg);
                    }
                    if (!this.isPipelining || hasPARALLEL || !(succ = blk.succList()).contains(blk)) break block21;
                    if (this.pipe.pipelining(flowGraph, blk, dg, instrList)) break block22;
                    dg = this.pipe.reconstructDg(blk);
                }
                BiList biList = instrListSeg = mode == "After" ? dg.scheduleInst() : dg.scheduleLir();
                if (this.root.traceOK("TMD", 1)) {
                    this.debOut.println("\nList of Lir nodes after scheduling\n");
                    this.debOut.println(instrListSeg);
                }
                instrList.addAll(instrListSeg);
                blk.setInstrList(instrList);
            }
            p = p.next();
        }
        this.func.touch();
    }

    private static class TriggerA
    implements LocalTransformer {
        private TriggerA() {
        }

        public boolean doIt(Function func, ImList args) {
            new Schedule().schedule(func, "After");
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ScheduleAfter";
        }

        public String subject() {
            return "Instruction Scheduling (after register allocation)";
        }
    }

    private static class TriggerB
    implements LocalTransformer {
        private TriggerB() {
        }

        public boolean doIt(Function func, ImList args) {
            new Schedule().schedule(func, "Before");
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ScheduleBefore";
        }

        public String subject() {
            return "Instruction Scheduling (before register allocation)";
        }
    }
}

