/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sched;

import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.sched.DependGraph;
import coins.backend.sched.DependNode;
import coins.backend.sched.Schedule;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import java.util.ArrayList;

public class Pipelining {
    Schedule scheduler;
    LirFactory lir;
    FlowGraph flowGraph;
    BasicBlk basicBlk;
    DependGraph dependGraph;
    ResourceTable table;
    ScheduleInfo info;
    int[] latencyArray;

    public Pipelining(Schedule scheduler) {
        this.scheduler = scheduler;
        this.lir = scheduler.lir;
    }

    boolean pipelining(FlowGraph fGraph, BasicBlk bBlk, DependGraph dg, BiList instLINE) {
        if (!this.hasLargeLatency(bBlk)) {
            return false;
        }
        this.flowGraph = fGraph;
        this.basicBlk = bBlk;
        this.dependGraph = dg;
        try {
            this.scheduleBranchAndDepend();
            ArrayList selectedList = this.selectFromSchedulable();
            this.scheduleNodesOfSelectedList(selectedList);
            this.scheduleDependentNode();
            this.scheduleRemainingSchedulableNodes();
            if (this.scheduler.root.traceOK("TMD", 1)) {
                this.scheduler.debOut.println("\n-------loop kernel--------\n");
                this.scheduler.debOut.println(this.table.toString());
            }
            if (this.table.getMaxStage() == 0) {
                return false;
            }
            this.constructPipelinedBlocks(instLINE);
        }
        catch (PipeliningException pe) {
            if (this.scheduler.root.traceOK("TMD", 1)) {
                this.scheduler.debOut.println(pe);
                this.scheduler.debOut.println(dg);
            }
            return false;
        }
        return true;
    }

    boolean hasLargeLatency(BasicBlk bBlk) {
        BiLink q = bBlk.instrList().first();
        while (!q.atEnd()) {
            LirNode ins = (LirNode)q.elem();
            ImList info = this.scheduler.codeGen.codeInfo(ins);
            int cost = (Integer)info.elem2nd();
            if (4 <= cost) {
                return true;
            }
            q = q.next();
        }
        return false;
    }

    void scheduleBranchAndDepend() {
        int i;
        int listLength = this.dependGraph.schedulable.length() + this.dependGraph.unSchedulable.length();
        this.info = new ScheduleInfo(this.dependGraph.schedulable, this.dependGraph.unSchedulable);
        DependNode lastBranch = this.dependGraph.lastBranch;
        BiList list_1 = new BiList();
        this.info.addAllDependTo(list_1, lastBranch);
        list_1.sort();
        Object[] sortedArray = list_1.toArray();
        this.latencyArray = new int[sortedArray.length];
        DependNode dn = (DependNode)sortedArray[this.latencyArray.length - 1];
        this.latencyArray[this.latencyArray.length - 1] = dn.latency;
        for (i = this.latencyArray.length - 2; i >= 0; --i) {
            dn = (DependNode)sortedArray[i];
            int iLatency = 1 + this.latencyArray[i + 1];
            for (int j = i + 1; j < this.latencyArray.length; ++j) {
                DependNode jNode = (DependNode)sortedArray[j];
                if (!jNode.trueDependOn.contains(dn) || dn.latency + this.latencyArray[j] <= iLatency) continue;
                iLatency = dn.latency + this.latencyArray[j];
            }
            this.latencyArray[i] = iLatency;
        }
        if (this.latencyArray[0] >= listLength) {
            listLength = this.latencyArray[0] + 1;
        }
        this.table = new ResourceTable(listLength);
        this.info.placeAt(lastBranch, 0, listLength - 1);
        for (i = this.latencyArray.length - 1; i >= 0; --i) {
            dn = (DependNode)sortedArray[i];
            this.info.placeAt(dn, 0, listLength - 1 - this.latencyArray[i]);
        }
    }

    ArrayList selectFromSchedulable() {
        ArrayList<ScheduledNode> selectedList = new ArrayList<ScheduledNode>();
        for (int i = 0; i < this.info.schedulable.size(); ++i) {
            ScheduledNode sn = (ScheduledNode)this.info.schedulable.get(i);
            DependNode temp = sn.node;
            if (temp.beDepended.length() <= 0) continue;
            selectedList.add(sn);
        }
        return selectedList;
    }

    void scheduleNodesOfSelectedList(ArrayList selectedList) {
        boolean beginAtMiddle = this.latencyArray[0] > this.table.size / 2;
        int index = beginAtMiddle ? this.table.size / 2 : this.table.size - 2;
        for (int i = 0; i < selectedList.size(); ++i) {
            ScheduledNode temp = (ScheduledNode)selectedList.get(i);
            index = beginAtMiddle ? this.info.placeAtOrAfter(temp, index) : this.info.placeAtOrBefore(temp, index);
            this.info.removeFromSchedulable(temp);
            this.info.eraseDependent(temp);
        }
    }

    void scheduleDependentNode() {
        while (true) {
            ScheduledNode sn;
            if (!this.info.scheduleFirst.isEmpty()) {
                sn = (ScheduledNode)this.info.scheduleFirst.get(this.info.scheduleFirst.size() - 1);
                this.info.scheduleFirst.remove(sn);
                this.table.setWithReason(sn);
                this.info.eraseDependent(sn);
                continue;
            }
            while (!this.info.scheduleSecond.isEmpty()) {
                sn = (ScheduledNode)this.info.scheduleSecond.get(this.info.scheduleSecond.size() - 1);
                this.info.scheduleSecond.remove(sn);
                this.table.setWithFalseDepend(sn);
                this.info.eraseDependent(sn);
            }
            if (this.info.scheduleFirst.isEmpty()) break;
        }
    }

    void scheduleRemainingSchedulableNodes() {
        int tableIndex = 0;
        for (int i = 0; i < this.info.schedulable.size(); ++i) {
            ScheduledNode sn = (ScheduledNode)this.info.schedulable.get(i);
            tableIndex = this.info.placeAtOrAfter(sn, tableIndex);
        }
    }

    void constructPipelinedBlocks(BiList instLINE) {
        BiList inst;
        int i;
        ArrayList kernel = this.table.table;
        LirNode jumpNext = null;
        BasicBlk[] epilogue = new BasicBlk[this.table.getMaxStage()];
        for (int i2 = epilogue.length - 1; i2 >= 0; --i2) {
            epilogue[i2] = i2 == epilogue.length - 1 ? this.flowGraph.insertNewBlkBefore(this.basicBlk) : this.flowGraph.insertNewBlkBefore(epilogue[i2 + 1]);
        }
        BasicBlk loop = this.flowGraph.insertNewBlkBefore(epilogue[0]);
        BasicBlk[] prologue = new BasicBlk[this.table.getMaxStage()];
        for (int i3 = prologue.length - 1; i3 >= 0; --i3) {
            prologue[i3] = i3 == prologue.length - 1 ? this.flowGraph.insertNewBlkBefore(loop) : this.flowGraph.insertNewBlkBefore(prologue[i3 + 1]);
        }
        BiList succ = this.basicBlk.succList();
        BiLink suc = succ.first();
        while (!suc.atEnd()) {
            BasicBlk block = (BasicBlk)suc.elem();
            if (block != this.basicBlk) {
                epilogue[epilogue.length - 1].addEdge(block);
                jumpNext = this.lir.node(49, 0, this.lir.labelRef(block.label()));
            }
            suc = suc.next();
        }
        epilogue[epilogue.length - 1].removeEdge(this.basicBlk);
        this.basicBlk.clearEdges();
        this.flowGraph.basicBlkList.remove(this.basicBlk);
        BiList pred = this.basicBlk.predList();
        BiLink pre = pred.first();
        while (!pre.atEnd()) {
            BasicBlk block = (BasicBlk)pre.elem();
            BiList instList = block.instrList();
            LirNode last = (LirNode)instList.last().elem();
            if (last.isBranch()) {
                instList.remove(last);
                if (last.opCode == 49) {
                    instList.add(this.lir.node(49, last.type, this.lir.labelRef(prologue[0].label())));
                } else if (last.opCode == 50) {
                    Label[] targets = last.getTargets();
                    if (targets[0] == this.basicBlk.label()) {
                        instList.add(this.lir.node(50, last.type, last.kid(0), this.lir.labelRef(prologue[0].label()), this.lir.labelRef(targets[1])));
                    } else {
                        instList.add(this.lir.node(50, last.type, last.kid(0), this.lir.labelRef(targets[0]), this.lir.labelRef(prologue[0].label())));
                    }
                }
                block.removeEdge(this.basicBlk);
                block.addEdge(prologue[0]);
            }
            pre = pre.next();
        }
        for (i = 0; i < prologue.length; ++i) {
            inst = new BiList();
            if (i == 0) {
                inst.addAll(instLINE);
            }
            for (int j = 0; j < this.table.size; ++j) {
                ScheduledNode sn = this.table.get(j);
                if (sn == null) continue;
                if (j == this.table.size - 1) {
                    LirNode lastInst = sn.node.instr;
                    LirNode testInst = lastInst.kid(0);
                    if (i == prologue.length - 1) {
                        inst.add(this.lir.node(lastInst.opCode, lastInst.type, this.lir.node(this.reverseOp(testInst.opCode), testInst.type, testInst.kid(0), testInst.kid(1)), this.lir.labelRef(epilogue[epilogue.length - i - 1].label()), this.lir.labelRef(loop.label())));
                        continue;
                    }
                    inst.add(this.lir.node(lastInst.opCode, lastInst.type, this.lir.node(this.reverseOp(testInst.opCode), testInst.type, testInst.kid(0), testInst.kid(1)), this.lir.labelRef(epilogue[epilogue.length - i - 1].label()), this.lir.labelRef(prologue[i + 1].label())));
                    continue;
                }
                if (sn.pIndex.stage > i) continue;
                inst.add(this.getLirNodeFromDependent(sn.node));
            }
            prologue[i].setInstrList(inst);
        }
        inst = new BiList();
        for (i = 0; i < this.table.size; ++i) {
            ScheduledNode sn = this.table.get(i);
            if (sn == null) continue;
            if (i == this.table.size - 1) {
                LirNode lastInst = sn.node.instr;
                inst.add(this.lir.node(lastInst.opCode, lastInst.type, lastInst.kid(0), this.lir.labelRef(loop.label()), this.lir.labelRef(epilogue[0].label())));
                continue;
            }
            inst.add(this.getLirNodeFromDependent(sn.node));
        }
        loop.setInstrList(inst);
        for (i = 0; i < epilogue.length; ++i) {
            inst = new BiList();
            int prologueIndex = epilogue.length - 1 - i;
            for (int j = prologueIndex + 1; j <= epilogue.length; ++j) {
                for (int k = 0; k < this.table.size; ++k) {
                    ScheduledNode sn = this.table.get(k);
                    if (sn == null || sn.pIndex.stage != j) continue;
                    inst.add(this.getLirNodeFromDependent(sn.node));
                }
            }
            if (i == epilogue.length - 1) {
                inst.add(jumpNext);
            } else {
                inst.add(this.lir.node(49, 0, this.lir.labelRef(epilogue[i + 1].label())));
            }
            epilogue[i].setInstrList(inst);
        }
        loop.maintEdges();
        for (i = 0; i < this.table.getMaxStage(); ++i) {
            prologue[i].maintEdges();
            epilogue[i].maintEdges();
        }
        this.scheduler.func.touch();
    }

    DependGraph reconstructDg(BasicBlk blk) {
        DependGraph dg = new DependGraph(this.scheduler.func);
        BiList instrList = new BiList();
        BiLink q = blk.instrList().first();
        while (!q.atEnd()) {
            LirNode ins = (LirNode)q.elem();
            if (ins.opCode == 65 || ins.opCode == 66) {
                instrList.add(ins);
            } else {
                DependNode dn = new DependNode(ins, this.scheduler);
                dg.add(dn);
                switch (ins.opCode) {
                    case 54: {
                        dn.setLatency(100);
                        break;
                    }
                    case 55: {
                        break;
                    }
                    case 49: 
                    case 50: {
                        dg.hasBranch(dn);
                    }
                    default: {
                        ImList info = this.scheduler.codeGen.codeInfo(ins);
                        dn.setLatency((Integer)info.elem2nd());
                    }
                }
            }
            q = q.next();
        }
        return dg;
    }

    LirNode getLirNodeFromDependent(DependNode node) {
        LirNode original = node.instr;
        int n = original.nKids();
        int opcode = original.opCode;
        int type = original.type;
        switch (n) {
            case 0: {
                return this.lir.node(opcode, type);
            }
            case 1: {
                return this.lir.node(opcode, type, original.kid(0));
            }
            case 2: {
                return this.lir.node(opcode, type, original.kid(0), original.kid(1));
            }
            case 3: {
                return this.lir.node(opcode, type, original.kid(0), original.kid(1), original.kid(2));
            }
        }
        return null;
    }

    int reverseOp(int op) {
        switch (op) {
            case 35: {
                return 36;
            }
            case 36: {
                return 35;
            }
            case 40: {
                return 37;
            }
            case 37: {
                return 40;
            }
            case 44: {
                return 41;
            }
            case 41: {
                return 44;
            }
            case 39: {
                return 38;
            }
            case 38: {
                return 39;
            }
            case 43: {
                return 42;
            }
            case 42: {
                return 43;
            }
        }
        return op;
    }

    BiList getLoopBlks(FlowGraph flowGraph) {
        BiList list = new BiList();
        BiLink p = flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList succ = blk.succList();
            if (succ.contains(blk)) {
                list.add(blk);
            }
            p = p.next();
        }
        return list;
    }

    BiList eliminatingUnnecessaryLoop(BiList list) {
        BiList newList = new BiList();
        BiLink p = list.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            boolean flag = false;
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                ImList info = this.scheduler.codeGen.codeInfo(ins);
                int cost = (Integer)info.elem2nd();
                if (ins.opCode == 56) {
                    flag = false;
                    break;
                }
                if (4 <= cost) {
                    flag = true;
                }
                q = q.next();
            }
            if (flag) {
                newList.add(blk);
            }
            p = p.next();
        }
        return newList;
    }

    void pipelining0(FlowGraph flowGraph) {
        BiList list = this.eliminatingUnnecessaryLoop(this.getLoopBlks(flowGraph));
        if (list.isEmpty()) {
            return;
        }
        BiLink p = list.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList dependent = new BiList();
            int max = 0;
            DependNode maxNode = null;
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                DependNode dn = new DependNode(ins, this.scheduler);
                ImList info = this.scheduler.codeGen.codeInfo(ins);
                int latency = (Integer)info.elem2nd();
                dn.setLatency(latency);
                if (max < latency && ins.opCode != 50) {
                    maxNode = dn;
                    max = latency;
                }
                dependent.add(dn);
                q = q.next();
            }
            BiLink i = dependent.first();
            while (!i.atEnd()) {
                BiLink j = i.next();
                while (!j.atEnd()) {
                    ((DependNode)j.elem()).dependOn((DependNode)i.elem());
                    j = j.next();
                }
                i = i.next();
            }
            if (maxNode != null) {
                BiList prologueList = maxNode.dependOn(dependent);
                prologueList.add(maxNode);
                DependNode lastNode = (DependNode)dependent.last().elem();
                BiList branchList = new BiList();
                BiLink i2 = lastNode.dependOn(dependent).first();
                while (!i2.atEnd()) {
                    if (!prologueList.contains(i2.elem())) {
                        branchList.add(i2.elem());
                    }
                    i2 = i2.next();
                }
                branchList.add(lastNode);
                prologueList.concatenate(branchList.copy());
                BiList epilogueList = new BiList();
                BiLink i3 = dependent.first();
                while (!i3.atEnd()) {
                    DependNode temp = (DependNode)i3.elem();
                    if (!prologueList.contains(temp) && !branchList.contains(temp)) {
                        epilogueList.add(temp);
                    }
                    i3 = i3.next();
                }
                if (epilogueList.length() != 0) {
                    BiList loopList = epilogueList.copy();
                    loopList.concatenate(prologueList.copy());
                    LirNode lastInstr = null;
                    BasicBlk epilogue = flowGraph.insertNewBlkBefore(blk);
                    BasicBlk loopKernel = flowGraph.insertNewBlkBefore(epilogue);
                    BasicBlk prologue = flowGraph.insertNewBlkBefore(loopKernel);
                    BiList succ = blk.succList();
                    BiLink suc = succ.first();
                    while (!suc.atEnd()) {
                        BasicBlk block = (BasicBlk)suc.elem();
                        if (block != blk) {
                            epilogue.addEdge(block);
                            lastInstr = this.lir.node(49, 0, this.lir.labelRef(block.label()));
                        }
                        suc = suc.next();
                    }
                    epilogue.removeEdge(blk);
                    blk.clearEdges();
                    flowGraph.basicBlkList.remove(blk);
                    BiList pred = blk.predList();
                    BiLink pre = pred.first();
                    while (!pre.atEnd()) {
                        BasicBlk block = (BasicBlk)pre.elem();
                        BiList instList = block.instrList();
                        LirNode lastBranch = (LirNode)instList.last().elem();
                        if (lastBranch.isBranch()) {
                            instList.remove(lastBranch);
                            if (lastBranch.opCode == 49) {
                                instList.add(this.lir.node(49, lastBranch.type, this.lir.labelRef(prologue.label())));
                            } else if (lastBranch.opCode == 50) {
                                Label[] targets = lastBranch.getTargets();
                                if (targets[0] == blk.label()) {
                                    instList.add(this.lir.node(50, lastBranch.type, lastBranch.kid(0), this.lir.labelRef(prologue.label()), this.lir.labelRef(targets[1])));
                                } else {
                                    instList.add(this.lir.node(50, lastBranch.type, lastBranch.kid(0), this.lir.labelRef(targets[0]), this.lir.labelRef(prologue.label())));
                                }
                            }
                            block.removeEdge(blk);
                        }
                        pre = pre.next();
                    }
                    BiList newLoop = new BiList();
                    BiLink i4 = loopList.first();
                    while (!i4.atEnd()) {
                        DependNode temp = (DependNode)i4.elem();
                        if (i4 == loopList.last()) {
                            newLoop.add(this.lir.node(temp.instr.opCode, temp.instr.type, temp.instr.kid(0), this.lir.labelRef(loopKernel.label()), this.lir.labelRef(epilogue.label())));
                        } else {
                            newLoop.add(this.getLirNodeFromDependent(temp));
                        }
                        i4 = i4.next();
                    }
                    BiList newPrologue = new BiList();
                    BiLink i5 = prologueList.first();
                    while (!i5.atEnd()) {
                        DependNode temp = (DependNode)i5.elem();
                        if (i5 == prologueList.last()) {
                            LirNode lastInst = temp.instr;
                            LirNode testInst = lastInst.kid(0);
                            newPrologue.add(this.lir.node(lastInst.opCode, lastInst.type, this.lir.node(this.reverseOp(testInst.opCode), testInst.type, testInst.kid(0), testInst.kid(1)), this.lir.labelRef(epilogue.label()), this.lir.labelRef(loopKernel.label())));
                        } else {
                            newPrologue.add(this.getLirNodeFromDependent(temp));
                        }
                        i5 = i5.next();
                    }
                    BiList newEpilogue = new BiList();
                    BiLink i6 = epilogueList.first();
                    while (!i6.atEnd()) {
                        DependNode temp = (DependNode)i6.elem();
                        newEpilogue.add(this.getLirNodeFromDependent(temp));
                        i6 = i6.next();
                    }
                    newEpilogue.add(lastInstr);
                    loopKernel.setInstrList(newLoop);
                    prologue.setInstrList(newPrologue);
                    epilogue.setInstrList(newEpilogue);
                    loopKernel.maintEdges();
                    prologue.maintEdges();
                    epilogue.maintEdges();
                }
            }
            p = p.next();
        }
        this.scheduler.func.touch();
    }

    class ScheduleInfo {
        ArrayList scheduleFirst = new ArrayList();
        ArrayList scheduleSecond = new ArrayList();
        ArrayList schedulable = new ArrayList();
        ArrayList unschedulable = new ArrayList();
        ArrayList removed = new ArrayList();

        ScheduleInfo(BiList sch, BiList unsch) {
            BiLink i = sch.first();
            while (!i.atEnd()) {
                this.schedulable.add(new ScheduledNode((DependNode)i.elem()));
                i = i.next();
            }
            i = unsch.first();
            while (!i.atEnd()) {
                this.unschedulable.add(new ScheduledNode((DependNode)i.elem()));
                i = i.next();
            }
        }

        void addAllDependTo(BiList list, DependNode dn) {
            DependNode dn1;
            BiLink n = dn.trueDependOn.first();
            while (!n.atEnd()) {
                dn1 = (DependNode)n.elem();
                if (!list.contains(dn1)) {
                    list.add(dn1);
                    this.addAllDependTo(list, dn1);
                }
                n = n.next();
            }
            n = dn.falseDependOn.first();
            while (!n.atEnd()) {
                dn1 = (DependNode)n.elem();
                if (!list.contains(dn1)) {
                    list.add(dn1);
                    this.addAllDependTo(list, dn1);
                }
                n = n.next();
            }
        }

        void removeFromSchedulable(ScheduledNode node) {
            DependNode dn = node.node;
            for (int i = 0; i < this.schedulable.size(); ++i) {
                ScheduledNode sn = (ScheduledNode)this.schedulable.get(i);
                if (!dn.equals(sn.node)) continue;
                this.schedulable.remove(sn);
                this.removed.add(sn);
                return;
            }
        }

        void removeFromUnschedulable(ScheduledNode node) {
            DependNode dn = node.node;
            for (int i = 0; i < this.unschedulable.size(); ++i) {
                ScheduledNode sn = (ScheduledNode)this.unschedulable.get(i);
                if (!dn.equals(sn.node)) continue;
                this.unschedulable.remove(sn);
                this.removed.add(sn);
                return;
            }
        }

        void remove(ScheduledNode node) {
            this.removeFromUnschedulable(node);
            this.removeFromSchedulable(node);
        }

        boolean isRemoved(ScheduledNode node) {
            for (int i = 0; i < this.removed.size(); ++i) {
                ScheduledNode sn = (ScheduledNode)this.removed.get(i);
                if (!node.equals(sn)) continue;
                return true;
            }
            return false;
        }

        void eraseDependent(ScheduledNode node) {
            int index = node.pIndex.index;
            DependNode dn = node.node;
            for (int i = 0; i < this.unschedulable.size(); ++i) {
                ScheduledNode unschTemp = (ScheduledNode)this.unschedulable.get(i);
                DependNode unschNode = unschTemp.node;
                if (unschNode.trueDependOn.contains(dn)) {
                    unschNode.trueDependOn.remove(dn);
                    unschTemp.reasons.add(new Reason(node, true));
                    if (unschNode.trueDependOn.isEmpty() && unschNode.falseDependOn.isEmpty()) {
                        this.scheduleFirst.add(unschTemp);
                        this.unschedulable.remove(unschTemp);
                        --i;
                    }
                }
                if (!unschNode.falseDependOn.contains(dn)) continue;
                unschNode.falseDependOn.remove(dn);
                unschTemp.reasons.add(new Reason(node, false));
                if (!unschNode.trueDependOn.isEmpty() || !unschNode.falseDependOn.isEmpty()) continue;
                boolean isAdded = false;
                for (int j = 0; j < unschTemp.reasons.size(); ++j) {
                    Reason reason = (Reason)unschTemp.reasons.get(j);
                    if (isAdded || !reason.isTrueDepend) continue;
                    this.scheduleFirst.add(unschTemp);
                    isAdded = true;
                }
                if (!isAdded) {
                    this.scheduleSecond.add(unschTemp);
                }
                this.unschedulable.remove(unschTemp);
                --i;
            }
        }

        void placeAt(DependNode dn, int stage, int index) {
            ScheduledNode node = new ScheduledNode(dn, stage, index);
            Pipelining.this.table.set(node);
            this.eraseDependent(node);
            this.remove(node);
        }

        int placeAtOrBefore(ScheduledNode sn, int index) {
            int i;
            for (i = index; i >= 0 && Pipelining.this.table.get(i) != null; --i) {
            }
            if (i < 0) {
                throw new PipeliningException("can not placeAtOrBefore " + index);
            }
            Pipelining.this.table.set(sn, 0, i);
            return i;
        }

        int placeAtOrAfter(ScheduledNode sn, int index) {
            int i;
            for (i = index; i < Pipelining.this.table.size && Pipelining.this.table.get(i) != null; ++i) {
            }
            if (i < Pipelining.this.table.size) {
                Pipelining.this.table.set(sn, 0, i);
                return i;
            }
            return this.placeAtOrBefore(sn, index);
        }

        PairIndex placeAtOrAfter(ScheduledNode sn, PairIndex pi) {
            int i;
            for (i = pi.index; i < Pipelining.this.table.size && Pipelining.this.table.get(i) != null; ++i) {
            }
            if (i < Pipelining.this.table.size) {
                Pipelining.this.table.set(sn, pi.stage, i);
                return new PairIndex(pi.stage, i);
            }
            return this.placeAtOrAfter(sn, new PairIndex(pi.stage + 1, 0));
        }

        public String toString() {
            ScheduledNode temp;
            int i;
            StringBuffer sb = new StringBuffer("\n---------ScheduleInfo---------\n");
            sb.append("schedulable\n");
            for (i = 0; i < this.schedulable.size(); ++i) {
                temp = (ScheduledNode)this.schedulable.get(i);
                sb.append(temp.toString() + "\n");
            }
            sb.append("unschedulable\n");
            for (i = 0; i < this.unschedulable.size(); ++i) {
                temp = (ScheduledNode)this.unschedulable.get(i);
                sb.append(temp.toString() + "\n");
            }
            sb.append("scheduleFirst\n");
            for (i = 0; i < this.scheduleFirst.size(); ++i) {
                temp = (ScheduledNode)this.scheduleFirst.get(i);
                sb.append(temp.toString() + "\n");
            }
            sb.append("scheduleSecond\n");
            for (i = 0; i < this.scheduleSecond.size(); ++i) {
                temp = (ScheduledNode)this.scheduleSecond.get(i);
                sb.append(temp.toString() + "\n");
            }
            return sb.toString();
        }
    }

    class PipeliningException
    extends RuntimeException {
        PipeliningException(String s) {
            super(s);
        }
    }

    class ResourceTable {
        ArrayList table;
        int size;

        ResourceTable(int length) {
            this.table = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                this.table.add(null);
            }
            this.size = length;
        }

        ScheduledNode get(int index) {
            return (ScheduledNode)this.table.get(index);
        }

        void set(ScheduledNode sn) {
            this.table.set(sn.pIndex.index, sn);
        }

        void set(ScheduledNode sn, int stage, int index) {
            sn.setPairIndex(stage, index);
            this.table.set(index, sn);
        }

        void set(ScheduledNode sn, PairIndex pi) {
            sn.setPairIndex(pi);
            this.table.set(pi.index, sn);
        }

        void add(ScheduledNode sn, PairIndex pi) {
            this.table.add(pi.index, sn);
            sn.setPairIndex(pi);
            this.size = this.table.size();
            for (int i = pi.index; i < this.size; ++i) {
                ScheduledNode sni = (ScheduledNode)this.table.get(i);
                if (sni == null) continue;
                sni.pIndex.index = i;
            }
        }

        int setWithReason(ScheduledNode sn) {
            ScheduledNode currentNode;
            PairIndex baseMin;
            ArrayList list = sn.reasons;
            int latency = 0;
            if (!sn.hasReasonWithTrueDepend()) {
                return this.setWithFalseDepend(sn);
            }
            Reason r = (Reason)list.get(0);
            PairIndex baseMax = baseMin = r.node.pIndex;
            latency = r.isTrueDepend ? r.node.node.latency : 1;
            PairIndex maxPair = baseMax.add(latency);
            for (int i = 1; i < list.size(); ++i) {
                r = (Reason)list.get(i);
                PairIndex current = new PairIndex(r.node.pIndex.stage, r.node.pIndex.index);
                if (current.lessThan(baseMin)) {
                    baseMin = current;
                } else if (current.greaterThan(baseMax)) {
                    baseMax = current;
                }
                latency = r.isTrueDepend ? r.node.node.latency : 1;
                current = current.add(latency);
                if (!current.greaterThan(maxPair)) continue;
                maxPair = current;
            }
            int range = baseMax.distanceFrom(baseMin);
            if (range < 0 || range >= this.size - 1) {
                if (range == this.size - 1) {
                    this.add(sn, baseMax.incrementIndex());
                    return baseMax.index;
                }
                throw new PipeliningException("too large dependent range " + range + sn.toString());
            }
            PairIndex lastPair = baseMin.copy().incrementStage();
            PairIndex start = maxPair;
            if (lastPair.lessThan(maxPair)) {
                start = lastPair.copy().decrementIndex();
            }
            PairIndex current = start.copy();
            while (current.lessThan(lastPair)) {
                currentNode = (ScheduledNode)this.table.get(current.index);
                if (currentNode == null) {
                    this.set(sn, current);
                    return current.index;
                }
                current.incrementIndex();
            }
            current = start.copy().decrementIndex();
            while (current.greaterThan(baseMax)) {
                currentNode = (ScheduledNode)this.table.get(current.index);
                if (currentNode == null) {
                    this.set(sn, current);
                    return current.index;
                }
                current.decrementIndex();
            }
            this.add(sn, start);
            return start.index;
        }

        int setWithFalseDepend(ScheduledNode sn) {
            PairIndex baseMin;
            ArrayList list = sn.reasons;
            Reason r = (Reason)list.get(0);
            PairIndex baseMax = baseMin = r.node.pIndex;
            for (int i = 1; i < list.size(); ++i) {
                r = (Reason)list.get(i);
                PairIndex current = new PairIndex(r.node.pIndex.stage, r.node.pIndex.index);
                if (current.lessThan(baseMin)) {
                    baseMin = current;
                    continue;
                }
                if (!current.greaterThan(baseMax)) continue;
                baseMax = current;
            }
            int range = baseMax.distanceFrom(baseMin);
            if (range < 0 || range >= this.table.size() - 1) {
                if (range == this.size) {
                    this.add(sn, baseMax.incrementIndex());
                } else {
                    throw new PipeliningException("too large dependent range " + range + sn.toString());
                }
            }
            PairIndex lastPair = baseMin.copy().incrementStage();
            PairIndex start = baseMax.add(1);
            PairIndex current = start.copy();
            while (current.lessThan(lastPair)) {
                ScheduledNode currentNode = (ScheduledNode)this.table.get(current.index);
                if (currentNode == null) {
                    this.set(sn, current);
                    return current.index;
                }
                current.incrementIndex();
            }
            this.add(sn, start);
            return start.index;
        }

        int getMaxStage() {
            int max = 0;
            for (int i = 0; i < this.size; ++i) {
                ScheduledNode sn = (ScheduledNode)this.table.get(i);
                if (sn == null || max >= sn.pIndex.stage) continue;
                max = sn.pIndex.stage;
            }
            return max;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("\n-----------ResourceTable-------\n");
            for (int i = 0; i < this.table.size(); ++i) {
                ScheduledNode sn = (ScheduledNode)this.table.get(i);
                if (sn == null) continue;
                sb.append("\n" + sn.toString());
            }
            return sb.toString();
        }
    }

    class Reason {
        ScheduledNode node;
        boolean isTrueDepend;

        Reason(ScheduledNode sn, boolean isT) {
            this.node = sn;
            this.isTrueDepend = isT;
        }

        public String toString() {
            String trueOrFalse = "false on ";
            if (this.isTrueDepend) {
                trueOrFalse = "false on ";
            }
            return trueOrFalse + this.node.pIndex.toString();
        }
    }

    class ScheduledNode {
        DependNode node;
        PairIndex pIndex;
        ArrayList reasons;

        ScheduledNode(DependNode dn) {
            this.node = dn;
            this.pIndex = null;
            this.reasons = new ArrayList();
        }

        ScheduledNode(DependNode dn, PairIndex pi) {
            this.node = dn;
            this.pIndex = pi;
            this.reasons = new ArrayList();
        }

        ScheduledNode(DependNode dn, int stage, int index) {
            this.node = dn;
            this.pIndex = new PairIndex(stage, index);
            this.reasons = new ArrayList();
        }

        void setPairIndex(int stage, int index) {
            this.pIndex = new PairIndex(stage, index);
        }

        void setPairIndex(PairIndex pi) {
            this.pIndex = pi;
        }

        boolean hasReasonWithTrueDepend() {
            for (int i = 0; i < this.reasons.size(); ++i) {
                Reason r = (Reason)this.reasons.get(i);
                if (!r.isTrueDepend) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer("scheduled node:");
            if (this.pIndex == null) {
                bf.append("not scheduled\n" + this.node.toString());
            } else {
                bf.append(this.pIndex.toString() + "\n" + this.node.toString());
            }
            bf.append("\nreasons\n");
            for (int i = 0; i < this.reasons.size(); ++i) {
                bf.append(((Reason)this.reasons.get(i)).toString() + "\n");
            }
            return bf.toString();
        }
    }

    class PairIndex {
        int stage;
        int index;

        PairIndex(int s, int i) {
            this.stage = s;
            this.index = i;
        }

        PairIndex add(int i) {
            PairIndex result = new PairIndex(this.stage, this.index);
            result.index += i;
            if (result.index >= Pipelining.this.table.size) {
                result.index -= Pipelining.this.table.size;
                ++result.stage;
                if (result.index >= Pipelining.this.table.size) {
                    result.index = Pipelining.this.table.size - 1;
                }
            }
            return result;
        }

        boolean lessThan(PairIndex other) {
            return this.stage < other.stage || this.stage == other.stage && this.index < other.index;
        }

        boolean greaterThan(PairIndex other) {
            return this.stage > other.stage || this.stage == other.stage && this.index > other.index;
        }

        PairIndex incrementIndex() {
            ++this.index;
            if (this.index >= Pipelining.this.table.size) {
                this.index = 0;
                ++this.stage;
            }
            return this;
        }

        PairIndex incrementStage() {
            ++this.stage;
            return this;
        }

        PairIndex decrementIndex() {
            --this.index;
            if (this.index < 0) {
                this.index = Pipelining.this.table.size - 1;
                --this.stage;
            }
            return this;
        }

        PairIndex copy() {
            return new PairIndex(this.stage, this.index);
        }

        int distanceFrom(PairIndex p) {
            return (this.stage - p.stage) * Pipelining.this.table.size + (this.index - p.index);
        }

        public String toString() {
            return "stage:" + this.stage + ", index:" + this.index;
        }
    }
}

