/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.regalo;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Root;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.opt.Ssa;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.backend.util.UnionFind;

public class LiveRange {
    public static final Trigger trig = new Trigger();
    private Function func;
    private Root root;
    private UnionFind ufo;
    private Symbol[] symVector;

    private LiveRange(Function func) {
        this.func = func;
        this.root = func.root;
    }

    private void doIt(ImList args) {
        LirNode ins;
        BiLink q;
        BasicBlk blk;
        this.func.apply(Ssa.trigger("pruned"), args);
        this.symVector = this.func.symVector();
        this.ufo = new UnionFind(this.symVector.length);
        boolean[] used = new boolean[this.symVector.length];
        BiLink p = this.func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                ins = (LirNode)q.elem();
                if (ins.opCode == 59) {
                    Symbol dst = ((LirSymRef)ins.kid((int)0)).symbol;
                    int n = ins.nKids();
                    for (int i = 1; i < n; ++i) {
                        if (ins.kid((int)i).kid((int)0).opCode != 6) continue;
                        Symbol src = ((LirSymRef)ins.kid((int)i).kid((int)0)).symbol;
                        this.join(dst, src);
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
        p = this.func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                ins = (LirNode)q.elem();
                BiLink next = q.next();
                if (ins.opCode == 59) {
                    q.unlink();
                } else {
                    this.renameRegvars(ins, used);
                }
                q = next;
            }
            p = p.next();
        }
        p = this.func.localSymtab.symbols().first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            if (sym.storage == 2 && !used[sym.id]) {
                this.func.localSymtab.remove(sym);
            }
            p = p.next();
        }
    }

    private void renameRegvars(LirNode tree, boolean[] used) {
        int n = tree.nKids();
        for (int i = 0; i < n; ++i) {
            if (tree.kid((int)i).opCode == 6) {
                Symbol old = ((LirSymRef)tree.kid((int)i)).symbol;
                Symbol neu = this.nameof(old);
                if (neu != old) {
                    tree.setKid(i, this.func.newLir.symRef(neu));
                    used[neu.id] = true;
                    continue;
                }
                used[old.id] = true;
                continue;
            }
            this.renameRegvars(tree.kid(i), used);
        }
    }

    Symbol nameof(Symbol x) {
        return this.symVector[this.ufo.find(x.id)];
    }

    void join(Symbol x, Symbol y) {
        int iy;
        int ix = this.ufo.find(x.id);
        if (ix != (iy = this.ufo.find(y.id))) {
            int i = this.ufo.union(ix, iy);
            this.symVector[i] = ix < iy ? this.symVector[ix] : this.symVector[iy];
        }
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new LiveRange(func).doIt(args);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "LiveRange";
        }

        public String subject() {
            return "Live Range Identification";
        }
    }
}

