/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class JumpCanon {
    public static final Trigger trig = new Trigger();

    public void doIt(Function f) {
        FlowGraph g = f.flowGraph();
        LirFactory newLir = f.newLir;
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BiLink lastp;
            BasicBlk blk = (BasicBlk)p.elem();
            BasicBlk nextblk = null;
            if (!p.next().atEnd()) {
                nextblk = (BasicBlk)p.next().elem();
            }
            if (!(lastp = blk.instrList().last()).atEnd()) {
                Label[] targets;
                LirNode ins = (LirNode)lastp.elem();
                if (ins.opCode == 50 && (targets = ins.getTargets())[1].basicBlk() != nextblk) {
                    if (targets[0].basicBlk() == nextblk) {
                        int testOp = this.flipCondition(ins.kid((int)0).opCode);
                        ins.setKid(0, newLir.operator(testOp, ins.kid((int)0).type, ins.kid(0).kid(0), ins.kid(0).kid(1), null));
                        LirNode temp = ins.kid(1);
                        ins.setKid(1, ins.kid(2));
                        ins.setKid(2, temp);
                    } else {
                        BasicBlk newblk = f.flowGraph().insertNewBlkBefore(nextblk);
                        LirNode jmp = (LirNode)newblk.instrList().last().elem();
                        jmp.setKid(0, ins.kid(2));
                        ins.setKid(2, f.newLir.labelRef(newblk.label()));
                        newblk.maintEdges();
                        blk.maintEdges();
                    }
                }
            }
            p = p.next();
        }
    }

    private int flipCondition(int testOp) {
        switch (testOp) {
            case 35: {
                return 36;
            }
            case 36: {
                return 35;
            }
            case 37: {
                return 40;
            }
            case 38: {
                return 39;
            }
            case 39: {
                return 38;
            }
            case 40: {
                return 37;
            }
            case 41: {
                return 44;
            }
            case 42: {
                return 43;
            }
            case 43: {
                return 42;
            }
            case 44: {
                return 41;
            }
        }
        throw new IllegalArgumentException("non-test op");
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new JumpCanon().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "JumpCanon";
        }

        public String subject() {
            return "Jump Instruction Canonicalization";
        }
    }
}

