/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.IoRoot;
import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Transformer;
import coins.backend.Type;
import coins.backend.ana.SaveRegisters;
import coins.backend.asmpp.CPU;
import coins.backend.asmpp.LiteralAndBranchProcessor;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.gen.CodeGenerator;
import coins.backend.gen.Rule;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Label;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.Misc;
import coins.backend.util.NumberSet;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.CompileThread;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerator_arm
extends CodeGenerator {
    State[] stateVec;
    private RewrState[] rewrStates;
    private static final Rule[] rulev = new Rule[297];
    boolean isSimulate = false;
    final LocalTransformer testJumpcTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            FlowGraph cfg = func.flowGraph();
            BiLink p = cfg.basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                BiLink inst = blk.instrList().first();
                while (!inst.atEnd()) {
                    LirNode lir = (LirNode)inst.elem();
                    if (lir.opCode == 50) {
                        CodeGenerator_arm.this.examineJUMPC(p, lir);
                    }
                    inst = inst.next();
                }
                p = p.next();
            }
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "TestJumpc";
        }

        public String subject() {
            return "Examin conditional jump";
        }
    };
    private static final int MAX_COND_LEN = 8;
    private LiteralAndBranchProcessor pp;
    ImList regCallClobbers = new ImList(ImList.list("REG", "I32", "%r0"), new ImList(ImList.list("REG", "I32", "%r1"), new ImList(ImList.list("REG", "I32", "%r2"), new ImList(ImList.list("REG", "I32", "%r3"), new ImList(ImList.list("REG", "I32", "%ip"), ImList.list(ImList.list("REG", "I32", "%lr"), ImList.list("REG", "F64", "%f0"), ImList.list("REG", "F64", "%f1"), ImList.list("REG", "F64", "%f2"), ImList.list("REG", "F64", "%f3")))))));
    int decompMax = 4;
    int tmpCnt = 0;
    Map conditionalExec = new HashMap();
    Map jumpcInfo = new HashMap();
    static final int I64;
    static final int I32;
    static final int I16;
    static final int I8;
    static final int F64;
    static final int F32;
    static final int MAXREGPARAM = 4;
    static final int REGWIDTH = 4;
    static final int CALLEE_SAVE = 28;
    static final String NEED_OFFSET_REWRITE = "&vframe";
    static final String[] paramRegv;
    static final Map flipCc;
    ArmConst ximm = null;
    private Map peepHoleOpts = new HashMap();
    PeepHoleOp decompMov = new PeepHoleOp(){

        boolean doIt(ImList inst, BiLink l) {
            long imm = (Long)CodeGenerator_arm.this.nth(inst, 2);
            Object dst = CodeGenerator_arm.this.car(CodeGenerator_arm.this.cdr(inst));
            ArmConst val = new ArmConst(imm);
            ArmConst val2 = new ArmConst(imm ^ 0xFFFFFFFFFFFFFFFFL);
            val.normalize();
            val2.normalize();
            if (val2.nofBytes == 1) {
                this.addBefore(ImList.list("mvn", dst, "#" + val2.get(0)), l);
            } else {
                this.addBefore(ImList.list("mov", dst, "#" + val.get(0)), l);
                for (int i = 1; i < val.nofBytes; ++i) {
                    this.addBefore(ImList.list("orr", dst, dst, "#" + val.get(i)), l);
                }
            }
            return true;
        }
    };
    PeepHoleOp decompAdd = new PeepHoleOp(){

        boolean doIt(ImList inst, BiLink l) {
            Object mnemo = CodeGenerator_arm.this.nth(inst, 1);
            Object mnemo2 = CodeGenerator_arm.this.nth(inst, 2);
            Object dst = CodeGenerator_arm.this.nth(inst, 3);
            Object src = CodeGenerator_arm.this.nth(inst, 4);
            long imm = (Long)CodeGenerator_arm.this.nth(inst, 5);
            ArmConst val = new ArmConst(imm);
            ArmConst val2 = new ArmConst(-imm);
            val.normalize();
            val2.normalize();
            if (val2.nofBytes < val.nofBytes) {
                val = val2;
                mnemo = mnemo2;
            }
            for (int i = 0; i < val.nofBytes; ++i) {
                this.addBefore(ImList.list(mnemo, dst, src, "#" + val.get(i)), l);
                src = dst;
            }
            return true;
        }
    };
    PeepHoleOp decompOr = new PeepHoleOp(){

        boolean doIt(ImList inst, BiLink l) {
            CodeGenerator_arm.this.logop(inst, l, false);
            return true;
        }
    };
    PeepHoleOp decompBic = new PeepHoleOp(){

        boolean doIt(ImList inst, BiLink l) {
            CodeGenerator_arm.this.logop(inst, l, true);
            return true;
        }
    };

    void initRewriteLabeling() {
        this.rewrStates = new RewrState[0];
    }

    private void setRewrStates(int index, RewrState v) {
        if (index >= this.rewrStates.length) {
            RewrState[] w = new RewrState[Misc.clp2(index + 1)];
            for (int i = 0; i < this.rewrStates.length; ++i) {
                w[i] = this.rewrStates[i];
            }
            this.rewrStates = w;
        }
        this.rewrStates[index] = v;
    }

    private RewrState getRewrStates(int index) {
        if (index < this.rewrStates.length) {
            return this.rewrStates[index];
        }
        return null;
    }

    LirNode rewriteTree(LirNode tree, String phase, BiList pre, BiList post) {
        RewrState s = this.getRewrStates(tree.id);
        if (s != null && !s.rewritten) {
            return tree;
        }
        while (true) {
            int n = this.nActualOperands(tree);
            RewrState[] kidst = new RewrState[n];
            for (int i = 0; i < n; ++i) {
                LirNode r = this.rewriteTree(tree.kid(i), phase, pre, post);
                if (r != tree.kid(i)) {
                    tree.setKid(i, r);
                }
                kidst[i] = this.getRewrStates(tree.kid((int)i).id);
            }
            s = new RewrState();
            this.setRewrStates(tree.id, s);
            if (this.disableRewrite.contains(tree.id)) {
                return tree;
            }
            LirNode newTree = s.labelAndRewrite(tree, kidst, phase, pre, post);
            if (newTree == null) {
                return tree;
            }
            tree = newTree;
        }
    }

    private static void rrinit0() {
        CodeGenerator_arm.rulev[30] = new Rule(30, true, false, 22, "30: base -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[35] = new Rule(35, true, false, 25, "35: index -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[148] = new Rule(148, true, false, 49, "148: orop -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[150] = new Rule(150, true, false, 50, "150: opop -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[152] = new Rule(152, true, false, 51, "152: logop -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[154] = new Rule(154, true, false, 52, "154: cmpop -> regw", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[4] = new Rule(4, true, false, 1, "4: regw -> xregw", null, null, null, 0L, false, false, new int[]{8}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[7] = new Rule(7, true, false, 2, "7: regh -> xregh", null, null, null, 0L, false, false, new int[]{9}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[10] = new Rule(10, true, false, 3, "10: regb -> xregb", null, null, null, 0L, false, false, new int[]{10}, new String[]{"*reg-I8*", null});
        CodeGenerator_arm.rulev[13] = new Rule(13, true, false, 4, "13: regf -> xregf", null, null, null, 0L, false, false, new int[]{11}, new String[]{"*reg-F32*", null});
        CodeGenerator_arm.rulev[16] = new Rule(16, true, false, 5, "16: regd -> xregd", null, null, null, 0L, false, false, new int[]{12}, new String[]{"*reg-F64*", null});
        CodeGenerator_arm.rulev[18] = new Rule(18, true, false, 14, "18: cnst -> cbu", null, null, null, 0L, false, false, new int[]{13}, new String[]{null, null});
        CodeGenerator_arm.rulev[72] = new Rule(72, true, false, 3, "72: regb -> cbu", ImList.list(ImList.list("mov", "$0", ImList.list("u0", "$1"))), null, null, 0L, false, false, new int[]{13}, new String[]{"*reg-I8*", null});
        CodeGenerator_arm.rulev[24] = new Rule(24, true, false, 18, "24: asmcnst -> cnst", null, null, null, 0L, false, false, new int[]{14}, new String[]{null, null});
        CodeGenerator_arm.rulev[20] = new Rule(20, true, false, 14, "20: cnst -> ch", null, null, null, 0L, false, false, new int[]{15}, new String[]{null, null});
        CodeGenerator_arm.rulev[74] = new Rule(74, true, false, 2, "74: regh -> ch", ImList.list(ImList.list("mov", "$0", ImList.list("h0", "$1")), ImList.list("orr", "$0", "$0", ImList.list("b1", "$1"))), null, null, 0L, false, false, new int[]{15}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[22] = new Rule(22, true, false, 14, "22: cnst -> cw", null, null, null, 0L, false, false, new int[]{16}, new String[]{null, null});
        CodeGenerator_arm.rulev[75] = new Rule(75, true, false, 1, "75: regw -> cw", ImList.list(ImList.list("ldr", "$0", ImList.list("lit", "$1"))), null, null, 0L, false, false, new int[]{16}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[69] = new Rule(69, true, false, 1, "69: regw -> sta", ImList.list(ImList.list("ldr", "$0", ImList.list("lit", "$1"))), null, null, 0L, false, false, new int[]{17}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[70] = new Rule(70, true, false, 1, "70: regw -> asmcnst", ImList.list(ImList.list("ldr", "$0", ImList.list("lit", "$1"))), null, null, 0L, false, false, new int[]{18}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[73] = new Rule(73, true, false, 2, "73: regh -> ximm1", ImList.list(ImList.list("mov", "$0", ImList.list("b0", "$1"))), null, null, 0L, false, false, new int[]{19}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[76] = new Rule(76, true, false, 1, "76: regw -> ximm", ImList.list(ImList.list("_mov", "$0", "$1")), null, null, 0L, false, false, new int[]{21}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[52] = new Rule(52, true, false, 35, "52: addr2 -> base", null, ImList.list(ImList.list("amode2", "$1", ImList.list())), null, 0L, false, false, new int[]{22}, new String[]{null, null});
        CodeGenerator_arm.rulev[60] = new Rule(60, true, false, 36, "60: addr3 -> base", null, ImList.list(ImList.list("amode3", "$1", ImList.list())), null, 0L, false, false, new int[]{22}, new String[]{null, null});
        CodeGenerator_arm.rulev[33] = new Rule(33, true, false, 25, "33: index -> imm8", null, null, null, 0L, false, false, new int[]{23}, new String[]{null, null});
        CodeGenerator_arm.rulev[34] = new Rule(34, true, false, 25, "34: index -> imm12", null, null, null, 0L, false, false, new int[]{24}, new String[]{null, null});
        CodeGenerator_arm.rulev[79] = new Rule(79, true, false, 1, "79: regw -> memw", ImList.list(ImList.list("ldr", "$0", "$1")), null, null, 0L, false, false, new int[]{37}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[77] = new Rule(77, true, false, 3, "77: regb -> memb", ImList.list(ImList.list("ldrb", "$0", "$1")), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I8*", null});
        CodeGenerator_arm.rulev[78] = new Rule(78, true, false, 2, "78: regh -> memh", ImList.list(ImList.list("ldrh", "$0", "$1")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[141] = new Rule(141, true, false, 49, "141: orop -> imm8r", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{45}, new String[]{null, null});
        CodeGenerator_arm.rulev[142] = new Rule(142, true, false, 50, "142: opop -> imm8r", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{45}, new String[]{null, null});
        CodeGenerator_arm.rulev[144] = new Rule(144, true, false, 51, "144: logop -> imm8r", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{45}, new String[]{null, null});
        CodeGenerator_arm.rulev[146] = new Rule(146, true, false, 52, "146: cmpop -> imm8r", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{45}, new String[]{null, null});
        CodeGenerator_arm.rulev[143] = new Rule(143, true, false, 50, "143: opop -> imm8rm", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{46}, new String[]{null, null});
        CodeGenerator_arm.rulev[147] = new Rule(147, true, false, 52, "147: cmpop -> imm8rm", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{46}, new String[]{null, null});
        CodeGenerator_arm.rulev[145] = new Rule(145, true, false, 51, "145: logop -> imm8rn", null, ImList.list(ImList.list("hash", ImList.list("pls", "$1"))), null, 0L, false, false, new int[]{47}, new String[]{null, null});
        CodeGenerator_arm.rulev[149] = new Rule(149, true, false, 49, "149: orop -> sregw", null, null, null, 0L, false, false, new int[]{48}, new String[]{null, null});
        CodeGenerator_arm.rulev[151] = new Rule(151, true, false, 50, "151: opop -> sregw", null, null, null, 0L, false, false, new int[]{48}, new String[]{null, null});
        CodeGenerator_arm.rulev[153] = new Rule(153, true, false, 51, "153: logop -> sregw", null, null, null, 0L, false, false, new int[]{48}, new String[]{null, null});
        CodeGenerator_arm.rulev[155] = new Rule(155, true, false, 52, "155: cmpop -> sregw", null, null, null, 0L, false, false, new int[]{48}, new String[]{null, null});
        CodeGenerator_arm.rulev[206] = new Rule(206, true, false, 4, "206: regf -> cnstf", ImList.list(ImList.list("ldfs", "$0", ImList.list("litf", "$1"))), null, null, 0L, false, false, new int[]{63}, new String[]{"*reg-F32*", null});
        CodeGenerator_arm.rulev[239] = new Rule(239, true, false, 5, "239: regd -> cnstd", ImList.list(ImList.list("ldfd", "$0", ImList.list("litd", "$1"))), null, null, 0L, false, false, new int[]{64}, new String[]{"*reg-F64*", null});
        CodeGenerator_arm.rulev[207] = new Rule(207, true, false, 4, "207: regf -> memf", ImList.list(ImList.list("ldfs", "$0", "$1")), null, null, 0L, false, false, new int[]{65}, new String[]{"*reg-F32*", null});
        CodeGenerator_arm.rulev[240] = new Rule(240, true, false, 5, "240: regd -> memd", ImList.list(ImList.list("ldfd", "$0", "$1")), null, null, 0L, false, false, new int[]{76}, new String[]{"*reg-F64*", null});
        CodeGenerator_arm.rulev[17] = new Rule(17, false, false, 13, "17: cbu -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[19] = new Rule(19, false, false, 15, "19: ch -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[21] = new Rule(21, false, false, 16, "21: cw -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[27] = new Rule(27, false, false, 19, "27: ximm1 -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[28] = new Rule(28, false, false, 20, "28: xmimm -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[29] = new Rule(29, false, false, 21, "29: ximm -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[31] = new Rule(31, false, false, 23, "31: imm8 -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[32] = new Rule(32, false, false, 24, "32: imm12 -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[110] = new Rule(110, false, false, 45, "110: imm8r -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[111] = new Rule(111, false, false, 46, "111: imm8rm -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[112] = new Rule(112, false, false, 47, "112: imm8rn -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[36] = new Rule(36, false, true, 27, "36: _1 -> (INTCONST I32 1)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[38] = new Rule(38, false, true, 28, "38: _2 -> (INTCONST I32 2)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[40] = new Rule(40, false, true, 29, "40: _3 -> (INTCONST I32 3)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[42] = new Rule(42, false, true, 30, "42: _4 -> (INTCONST I32 4)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[44] = new Rule(44, false, true, 31, "44: _5 -> (INTCONST I32 5)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[46] = new Rule(46, false, true, 32, "46: _6 -> (INTCONST I32 6)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[48] = new Rule(48, false, true, 33, "48: _7 -> (INTCONST I32 7)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[50] = new Rule(50, false, true, 34, "50: _8 -> (INTCONST I32 8)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[203] = new Rule(203, false, false, 63, "203: cnstf -> (FLOATCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[204] = new Rule(204, false, false, 64, "204: cnstd -> (FLOATCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[23] = new Rule(23, false, false, 17, "23: sta -> (STATIC I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[8] = new Rule(8, false, false, 10, "8: xregb -> (REG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[5] = new Rule(5, false, false, 9, "5: xregh -> (REG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[2] = new Rule(2, false, false, 8, "2: xregw -> (REG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[275] = new Rule(275, false, true, 87, "275: _42 -> (REG I32 \"%sp\")", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_arm.rulev[11] = new Rule(11, false, false, 11, "11: xregf -> (REG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[14] = new Rule(14, false, false, 12, "14: xregd -> (REG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[9] = new Rule(9, false, false, 10, "9: xregb -> (SUBREG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[6] = new Rule(6, false, false, 9, "6: xregh -> (SUBREG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[3] = new Rule(3, false, false, 8, "3: xregw -> (SUBREG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[12] = new Rule(12, false, false, 11, "12: xregf -> (SUBREG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[15] = new Rule(15, false, false, 12, "15: xregd -> (SUBREG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[1] = new Rule(1, false, false, 7, "1: label -> (LABEL _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_arm.rulev[178] = new Rule(178, false, false, 1, "178: regw -> (NEG I32 regw)", ImList.list(ImList.list("rsb", "$0", "$1", ImList.list("hash", "0"))), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[209] = new Rule(209, false, false, 4, "209: regf -> (NEG F32 regf)", ImList.list(ImList.list("mnfs", "$0", "$1")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-F32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[242] = new Rule(242, false, false, 5, "242: regd -> (NEG F64 regd)", ImList.list(ImList.list("mnfd", "$0", "$1")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-F64*", "*reg-F64*"});
        CodeGenerator_arm.rulev[25] = new Rule(25, false, false, 18, "25: asmcnst -> (ADD I32 asmcnst cnst)", null, ImList.list(ImList.list("+", "$1", "$2")), null, 0L, false, false, new int[]{18, 14}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[53] = new Rule(53, false, false, 35, "53: addr2 -> (ADD I32 base imm12)", null, ImList.list(ImList.list("amode2", "%fp", ImList.list("hash", ImList.list("adjDisp", ImList.list("pls", "$2"))))), null, 0L, false, false, new int[]{22, 24}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[54] = new Rule(54, false, false, 35, "54: addr2 -> (ADD I32 base imm12)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("hash", ImList.list("pls", "$2")))), null, 0L, false, false, new int[]{22, 24}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[56] = new Rule(56, false, false, 35, "56: addr2 -> (ADD I32 base index)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("pind", "$2"))), null, 0L, false, false, new int[]{22, 25}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[58] = new Rule(58, false, false, 35, "58: addr2 -> (ADD I32 base sindex)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("pind", "$2"))), null, 0L, false, false, new int[]{22, 26}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[61] = new Rule(61, false, false, 36, "61: addr3 -> (ADD I32 base imm8)", null, ImList.list(ImList.list("amode3", "%fp", ImList.list("hash", ImList.list("adjDisp", ImList.list("pls", "$2"))))), null, 0L, false, false, new int[]{22, 23}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[62] = new Rule(62, false, false, 36, "62: addr3 -> (ADD I32 base imm8)", null, ImList.list(ImList.list("amode3", "$1", ImList.list("hash", ImList.list("pls", "$2")))), null, 0L, false, false, new int[]{22, 23}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[113] = new Rule(113, false, false, 1, "113: regw -> (ADD I32 regw xmimm)", ImList.list(ImList.list("sub", "$0", "%fp", ImList.list("vb0", "$2")), ImList.list("sub", "$0", "$0", ImList.list("vb1", "$2")), ImList.list("sub", "$0", "$0", ImList.list("vb2", "$2")), ImList.list("sub", "$0", "$0", ImList.list("vb3", "$2"))), null, null, 0L, false, false, new int[]{1, 20}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[156] = new Rule(156, false, false, 1, "156: regw -> (ADD I32 regw opop)", ImList.list(ImList.list("add", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 50}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[166] = new Rule(166, false, false, 1, "166: regw -> (ADD I32 regw ximm)", ImList.list(new ImList("_add", ImList.list("add", "sub", "$0", "$1", "$2"))), null, null, 0L, false, false, new int[]{1, 21}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[288] = new Rule(288, false, true, 98, "288: _53 -> (ADD I32 _42 _4)", null, null, null, 0L, false, false, new int[]{87, 30}, null);
        CodeGenerator_arm.rulev[293] = new Rule(293, false, true, 102, "293: _57 -> (ADD I32 _42 _8)", null, null, null, 0L, false, false, new int[]{87, 34}, null);
        CodeGenerator_arm.rulev[210] = new Rule(210, false, false, 4, "210: regf -> (ADD F32 regf regf)", ImList.list(ImList.list("adfs", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{4, 4}, new String[]{"*reg-F32*", "*reg-F32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[243] = new Rule(243, false, false, 5, "243: regd -> (ADD F64 regd regd)", ImList.list(ImList.list("adfd", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{5, 5}, new String[]{"*reg-F64*", "*reg-F64*", "*reg-F64*"});
        CodeGenerator_arm.rulev[26] = new Rule(26, false, false, 18, "26: asmcnst -> (SUB I32 asmcnst cnst)", null, ImList.list(ImList.list("-", "$1", "$2")), null, 0L, false, false, new int[]{18, 14}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[55] = new Rule(55, false, false, 35, "55: addr2 -> (SUB I32 base imm12)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("hash", ImList.list("neg", "$2")))), null, 0L, false, false, new int[]{22, 24}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[57] = new Rule(57, false, false, 35, "57: addr2 -> (SUB I32 base index)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("mind", "$2"))), null, 0L, false, false, new int[]{22, 25}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[59] = new Rule(59, false, false, 35, "59: addr2 -> (SUB I32 base sindex)", null, ImList.list(ImList.list("amode2", "$1", ImList.list("mind", "$2"))), null, 0L, false, false, new int[]{22, 26}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[63] = new Rule(63, false, false, 36, "63: addr3 -> (SUB I32 base imm8)", null, ImList.list(ImList.list("amode3", "$1", ImList.list("hash", ImList.list("neg", "$2")))), null, 0L, false, false, new int[]{22, 23}, new String[]{null, null, null});
    }

    private static void rrinit100() {
        CodeGenerator_arm.rulev[157] = new Rule(157, false, false, 1, "157: regw -> (SUB I32 regw opop)", ImList.list(ImList.list("sub", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 50}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[159] = new Rule(159, false, false, 1, "159: regw -> (SUB I32 orop regw)", ImList.list(ImList.list("rsb", "$0", "$2", "$1")), null, null, 0L, false, false, new int[]{49, 1}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_arm.rulev[167] = new Rule(167, false, false, 1, "167: regw -> (SUB I32 regw ximm)", ImList.list(new ImList("_add", ImList.list("sub", "add", "$0", "$1", "$2"))), null, null, 0L, false, false, new int[]{1, 21}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[276] = new Rule(276, false, true, 88, "276: _43 -> (SUB I32 _42 _4)", null, null, null, 0L, false, false, new int[]{87, 30}, null);
        CodeGenerator_arm.rulev[281] = new Rule(281, false, true, 92, "281: _47 -> (SUB I32 _42 _8)", null, null, null, 0L, false, false, new int[]{87, 34}, null);
        CodeGenerator_arm.rulev[211] = new Rule(211, false, false, 4, "211: regf -> (SUB F32 regf regf)", ImList.list(ImList.list("sufs", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{4, 4}, new String[]{"*reg-F32*", "*reg-F32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[244] = new Rule(244, false, false, 5, "244: regd -> (SUB F64 regd regd)", ImList.list(ImList.list("sufd", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{5, 5}, new String[]{"*reg-F64*", "*reg-F64*", "*reg-F64*"});
        CodeGenerator_arm.rulev[169] = new Rule(169, false, false, 1, "169: regw -> (MUL I32 regw regw)", ImList.list(ImList.list("mul", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 1}, new String[]{"*reg-nlr-I32*", "*reg-lr-I32*", "*reg-nlr-I32*"});
        CodeGenerator_arm.rulev[212] = new Rule(212, false, false, 4, "212: regf -> (MUL F32 regf regf)", ImList.list(ImList.list("mufs", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{4, 4}, new String[]{"*reg-F32*", "*reg-F32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[245] = new Rule(245, false, false, 5, "245: regd -> (MUL F64 regd regd)", ImList.list(ImList.list("mufd", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{5, 5}, new String[]{"*reg-F64*", "*reg-F64*", "*reg-F64*"});
        CodeGenerator_arm.rulev[170] = new Rule(170, false, false, 1, "170: regw -> (DIVS I32 regw regw)", ImList.list(ImList.list("bl", "__divsi3")), null, ImList.list(ImList.list("REG", "I32", "%r1"), ImList.list("REG", "I32", "%r2"), ImList.list("REG", "I32", "%r3"), ImList.list("REG", "I32", "%ip"), ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 1}, new String[]{"*reg-r0-I32*", "*reg-r0-I32*", "*reg-r1-I32*"});
        CodeGenerator_arm.rulev[213] = new Rule(213, false, false, 4, "213: regf -> (DIVS F32 regf regf)", ImList.list(ImList.list("dvfs", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{4, 4}, new String[]{"*reg-F32*", "*reg-F32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[246] = new Rule(246, false, false, 5, "246: regd -> (DIVS F64 regd regd)", ImList.list(ImList.list("dvfd", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{5, 5}, new String[]{"*reg-F64*", "*reg-F64*", "*reg-F64*"});
        CodeGenerator_arm.rulev[171] = new Rule(171, false, false, 1, "171: regw -> (DIVU I32 regw regw)", ImList.list(ImList.list("bl", "__udivsi3")), null, ImList.list(ImList.list("REG", "I32", "%r1"), ImList.list("REG", "I32", "%r2"), ImList.list("REG", "I32", "%r3"), ImList.list("REG", "I32", "%ip"), ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 1}, new String[]{"*reg-r0-I32*", "*reg-r0-I32*", "*reg-r1-I32*"});
        CodeGenerator_arm.rulev[172] = new Rule(172, false, false, 1, "172: regw -> (MODS I32 regw regw)", ImList.list(ImList.list("bl", "__modsi3")), null, ImList.list(ImList.list("REG", "I32", "%r1"), ImList.list("REG", "I32", "%r2"), ImList.list("REG", "I32", "%r3"), ImList.list("REG", "I32", "%ip"), ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 1}, new String[]{"*reg-r0-I32*", "*reg-r0-I32*", "*reg-r1-I32*"});
        CodeGenerator_arm.rulev[173] = new Rule(173, false, false, 1, "173: regw -> (MODU I32 regw regw)", ImList.list(ImList.list("bl", "__umodsi3")), null, ImList.list(ImList.list("REG", "I32", "%r1"), ImList.list("REG", "I32", "%r2"), ImList.list("REG", "I32", "%r3"), ImList.list("REG", "I32", "%ip"), ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 1}, new String[]{"*reg-r0-I32*", "*reg-r0-I32*", "*reg-r1-I32*"});
        CodeGenerator_arm.rulev[85] = new Rule(85, false, false, 2, "85: regh -> (CONVSX I16 memsb)", ImList.list(ImList.list("ldrsb", "$0", "$1")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[106] = new Rule(106, false, false, 2, "106: regh -> (CONVSX I16 regb)", ImList.list(ImList.list("mov", "$0", ImList.list("lsl", "$1", ImList.list("hash", "24"))), ImList.list("mov", "$0", ImList.list("asr", "$0", ImList.list("hash", "24")))), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I16*", "*reg-I8*"});
        CodeGenerator_arm.rulev[82] = new Rule(82, false, false, 1, "82: regw -> (CONVSX I32 memsb)", ImList.list(ImList.list("ldrsb", "$0", "$1")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[83] = new Rule(83, false, false, 1, "83: regw -> (CONVSX I32 memh)", ImList.list(ImList.list("ldrsh", "$0", "$1")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[104] = new Rule(104, false, false, 1, "104: regw -> (CONVSX I32 regb)", ImList.list(ImList.list("mov", "$0", ImList.list("lsl", "$1", ImList.list("hash", "24"))), ImList.list("mov", "$0", ImList.list("asr", "$0", ImList.list("hash", "24")))), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I32*", "*reg-I8*"});
        CodeGenerator_arm.rulev[105] = new Rule(105, false, false, 1, "105: regw -> (CONVSX I32 regh)", ImList.list(ImList.list("mov", "$0", ImList.list("lsl", "$1", ImList.list("hash", "16"))), ImList.list("mov", "$0", ImList.list("asr", "$0", ImList.list("hash", "16")))), null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I32*", "*reg-I16*"});
        CodeGenerator_arm.rulev[84] = new Rule(84, false, false, 2, "84: regh -> (CONVZX I16 memb)", ImList.list(ImList.list("ldrb", "$0", "$1")), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[103] = new Rule(103, false, false, 2, "103: regh -> (CONVZX I16 regb)", null, null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I16*", "*reg-I8*"});
        CodeGenerator_arm.rulev[80] = new Rule(80, false, false, 1, "80: regw -> (CONVZX I32 memb)", ImList.list(ImList.list("ldrb", "$0", "$1")), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[81] = new Rule(81, false, false, 1, "81: regw -> (CONVZX I32 memh)", ImList.list(ImList.list("ldrh", "$0", "$1")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I32*", null});
        CodeGenerator_arm.rulev[101] = new Rule(101, false, false, 1, "101: regw -> (CONVZX I32 regh)", null, null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I32*", "*reg-I16*"});
        CodeGenerator_arm.rulev[102] = new Rule(102, false, false, 1, "102: regw -> (CONVZX I32 regb)", null, null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I32*", "*reg-I8*"});
        CodeGenerator_arm.rulev[86] = new Rule(86, false, false, 3, "86: regb -> (CONVIT I8 memw3)", ImList.list(ImList.list("ldrb", "$0", "$1")), null, null, 0L, false, false, new int[]{38}, new String[]{"*reg-I8*", null});
        CodeGenerator_arm.rulev[88] = new Rule(88, false, false, 3, "88: regb -> (CONVIT I8 memh)", ImList.list(ImList.list("ldrb", "$0", "$1")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I8*", null});
        CodeGenerator_arm.rulev[92] = new Rule(92, false, true, 42, "92: _9 -> (CONVIT I8 regw)", null, null, null, 0L, false, false, new int[]{1}, null);
        CodeGenerator_arm.rulev[94] = new Rule(94, false, true, 43, "94: _10 -> (CONVIT I8 regh)", null, null, null, 0L, false, false, new int[]{2}, null);
        CodeGenerator_arm.rulev[107] = new Rule(107, false, false, 3, "107: regb -> (CONVIT I8 regw)", ImList.list(ImList.list("and", "$0", "$1", "#255")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I8*", "*reg-I32*"});
        CodeGenerator_arm.rulev[108] = new Rule(108, false, false, 3, "108: regb -> (CONVIT I8 regh)", ImList.list(ImList.list("and", "$0", "$1", "#255")), null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I8*", "*reg-I16*"});
        CodeGenerator_arm.rulev[87] = new Rule(87, false, false, 2, "87: regh -> (CONVIT I16 memw3)", ImList.list(ImList.list("ldrh", "$0", "$1")), null, null, 0L, false, false, new int[]{38}, new String[]{"*reg-I16*", null});
        CodeGenerator_arm.rulev[96] = new Rule(96, false, true, 44, "96: _11 -> (CONVIT I16 regw)", null, null, null, 0L, false, false, new int[]{1}, null);
        CodeGenerator_arm.rulev[109] = new Rule(109, false, false, 2, "109: regh -> (CONVIT I16 regw)", ImList.list(ImList.list("mov", "$0", ImList.list("lsl", "$1", ImList.list("hash", "16"))), ImList.list("mov", "$0", ImList.list("lsr", "$0", ImList.list("hash", "16")))), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I16*", "*reg-I32*"});
        CodeGenerator_arm.rulev[271] = new Rule(271, false, false, 5, "271: regd -> (CONVFX F64 regf)", ImList.list(ImList.list("mvfd", "$0", "$1")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-F64*", "*reg-F32*"});
        CodeGenerator_arm.rulev[272] = new Rule(272, false, false, 4, "272: regf -> (CONVFT F32 regd)", ImList.list(ImList.list("mvfs", "$0", "$1")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-F32*", "*reg-F64*"});
        CodeGenerator_arm.rulev[236] = new Rule(236, false, false, 3, "236: regb -> (CONVFS I8 regf)", ImList.list(ImList.list("fixz", "$0", "$1"), ImList.list("and", "$0", "$0", "#255")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I8*", "*reg-F32*"});
        CodeGenerator_arm.rulev[269] = new Rule(269, false, false, 3, "269: regb -> (CONVFS I8 regd)", ImList.list(ImList.list("fixz", "$0", "$1"), ImList.list("and", "$0", "$0", "#255")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-I8*", "*reg-F64*"});
        CodeGenerator_arm.rulev[235] = new Rule(235, false, false, 2, "235: regh -> (CONVFS I16 regf)", ImList.list(ImList.list("fixz", "$0", "$1"), ImList.list("mov", "$0", ImList.list("lsl", "$0", ImList.list("hash", "16"))), ImList.list("mov", "$0", ImList.list("lsr", "$0", ImList.list("hash", "16")))), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I16*", "*reg-F32*"});
        CodeGenerator_arm.rulev[268] = new Rule(268, false, false, 2, "268: regh -> (CONVFS I16 regd)", ImList.list(ImList.list("fixz", "$0", "$1"), ImList.list("mov", "$0", ImList.list("lsl", "$0", ImList.list("hash", "16"))), ImList.list("mov", "$0", ImList.list("lsr", "$0", ImList.list("hash", "16")))), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-I16*", "*reg-F64*"});
        CodeGenerator_arm.rulev[234] = new Rule(234, false, false, 1, "234: regw -> (CONVFS I32 regf)", ImList.list(ImList.list("fixz", "$0", "$1")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I32*", "*reg-F32*"});
        CodeGenerator_arm.rulev[267] = new Rule(267, false, false, 1, "267: regw -> (CONVFS I32 regd)", ImList.list(ImList.list("fixz", "$0", "$1")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-I32*", "*reg-F64*"});
        CodeGenerator_arm.rulev[237] = new Rule(237, false, false, 4, "237: regf -> (CONVSF F32 regw)", ImList.list(ImList.list("flts", "$0", "$1")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-F32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[270] = new Rule(270, false, false, 5, "270: regd -> (CONVSF F64 regw)", ImList.list(ImList.list("fltd", "$0", "$1")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-F64*", "*reg-I32*"});
        CodeGenerator_arm.rulev[158] = new Rule(158, false, false, 1, "158: regw -> (BAND I32 regw logop)", ImList.list(ImList.list("and", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 51}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[168] = new Rule(168, false, false, 1, "168: regw -> (BAND I32 regw ximm)", ImList.list(ImList.list("_bic", "bic", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 21}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[160] = new Rule(160, false, false, 1, "160: regw -> (BOR I32 regw imm8rm)", ImList.list(ImList.list("mov", "%lr", ImList.list("hash", "$2")), ImList.list("orr", "$0", "$1", "%lr")), null, ImList.list(ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 46}, new String[]{"*reg-nlr-I32*", "*reg-nlr-I32*", null});
        CodeGenerator_arm.rulev[161] = new Rule(161, false, false, 1, "161: regw -> (BOR I32 regw orop)", ImList.list(ImList.list("orr", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 49}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[164] = new Rule(164, false, false, 1, "164: regw -> (BOR I32 regw ximm)", ImList.list(ImList.list("_or", "orr", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 21}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[162] = new Rule(162, false, false, 1, "162: regw -> (BXOR I32 regw imm8rm)", ImList.list(ImList.list("mov", "%lr", ImList.list("hash", "$2")), ImList.list("eor", "$0", "$1", "%lr")), null, ImList.list(ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{1, 46}, new String[]{"*reg-nlr-I32*", "*reg-nlr-I32*", null});
        CodeGenerator_arm.rulev[163] = new Rule(163, false, false, 1, "163: regw -> (BXOR I32 regw orop)", ImList.list(ImList.list("eor", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 49}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[165] = new Rule(165, false, false, 1, "165: regw -> (BXOR I32 regw ximm)", ImList.list(ImList.list("_or", "eor", "$0", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 21}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[177] = new Rule(177, false, false, 1, "177: regw -> (BNOT I32 regw)", ImList.list(ImList.list("mvn", "$0", "$1")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[37] = new Rule(37, false, false, 26, "37: sindex -> (LSHS I32 regw _1)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "1"))), null, 0L, false, false, new int[]{1, 27}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[39] = new Rule(39, false, false, 26, "39: sindex -> (LSHS I32 regw _2)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "2"))), null, 0L, false, false, new int[]{1, 28}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[41] = new Rule(41, false, false, 26, "41: sindex -> (LSHS I32 regw _3)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "3"))), null, 0L, false, false, new int[]{1, 29}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[43] = new Rule(43, false, false, 26, "43: sindex -> (LSHS I32 regw _4)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "4"))), null, 0L, false, false, new int[]{1, 30}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[45] = new Rule(45, false, false, 26, "45: sindex -> (LSHS I32 regw _5)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "5"))), null, 0L, false, false, new int[]{1, 31}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[47] = new Rule(47, false, false, 26, "47: sindex -> (LSHS I32 regw _6)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "6"))), null, 0L, false, false, new int[]{1, 32}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[49] = new Rule(49, false, false, 26, "49: sindex -> (LSHS I32 regw _7)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "7"))), null, 0L, false, false, new int[]{1, 33}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[51] = new Rule(51, false, false, 26, "51: sindex -> (LSHS I32 regw _8)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "8"))), null, 0L, false, false, new int[]{1, 34}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[114] = new Rule(114, false, false, 48, "114: sregw -> (LSHS I32 regw _1)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "1"))), null, 0L, false, false, new int[]{1, 27}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[117] = new Rule(117, false, false, 48, "117: sregw -> (LSHS I32 regw _2)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "2"))), null, 0L, false, false, new int[]{1, 28}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[120] = new Rule(120, false, false, 48, "120: sregw -> (LSHS I32 regw _3)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "3"))), null, 0L, false, false, new int[]{1, 29}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[123] = new Rule(123, false, false, 48, "123: sregw -> (LSHS I32 regw _4)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "4"))), null, 0L, false, false, new int[]{1, 30}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[126] = new Rule(126, false, false, 48, "126: sregw -> (LSHS I32 regw _5)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "5"))), null, 0L, false, false, new int[]{1, 31}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[129] = new Rule(129, false, false, 48, "129: sregw -> (LSHS I32 regw _6)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "6"))), null, 0L, false, false, new int[]{1, 32}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[132] = new Rule(132, false, false, 48, "132: sregw -> (LSHS I32 regw _7)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "7"))), null, 0L, false, false, new int[]{1, 33}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[135] = new Rule(135, false, false, 48, "135: sregw -> (LSHS I32 regw _8)", null, ImList.list(ImList.list("lsl", "$1", ImList.list("hash", "8"))), null, 0L, false, false, new int[]{1, 34}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[138] = new Rule(138, false, false, 48, "138: sregw -> (LSHS I32 regw regw)", null, ImList.list(ImList.list("lsl", "$1", "$2")), null, 0L, false, false, new int[]{1, 1}, new String[]{null, "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[174] = new Rule(174, false, false, 1, "174: regw -> (LSHS I32 regw regw)", ImList.list(ImList.list("mov", "$0", ImList.list("lsl", "$1", "$2"))), null, null, 0L, false, false, new int[]{1, 1}, new String[]{"*reg-I32*", "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[115] = new Rule(115, false, false, 48, "115: sregw -> (RSHS I32 regw _1)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "1"))), null, 0L, false, false, new int[]{1, 27}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[118] = new Rule(118, false, false, 48, "118: sregw -> (RSHS I32 regw _2)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "2"))), null, 0L, false, false, new int[]{1, 28}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[121] = new Rule(121, false, false, 48, "121: sregw -> (RSHS I32 regw _3)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "3"))), null, 0L, false, false, new int[]{1, 29}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[124] = new Rule(124, false, false, 48, "124: sregw -> (RSHS I32 regw _4)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "4"))), null, 0L, false, false, new int[]{1, 30}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[127] = new Rule(127, false, false, 48, "127: sregw -> (RSHS I32 regw _5)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "5"))), null, 0L, false, false, new int[]{1, 31}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[130] = new Rule(130, false, false, 48, "130: sregw -> (RSHS I32 regw _6)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "6"))), null, 0L, false, false, new int[]{1, 32}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[133] = new Rule(133, false, false, 48, "133: sregw -> (RSHS I32 regw _7)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "7"))), null, 0L, false, false, new int[]{1, 33}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[136] = new Rule(136, false, false, 48, "136: sregw -> (RSHS I32 regw _8)", null, ImList.list(ImList.list("asr", "$1", ImList.list("hash", "8"))), null, 0L, false, false, new int[]{1, 34}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[139] = new Rule(139, false, false, 48, "139: sregw -> (RSHS I32 regw regw)", null, ImList.list(ImList.list("asr", "$1", "$2")), null, 0L, false, false, new int[]{1, 1}, new String[]{null, "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[175] = new Rule(175, false, false, 1, "175: regw -> (RSHS I32 regw regw)", ImList.list(ImList.list("mov", "$0", ImList.list("asr", "$1", "$2"))), null, null, 0L, false, false, new int[]{1, 1}, new String[]{"*reg-I32*", "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[116] = new Rule(116, false, false, 48, "116: sregw -> (RSHU I32 regw _1)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "1"))), null, 0L, false, false, new int[]{1, 27}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[119] = new Rule(119, false, false, 48, "119: sregw -> (RSHU I32 regw _2)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "2"))), null, 0L, false, false, new int[]{1, 28}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[122] = new Rule(122, false, false, 48, "122: sregw -> (RSHU I32 regw _3)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "3"))), null, 0L, false, false, new int[]{1, 29}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[125] = new Rule(125, false, false, 48, "125: sregw -> (RSHU I32 regw _4)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "4"))), null, 0L, false, false, new int[]{1, 30}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[128] = new Rule(128, false, false, 48, "128: sregw -> (RSHU I32 regw _5)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "5"))), null, 0L, false, false, new int[]{1, 31}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[131] = new Rule(131, false, false, 48, "131: sregw -> (RSHU I32 regw _6)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "6"))), null, 0L, false, false, new int[]{1, 32}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[134] = new Rule(134, false, false, 48, "134: sregw -> (RSHU I32 regw _7)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "7"))), null, 0L, false, false, new int[]{1, 33}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[137] = new Rule(137, false, false, 48, "137: sregw -> (RSHU I32 regw _8)", null, ImList.list(ImList.list("lsr", "$1", ImList.list("hash", "8"))), null, 0L, false, false, new int[]{1, 34}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[140] = new Rule(140, false, false, 48, "140: sregw -> (RSHU I32 regw regw)", null, ImList.list(ImList.list("lsr", "$1", "$2")), null, 0L, false, false, new int[]{1, 1}, new String[]{null, "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[176] = new Rule(176, false, false, 1, "176: regw -> (RSHU I32 regw regw)", ImList.list(ImList.list("mov", "$0", ImList.list("lsr", "$1", "$2"))), null, null, 0L, false, false, new int[]{1, 1}, new String[]{"*reg-I32*", "*reg-I32*", "*reg-I32*"});
        CodeGenerator_arm.rulev[179] = new Rule(179, false, false, 1, "179: regw -> (TSTEQ I32 regw cmpop)", ImList.list(ImList.list("cmp", "$1", "$2")), null, null, 0L, false, false, new int[]{1, 52}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_arm.rulev[180] = new Rule(180, false, true, 53, "180: _12 -> (TSTEQ I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[214] = new Rule(214, false, true, 66, "214: _22 -> (TSTEQ I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[247] = new Rule(247, false, true, 77, "247: _32 -> (TSTEQ I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[182] = new Rule(182, false, true, 54, "182: _13 -> (TSTNE I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[216] = new Rule(216, false, true, 67, "216: _23 -> (TSTNE I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
    }

    private static void rrinit200() {
        CodeGenerator_arm.rulev[249] = new Rule(249, false, true, 78, "249: _33 -> (TSTNE I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[184] = new Rule(184, false, true, 55, "184: _14 -> (TSTLTS I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[218] = new Rule(218, false, true, 68, "218: _24 -> (TSTLTS I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[251] = new Rule(251, false, true, 79, "251: _34 -> (TSTLTS I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[186] = new Rule(186, false, true, 56, "186: _15 -> (TSTLES I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[220] = new Rule(220, false, true, 69, "220: _25 -> (TSTLES I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[253] = new Rule(253, false, true, 80, "253: _35 -> (TSTLES I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[188] = new Rule(188, false, true, 57, "188: _16 -> (TSTGTS I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[222] = new Rule(222, false, true, 70, "222: _26 -> (TSTGTS I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[255] = new Rule(255, false, true, 81, "255: _36 -> (TSTGTS I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[190] = new Rule(190, false, true, 58, "190: _17 -> (TSTGES I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[224] = new Rule(224, false, true, 71, "224: _27 -> (TSTGES I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[257] = new Rule(257, false, true, 82, "257: _37 -> (TSTGES I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[192] = new Rule(192, false, true, 59, "192: _18 -> (TSTLTU I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[226] = new Rule(226, false, true, 72, "226: _28 -> (TSTLTU I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[259] = new Rule(259, false, true, 83, "259: _38 -> (TSTLTU I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[194] = new Rule(194, false, true, 60, "194: _19 -> (TSTLEU I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[228] = new Rule(228, false, true, 73, "228: _29 -> (TSTLEU I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[261] = new Rule(261, false, true, 84, "261: _39 -> (TSTLEU I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[196] = new Rule(196, false, true, 61, "196: _20 -> (TSTGTU I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[230] = new Rule(230, false, true, 74, "230: _30 -> (TSTGTU I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[263] = new Rule(263, false, true, 85, "263: _40 -> (TSTGTU I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[198] = new Rule(198, false, true, 62, "198: _21 -> (TSTGEU I32 regw cmpop)", null, null, null, 0L, false, false, new int[]{1, 52}, null);
        CodeGenerator_arm.rulev[232] = new Rule(232, false, true, 75, "232: _31 -> (TSTGEU I32 regf regf)", null, null, null, 0L, false, false, new int[]{4, 4}, null);
        CodeGenerator_arm.rulev[265] = new Rule(265, false, true, 86, "265: _41 -> (TSTGEU I32 regd regd)", null, null, null, 0L, false, false, new int[]{5, 5}, null);
        CodeGenerator_arm.rulev[66] = new Rule(66, false, false, 39, "66: memb -> (MEM I8 addr2)", null, null, null, 0L, false, false, new int[]{35}, new String[]{null, null});
        CodeGenerator_arm.rulev[68] = new Rule(68, false, false, 41, "68: memsb -> (MEM I8 addr3)", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_arm.rulev[67] = new Rule(67, false, false, 40, "67: memh -> (MEM I16 addr3)", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_arm.rulev[64] = new Rule(64, false, false, 37, "64: memw -> (MEM I32 addr2)", null, null, null, 0L, false, false, new int[]{35}, new String[]{null, null});
        CodeGenerator_arm.rulev[65] = new Rule(65, false, false, 38, "65: memw3 -> (MEM I32 addr3)", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_arm.rulev[286] = new Rule(286, false, true, 96, "286: _51 -> (MEM I32 _42)", null, null, null, 0L, false, false, new int[]{87}, null);
        CodeGenerator_arm.rulev[291] = new Rule(291, false, true, 100, "291: _55 -> (MEM I32 _53)", null, null, null, 0L, false, false, new int[]{98}, null);
        CodeGenerator_arm.rulev[205] = new Rule(205, false, false, 65, "205: memf -> (MEM F32 addr3)", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_arm.rulev[278] = new Rule(278, false, true, 90, "278: _45 -> (MEM F32 _42)", null, null, null, 0L, false, false, new int[]{87}, null);
        CodeGenerator_arm.rulev[238] = new Rule(238, false, false, 76, "238: memd -> (MEM F64 addr3)", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_arm.rulev[283] = new Rule(283, false, true, 94, "283: _49 -> (MEM F64 _42)", null, null, null, 0L, false, false, new int[]{87}, null);
        CodeGenerator_arm.rulev[91] = new Rule(91, false, false, 6, "91: void -> (SET I8 memb regb)", ImList.list(ImList.list("strb", "$2", "$1")), null, null, 0L, false, false, new int[]{39, 3}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_arm.rulev[93] = new Rule(93, false, false, 6, "93: void -> (SET I8 memb _9)", ImList.list(ImList.list("strb", "$2", "$1")), null, null, 0L, false, false, new int[]{39, 42}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_arm.rulev[95] = new Rule(95, false, false, 6, "95: void -> (SET I8 memb _10)", ImList.list(ImList.list("strb", "$2", "$1")), null, null, 0L, false, false, new int[]{39, 43}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_arm.rulev[100] = new Rule(100, false, false, 6, "100: void -> (SET I8 xregb regb)", ImList.list(ImList.list("mov", "$1", "$2")), null, null, 0L, false, false, new int[]{10, 3}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_arm.rulev[90] = new Rule(90, false, false, 6, "90: void -> (SET I16 memh regh)", ImList.list(ImList.list("strh", "$2", "$1")), null, null, 0L, false, false, new int[]{40, 2}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_arm.rulev[97] = new Rule(97, false, false, 6, "97: void -> (SET I16 memh _11)", ImList.list(ImList.list("strh", "$2", "$1")), null, null, 0L, false, false, new int[]{40, 44}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_arm.rulev[99] = new Rule(99, false, false, 6, "99: void -> (SET I16 xregh regh)", ImList.list(ImList.list("mov", "$1", "$2")), null, null, 0L, false, false, new int[]{9, 2}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_arm.rulev[89] = new Rule(89, false, false, 6, "89: void -> (SET I32 memw regw)", ImList.list(ImList.list("str", "$2", "$1")), null, null, 0L, false, false, new int[]{37, 1}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_arm.rulev[98] = new Rule(98, false, false, 6, "98: void -> (SET I32 xregw regw)", ImList.list(ImList.list("mov", "$1", "$2")), null, null, 0L, false, false, new int[]{8, 1}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_arm.rulev[277] = new Rule(277, false, true, 89, "277: _44 -> (SET I32 _42 _43)", null, null, null, 0L, false, false, new int[]{87, 88}, null);
        CodeGenerator_arm.rulev[282] = new Rule(282, false, true, 93, "282: _48 -> (SET I32 _42 _47)", null, null, null, 0L, false, false, new int[]{87, 92}, null);
        CodeGenerator_arm.rulev[287] = new Rule(287, false, true, 97, "287: _52 -> (SET I32 regw _51)", null, null, null, 0L, false, false, new int[]{1, 96}, null);
        CodeGenerator_arm.rulev[289] = new Rule(289, false, true, 99, "289: _54 -> (SET I32 _42 _53)", null, null, null, 0L, false, false, new int[]{87, 98}, null);
        CodeGenerator_arm.rulev[292] = new Rule(292, false, true, 101, "292: _56 -> (SET I32 regw _55)", null, null, null, 0L, false, false, new int[]{1, 100}, null);
        CodeGenerator_arm.rulev[294] = new Rule(294, false, true, 103, "294: _58 -> (SET I32 _42 _57)", null, null, null, 0L, false, false, new int[]{87, 102}, null);
        CodeGenerator_arm.rulev[208] = new Rule(208, false, false, 6, "208: void -> (SET F32 memf regf)", ImList.list(ImList.list("stfs", "$2", "$1")), null, null, 0L, false, false, new int[]{65, 4}, new String[]{null, null, "*reg-F32*"});
        CodeGenerator_arm.rulev[274] = new Rule(274, false, false, 6, "274: void -> (SET F32 xregf regf)", ImList.list(ImList.list("mvfs", "$1", "$2")), null, null, 0L, false, false, new int[]{11, 4}, new String[]{null, null, "*reg-F32*"});
        CodeGenerator_arm.rulev[279] = new Rule(279, false, true, 91, "279: _46 -> (SET F32 _45 regf)", null, null, null, 0L, false, false, new int[]{90, 4}, null);
        CodeGenerator_arm.rulev[296] = new Rule(296, false, false, 6, "296: void -> (SET F32 memf memf)", ImList.list(ImList.list("ldr", "%lr", "$2"), ImList.list("str", "%lr", "$1")), null, ImList.list(ImList.list("REG", "I32", "%lr")), 0L, false, false, new int[]{65, 65}, new String[]{null, null, null});
        CodeGenerator_arm.rulev[241] = new Rule(241, false, false, 6, "241: void -> (SET F64 memd regd)", ImList.list(ImList.list("stfd", "$2", "$1")), null, null, 0L, false, false, new int[]{76, 5}, new String[]{null, null, "*reg-F64*"});
        CodeGenerator_arm.rulev[273] = new Rule(273, false, false, 6, "273: void -> (SET F64 xregd regd)", ImList.list(ImList.list("mvfd", "$1", "$2")), null, null, 0L, false, false, new int[]{12, 5}, new String[]{null, null, "*reg-F64*"});
        CodeGenerator_arm.rulev[284] = new Rule(284, false, true, 95, "284: _50 -> (SET F64 _49 regd)", null, null, null, 0L, false, false, new int[]{94, 5}, null);
        CodeGenerator_arm.rulev[71] = new Rule(71, false, false, 6, "71: void -> (JUMP _ label)", ImList.list(ImList.list("b", "$1")), null, null, 0L, false, false, new int[]{7}, new String[]{null, null});
        CodeGenerator_arm.rulev[181] = new Rule(181, false, false, 6, "181: void -> (JUMPC _ _12 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("beq", "$3")), null, null, 0L, false, false, new int[]{53, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[183] = new Rule(183, false, false, 6, "183: void -> (JUMPC _ _13 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bne", "$3")), null, null, 0L, false, false, new int[]{54, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[185] = new Rule(185, false, false, 6, "185: void -> (JUMPC _ _14 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("blt", "$3")), null, null, 0L, false, false, new int[]{55, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[187] = new Rule(187, false, false, 6, "187: void -> (JUMPC _ _15 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("ble", "$3")), null, null, 0L, false, false, new int[]{56, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[189] = new Rule(189, false, false, 6, "189: void -> (JUMPC _ _16 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bgt", "$3")), null, null, 0L, false, false, new int[]{57, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[191] = new Rule(191, false, false, 6, "191: void -> (JUMPC _ _17 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bge", "$3")), null, null, 0L, false, false, new int[]{58, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[193] = new Rule(193, false, false, 6, "193: void -> (JUMPC _ _18 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("blo", "$3")), null, null, 0L, false, false, new int[]{59, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[195] = new Rule(195, false, false, 6, "195: void -> (JUMPC _ _19 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bls", "$3")), null, null, 0L, false, false, new int[]{60, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[197] = new Rule(197, false, false, 6, "197: void -> (JUMPC _ _20 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bhi", "$3")), null, null, 0L, false, false, new int[]{61, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[199] = new Rule(199, false, false, 6, "199: void -> (JUMPC _ _21 label label)", ImList.list(ImList.list("cmp", "$1", "$2"), ImList.list("bhs", "$3")), null, null, 0L, false, false, new int[]{62, 7, 7}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_arm.rulev[215] = new Rule(215, false, false, 6, "215: void -> (JUMPC _ _22 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("beq", "$3")), null, null, 0L, false, false, new int[]{66, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[217] = new Rule(217, false, false, 6, "217: void -> (JUMPC _ _23 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bne", "$3")), null, null, 0L, false, false, new int[]{67, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[219] = new Rule(219, false, false, 6, "219: void -> (JUMPC _ _24 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("blt", "$3")), null, null, 0L, false, false, new int[]{68, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[221] = new Rule(221, false, false, 6, "221: void -> (JUMPC _ _25 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("ble", "$3")), null, null, 0L, false, false, new int[]{69, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[223] = new Rule(223, false, false, 6, "223: void -> (JUMPC _ _26 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bgt", "$3")), null, null, 0L, false, false, new int[]{70, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[225] = new Rule(225, false, false, 6, "225: void -> (JUMPC _ _27 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bge", "$3")), null, null, 0L, false, false, new int[]{71, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[227] = new Rule(227, false, false, 6, "227: void -> (JUMPC _ _28 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("blo", "$3")), null, null, 0L, false, false, new int[]{72, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[229] = new Rule(229, false, false, 6, "229: void -> (JUMPC _ _29 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bls", "$3")), null, null, 0L, false, false, new int[]{73, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[231] = new Rule(231, false, false, 6, "231: void -> (JUMPC _ _30 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bhi", "$3")), null, null, 0L, false, false, new int[]{74, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[233] = new Rule(233, false, false, 6, "233: void -> (JUMPC _ _31 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bhs", "$3")), null, null, 0L, false, false, new int[]{75, 7, 7}, new String[]{null, "*reg-F32*", "*reg-F32*", null, null});
        CodeGenerator_arm.rulev[248] = new Rule(248, false, false, 6, "248: void -> (JUMPC _ _32 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("beq", "$3")), null, null, 0L, false, false, new int[]{77, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[250] = new Rule(250, false, false, 6, "250: void -> (JUMPC _ _33 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bne", "$3")), null, null, 0L, false, false, new int[]{78, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[252] = new Rule(252, false, false, 6, "252: void -> (JUMPC _ _34 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("blt", "$3")), null, null, 0L, false, false, new int[]{79, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[254] = new Rule(254, false, false, 6, "254: void -> (JUMPC _ _35 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("ble", "$3")), null, null, 0L, false, false, new int[]{80, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[256] = new Rule(256, false, false, 6, "256: void -> (JUMPC _ _36 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bgt", "$3")), null, null, 0L, false, false, new int[]{81, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[258] = new Rule(258, false, false, 6, "258: void -> (JUMPC _ _37 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bge", "$3")), null, null, 0L, false, false, new int[]{82, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[260] = new Rule(260, false, false, 6, "260: void -> (JUMPC _ _38 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("blo", "$3")), null, null, 0L, false, false, new int[]{83, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[262] = new Rule(262, false, false, 6, "262: void -> (JUMPC _ _39 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bls", "$3")), null, null, 0L, false, false, new int[]{84, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[264] = new Rule(264, false, false, 6, "264: void -> (JUMPC _ _40 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bhi", "$3")), null, null, 0L, false, false, new int[]{85, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[266] = new Rule(266, false, false, 6, "266: void -> (JUMPC _ _41 label label)", ImList.list(ImList.list("cmfe", "$1", "$2"), ImList.list("bhs", "$3")), null, null, 0L, false, false, new int[]{86, 7, 7}, new String[]{null, "*reg-F64*", "*reg-F64*", null, null});
        CodeGenerator_arm.rulev[200] = new Rule(200, false, false, 6, "200: void -> (CALL _ sta)", ImList.list(ImList.list("bl", "$1")), null, null, 0L, false, false, new int[]{17}, new String[]{null, null});
        CodeGenerator_arm.rulev[201] = new Rule(201, false, false, 6, "201: void -> (CALL _ regw)", ImList.list(ImList.list("mov", "%lr", "%pc"), ImList.list("mov", "%pc", "$1")), null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-nlr-I32*"});
        CodeGenerator_arm.rulev[202] = new Rule(202, false, false, 6, "202: void -> (CALL _ memw)", ImList.list(ImList.list("mov", "%lr", "%pc"), ImList.list("mov", "%pc", "$1")), null, null, 0L, false, false, new int[]{37}, new String[]{null, "*reg-nlr-I32*"});
        CodeGenerator_arm.rulev[280] = new Rule(280, false, false, 6, "280: void -> (PARALLEL _ _44 _46)", ImList.list(ImList.list("stfs", "$1", ImList.list("preinc", "sp", "-4"))), null, null, 0L, false, false, new int[]{89, 91}, new String[]{null, "*reg-F32*"});
        CodeGenerator_arm.rulev[285] = new Rule(285, false, false, 6, "285: void -> (PARALLEL _ _48 _50)", ImList.list(ImList.list("stfd", "$1", ImList.list("preinc", "sp", "-8"))), null, null, 0L, false, false, new int[]{93, 95}, new String[]{null, "*reg-F64*"});
        CodeGenerator_arm.rulev[290] = new Rule(290, false, false, 6, "290: void -> (PARALLEL _ _52 _54)", ImList.list(ImList.list("ldmfd", "sp!", ImList.list("regpair1", "$1"))), null, null, 0L, false, false, new int[]{97, 99}, new String[]{null, "*reg-I32*"});
        CodeGenerator_arm.rulev[295] = new Rule(295, false, false, 6, "295: void -> (PARALLEL _ _52 _56 _58)", ImList.list(ImList.list("ldmfd", "sp!", ImList.list("regpair2", "$1", "$2"))), null, null, 0L, false, false, new int[]{97, 101, 103}, new String[]{null, "*reg-I32*", "*reg-I32*"});
    }

    String defaultRegsetForType(int type) {
        switch (type) {
            case 514: {
                return "*reg-I32*";
            }
            case 258: {
                return "*reg-I16*";
            }
            case 130: {
                return "*reg-I8*";
            }
            case 1028: {
                return "*reg-F64*";
            }
            case 516: {
                return "*reg-F32*";
            }
        }
        return null;
    }

    void initLabeling(LirFactory lir) {
        this.stateVec = new State[lir.idBound()];
    }

    String showLabel(LirNode t) {
        return this.stateVec[t.id].toString();
    }

    void labelTree(LirNode t) {
        if (this.stateVec[t.id] == null) {
            State st;
            int n = this.nActualOperands(t);
            State[] kid = new State[n];
            for (int i = 0; i < n; ++i) {
                LirNode s = t.kid(i);
                this.labelTree(s);
                kid[i] = this.stateVec[s.id];
            }
            this.stateVec[t.id] = st = new State();
            st.label(t, kid);
        }
    }

    Rule getRule(LirNode t, int goal) {
        return rulev[this.stateVec[t.id].rule[goal]];
    }

    int getCost1(LirNode t, int goal) {
        return this.stateVec[t.id].cost1[goal];
    }

    int getCost2(LirNode t, int goal) {
        return this.stateVec[t.id].cost2[goal];
    }

    int startNT() {
        return 6;
    }

    Object expandBuildMacro(ImList form) {
        String name = (String)form.elem();
        if (name == "vb0") {
            return this.jmac15(form.elem(1));
        }
        if (name == "vb1") {
            return this.jmac16(form.elem(1));
        }
        if (name == "vb2") {
            return this.jmac17(form.elem(1));
        }
        if (name == "vb3") {
            return this.jmac18(form.elem(1));
        }
        return null;
    }

    Object quiltLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.quiltLirDefault(node);
    }

    String emitList(ImList form, boolean topLevel) {
        String name = (String)form.elem();
        if (name == "lit") {
            return this.jmac1(this.emitObject(form.elem(1)));
        }
        if (name == "litf") {
            return this.jmac2(this.emitObject(form.elem(1)));
        }
        if (name == "litd") {
            return this.jmac3(this.emitObject(form.elem(1)));
        }
        if (name == "pls") {
            return this.jmac4(this.emitObject(form.elem(1)));
        }
        if (name == "neg") {
            return this.jmac5(this.emitObject(form.elem(1)));
        }
        if (name == "pind") {
            return this.jmac6(this.emitObject(form.elem(1)));
        }
        if (name == "mind") {
            return this.jmac7(this.emitObject(form.elem(1)));
        }
        if (name == "lsl") {
            return this.jmac8(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "asr") {
            return this.jmac9(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "lsr") {
            return this.jmac10(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "amode2") {
            return this.jmac11(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "amode3") {
            return this.jmac12(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "hash") {
            return this.jmac13(this.emitObject(form.elem(1)));
        }
        if (name == "adjDisp") {
            return this.jmac14(this.emitObject(form.elem(1)));
        }
        if (name == "b0") {
            return this.jmac19(this.emitObject(form.elem(1)));
        }
        if (name == "b1") {
            return this.jmac20(this.emitObject(form.elem(1)));
        }
        if (name == "h0") {
            return this.jmac21(this.emitObject(form.elem(1)));
        }
        if (name == "u0") {
            return this.jmac22(this.emitObject(form.elem(1)));
        }
        if (name == "preinc") {
            return this.jmac23(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "regpair2") {
            return this.jmac24(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "regpair1") {
            return this.jmac25(this.emitObject(form.elem(1)));
        }
        if (name == "regwlow") {
            return this.jmac26(this.emitObject(form.elem(1)));
        }
        if (name == "regblow") {
            return this.jmac27(this.emitObject(form.elem(1)));
        }
        if (name == "prologue") {
            return this.jmac28(form.elem(1));
        }
        if (name == "epilogue") {
            return this.jmac29(form.elem(1), this.emitObject(form.elem(2)));
        }
        if (name == "deflabel") {
            return this.jmac30(this.emitObject(form.elem(1)));
        }
        if (name == "line") {
            return this.jmac31(this.emitObject(form.elem(1)));
        }
        if (name == "genasm") {
            return this.jmac32(this.emitObject(form.elem(1)), form.elem(2));
        }
        return this.emitListDefault(form, topLevel);
    }

    String emitLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.emitLirDefault(node);
    }

    void initializeMachineDep() {
        IoRoot io;
        CompileSpecification spec;
        CoinsOptions coinsOptions;
        this.peepHoleOpts.put("_mov", this.decompMov);
        this.peepHoleOpts.put("_add", this.decompAdd);
        this.peepHoleOpts.put("_or", this.decompOr);
        this.peepHoleOpts.put("_bic", this.decompBic);
        Thread th = Thread.currentThread();
        if (th instanceof CompileThread && (coinsOptions = (spec = (io = ((CompileThread)th).getIoRoot()).getCompileSpecification()).getCoinsOptions()).isSet("simulate")) {
            this.isSimulate = true;
        }
    }

    public Transformer[] lateRewritingSequence() {
        return new Transformer[]{this.localLateRewritingTrig, this.testJumpcTrig, this.ProcessFramesTrig};
    }

    boolean checkPred(BiLink q, BasicBlk bb) {
        BiList pred = ((BasicBlk)q.elem()).predList();
        if (pred.length() != 1) {
            return false;
        }
        return ((BasicBlk)pred.first().elem()).id == bb.id;
    }

    boolean checkTarget(Label lab, BiLink q) {
        if (!(q.elem() instanceof BasicBlk)) {
            return false;
        }
        return lab.name().equals(((BasicBlk)q.elem()).label().name());
    }

    boolean checkSucc(BiLink p, BasicBlk bb) {
        BiList succ = ((BasicBlk)p.elem()).succList();
        if (succ.length() != 1) {
            return false;
        }
        return ((BasicBlk)succ.first().elem()).id == bb.id;
    }

    boolean checkBody(BasicBlk bb) {
        int n = 0;
        BiList l = bb.instrList();
        BiLink p = l.first();
        while (!p.atEnd()) {
            LirNode tmp = (LirNode)p.elem();
            switch (tmp.opCode) {
                case 50: 
                case 53: 
                case 56: {
                    this.debug("::: too complex " + bb);
                    return false;
                }
            }
            this.debug("OK: " + tmp);
            if (++n > 8) {
                this.debug("::: too long " + bb);
                return false;
            }
            p = p.next();
        }
        return true;
    }

    void examineJUMPC(BiLink p, LirNode node) {
        BasicBlk blk = (BasicBlk)p.elem();
        int op = node.kid((int)0).opCode;
        LirNode y = node.kid(2);
        LirNode z = node.kid(1);
        Label falseTarget = ((LirLabelRef)y).label;
        Label trueTarget = ((LirLabelRef)z).label;
        this.debug2(" then target " + z + " -> " + trueTarget);
        this.debug2(" else target " + y + " -> " + falseTarget);
        BiLink q = null;
        BiLink r = null;
        BiLink s = null;
        if (!(p.next().atEnd() || (q = p.next()).next().atEnd() || (r = q.next()).next().atEnd())) {
            s = r.next();
        }
        if (q == null || r == null) {
            this.debug("examineJUMPC: bad lir ?");
            return;
        }
        if (!(this.checkPred(q, blk) && this.checkTarget(trueTarget, q) && this.checkTarget(falseTarget, r) && this.checkBody((BasicBlk)q.elem()))) {
            this.debug2(" cexec no ");
            return;
        }
        if (this.checkSucc(q, (BasicBlk)r.elem())) {
            this.debug2("if-then type: " + blk.label());
            this.debug2("  -> OK, target: " + trueTarget.name());
            this.jumpcInfo.put(trueTarget.name().intern(), new JumpcEntry(this.op2cc(op), trueTarget.name()));
            return;
        }
        if (!(s != null && this.checkPred(r, blk) && this.checkSucc(q, (BasicBlk)s.elem()) && this.checkSucc(r, (BasicBlk)s.elem()))) {
            this.debug2(" cexec no");
            return;
        }
        if (!this.checkBody((BasicBlk)r.elem())) {
            this.debug2("if-then-elseNG type: " + blk.label());
            this.debug2(" -> OK, target: " + trueTarget.name());
            this.jumpcInfo.put(trueTarget.name().intern(), new JumpcEntry(this.op2cc(op), trueTarget.name(), null));
            return;
        }
        this.debug2("if-then-else type: " + blk.label());
        this.debug2(" -> OK, target: " + trueTarget.name() + ", " + falseTarget.name());
        this.jumpcInfo.put(trueTarget.name().intern(), new JumpcEntry(this.op2cc(op), trueTarget.name(), falseTarget.name()));
    }

    OutputStream insertPostProcessor(OutputStream out) {
        this.pp = LiteralAndBranchProcessor.postProcessor(out);
        this.pp.setCPU(new Arm());
        return this.pp.pipeTo();
    }

    void notifyEndToPostProcessor() {
        this.pp.notifyEnd();
    }

    CodeGenerator.FunctionAttr newFunctionAttr(Function func) {
        ArmAttr attr = new ArmAttr(func);
        if (this.isSimulate) {
            attr.adjustCalleeSaves = 28;
        }
        return attr;
    }

    boolean isImm8r(long val) {
        ArmConst c = new ArmConst(val);
        c.normalize();
        return c.nofBytes == 1;
    }

    boolean isXimm(long val) {
        ArmConst c = new ArmConst(val);
        c.normalize();
        return c.nofBytes < 3;
    }

    int nofBytes(long val) {
        ArmConst c = new ArmConst(val);
        c.normalize();
        int n = c.nofBytes;
        this.debug("nofByte(" + val + ") = " + n);
        return n <= this.decompMax ? n : 5;
    }

    boolean isConv(int op) {
        switch (op) {
            case 17: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    boolean equalArg(LirNode x, LirNode y) {
        if (x.opCode == 47 || this.isConv(x.opCode)) {
            x = x.kid(0);
        }
        if (y.opCode == 47 || this.isConv(y.opCode)) {
            y = y.kid(0);
        }
        if (x instanceof LirSymRef && y instanceof LirSymRef) {
            return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
        }
        return false;
    }

    int makeVaStart(LirNode arg) {
        ArmAttr at = (ArmAttr)this.getFunctionAttr(this.func);
        at.isVarArg = true;
        at.stackParamOffset = 4;
        return this.paramOffset(arg) + 4;
    }

    int clcvnRegLimit() {
        return 16;
    }

    LirNode clcvnParamWord(int type, int location, boolean caller) {
        ArmAttr at = (ArmAttr)this.getFunctionAttr(this.func);
        if (location < (caller ? 16 : at.stackParamOffset)) {
            return this.clcvnParamReg(type, location, caller);
        }
        return this.clcvnParamMem(type, location, caller);
    }

    LirNode clcvnParamReg(int type, int location, boolean caller) {
        LirNode master = this.phyReg(paramRegv[location >> 2]);
        if (type == master.type) {
            return master;
        }
        if (type == I16) {
            return this.lir.node(7, I16, master, this.lir.untaggedIconst(I32, 0L));
        }
        if (type == I8) {
            return this.lir.node(7, I8, master, this.lir.untaggedIconst(I32, 0L));
        }
        throw new CantHappenException("type: " + type);
    }

    LirNode clcvnParamMem(int type, int location, boolean caller) {
        ArmAttr at = (ArmAttr)this.getFunctionAttr(this.func);
        return this.lir.node(47, type, this.lir.node(10, I32, this.phyReg(caller ? "%sp" : "%fp"), this.lir.iconst(I32, caller ? location - 16 : 4 + (location - at.stackParamOffset))));
    }

    int clcvnParamOffset(int location) {
        ArmAttr at = (ArmAttr)this.getFunctionAttr(this.func);
        return 4 + (location - at.stackParamOffset);
    }

    void clcvnPassFloatRegMem(int location, LirNode arg, BiLink memp, BiLink regp, BiList alist) {
        int w = Type.bytes(arg.type);
        LirNode sp = this.phyReg("%sp");
        LirNode r = this.phyReg(paramRegv[location >> 2]);
        if (location + w <= 16) {
            memp.addBefore(this.lir.node(56, 0, this.lir.node(48, I32, sp, this.lir.node(11, I32, sp, this.lir.iconst(I32, w))), this.lir.node(48, arg.type, this.lir.node(47, arg.type, sp), arg)));
            if (w > 4) {
                LirNode r2 = this.phyReg(paramRegv[(location >> 2) + 1]);
                regp.addBefore(this.lir.node(56, 0, this.lir.node(48, I32, r, this.lir.node(47, I32, sp)), this.lir.node(48, I32, r2, this.lir.node(47, I32, this.lir.node(10, I32, sp, this.lir.iconst(I32, 4L)))), this.lir.node(48, I32, sp, this.lir.node(10, I32, sp, this.lir.iconst(I32, 8L)))));
            } else {
                regp.addBefore(this.lir.node(56, 0, this.lir.node(48, I32, r, this.lir.node(47, I32, sp)), this.lir.node(48, I32, sp, this.lir.node(10, I32, sp, this.lir.iconst(I32, 4L)))));
            }
        } else {
            if (w != 8) {
                throw new CantHappenException("double expected");
            }
            memp.addBefore(this.lir.node(48, I32, sp, this.lir.node(11, I32, sp, this.lir.iconst(I32, 4L))));
            memp.addBefore(this.lir.node(48, arg.type, this.lir.node(47, arg.type, sp), arg));
            regp.addBefore(this.lir.node(56, 0, this.lir.node(48, I32, r, this.lir.node(47, I32, sp)), this.lir.node(48, I32, sp, this.lir.node(10, I32, sp, this.lir.iconst(I32, 4L)))));
        }
    }

    LirNode clcvnReturnValue(int type) {
        if (Type.tag(type) == 2) {
            return this.regnode(type, "%r0");
        }
        return this.regnode(type, "%f0");
    }

    LirNode clcvnPartialWord(LirNode exp, int part) {
        if (exp.type == I64) {
            return this.lir.node(7, I32, exp, this.lir.untaggedIconst(I32, part));
        }
        return exp;
    }

    LirNode clcvnSetPartialWord(LirNode lhs, int part, LirNode rhs) {
        if (lhs.type == I64) {
            return this.lir.node(48, I32, this.lir.node(7, I32, lhs, this.lir.untaggedIconst(I32, part)), rhs);
        }
        return this.lir.node(48, lhs.type, lhs, rhs);
    }

    ImList clcvnClobbers() {
        return this.regCallClobbers;
    }

    boolean clcvnStructReturnAsFirst() {
        return true;
    }

    private void debug(String s) {
    }

    private void debug2(String s) {
    }

    private void bug() {
        System.out.println("bug");
    }

    private void bug(String s) {
        System.out.println("bug: " + s);
    }

    private LirNode setExp(int type, LirNode op1, LirNode op2) {
        return this.lir.node(48, type, op1, op2);
    }

    private LirNode memExp(int type, LirNode op1) {
        return this.lir.node(47, type, op1);
    }

    private LirNode memExp(int type, LirNode op1, int align) {
        return this.lir.operator(47, type, op1, ImList.list("&align", String.valueOf(align)));
    }

    private LirNode addExp(int type, LirNode op1, LirNode op2) {
        return this.lir.node(10, type, op1, op2);
    }

    private LirNode setI32(LirNode op1, LirNode op2) {
        return this.lir.node(48, I32, op1, op2);
    }

    private LirNode memI32(LirNode op1) {
        return this.lir.node(47, I32, op1);
    }

    private LirNode memI32Base(LirNode base, int disp) {
        return this.memI32(this.addI32(base, disp));
    }

    private LirNode addI32(LirNode op1, int n) {
        return this.lir.node(10, I32, op1, this.lir.iconst(I32, n));
    }

    private LirNode regI32(int nth) {
        return this.lir.symRef(this.module.globalSymtab.get("%r" + nth));
    }

    LirNode rewriteFrame(LirNode node) {
        int off;
        Symbol fp = this.func.module.globalSymtab.get("%fp");
        Symbol vfp = this.func.module.globalSymtab.get("%vfp");
        if (!(node instanceof LirSymRef)) {
            this.bug("rewriteFrame() requires LirSymRef: " + node);
            return node;
        }
        Symbol sym = ((LirSymRef)node).symbol;
        if (!(sym instanceof SymAuto)) {
            this.bug("rewriteFrame() requires SymAuto: " + sym);
        }
        if ((off = ((SymAuto)sym).offset()) < 0) {
            this.debug(" -> " + (off -= 40));
            if (this.isSimulate) {
                return this.addExp(I32, this.lir.symRef(fp), this.lir.iconst(I32, off));
            }
            return this.addExp(I32, this.lir.symRef(vfp), this.lir.iconst(I32, off));
        }
        return this.addExp(I32, this.lir.symRef(fp), this.lir.iconst(I32, off));
    }

    private LirNode regnode(int type, String name) {
        LirNode master = this.lir.symRef(this.module.globalSymtab.get(name));
        switch (Type.tag(type)) {
            case 2: {
                if (type == I32) {
                    return master;
                }
                if (type == I16) {
                    return this.lir.node(7, I16, master, this.lir.untaggedIconst(I32, 0L));
                }
                if (type == I8) {
                    return this.lir.node(7, I8, master, this.lir.untaggedIconst(I32, 0L));
                }
            }
            case 4: {
                if (type == F64) {
                    return master;
                }
                if (type != F32) break;
                return this.lir.node(7, F32, master, this.lir.untaggedIconst(I32, 0L));
            }
        }
        return null;
    }

    String op2cc(int op) {
        switch (op) {
            case 35: {
                return "eq";
            }
            case 36: {
                return "ne";
            }
            case 37: {
                return "lt";
            }
            case 38: {
                return "le";
            }
            case 39: {
                return "gt";
            }
            case 40: {
                return "ge";
            }
            case 41: {
                return "lo";
            }
            case 42: {
                return "ls";
            }
            case 43: {
                return "hi";
            }
            case 44: {
                return "hs";
            }
        }
        return "badOp";
    }

    String jmac1(String x) {
        return "=W" + x;
    }

    String jmac2(String x) {
        double value = Float.parseFloat(x);
        long bits = Float.floatToIntBits((float)value);
        return "=W" + Long.toString(bits & 0xFFFFFFFFL, 10) + " @ " + x;
    }

    String jmac3(String x) {
        double value = Double.parseDouble(x);
        long bits = Double.doubleToLongBits(value);
        return "=D0x" + Long.toString(bits >>> 32 & 0xFFFFFFFFL, 16) + "_0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " @ " + x;
    }

    String jmac4(String x) {
        return "" + x;
    }

    String jmac5(String x) {
        return "-" + x;
    }

    String jmac6(String x) {
        return x;
    }

    String jmac7(String x) {
        return "-" + x;
    }

    String jmac8(String x, String y) {
        return x + ", lsl " + y;
    }

    String jmac9(String x, String y) {
        return x + ", asr " + y;
    }

    String jmac10(String x, String y) {
        return x + ", lsr " + y;
    }

    String jmac11(String x, String y) {
        if (y.length() > 0) {
            return "[" + x + ", " + y + "]";
        }
        return "[" + x + "]";
    }

    String jmac12(String x, String y) {
        if (y.length() > 0) {
            return "[" + x + ", " + y + "]";
        }
        return "[" + x + "]";
    }

    String jmac13(String x) {
        return "#" + x;
    }

    String jmac14(String x) {
        ArmAttr attr = (ArmAttr)this.getFunctionAttr(this.func);
        long off = Long.parseLong(x) + 28L - (long)attr.adjustCalleeSaves;
        return String.valueOf(off);
    }

    Object jmac15(Object x) {
        ArmAttr attr = (ArmAttr)this.getFunctionAttr(this.func);
        if (attr.adjustCalleeSaves < 0) {
            SaveRegisters saveList = (SaveRegisters)this.func.require(SaveRegisters.analyzer);
            attr.adjustCalleeSaves = 0;
            NumberSet.Iterator it = saveList.calleeSave.iterator();
            while (it.hasNext()) {
                int reg = it.next();
                attr.adjustCalleeSaves += 4;
            }
        }
        long off = Long.parseLong(x.toString()) + 28L - (long)attr.adjustCalleeSaves;
        this.ximm = new ArmConst(-off);
        this.ximm.normalize();
        return ImList.list("#" + this.ximm.get(0));
    }

    Object jmac16(Object x) {
        return ImList.list("#" + this.ximm.get(1));
    }

    Object jmac17(Object x) {
        return ImList.list("#" + this.ximm.get(2));
    }

    Object jmac18(Object x) {
        return ImList.list("#" + this.ximm.get(3));
    }

    String jmac19(String x) {
        this.debug("decomposing " + x);
        this.ximm = new ArmConst(Long.parseLong(x));
        this.ximm.normalize();
        return "#" + this.ximm.get(0);
    }

    String jmac20(String x) {
        return "#" + this.ximm.get(1);
    }

    String jmac21(String x) {
        this.debug("decomposing " + x);
        this.ximm = new ArmConst(Long.parseLong(x) & 0xFFFFL);
        this.ximm.normalize();
        return "#" + this.ximm.get(0);
    }

    String jmac22(String x) {
        return "#" + (Long.parseLong(x) & 0xFFL);
    }

    String jmac23(String x, String y) {
        return "[" + x + ", #" + y + "]!";
    }

    String jmac24(String x, String y) {
        return "{" + x + ", " + y + "}";
    }

    String jmac25(String x) {
        return "{" + x + "}";
    }

    String jmac26(String x) {
        return "%" + x.substring(2);
    }

    String jmac27(String x) {
        return "%" + x.substring(2, 3) + "l";
    }

    String jmac28(Object f) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        int size = this.frameSize(func);
        ArmAttr attr = (ArmAttr)this.getFunctionAttr(func);
        if (!this.isSimulate) {
            attr.adjustCalleeSaves = 0;
        }
        int forCall = attr.requiredStack;
        if ((forCall -= 16) < 0) {
            forCall = 0;
        }
        this.debug("**** defemit prologue: frame size " + (size += forCall));
        size = size + 3 & 0xFFFFFFFC;
        String seq = "\n@ prologue\n\tmov\tip, sp";
        String seq2 = "\n\tstmfd\t%sp!, {";
        if (this.isSimulate) {
            seq2 = seq2 + "%r4,%r5,%r6,%r7,%r8,%r9,%r10,";
        } else {
            NumberSet.Iterator it = saveList.calleeSave.iterator();
            while (it.hasNext()) {
                int reg = it.next();
                seq2 = seq2 + this.machineParams.registerToString(reg) + ", ";
                attr.adjustCalleeSaves += 4;
            }
        }
        seq2 = seq2 + "%fp, %ip, %lr, %pc}";
        if (attr.stackParamOffset < 16) {
            seq = seq + "\n\tsub\tsp, sp, #" + (16 - attr.stackParamOffset);
        }
        seq2 = seq2 + "\n\tsub\tfp, ip, #" + (4 + (16 - attr.stackParamOffset));
        if (size > 0) {
            seq2 = size + attr.adjustCalleeSaves > 1024 ? seq2 + "\n\tldr\tlr, =W" + (size + attr.adjustCalleeSaves) + "\n\tsub\tsp, sp, lr" : seq2 + "\n\tsub\tsp, sp, #" + (size + attr.adjustCalleeSaves) + "\t@frame 2";
        } else if (size == 0) {
            // empty if block
        }
        return seq + seq2;
    }

    String jmac29(Object f, String rettype) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        String seq = "\n@ epilgue\n\tldmea\t%fp, {";
        if (this.isSimulate) {
            seq = seq + "%r4,%r5,%r6,%r7,%r8,%r9,%r10,";
        } else {
            NumberSet.Iterator it = saveList.calleeSave.iterator();
            while (it.hasNext()) {
                int reg = it.next();
                seq = seq + this.machineParams.registerToString(reg) + ", ";
            }
        }
        seq = seq + "%fp, %sp, %pc}\n";
        seq = seq + ".ltorg\n";
        return seq;
    }

    String jmac30(String x) {
        return x + ":";
    }

    String jmac31(String x) {
        return "@line " + x;
    }

    String jmac32(String format, Object args) {
        return this.emitAsmCode(format, (ImList)args);
    }

    void emitComment(PrintWriter out, String comment) {
        out.println("@ " + comment);
    }

    void emitBeginningOfSegment(PrintWriter out, String segment) {
        out.println("\t.section \"" + segment + "\"");
    }

    void emitEndOfSegment(PrintWriter out, String segment) {
    }

    void emitDataLabel(PrintWriter out, String label) {
        out.println(label + ":");
    }

    void emitCodeLabel(PrintWriter out, String label) {
        out.println(label + ":");
    }

    void emitAlign(PrintWriter out, int align) {
        int n = 0;
        while (1 << n < align) {
            ++n;
        }
        if (n > 0) {
            out.println("\t.align\t" + n);
        }
    }

    void emitCommon(PrintWriter out, SymStatic symbol, int bytes) {
        if (symbol.linkage == "LDEF") {
            out.println("\t.local\t" + symbol.name);
        }
        out.println("\t.common\t" + symbol.name + "," + bytes + "," + symbol.boundary);
    }

    void emitLinkage(PrintWriter out, SymStatic symbol) {
        if (symbol.linkage == "XDEF") {
            out.println("\t.global\t" + symbol.name);
        }
    }

    void emitZeros(PrintWriter out, int bytes) {
        if (bytes > 0) {
            out.println("\t.skip\t" + bytes);
        }
    }

    void emitData(PrintWriter out, int type, LirNode node) {
        if (type == I32) {
            out.println("\t.word\t" + this.lexpConv.convert(node));
        } else if (type == I16) {
            out.println("\t.short\t" + ((LirIconst)node).signedValue());
        } else if (type == I8) {
            out.println("\t.byte\t" + ((LirIconst)node).signedValue());
        } else if (type == F64) {
            double value = ((LirFconst)node).value;
            long bits = Double.doubleToLongBits(value);
            out.println("\t.long\t0x" + Long.toString(bits >> 32 & 0xFFFFFFFFL, 16) + " @ " + value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16));
        } else if (type == F32) {
            double value = ((LirFconst)node).value;
            long bits = Float.floatToIntBits((float)value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " @ " + value);
        } else {
            throw new CantHappenException("unknown type: " + type);
        }
    }

    String emitAsmCode(String format, ImList args) {
        StringBuffer buf = new StringBuffer();
        int n = format.length();
        int i = 0;
        while (i < n) {
            char c;
            if ((c = format.charAt(i++)) == '%' && i < n) {
                if ((c = format.charAt(i++)) == '%') {
                    buf.append(c);
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (args.elem(c - 49) instanceof Long) {
                        Long tmp = (Long)args.elem(c - 49);
                        ArmAttr attr = (ArmAttr)this.getFunctionAttr(this.func);
                        long off = tmp + 28L - (long)attr.adjustCalleeSaves;
                        buf.append(Long.toString(off));
                        continue;
                    }
                    buf.append(args.elem(c - 49).toString());
                    continue;
                }
                buf.append('%');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private Object car(Object l) {
        return ((ImList)l).elem();
    }

    private Object cdr(Object l) {
        return ((ImList)l).next();
    }

    private boolean isDelSub(ImList tmp) {
        Object imm;
        String src;
        String dst = (String)this.car(this.cdr(tmp));
        return dst.equals(src = (String)this.car(this.cdr(this.cdr(tmp)))) && (imm = this.car(this.cdr(this.cdr(this.cdr(tmp))))).equals("#0");
    }

    ImList addCc(Object cc, ImList inst) {
        String oldinst = this.car(inst).toString();
        String newinst = oldinst + cc;
        if (oldinst.equals("bl")) {
            newinst = oldinst;
        } else if (oldinst.startsWith("ldr") || oldinst.startsWith("str") || oldinst.startsWith("ldm") || oldinst.startsWith("stm") || oldinst.startsWith("ldf") || oldinst.startsWith("stf") || oldinst.startsWith("adf") || oldinst.startsWith("suf") || oldinst.startsWith("rsf") || oldinst.startsWith("muf") || oldinst.startsWith("dvf") || oldinst.startsWith("mvf") || oldinst.startsWith("mnf") || oldinst.startsWith("flt") || oldinst.startsWith("fix")) {
            newinst = oldinst.substring(0, 3) + cc + oldinst.substring(3);
        }
        return new ImList(newinst, (ImList)this.cdr(inst));
    }

    ImList toComment(String prefix, ImList inst) {
        StringBuffer tmp = new StringBuffer(prefix);
        do {
            tmp.append(' ').append(this.car(inst));
        } while ((inst = (ImList)this.cdr(inst)) != ImList.Empty);
        return new ImList(tmp.toString(), ImList.Empty);
    }

    boolean isOp(String op, ImList inst) {
        String tmp = (String)this.car(inst);
        return op.equals(tmp);
    }

    boolean rewriteCondExec(BiLink p) {
        ImList old;
        ImList cexec = ImList.Empty;
        ImList tmp = (ImList)p.elem();
        JumpcEntry t = (JumpcEntry)this.jumpcInfo.get(this.car(this.cdr(tmp)).toString());
        if (t == null) {
            return false;
        }
        BiLink bcc = p.prev();
        bcc.addBefore(".ltorg2");
        bcc.setElem(this.toComment("@", (ImList)bcc.elem()));
        p.setElem(this.toComment("@", tmp));
        BiLink q = p.next();
        while (!q.atEnd() && !this.isOp("deflabel", old = (ImList)q.elem())) {
            p.addBefore(this.addCc(t.cc, old));
            q.unlink();
            q = q.next();
        }
        if (t.ifThenElse && t.falseTarget != null) {
            q.setElem(this.toComment("@", (ImList)q.elem()));
            q = q.next();
            while (!q.atEnd() && !this.isOp("deflabel", old = (ImList)q.elem())) {
                p.addBefore(this.addCc(flipCc.get(t.cc), old));
                q.unlink();
                q = q.next();
            }
        }
        return true;
    }

    Object nth(ImList l, int n) {
        for (int i = 0; i < n; ++i) {
            l = (ImList)this.cdr(l);
        }
        return this.car(l);
    }

    void logop(ImList inst, BiLink l, boolean cpl) {
        Object mnemo = this.nth(inst, 1);
        Object dst = this.nth(inst, 2);
        Object src = this.nth(inst, 3);
        long imm = (Long)this.nth(inst, 4);
        ArmConst val = new ArmConst(cpl ? imm ^ 0xFFFFFFFFFFFFFFFFL : imm);
        val.normalize();
        for (int i = 0; i < val.nofBytes; ++i) {
            ImList tmp = ImList.list(mnemo, dst, src, "#" + val.get(i));
            l.addBefore(tmp);
            src = dst;
        }
    }

    void peepHoleOpt(BiList list) {
        String op;
        ImList tmp;
        BiLink p = list.first();
        while (!p.atEnd()) {
            tmp = (ImList)p.elem();
            op = "";
            if (!(this.car(tmp) instanceof String)) {
                System.out.println("*** " + tmp);
            } else {
                op = (String)this.car(tmp);
                PeepHoleOp opt = (PeepHoleOp)this.peepHoleOpts.get(op);
                if (opt != null && opt.doIt(tmp, p)) {
                    p.unlink();
                } else if (op.equals("sub") && this.isDelSub(tmp)) {
                    p.unlink();
                }
            }
            p = p.next();
        }
        p = list.first();
        while (!p.atEnd()) {
            tmp = (ImList)p.elem();
            op = (String)this.car(tmp);
            if (op.equals("deflabel") && this.rewriteCondExec(p)) {
                p = p.next();
            }
            p = p.next();
        }
    }

    boolean isVirtual(LirNode node) {
        Symbol vfp = this.func.module.globalSymtab.get("%vfp");
        if (node instanceof LirSymRef) {
            Symbol sym = ((LirSymRef)node).symbol;
            return sym == vfp;
        }
        return false;
    }

    static {
        CodeGenerator_arm.rrinit0();
        CodeGenerator_arm.rrinit100();
        CodeGenerator_arm.rrinit200();
        I64 = Type.type(2, 64L);
        I32 = Type.type(2, 32L);
        I16 = Type.type(2, 16L);
        I8 = Type.type(2, 8L);
        F64 = Type.type(4, 64L);
        F32 = Type.type(4, 32L);
        paramRegv = new String[]{"%r0", "%r1", "%r2", "%r3"};
        flipCc = new HashMap();
        flipCc.put("eq", "ne");
        flipCc.put("ne", "eq");
        flipCc.put("lt", "ge");
        flipCc.put("le", "gt");
        flipCc.put("gt", "le");
        flipCc.put("ge", "lt");
        flipCc.put("lo", "hs");
        flipCc.put("ls", "hi");
        flipCc.put("hi", "ls");
        flipCc.put("hs", "lo");
    }

    abstract class PeepHoleOp {
        PeepHoleOp() {
        }

        abstract boolean doIt(ImList var1, BiLink var2);

        void addBefore(ImList inst, BiLink l) {
            l.addBefore(inst);
        }
    }

    class JumpcEntry {
        final String cc;
        final String trueTarget;
        final String falseTarget;
        final boolean ifThenElse;

        JumpcEntry(String cc, String trueTarget) {
            this.cc = cc;
            this.ifThenElse = false;
            this.trueTarget = trueTarget;
            this.falseTarget = "";
        }

        JumpcEntry(String cc, String trueTarget, String falseTarget) {
            this.cc = cc;
            this.ifThenElse = true;
            this.trueTarget = trueTarget;
            this.falseTarget = falseTarget;
        }

        public String toString() {
            return "[cc = " + this.cc + ", label1 = " + this.trueTarget + ", label1 = " + this.falseTarget + "]";
        }
    }

    class JumpcKey {
        Function func;
        int id;

        JumpcKey(Function f, int i) {
            this.func = f;
            this.id = i;
        }
    }

    class ArmConst {
        private long rawValue;
        private RotatedValue val;
        private static final long UINT_MAX = 0xFFFFFFFFL;
        RotatedValue[] b = new RotatedValue[4];
        int nofBytes = 0;

        private String toHex(int val) {
            return this.toHex((long)val);
        }

        private String toHex(long val) {
            return Long.toString(val & 0xFFFFFFFFL, 16);
        }

        public ArmConst(long val) {
            this.rawValue = val & 0xFFFFFFFFL;
            this.val = new RotatedValue(this.rawValue);
        }

        int normalize() {
            int bi = 0;
            if (this.rawValue == 0L) {
                this.nofBytes = 1;
                return 1;
            }
            while (this.val.value() != 0L) {
                this.val.minimize();
                this.b[bi] = new RotatedValue(this.val.value() & 0xFFL, this.val.lsr());
                ++bi;
                this.val.shr8();
            }
            this.nofBytes = bi;
            return this.nofBytes;
        }

        public String get(int off) {
            if (this.rawValue == 0L) {
                return "0";
            }
            if (this.b[off] == null) {
                return "0";
            }
            return String.valueOf(this.b[off]);
        }

        public void print() {
            System.out.println("value: " + this.toHex(this.rawValue));
            for (int i = 0; i < this.nofBytes; ++i) {
                System.out.println("  " + i + ": " + this.b[i].value() + ":" + this.b[i].lsr());
            }
        }

        private class RotatedValue {
            private long value;
            private int lsr;

            RotatedValue(long val, int n) {
                this.value = val & 0xFFFFFFFFL;
                this.lsr = n;
            }

            RotatedValue(long val) {
                this(val, 0);
            }

            long value() {
                return this.value;
            }

            int lsr() {
                return this.lsr;
            }

            private void incLsr() {
                ++this.lsr;
                if (this.lsr == 32) {
                    this.lsr = 0;
                }
            }

            private void decLsr() {
                --this.lsr;
                if (this.lsr == -1) {
                    this.lsr = 31;
                }
            }

            void ror() {
                this.incLsr();
                this.value = (this.value << 31 | this.value >>> 1) & 0xFFFFFFFFL;
            }

            void rol() {
                this.decLsr();
                this.value = (this.value << 1 | this.value >>> 31) & 0xFFFFFFFFL;
            }

            void ror2(int n) {
                for (int i = 0; i < n; ++i) {
                    this.ror();
                    this.ror();
                }
            }

            void rol2(int n) {
                for (int i = 0; i < n; ++i) {
                    this.rol();
                    this.rol();
                }
            }

            void shr8() {
                this.lsr += 8;
                if (this.lsr > 32) {
                    this.lsr -= 32;
                }
                this.value = this.value >>> 8 & 0xFFFFFFFFL;
            }

            public String toString() {
                return "0x" + Long.toString(this.value << this.lsr & 0xFFFFFFFFL | this.value >>> 32 - this.lsr & 0xFFFFFFFFL, 16);
            }

            void minimize() {
                int n = this.lsr;
                long min = this.value;
                for (int i = 1; i <= 16; ++i) {
                    this.ror2(1);
                    if (this.value >= min) continue;
                    min = this.value;
                    n = this.lsr;
                }
                this.value = min;
                this.lsr = n;
            }
        }
    }

    static class ArmAttr
    extends CodeGenerator.FunctionAttr {
        int adjustCalleeSaves = -1;

        ArmAttr(Function func) {
            super(func);
        }
    }

    final class Arm
    extends CPU {
        Arm() {
            this.bccRange = new int[]{-2147483632, 0x7FFFFFF0};
            this.braRange = new int[]{-2147483632, 0x7FFFFFF0};
            this.literalRange = new int[]{-800, 800};
            this.bccMnemo = new String[]{"beq", "bne", "bhs", "blo", "bhi", "bls", "bge", "blt", "bgt", "ble"};
            this.braMnemo = "b";
            this.braLength = 4;
            this.codeAlign = 2;
        }

        public int codeLength(String inst) {
            return 4;
        }

        public String toString() {
            return "Arm";
        }
    }

    class State {
        static final int NNONTERM = 104;
        static final int NRULES = 297;
        static final int START_NT = 6;
        static final int NT__ = 0;
        static final int NT_regw = 1;
        static final int NT_regh = 2;
        static final int NT_regb = 3;
        static final int NT_regf = 4;
        static final int NT_regd = 5;
        static final int NT_void = 6;
        static final int NT_label = 7;
        static final int NT_xregw = 8;
        static final int NT_xregh = 9;
        static final int NT_xregb = 10;
        static final int NT_xregf = 11;
        static final int NT_xregd = 12;
        static final int NT_cbu = 13;
        static final int NT_cnst = 14;
        static final int NT_ch = 15;
        static final int NT_cw = 16;
        static final int NT_sta = 17;
        static final int NT_asmcnst = 18;
        static final int NT_ximm1 = 19;
        static final int NT_xmimm = 20;
        static final int NT_ximm = 21;
        static final int NT_base = 22;
        static final int NT_imm8 = 23;
        static final int NT_imm12 = 24;
        static final int NT_index = 25;
        static final int NT_sindex = 26;
        static final int NT__1 = 27;
        static final int NT__2 = 28;
        static final int NT__3 = 29;
        static final int NT__4 = 30;
        static final int NT__5 = 31;
        static final int NT__6 = 32;
        static final int NT__7 = 33;
        static final int NT__8 = 34;
        static final int NT_addr2 = 35;
        static final int NT_addr3 = 36;
        static final int NT_memw = 37;
        static final int NT_memw3 = 38;
        static final int NT_memb = 39;
        static final int NT_memh = 40;
        static final int NT_memsb = 41;
        static final int NT__9 = 42;
        static final int NT__10 = 43;
        static final int NT__11 = 44;
        static final int NT_imm8r = 45;
        static final int NT_imm8rm = 46;
        static final int NT_imm8rn = 47;
        static final int NT_sregw = 48;
        static final int NT_orop = 49;
        static final int NT_opop = 50;
        static final int NT_logop = 51;
        static final int NT_cmpop = 52;
        static final int NT__12 = 53;
        static final int NT__13 = 54;
        static final int NT__14 = 55;
        static final int NT__15 = 56;
        static final int NT__16 = 57;
        static final int NT__17 = 58;
        static final int NT__18 = 59;
        static final int NT__19 = 60;
        static final int NT__20 = 61;
        static final int NT__21 = 62;
        static final int NT_cnstf = 63;
        static final int NT_cnstd = 64;
        static final int NT_memf = 65;
        static final int NT__22 = 66;
        static final int NT__23 = 67;
        static final int NT__24 = 68;
        static final int NT__25 = 69;
        static final int NT__26 = 70;
        static final int NT__27 = 71;
        static final int NT__28 = 72;
        static final int NT__29 = 73;
        static final int NT__30 = 74;
        static final int NT__31 = 75;
        static final int NT_memd = 76;
        static final int NT__32 = 77;
        static final int NT__33 = 78;
        static final int NT__34 = 79;
        static final int NT__35 = 80;
        static final int NT__36 = 81;
        static final int NT__37 = 82;
        static final int NT__38 = 83;
        static final int NT__39 = 84;
        static final int NT__40 = 85;
        static final int NT__41 = 86;
        static final int NT__42 = 87;
        static final int NT__43 = 88;
        static final int NT__44 = 89;
        static final int NT__45 = 90;
        static final int NT__46 = 91;
        static final int NT__47 = 92;
        static final int NT__48 = 93;
        static final int NT__49 = 94;
        static final int NT__50 = 95;
        static final int NT__51 = 96;
        static final int NT__52 = 97;
        static final int NT__53 = 98;
        static final int NT__54 = 99;
        static final int NT__55 = 100;
        static final int NT__56 = 101;
        static final int NT__57 = 102;
        static final int NT__58 = 103;
        final int[] rule = new int[104];
        final int[] cost1 = new int[104];
        final int[] cost2 = new int[104];

        State() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "regw";
                }
                case 2: {
                    return "regh";
                }
                case 3: {
                    return "regb";
                }
                case 4: {
                    return "regf";
                }
                case 5: {
                    return "regd";
                }
                case 6: {
                    return "void";
                }
                case 7: {
                    return "label";
                }
                case 8: {
                    return "xregw";
                }
                case 9: {
                    return "xregh";
                }
                case 10: {
                    return "xregb";
                }
                case 11: {
                    return "xregf";
                }
                case 12: {
                    return "xregd";
                }
                case 13: {
                    return "cbu";
                }
                case 14: {
                    return "cnst";
                }
                case 15: {
                    return "ch";
                }
                case 16: {
                    return "cw";
                }
                case 17: {
                    return "sta";
                }
                case 18: {
                    return "asmcnst";
                }
                case 19: {
                    return "ximm1";
                }
                case 20: {
                    return "xmimm";
                }
                case 21: {
                    return "ximm";
                }
                case 22: {
                    return "base";
                }
                case 23: {
                    return "imm8";
                }
                case 24: {
                    return "imm12";
                }
                case 25: {
                    return "index";
                }
                case 26: {
                    return "sindex";
                }
                case 27: {
                    return "_1";
                }
                case 28: {
                    return "_2";
                }
                case 29: {
                    return "_3";
                }
                case 30: {
                    return "_4";
                }
                case 31: {
                    return "_5";
                }
                case 32: {
                    return "_6";
                }
                case 33: {
                    return "_7";
                }
                case 34: {
                    return "_8";
                }
                case 35: {
                    return "addr2";
                }
                case 36: {
                    return "addr3";
                }
                case 37: {
                    return "memw";
                }
                case 38: {
                    return "memw3";
                }
                case 39: {
                    return "memb";
                }
                case 40: {
                    return "memh";
                }
                case 41: {
                    return "memsb";
                }
                case 42: {
                    return "_9";
                }
                case 43: {
                    return "_10";
                }
                case 44: {
                    return "_11";
                }
                case 45: {
                    return "imm8r";
                }
                case 46: {
                    return "imm8rm";
                }
                case 47: {
                    return "imm8rn";
                }
                case 48: {
                    return "sregw";
                }
                case 49: {
                    return "orop";
                }
                case 50: {
                    return "opop";
                }
                case 51: {
                    return "logop";
                }
                case 52: {
                    return "cmpop";
                }
                case 53: {
                    return "_12";
                }
                case 54: {
                    return "_13";
                }
                case 55: {
                    return "_14";
                }
                case 56: {
                    return "_15";
                }
                case 57: {
                    return "_16";
                }
                case 58: {
                    return "_17";
                }
                case 59: {
                    return "_18";
                }
                case 60: {
                    return "_19";
                }
                case 61: {
                    return "_20";
                }
                case 62: {
                    return "_21";
                }
                case 63: {
                    return "cnstf";
                }
                case 64: {
                    return "cnstd";
                }
                case 65: {
                    return "memf";
                }
                case 66: {
                    return "_22";
                }
                case 67: {
                    return "_23";
                }
                case 68: {
                    return "_24";
                }
                case 69: {
                    return "_25";
                }
                case 70: {
                    return "_26";
                }
                case 71: {
                    return "_27";
                }
                case 72: {
                    return "_28";
                }
                case 73: {
                    return "_29";
                }
                case 74: {
                    return "_30";
                }
                case 75: {
                    return "_31";
                }
                case 76: {
                    return "memd";
                }
                case 77: {
                    return "_32";
                }
                case 78: {
                    return "_33";
                }
                case 79: {
                    return "_34";
                }
                case 80: {
                    return "_35";
                }
                case 81: {
                    return "_36";
                }
                case 82: {
                    return "_37";
                }
                case 83: {
                    return "_38";
                }
                case 84: {
                    return "_39";
                }
                case 85: {
                    return "_40";
                }
                case 86: {
                    return "_41";
                }
                case 87: {
                    return "_42";
                }
                case 88: {
                    return "_43";
                }
                case 89: {
                    return "_44";
                }
                case 90: {
                    return "_45";
                }
                case 91: {
                    return "_46";
                }
                case 92: {
                    return "_47";
                }
                case 93: {
                    return "_48";
                }
                case 94: {
                    return "_49";
                }
                case 95: {
                    return "_50";
                }
                case 96: {
                    return "_51";
                }
                case 97: {
                    return "_52";
                }
                case 98: {
                    return "_53";
                }
                case 99: {
                    return "_54";
                }
                case 100: {
                    return "_55";
                }
                case 101: {
                    return "_56";
                }
                case 102: {
                    return "_57";
                }
                case 103: {
                    return "_58";
                }
            }
            return null;
        }

        void record(int nt, int cost1, int cost2, int rule) {
            if (this.rule[nt] == 0 || (CodeGenerator_arm.this.optSpeed ? cost1 < this.cost1[nt] || cost1 == this.cost1[nt] && cost2 < this.cost2[nt] : cost2 < this.cost2[nt] || cost2 == this.cost2[nt] && cost1 < this.cost1[nt])) {
                this.rule[nt] = rule;
                this.cost1[nt] = cost1;
                this.cost2[nt] = cost2;
                switch (nt) {
                    case 1: {
                        this.record(22, 0 + cost1, 0 + cost2, 30);
                        this.record(25, 0 + cost1, 0 + cost2, 35);
                        this.record(49, 0 + cost1, 0 + cost2, 148);
                        this.record(50, 0 + cost1, 0 + cost2, 150);
                        this.record(51, 0 + cost1, 0 + cost2, 152);
                        this.record(52, 0 + cost1, 0 + cost2, 154);
                        break;
                    }
                    case 8: {
                        this.record(1, 0 + cost1, 0 + cost2, 4);
                        break;
                    }
                    case 9: {
                        this.record(2, 0 + cost1, 0 + cost2, 7);
                        break;
                    }
                    case 10: {
                        this.record(3, 0 + cost1, 0 + cost2, 10);
                        break;
                    }
                    case 11: {
                        this.record(4, 0 + cost1, 0 + cost2, 13);
                        break;
                    }
                    case 12: {
                        this.record(5, 0 + cost1, 0 + cost2, 16);
                        break;
                    }
                    case 13: {
                        this.record(14, 0 + cost1, 0 + cost2, 18);
                        this.record(3, 1 + cost1, 1 + cost2, 72);
                        break;
                    }
                    case 14: {
                        this.record(18, 0 + cost1, 0 + cost2, 24);
                        break;
                    }
                    case 15: {
                        this.record(14, 0 + cost1, 0 + cost2, 20);
                        this.record(2, 2 + cost1, 2 + cost2, 74);
                        break;
                    }
                    case 16: {
                        this.record(14, 0 + cost1, 0 + cost2, 22);
                        this.record(1, 2 + cost1, 1 + cost2, 75);
                        break;
                    }
                    case 17: {
                        this.record(1, 2 + cost1, 1 + cost2, 69);
                        break;
                    }
                    case 18: {
                        this.record(1, 2 + cost1, 1 + cost2, 70);
                        break;
                    }
                    case 19: {
                        this.record(2, 1 + cost1, 1 + cost2, 73);
                        break;
                    }
                    case 21: {
                        this.record(1, 1 + cost1, 1 + cost2, 76);
                        break;
                    }
                    case 22: {
                        this.record(35, 0 + cost1, 0 + cost2, 52);
                        this.record(36, 0 + cost1, 0 + cost2, 60);
                        break;
                    }
                    case 23: {
                        this.record(25, 0 + cost1, 0 + cost2, 33);
                        break;
                    }
                    case 24: {
                        this.record(25, 0 + cost1, 0 + cost2, 34);
                        break;
                    }
                    case 37: {
                        this.record(1, 2 + cost1, 1 + cost2, 79);
                        break;
                    }
                    case 39: {
                        this.record(3, 3 + cost1, 1 + cost2, 77);
                        break;
                    }
                    case 40: {
                        this.record(2, 3 + cost1, 1 + cost2, 78);
                        break;
                    }
                    case 45: {
                        this.record(49, 0 + cost1, 0 + cost2, 141);
                        this.record(50, 0 + cost1, 0 + cost2, 142);
                        this.record(51, 0 + cost1, 0 + cost2, 144);
                        this.record(52, 0 + cost1, 0 + cost2, 146);
                        break;
                    }
                    case 46: {
                        this.record(50, 0 + cost1, 0 + cost2, 143);
                        this.record(52, 0 + cost1, 0 + cost2, 147);
                        break;
                    }
                    case 47: {
                        this.record(51, 0 + cost1, 0 + cost2, 145);
                        break;
                    }
                    case 48: {
                        this.record(49, 0 + cost1, 0 + cost2, 149);
                        this.record(50, 0 + cost1, 0 + cost2, 151);
                        this.record(51, 0 + cost1, 0 + cost2, 153);
                        this.record(52, 0 + cost1, 0 + cost2, 155);
                        break;
                    }
                    case 63: {
                        this.record(4, 4 + cost1, 4 + cost2, 206);
                        break;
                    }
                    case 64: {
                        this.record(5, 4 + cost1, 4 + cost2, 239);
                        break;
                    }
                    case 65: {
                        this.record(4, 4 + cost1, 4 + cost2, 207);
                        break;
                    }
                    case 76: {
                        this.record(5, 4 + cost1, 4 + cost2, 240);
                    }
                }
            }
        }

        void label(LirNode t, State[] kids) {
            switch (t.opCode) {
                case 2: {
                    if (Type.bits(((LirIconst)t).type) == 8) {
                        this.record(13, 0, 0, 17);
                    }
                    if (Type.bits(((LirIconst)t).type) == 16) {
                        this.record(15, 0, 0, 19);
                    }
                    if (Type.bits(((LirIconst)t).type) == 32) {
                        this.record(16, 0, 0, 21);
                    }
                    if (CodeGenerator_arm.this.nofBytes(((LirIconst)t).signedValue()) == 1) {
                        this.record(19, 0, 0, 27);
                    }
                    if (CodeGenerator_arm.this.nofBytes(-((LirIconst)t).signedValue()) <= 4) {
                        this.record(20, 0, 0, 28);
                    }
                    this.record(21, 0, 0, 29);
                    if (-255L <= ((LirIconst)t).signedValue() && ((LirIconst)t).signedValue() <= 255L) {
                        this.record(23, 0, 0, 31);
                    }
                    if (-4095L <= ((LirIconst)t).signedValue() && ((LirIconst)t).signedValue() <= 4095L) {
                        this.record(24, 0, 0, 32);
                    }
                    if (CodeGenerator_arm.this.isImm8r(((LirIconst)t).signedValue())) {
                        this.record(45, 0, 0, 110);
                    }
                    if (CodeGenerator_arm.this.isImm8r(-((LirIconst)t).signedValue())) {
                        this.record(46, 0, 0, 111);
                    }
                    if (CodeGenerator_arm.this.isImm8r(((LirIconst)t).signedValue() ^ 0xFFFFFFFFFFFFFFFFL)) {
                        this.record(47, 0, 0, 112);
                    }
                    if (t.type != 514) break;
                    if (((LirIconst)t).value == 1L) {
                        this.record(27, 0, 0, 36);
                    }
                    if (((LirIconst)t).value == 2L) {
                        this.record(28, 0, 0, 38);
                    }
                    if (((LirIconst)t).value == 3L) {
                        this.record(29, 0, 0, 40);
                    }
                    if (((LirIconst)t).value == 4L) {
                        this.record(30, 0, 0, 42);
                    }
                    if (((LirIconst)t).value == 5L) {
                        this.record(31, 0, 0, 44);
                    }
                    if (((LirIconst)t).value == 6L) {
                        this.record(32, 0, 0, 46);
                    }
                    if (((LirIconst)t).value == 7L) {
                        this.record(33, 0, 0, 48);
                    }
                    if (((LirIconst)t).value != 8L) break;
                    this.record(34, 0, 0, 50);
                    break;
                }
                case 3: {
                    if (Type.bits(((LirFconst)t).type) == 32) {
                        this.record(63, 0, 0, 203);
                    }
                    if (Type.bits(((LirFconst)t).type) != 64) break;
                    this.record(64, 0, 0, 204);
                    break;
                }
                case 4: {
                    if (t.type != 514) break;
                    this.record(17, 0, 0, 23);
                    break;
                }
                case 6: {
                    if (t.type == 130) {
                        this.record(10, 0, 0, 8);
                    }
                    if (t.type == 258) {
                        this.record(9, 0, 0, 5);
                    }
                    if (t.type == 514) {
                        this.record(8, 0, 0, 2);
                        if (((LirSymRef)t).symbol.name == "%sp") {
                            this.record(87, 0, 0, 275);
                        }
                    }
                    if (t.type == 516) {
                        this.record(11, 0, 0, 11);
                    }
                    if (t.type != 1028) break;
                    this.record(12, 0, 0, 14);
                    break;
                }
                case 7: {
                    if (t.type == 130) {
                        this.record(10, 0, 0, 9);
                    }
                    if (t.type == 258) {
                        this.record(9, 0, 0, 6);
                    }
                    if (t.type == 514) {
                        this.record(8, 0, 0, 3);
                    }
                    if (t.type == 516) {
                        this.record(11, 0, 0, 12);
                    }
                    if (t.type != 1028) break;
                    this.record(12, 0, 0, 15);
                    break;
                }
                case 8: {
                    this.record(7, 0, 0, 1);
                    break;
                }
                case 9: {
                    if (t.type == 514 && kids[0].rule[1] != 0) {
                        this.record(1, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 178);
                    }
                    if (t.type == 516 && kids[0].rule[4] != 0) {
                        this.record(4, 3 + kids[0].cost1[4], 3 + kids[0].cost2[4], 209);
                    }
                    if (t.type != 1028 || kids[0].rule[5] == 0) break;
                    this.record(5, 3 + kids[0].cost1[5], 3 + kids[0].cost2[5], 242);
                    break;
                }
                case 10: {
                    if (t.type == 514) {
                        if (kids[0].rule[18] != 0 && kids[1].rule[14] != 0) {
                            this.record(18, 0 + kids[0].cost1[18] + kids[1].cost1[14], 0 + kids[0].cost2[18] + kids[1].cost2[14], 25);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[24] != 0 && CodeGenerator_arm.this.isVirtual(t.kid(0))) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[24], 0 + kids[0].cost2[22] + kids[1].cost2[24], 53);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[24] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[24], 0 + kids[0].cost2[22] + kids[1].cost2[24], 54);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[25] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[25], 0 + kids[0].cost2[22] + kids[1].cost2[25], 56);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[26] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[26], 0 + kids[0].cost2[22] + kids[1].cost2[26], 58);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[23] != 0 && CodeGenerator_arm.this.isVirtual(t.kid(0))) {
                            this.record(36, 0 + kids[0].cost1[22] + kids[1].cost1[23], 0 + kids[0].cost2[22] + kids[1].cost2[23], 61);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[23] != 0) {
                            this.record(36, 0 + kids[0].cost1[22] + kids[1].cost1[23], 0 + kids[0].cost2[22] + kids[1].cost2[23], 62);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[20] != 0 && CodeGenerator_arm.this.isVirtual(t.kid(0))) {
                            this.record(1, 0 + kids[0].cost1[1] + kids[1].cost1[20], 0 + kids[0].cost2[1] + kids[1].cost2[20], 113);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[50] != 0) {
                            this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[50], 1 + kids[0].cost2[1] + kids[1].cost2[50], 156);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[21] != 0) {
                            this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[21], 2 + kids[0].cost2[1] + kids[1].cost2[21], 166);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[30] != 0) {
                            this.record(98, 0 + kids[0].cost1[87] + kids[1].cost1[30], 0 + kids[0].cost2[87] + kids[1].cost2[30], 288);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[34] != 0) {
                            this.record(102, 0 + kids[0].cost1[87] + kids[1].cost1[34], 0 + kids[0].cost2[87] + kids[1].cost2[34], 293);
                        }
                    }
                    if (t.type == 516 && kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(4, 3 + kids[0].cost1[4] + kids[1].cost1[4], 3 + kids[0].cost2[4] + kids[1].cost2[4], 210);
                    }
                    if (t.type != 1028 || kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(5, 3 + kids[0].cost1[5] + kids[1].cost1[5], 3 + kids[0].cost2[5] + kids[1].cost2[5], 243);
                    break;
                }
                case 11: {
                    if (t.type == 514) {
                        if (kids[0].rule[18] != 0 && kids[1].rule[14] != 0) {
                            this.record(18, 0 + kids[0].cost1[18] + kids[1].cost1[14], 0 + kids[0].cost2[18] + kids[1].cost2[14], 26);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[24] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[24], 0 + kids[0].cost2[22] + kids[1].cost2[24], 55);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[25] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[25], 0 + kids[0].cost2[22] + kids[1].cost2[25], 57);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[26] != 0) {
                            this.record(35, 0 + kids[0].cost1[22] + kids[1].cost1[26], 0 + kids[0].cost2[22] + kids[1].cost2[26], 59);
                        }
                        if (kids[0].rule[22] != 0 && kids[1].rule[23] != 0) {
                            this.record(36, 0 + kids[0].cost1[22] + kids[1].cost1[23], 0 + kids[0].cost2[22] + kids[1].cost2[23], 63);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[50] != 0) {
                            this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[50], 1 + kids[0].cost2[1] + kids[1].cost2[50], 157);
                        }
                        if (kids[0].rule[49] != 0 && kids[1].rule[1] != 0) {
                            this.record(1, 1 + kids[0].cost1[49] + kids[1].cost1[1], 1 + kids[0].cost2[49] + kids[1].cost2[1], 159);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[21] != 0) {
                            this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[21], 2 + kids[0].cost2[1] + kids[1].cost2[21], 167);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[30] != 0) {
                            this.record(88, 0 + kids[0].cost1[87] + kids[1].cost1[30], 0 + kids[0].cost2[87] + kids[1].cost2[30], 276);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[34] != 0) {
                            this.record(92, 0 + kids[0].cost1[87] + kids[1].cost1[34], 0 + kids[0].cost2[87] + kids[1].cost2[34], 281);
                        }
                    }
                    if (t.type == 516 && kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(4, 3 + kids[0].cost1[4] + kids[1].cost1[4], 3 + kids[0].cost2[4] + kids[1].cost2[4], 211);
                    }
                    if (t.type != 1028 || kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(5, 3 + kids[0].cost1[5] + kids[1].cost1[5], 3 + kids[0].cost2[5] + kids[1].cost2[5], 244);
                    break;
                }
                case 12: {
                    if (t.type == 514 && kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(1, 4 + kids[0].cost1[1] + kids[1].cost1[1], 1 + kids[0].cost2[1] + kids[1].cost2[1], 169);
                    }
                    if (t.type == 516 && kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(4, 3 + kids[0].cost1[4] + kids[1].cost1[4], 3 + kids[0].cost2[4] + kids[1].cost2[4], 212);
                    }
                    if (t.type != 1028 || kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(5, 3 + kids[0].cost1[5] + kids[1].cost1[5], 3 + kids[0].cost2[5] + kids[1].cost2[5], 245);
                    break;
                }
                case 13: {
                    if (t.type == 514 && kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(1, 20 + kids[0].cost1[1] + kids[1].cost1[1], 4 + kids[0].cost2[1] + kids[1].cost2[1], 170);
                    }
                    if (t.type == 516 && kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(4, 3 + kids[0].cost1[4] + kids[1].cost1[4], 3 + kids[0].cost2[4] + kids[1].cost2[4], 213);
                    }
                    if (t.type != 1028 || kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(5, 3 + kids[0].cost1[5] + kids[1].cost1[5], 3 + kids[0].cost2[5] + kids[1].cost2[5], 246);
                    break;
                }
                case 14: {
                    if (t.type != 514 || kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 20 + kids[0].cost1[1] + kids[1].cost1[1], 4 + kids[0].cost2[1] + kids[1].cost2[1], 171);
                    break;
                }
                case 15: {
                    if (t.type != 514 || kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 20 + kids[0].cost1[1] + kids[1].cost1[1], 4 + kids[0].cost2[1] + kids[1].cost2[1], 172);
                    break;
                }
                case 16: {
                    if (t.type != 514 || kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 20 + kids[0].cost1[1] + kids[1].cost1[1], 4 + kids[0].cost2[1] + kids[1].cost2[1], 173);
                    break;
                }
                case 17: {
                    if (t.type == 258) {
                        if (kids[0].rule[41] != 0) {
                            this.record(2, 3 + kids[0].cost1[41], 1 + kids[0].cost2[41], 85);
                        }
                        if (kids[0].rule[3] != 0) {
                            this.record(2, 2 + kids[0].cost1[3], 2 + kids[0].cost2[3], 106);
                        }
                    }
                    if (t.type != 514) break;
                    if (kids[0].rule[41] != 0) {
                        this.record(1, 3 + kids[0].cost1[41], 1 + kids[0].cost2[41], 82);
                    }
                    if (kids[0].rule[40] != 0) {
                        this.record(1, 3 + kids[0].cost1[40], 1 + kids[0].cost2[40], 83);
                    }
                    if (kids[0].rule[3] != 0) {
                        this.record(1, 2 + kids[0].cost1[3], 2 + kids[0].cost2[3], 104);
                    }
                    if (kids[0].rule[2] == 0) break;
                    this.record(1, 2 + kids[0].cost1[2], 2 + kids[0].cost2[2], 105);
                    break;
                }
                case 18: {
                    if (t.type == 258) {
                        if (kids[0].rule[39] != 0) {
                            this.record(2, 3 + kids[0].cost1[39], 1 + kids[0].cost2[39], 84);
                        }
                        if (kids[0].rule[3] != 0) {
                            this.record(2, 0 + kids[0].cost1[3], 0 + kids[0].cost2[3], 103);
                        }
                    }
                    if (t.type != 514) break;
                    if (kids[0].rule[39] != 0) {
                        this.record(1, 3 + kids[0].cost1[39], 1 + kids[0].cost2[39], 80);
                    }
                    if (kids[0].rule[40] != 0) {
                        this.record(1, 3 + kids[0].cost1[40], 1 + kids[0].cost2[40], 81);
                    }
                    if (kids[0].rule[2] != 0) {
                        this.record(1, 0 + kids[0].cost1[2], 0 + kids[0].cost2[2], 101);
                    }
                    if (kids[0].rule[3] == 0) break;
                    this.record(1, 0 + kids[0].cost1[3], 0 + kids[0].cost2[3], 102);
                    break;
                }
                case 19: {
                    if (t.type == 130) {
                        if (kids[0].rule[38] != 0) {
                            this.record(3, 3 + kids[0].cost1[38], 1 + kids[0].cost2[38], 86);
                        }
                        if (kids[0].rule[40] != 0) {
                            this.record(3, 3 + kids[0].cost1[40], 1 + kids[0].cost2[40], 88);
                        }
                        if (kids[0].rule[1] != 0) {
                            this.record(42, 0 + kids[0].cost1[1], 0 + kids[0].cost2[1], 92);
                        }
                        if (kids[0].rule[2] != 0) {
                            this.record(43, 0 + kids[0].cost1[2], 0 + kids[0].cost2[2], 94);
                        }
                        if (kids[0].rule[1] != 0) {
                            this.record(3, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 107);
                        }
                        if (kids[0].rule[2] != 0) {
                            this.record(3, 1 + kids[0].cost1[2], 1 + kids[0].cost2[2], 108);
                        }
                    }
                    if (t.type != 258) break;
                    if (kids[0].rule[38] != 0) {
                        this.record(2, 3 + kids[0].cost1[38], 1 + kids[0].cost2[38], 87);
                    }
                    if (kids[0].rule[1] != 0) {
                        this.record(44, 0 + kids[0].cost1[1], 0 + kids[0].cost2[1], 96);
                    }
                    if (kids[0].rule[1] == 0) break;
                    this.record(2, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 109);
                    break;
                }
                case 20: {
                    if (t.type != 1028 || kids[0].rule[4] == 0) break;
                    this.record(5, 1 + kids[0].cost1[4], 1 + kids[0].cost2[4], 271);
                    break;
                }
                case 21: {
                    if (t.type != 516 || kids[0].rule[5] == 0) break;
                    this.record(4, 1 + kids[0].cost1[5], 1 + kids[0].cost2[5], 272);
                    break;
                }
                case 23: {
                    if (t.type == 130) {
                        if (kids[0].rule[4] != 0) {
                            this.record(3, 2 + kids[0].cost1[4], 2 + kids[0].cost2[4], 236);
                        }
                        if (kids[0].rule[5] != 0) {
                            this.record(3, 2 + kids[0].cost1[5], 2 + kids[0].cost2[5], 269);
                        }
                    }
                    if (t.type == 258) {
                        if (kids[0].rule[4] != 0) {
                            this.record(2, 3 + kids[0].cost1[4], 3 + kids[0].cost2[4], 235);
                        }
                        if (kids[0].rule[5] != 0) {
                            this.record(2, 3 + kids[0].cost1[5], 3 + kids[0].cost2[5], 268);
                        }
                    }
                    if (t.type != 514) break;
                    if (kids[0].rule[4] != 0) {
                        this.record(1, 1 + kids[0].cost1[4], 1 + kids[0].cost2[4], 234);
                    }
                    if (kids[0].rule[5] == 0) break;
                    this.record(1, 1 + kids[0].cost1[5], 1 + kids[0].cost2[5], 267);
                    break;
                }
                case 25: {
                    if (t.type == 516 && kids[0].rule[1] != 0) {
                        this.record(4, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 237);
                    }
                    if (t.type != 1028 || kids[0].rule[1] == 0) break;
                    this.record(5, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 270);
                    break;
                }
                case 27: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[51] != 0) {
                        this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[51], 1 + kids[0].cost2[1] + kids[1].cost2[51], 158);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[21] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[21], 2 + kids[0].cost2[1] + kids[1].cost2[21], 168);
                    break;
                }
                case 28: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[46] != 0) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[46], 2 + kids[0].cost2[1] + kids[1].cost2[46], 160);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[49] != 0) {
                        this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[49], 1 + kids[0].cost2[1] + kids[1].cost2[49], 161);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[21] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[21], 2 + kids[0].cost2[1] + kids[1].cost2[21], 164);
                    break;
                }
                case 29: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[46] != 0) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[46], 2 + kids[0].cost2[1] + kids[1].cost2[46], 162);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[49] != 0) {
                        this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[49], 1 + kids[0].cost2[1] + kids[1].cost2[49], 163);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[21] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[21], 2 + kids[0].cost2[1] + kids[1].cost2[21], 165);
                    break;
                }
                case 30: {
                    if (t.type != 514 || kids[0].rule[1] == 0) break;
                    this.record(1, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 177);
                    break;
                }
                case 31: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[27] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[27], 0 + kids[0].cost2[1] + kids[1].cost2[27], 37);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[28] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[28], 0 + kids[0].cost2[1] + kids[1].cost2[28], 39);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[29] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[29], 0 + kids[0].cost2[1] + kids[1].cost2[29], 41);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[30] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[30], 0 + kids[0].cost2[1] + kids[1].cost2[30], 43);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[31] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[31], 0 + kids[0].cost2[1] + kids[1].cost2[31], 45);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[32] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[32], 0 + kids[0].cost2[1] + kids[1].cost2[32], 47);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[33] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[33], 0 + kids[0].cost2[1] + kids[1].cost2[33], 49);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[34] != 0) {
                        this.record(26, 0 + kids[0].cost1[1] + kids[1].cost1[34], 0 + kids[0].cost2[1] + kids[1].cost2[34], 51);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[27] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[27], 0 + kids[0].cost2[1] + kids[1].cost2[27], 114);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[28] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[28], 0 + kids[0].cost2[1] + kids[1].cost2[28], 117);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[29] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[29], 0 + kids[0].cost2[1] + kids[1].cost2[29], 120);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[30] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[30], 0 + kids[0].cost2[1] + kids[1].cost2[30], 123);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[31] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[31], 0 + kids[0].cost2[1] + kids[1].cost2[31], 126);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[32] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[32], 0 + kids[0].cost2[1] + kids[1].cost2[32], 129);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[33] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[33], 0 + kids[0].cost2[1] + kids[1].cost2[33], 132);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[34] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[34], 0 + kids[0].cost2[1] + kids[1].cost2[34], 135);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(48, 1 + kids[0].cost1[1] + kids[1].cost1[1], 0 + kids[0].cost2[1] + kids[1].cost2[1], 138);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[1], 1 + kids[0].cost2[1] + kids[1].cost2[1], 174);
                    break;
                }
                case 33: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[27] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[27], 0 + kids[0].cost2[1] + kids[1].cost2[27], 115);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[28] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[28], 0 + kids[0].cost2[1] + kids[1].cost2[28], 118);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[29] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[29], 0 + kids[0].cost2[1] + kids[1].cost2[29], 121);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[30] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[30], 0 + kids[0].cost2[1] + kids[1].cost2[30], 124);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[31] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[31], 0 + kids[0].cost2[1] + kids[1].cost2[31], 127);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[32] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[32], 0 + kids[0].cost2[1] + kids[1].cost2[32], 130);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[33] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[33], 0 + kids[0].cost2[1] + kids[1].cost2[33], 133);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[34] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[34], 0 + kids[0].cost2[1] + kids[1].cost2[34], 136);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(48, 1 + kids[0].cost1[1] + kids[1].cost1[1], 0 + kids[0].cost2[1] + kids[1].cost2[1], 139);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[1], 1 + kids[0].cost2[1] + kids[1].cost2[1], 175);
                    break;
                }
                case 34: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[27] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[27], 0 + kids[0].cost2[1] + kids[1].cost2[27], 116);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[28] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[28], 0 + kids[0].cost2[1] + kids[1].cost2[28], 119);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[29] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[29], 0 + kids[0].cost2[1] + kids[1].cost2[29], 122);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[30] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[30], 0 + kids[0].cost2[1] + kids[1].cost2[30], 125);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[31] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[31], 0 + kids[0].cost2[1] + kids[1].cost2[31], 128);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[32] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[32], 0 + kids[0].cost2[1] + kids[1].cost2[32], 131);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[33] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[33], 0 + kids[0].cost2[1] + kids[1].cost2[33], 134);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[34] != 0) {
                        this.record(48, 0 + kids[0].cost1[1] + kids[1].cost1[34], 0 + kids[0].cost2[1] + kids[1].cost2[34], 137);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(48, 1 + kids[0].cost1[1] + kids[1].cost1[1], 0 + kids[0].cost2[1] + kids[1].cost2[1], 140);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[1] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[1], 1 + kids[0].cost2[1] + kids[1].cost2[1], 176);
                    break;
                }
                case 35: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[52], 1 + kids[0].cost2[1] + kids[1].cost2[52], 179);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(53, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 180);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(66, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 214);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(77, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 247);
                    break;
                }
                case 36: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(54, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 182);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(67, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 216);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(78, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 249);
                    break;
                }
                case 37: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(55, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 184);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(68, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 218);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(79, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 251);
                    break;
                }
                case 38: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(56, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 186);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(69, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 220);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(80, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 253);
                    break;
                }
                case 39: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(57, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 188);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(70, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 222);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(81, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 255);
                    break;
                }
                case 40: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(58, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 190);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(71, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 224);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(82, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 257);
                    break;
                }
                case 41: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(59, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 192);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(72, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 226);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(83, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 259);
                    break;
                }
                case 42: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(60, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 194);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(73, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 228);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(84, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 261);
                    break;
                }
                case 43: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(61, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 196);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(74, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 230);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(85, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 263);
                    break;
                }
                case 44: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[52] != 0) {
                        this.record(62, 0 + kids[0].cost1[1] + kids[1].cost1[52], 0 + kids[0].cost2[1] + kids[1].cost2[52], 198);
                    }
                    if (kids[0].rule[4] != 0 && kids[1].rule[4] != 0) {
                        this.record(75, 0 + kids[0].cost1[4] + kids[1].cost1[4], 0 + kids[0].cost2[4] + kids[1].cost2[4], 232);
                    }
                    if (kids[0].rule[5] == 0 || kids[1].rule[5] == 0) break;
                    this.record(86, 0 + kids[0].cost1[5] + kids[1].cost1[5], 0 + kids[0].cost2[5] + kids[1].cost2[5], 265);
                    break;
                }
                case 47: {
                    if (t.type == 130) {
                        if (kids[0].rule[35] != 0) {
                            this.record(39, 0 + kids[0].cost1[35], 0 + kids[0].cost2[35], 66);
                        }
                        if (kids[0].rule[36] != 0) {
                            this.record(41, 0 + kids[0].cost1[36], 0 + kids[0].cost2[36], 68);
                        }
                    }
                    if (t.type == 258 && kids[0].rule[36] != 0) {
                        this.record(40, 0 + kids[0].cost1[36], 0 + kids[0].cost2[36], 67);
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[35] != 0) {
                            this.record(37, 0 + kids[0].cost1[35], 0 + kids[0].cost2[35], 64);
                        }
                        if (kids[0].rule[36] != 0) {
                            this.record(38, 0 + kids[0].cost1[36], 0 + kids[0].cost2[36], 65);
                        }
                        if (kids[0].rule[87] != 0) {
                            this.record(96, 0 + kids[0].cost1[87], 0 + kids[0].cost2[87], 286);
                        }
                        if (kids[0].rule[98] != 0) {
                            this.record(100, 0 + kids[0].cost1[98], 0 + kids[0].cost2[98], 291);
                        }
                    }
                    if (t.type == 516) {
                        if (kids[0].rule[36] != 0) {
                            this.record(65, 0 + kids[0].cost1[36], 0 + kids[0].cost2[36], 205);
                        }
                        if (kids[0].rule[87] != 0) {
                            this.record(90, 0 + kids[0].cost1[87], 0 + kids[0].cost2[87], 278);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[36] != 0) {
                        this.record(76, 0 + kids[0].cost1[36], 0 + kids[0].cost2[36], 238);
                    }
                    if (kids[0].rule[87] == 0) break;
                    this.record(94, 0 + kids[0].cost1[87], 0 + kids[0].cost2[87], 283);
                    break;
                }
                case 48: {
                    if (t.type == 130) {
                        if (kids[0].rule[39] != 0 && kids[1].rule[3] != 0) {
                            this.record(6, 1 + kids[0].cost1[39] + kids[1].cost1[3], 1 + kids[0].cost2[39] + kids[1].cost2[3], 91);
                        }
                        if (kids[0].rule[39] != 0 && kids[1].rule[42] != 0) {
                            this.record(6, 1 + kids[0].cost1[39] + kids[1].cost1[42], 1 + kids[0].cost2[39] + kids[1].cost2[42], 93);
                        }
                        if (kids[0].rule[39] != 0 && kids[1].rule[43] != 0) {
                            this.record(6, 1 + kids[0].cost1[39] + kids[1].cost1[43], 1 + kids[0].cost2[39] + kids[1].cost2[43], 95);
                        }
                        if (kids[0].rule[10] != 0 && kids[1].rule[3] != 0) {
                            this.record(6, 1 + kids[0].cost1[10] + kids[1].cost1[3], 1 + kids[0].cost2[10] + kids[1].cost2[3], 100);
                        }
                    }
                    if (t.type == 258) {
                        if (kids[0].rule[40] != 0 && kids[1].rule[2] != 0) {
                            this.record(6, 1 + kids[0].cost1[40] + kids[1].cost1[2], 1 + kids[0].cost2[40] + kids[1].cost2[2], 90);
                        }
                        if (kids[0].rule[40] != 0 && kids[1].rule[44] != 0) {
                            this.record(6, 1 + kids[0].cost1[40] + kids[1].cost1[44], 1 + kids[0].cost2[40] + kids[1].cost2[44], 97);
                        }
                        if (kids[0].rule[9] != 0 && kids[1].rule[2] != 0) {
                            this.record(6, 1 + kids[0].cost1[9] + kids[1].cost1[2], 1 + kids[0].cost2[9] + kids[1].cost2[2], 99);
                        }
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[37] != 0 && kids[1].rule[1] != 0) {
                            this.record(6, 1 + kids[0].cost1[37] + kids[1].cost1[1], 1 + kids[0].cost2[37] + kids[1].cost2[1], 89);
                        }
                        if (kids[0].rule[8] != 0 && kids[1].rule[1] != 0) {
                            this.record(6, 1 + kids[0].cost1[8] + kids[1].cost1[1], 1 + kids[0].cost2[8] + kids[1].cost2[1], 98);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[88] != 0) {
                            this.record(89, 0 + kids[0].cost1[87] + kids[1].cost1[88], 0 + kids[0].cost2[87] + kids[1].cost2[88], 277);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[92] != 0) {
                            this.record(93, 0 + kids[0].cost1[87] + kids[1].cost1[92], 0 + kids[0].cost2[87] + kids[1].cost2[92], 282);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[96] != 0) {
                            this.record(97, 0 + kids[0].cost1[1] + kids[1].cost1[96], 0 + kids[0].cost2[1] + kids[1].cost2[96], 287);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[98] != 0) {
                            this.record(99, 0 + kids[0].cost1[87] + kids[1].cost1[98], 0 + kids[0].cost2[87] + kids[1].cost2[98], 289);
                        }
                        if (kids[0].rule[1] != 0 && kids[1].rule[100] != 0) {
                            this.record(101, 0 + kids[0].cost1[1] + kids[1].cost1[100], 0 + kids[0].cost2[1] + kids[1].cost2[100], 292);
                        }
                        if (kids[0].rule[87] != 0 && kids[1].rule[102] != 0) {
                            this.record(103, 0 + kids[0].cost1[87] + kids[1].cost1[102], 0 + kids[0].cost2[87] + kids[1].cost2[102], 294);
                        }
                    }
                    if (t.type == 516) {
                        if (kids[0].rule[65] != 0 && kids[1].rule[4] != 0) {
                            this.record(6, 3 + kids[0].cost1[65] + kids[1].cost1[4], 3 + kids[0].cost2[65] + kids[1].cost2[4], 208);
                        }
                        if (kids[0].rule[11] != 0 && kids[1].rule[4] != 0) {
                            this.record(6, 1 + kids[0].cost1[11] + kids[1].cost1[4], 1 + kids[0].cost2[11] + kids[1].cost2[4], 274);
                        }
                        if (kids[0].rule[90] != 0 && kids[1].rule[4] != 0) {
                            this.record(91, 0 + kids[0].cost1[90] + kids[1].cost1[4], 0 + kids[0].cost2[90] + kids[1].cost2[4], 279);
                        }
                        if (kids[0].rule[65] != 0 && kids[1].rule[65] != 0) {
                            this.record(6, 1 + kids[0].cost1[65] + kids[1].cost1[65], 1 + kids[0].cost2[65] + kids[1].cost2[65], 296);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[76] != 0 && kids[1].rule[5] != 0) {
                        this.record(6, 3 + kids[0].cost1[76] + kids[1].cost1[5], 3 + kids[0].cost2[76] + kids[1].cost2[5], 241);
                    }
                    if (kids[0].rule[12] != 0 && kids[1].rule[5] != 0) {
                        this.record(6, 1 + kids[0].cost1[12] + kids[1].cost1[5], 1 + kids[0].cost2[12] + kids[1].cost2[5], 273);
                    }
                    if (kids[0].rule[94] == 0 || kids[1].rule[5] == 0) break;
                    this.record(95, 0 + kids[0].cost1[94] + kids[1].cost1[5], 0 + kids[0].cost2[94] + kids[1].cost2[5], 284);
                    break;
                }
                case 49: {
                    if (kids[0].rule[7] == 0) break;
                    this.record(6, 3 + kids[0].cost1[7], 1 + kids[0].cost2[7], 71);
                    break;
                }
                case 50: {
                    if (kids[0].rule[53] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[53] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[53] + kids[1].cost2[7] + kids[2].cost2[7], 181);
                    }
                    if (kids[0].rule[54] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[54] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[54] + kids[1].cost2[7] + kids[2].cost2[7], 183);
                    }
                    if (kids[0].rule[55] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[55] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[55] + kids[1].cost2[7] + kids[2].cost2[7], 185);
                    }
                    if (kids[0].rule[56] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[56] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[56] + kids[1].cost2[7] + kids[2].cost2[7], 187);
                    }
                    if (kids[0].rule[57] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[57] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[57] + kids[1].cost2[7] + kids[2].cost2[7], 189);
                    }
                    if (kids[0].rule[58] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[58] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[58] + kids[1].cost2[7] + kids[2].cost2[7], 191);
                    }
                    if (kids[0].rule[59] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[59] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[59] + kids[1].cost2[7] + kids[2].cost2[7], 193);
                    }
                    if (kids[0].rule[60] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[60] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[60] + kids[1].cost2[7] + kids[2].cost2[7], 195);
                    }
                    if (kids[0].rule[61] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[61] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[61] + kids[1].cost2[7] + kids[2].cost2[7], 197);
                    }
                    if (kids[0].rule[62] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[62] + kids[1].cost1[7] + kids[2].cost1[7], 2 + kids[0].cost2[62] + kids[1].cost2[7] + kids[2].cost2[7], 199);
                    }
                    if (kids[0].rule[66] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[66] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[66] + kids[1].cost2[7] + kids[2].cost2[7], 215);
                    }
                    if (kids[0].rule[67] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[67] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[67] + kids[1].cost2[7] + kids[2].cost2[7], 217);
                    }
                    if (kids[0].rule[68] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[68] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[68] + kids[1].cost2[7] + kids[2].cost2[7], 219);
                    }
                    if (kids[0].rule[69] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[69] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[69] + kids[1].cost2[7] + kids[2].cost2[7], 221);
                    }
                    if (kids[0].rule[70] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[70] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[70] + kids[1].cost2[7] + kids[2].cost2[7], 223);
                    }
                    if (kids[0].rule[71] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[71] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[71] + kids[1].cost2[7] + kids[2].cost2[7], 225);
                    }
                    if (kids[0].rule[72] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[72] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[72] + kids[1].cost2[7] + kids[2].cost2[7], 227);
                    }
                    if (kids[0].rule[73] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[73] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[73] + kids[1].cost2[7] + kids[2].cost2[7], 229);
                    }
                    if (kids[0].rule[74] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[74] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[74] + kids[1].cost2[7] + kids[2].cost2[7], 231);
                    }
                    if (kids[0].rule[75] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[75] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[75] + kids[1].cost2[7] + kids[2].cost2[7], 233);
                    }
                    if (kids[0].rule[77] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[77] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[77] + kids[1].cost2[7] + kids[2].cost2[7], 248);
                    }
                    if (kids[0].rule[78] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[78] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[78] + kids[1].cost2[7] + kids[2].cost2[7], 250);
                    }
                    if (kids[0].rule[79] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[79] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[79] + kids[1].cost2[7] + kids[2].cost2[7], 252);
                    }
                    if (kids[0].rule[80] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[80] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[80] + kids[1].cost2[7] + kids[2].cost2[7], 254);
                    }
                    if (kids[0].rule[81] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[81] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[81] + kids[1].cost2[7] + kids[2].cost2[7], 256);
                    }
                    if (kids[0].rule[82] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[82] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[82] + kids[1].cost2[7] + kids[2].cost2[7], 258);
                    }
                    if (kids[0].rule[83] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[83] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[83] + kids[1].cost2[7] + kids[2].cost2[7], 260);
                    }
                    if (kids[0].rule[84] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[84] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[84] + kids[1].cost2[7] + kids[2].cost2[7], 262);
                    }
                    if (kids[0].rule[85] != 0 && kids[1].rule[7] != 0 && kids[2].rule[7] != 0) {
                        this.record(6, 4 + kids[0].cost1[85] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[85] + kids[1].cost2[7] + kids[2].cost2[7], 264);
                    }
                    if (kids[0].rule[86] == 0 || kids[1].rule[7] == 0 || kids[2].rule[7] == 0) break;
                    this.record(6, 4 + kids[0].cost1[86] + kids[1].cost1[7] + kids[2].cost1[7], 4 + kids[0].cost2[86] + kids[1].cost2[7] + kids[2].cost2[7], 266);
                    break;
                }
                case 53: {
                    if (kids[0].rule[17] != 0) {
                        this.record(6, 3 + kids[0].cost1[17], 1 + kids[0].cost2[17], 200);
                    }
                    if (kids[0].rule[1] != 0) {
                        this.record(6, 4 + kids[0].cost1[1], 2 + kids[0].cost2[1], 201);
                    }
                    if (kids[0].rule[37] == 0) break;
                    this.record(6, 6 + kids[0].cost1[37], 2 + kids[0].cost2[37], 202);
                    break;
                }
                case 56: {
                    if (kids.length == 2 && kids[0].rule[89] != 0 && kids[1].rule[91] != 0) {
                        this.record(6, 2 + kids[0].cost1[89] + kids[1].cost1[91], 2 + kids[0].cost2[89] + kids[1].cost2[91], 280);
                    }
                    if (kids.length == 2 && kids[0].rule[93] != 0 && kids[1].rule[95] != 0) {
                        this.record(6, 2 + kids[0].cost1[93] + kids[1].cost1[95], 2 + kids[0].cost2[93] + kids[1].cost2[95], 285);
                    }
                    if (kids.length == 2 && kids[0].rule[97] != 0 && kids[1].rule[99] != 0) {
                        this.record(6, 6 + kids[0].cost1[97] + kids[1].cost1[99], 6 + kids[0].cost2[97] + kids[1].cost2[99], 290);
                    }
                    if (kids.length != 3 || kids[0].rule[97] == 0 || kids[1].rule[101] == 0 || kids[2].rule[103] == 0) break;
                    this.record(6, 6 + kids[0].cost1[97] + kids[1].cost1[101] + kids[2].cost1[103], 6 + kids[0].cost2[97] + kids[1].cost2[101] + kids[2].cost2[103], 295);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 104; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i) + ":" + this.rule[i] + "[" + this.cost1[i] + "." + this.cost2[i] + "]");
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class RewrState {
        static final int NNONTERM = 5;
        static final int NRULES = 14;
        static final int START_NT = 1;
        static final int NT__ = 0;
        static final int NT__rewr = 1;
        static final int NT__1 = 2;
        static final int NT__2 = 3;
        static final int NT__3 = 4;
        final int[] rule = new int[5];
        boolean rewritten;

        RewrState() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "_rewr";
                }
                case 2: {
                    return "_1";
                }
                case 3: {
                    return "_2";
                }
                case 4: {
                    return "_3";
                }
            }
            return null;
        }

        void record(int nt, int rule) {
            if (this.rule[nt] == 0) {
                this.rule[nt] = rule;
            }
        }

        LirNode labelAndRewrite(LirNode t, RewrState[] kids, String phase, BiList pre, BiList post) {
            switch (t.opCode) {
                case 4: {
                    if (t.type != 514) break;
                    if (((LirSymRef)t).symbol.name == "__builtin_va_start") {
                        this.record(2, 7);
                    }
                    if (((LirSymRef)t).symbol.name != "alloca") break;
                    this.record(4, 10);
                    break;
                }
                case 24: {
                    if (phase != "early") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.rewriteCONVFU(t, pre);
                }
                case 26: {
                    if (phase != "early") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.rewriteCONVUF(t, pre);
                }
                case 48: {
                    if (phase != "late" || Type.tag(t.type) != 1) break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.rewriteAggregateCopy(t, pre);
                }
                case 51: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.rewriteJumpn(t, pre);
                }
                case 53: {
                    if (phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_arm.this.rewriteCall(t, pre, post);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[3] != 0 && kids[2].rule[3] != 0 && phase == "early") {
                        this.rewritten = true;
                        return CodeGenerator_arm.this.lir.node(48, 514, t.kid(2).kid(0), CodeGenerator_arm.this.lir.node(10, 514, CodeGenerator_arm.this.lir.node(6, 514, CodeGenerator_arm.this.func.getSymbol("%fp")), CodeGenerator_arm.this.lir.iconst(514, CodeGenerator_arm.this.makeVaStart(t.kid(1).kid(0)))));
                    }
                    if (kids[0].rule[4] == 0 || kids[1].rule[3] == 0 || kids[2].rule[3] == 0 || phase != "early") break;
                    this.rewritten = true;
                    pre.add(CodeGenerator_arm.this.lir.node(48, 514, CodeGenerator_arm.this.lir.node(6, 514, CodeGenerator_arm.this.func.getSymbol("%sp")), CodeGenerator_arm.this.lir.node(11, 514, CodeGenerator_arm.this.lir.node(6, 514, CodeGenerator_arm.this.func.getSymbol("%sp")), CodeGenerator_arm.this.lir.node(27, 514, CodeGenerator_arm.this.lir.node(10, 514, t.kid(1).kid(0), CodeGenerator_arm.this.lir.iconst(514, 3L)), CodeGenerator_arm.this.lir.iconst(514, -4L)))));
                    return CodeGenerator_arm.this.lir.node(48, 514, t.kid(2).kid(0), CodeGenerator_arm.this.lir.node(6, 514, CodeGenerator_arm.this.func.getSymbol("%sp")));
                }
                case 54: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.noRescan(CodeGenerator_arm.this.rewritePrologue(t, post));
                }
                case 55: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.noRescan(CodeGenerator_arm.this.rewriteEpilogue(t, pre));
                }
                case 61: {
                    if (kids.length != 1) break;
                    this.record(3, 8);
                    break;
                }
                case 67: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_arm.this.noRescan(CodeGenerator_arm.this.rewriteAsm(t, pre, post));
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 5; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i));
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

