/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.cfg;

import coins.backend.LocalAnalysis;
import coins.backend.cfg.DfstHook;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.io.PrintWriter;

public class BasicBlk {
    public final FlowGraph flowGraph;
    public final int id;
    private BiList instrList;
    private BiList succList = new BiList();
    private BiList predList = new BiList();
    private BiList dummySuccList = new BiList();
    private BiList dummyPredList = new BiList();
    int dfn;
    int dfnPre;
    BasicBlk parent;
    private Label label;
    private static final LocalAnalysis[] emptyAnares = new LocalAnalysis[0];

    BasicBlk(FlowGraph g, int idnum, BiList instr) {
        this.flowGraph = g;
        this.id = idnum;
        this.instrList = instr;
        BiLink insp = this.instrList.first();
        while (!insp.atEnd()) {
            LirNode node = (LirNode)insp.elem();
            BiLink next = insp.next();
            if (node.opCode == 52) {
                ((LirLabelRef)node.kid((int)0)).label.setBasicBlk(this);
                if (this.label == null) {
                    this.label = ((LirLabelRef)node.kid((int)0)).label;
                }
                insp.unlink();
            }
            insp = next;
        }
        if (this.label == null) {
            Label label = g.function.newLabel();
            label.setBasicBlk(this);
            this.setLabel(label);
        }
    }

    public BiList instrList() {
        return this.instrList;
    }

    public void setInstrList(BiList list) {
        this.instrList = list;
    }

    public Label label() {
        return this.label;
    }

    public void setLabel(Label l) {
        this.label = l;
    }

    public BiList succList() {
        return this.succList;
    }

    public BiList predList() {
        return this.predList;
    }

    public BiList dummySuccList() {
        return this.dummySuccList;
    }

    public BiList dummyPredList() {
        return this.dummyPredList;
    }

    public int dfn() {
        return this.dfn;
    }

    public int dfnPre() {
        return this.dfnPre;
    }

    public BasicBlk parent() {
        return this.parent;
    }

    public boolean isAncestorOf(BasicBlk x) {
        return this.dfnPre <= x.dfnPre && this.dfn <= x.dfn;
    }

    public boolean isDescendantOf(BasicBlk x) {
        return x.dfnPre <= this.dfnPre && x.dfn <= this.dfn;
    }

    public void addEdge(BasicBlk toBlk) {
        this.succList.addNew(toBlk);
        toBlk.predList.addNew(this);
    }

    public void removeEdge(BasicBlk toBlk) {
        this.succList.remove(toBlk);
        toBlk.predList.remove(toBlk);
    }

    public void addDummyEdge(BasicBlk toBlk) {
        this.dummySuccList.addNew(toBlk);
        toBlk.dummyPredList.addNew(this);
    }

    public void removeDummyEdge(BasicBlk toBlk) {
        this.dummySuccList.remove(toBlk);
        toBlk.dummyPredList.remove(toBlk);
    }

    public void clearEdges() {
        BiLink p = this.succList.first();
        while (!p.atEnd()) {
            BasicBlk target = (BasicBlk)p.elem();
            p = p.next();
            target.predList.remove(this);
        }
        this.succList.clear();
    }

    public void clearDummyEdges() {
        BiLink p = this.dummySuccList.first();
        while (!p.atEnd()) {
            BasicBlk target = (BasicBlk)p.elem();
            p = p.next();
            target.dummyPredList.remove(this);
        }
        this.dummySuccList.clear();
    }

    public void maintEdges() {
        Label[] targets;
        this.flowGraph.touch();
        this.clearEdges();
        if (!this.instrList.isEmpty() && (targets = ((LirNode)this.instrList.last().elem()).getTargets()) != null) {
            for (int i = 0; i < targets.length; ++i) {
                this.addEdge(targets[i].basicBlk());
            }
        }
    }

    public void replaceSucc(BasicBlk x, BasicBlk y) {
        LirNode jumpOp = (LirNode)this.instrList.last().elem();
        jumpOp.replaceLabel(x.label, y.label, this.flowGraph.function.newLir);
        this.maintEdges();
    }

    void depthFirstSearch(DfstHook h, BasicBlk from, int[] cpre, int[] crpost) {
        if (h != null) {
            h.preOrder(this, from);
        }
        this.dfnPre = cpre[0] = cpre[0] + 1;
        this.parent = from;
        BiLink p = this.succList.first();
        while (!p.atEnd()) {
            BasicBlk y = (BasicBlk)p.elem();
            if (y.dfnPre == 0) {
                y.depthFirstSearch(h, this, cpre, crpost);
            }
            p = p.next();
        }
        if (h != null) {
            h.postOrder(this);
        }
        this.dfn = crpost[0] = crpost[0] + 1;
    }

    public Object toSexp() {
        ImList list = ImList.Empty;
        if (this.flowGraph.entryBlk() != this) {
            list = new ImList(ImList.list("DEFLABEL", new QuotedString(this.label.toString())), list);
        }
        BiLink insp = this.instrList.first();
        while (!insp.atEnd()) {
            LirNode node = (LirNode)insp.elem();
            list = new ImList(node.toSexp(), list);
            insp = insp.next();
        }
        return list.destructiveReverse();
    }

    public void printStandardForm(PrintWriter output, String indent) {
        if (this.flowGraph.entryBlk() != this) {
            output.println(indent + "(DEFLABEL \"" + this.label + "\")");
        }
        BiLink insp = this.instrList.first();
        while (!insp.atEnd()) {
            LirNode node = (LirNode)insp.elem();
            output.println(indent + node.toString());
            insp = insp.next();
        }
    }

    public void printIt(PrintWriter output) {
        this.printIt(output, emptyAnares);
    }

    public void printIt(PrintWriter output, LocalAnalysis[] anals) {
        BasicBlk blk;
        output.println();
        output.print("  #" + this.id + " Basic Block");
        if (this.label != null) {
            output.print(" (" + this.label + ")");
        }
        output.print(": DFN=(" + this.dfnPre + "," + this.dfn + "),");
        if (this.parent != null) {
            output.print(" parent=#" + this.parent.id + ",");
        }
        output.print(" <-(");
        boolean middle = false;
        BiLink blkp = this.predList.first();
        while (!blkp.atEnd()) {
            blk = (BasicBlk)blkp.elem();
            output.print((middle ? ",#" : "#") + blk.id);
            middle = true;
            blkp = blkp.next();
        }
        blkp = this.dummyPredList.first();
        while (!blkp.atEnd()) {
            blk = (BasicBlk)blkp.elem();
            output.print((middle ? ",*#" : "*#") + blk.id);
            middle = true;
            blkp = blkp.next();
        }
        output.print(") ->(");
        middle = false;
        blkp = this.succList.first();
        while (!blkp.atEnd()) {
            blk = (BasicBlk)blkp.elem();
            output.print((middle ? ",#" : "#") + blk.id);
            middle = true;
            blkp = blkp.next();
        }
        blkp = this.dummySuccList.first();
        while (!blkp.atEnd()) {
            blk = (BasicBlk)blkp.elem();
            output.print((middle ? ",*#" : "*#") + blk.id);
            middle = true;
            blkp = blkp.next();
        }
        output.println(")");
        for (int i = 0; i < anals.length; ++i) {
            anals[i].printBeforeBlock(this, output);
        }
        BiLink insp = this.instrList.first();
        while (!insp.atEnd()) {
            int i;
            LirNode node = (LirNode)insp.elem();
            for (i = 0; i < anals.length; ++i) {
                anals[i].printBeforeStmt(node, output);
            }
            output.print("    ");
            output.println(node.toString());
            for (i = 0; i < anals.length; ++i) {
                anals[i].printAfterStmt(node, output);
            }
            insp = insp.next();
        }
        for (int i = 0; i < anals.length; ++i) {
            anals[i].printAfterBlock(this, output);
        }
    }
}

