/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.asmpp;

public abstract class CPU {
    public int[] bccRange;
    public int[] braRange;
    public int[] literalRange;
    public String[] bccMnemo;
    public String braMnemo;
    public int braLength;
    public int codeAlign;

    public int codeLength(String inst) {
        return 1;
    }

    public String generateBcc(String mnemo, String label) {
        return "\t" + mnemo + "\t" + label;
    }

    public String generateBra(String label) {
        return "\t" + this.braMnemo + "\t" + label;
    }

    public String[] rewriteToLongBranch(String label) {
        return new String[]{"\t" + this.braMnemo + "\t" + label};
    }

    public boolean isBcc(String mnemo) {
        for (int i = 0; i < this.bccMnemo.length; ++i) {
            if (!mnemo.equalsIgnoreCase(this.bccMnemo[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isBra(String mnemo) {
        return mnemo.equalsIgnoreCase(this.braMnemo);
    }

    public boolean inBccRange(int n) {
        return this.bccRange[0] <= n && n <= this.bccRange[1];
    }

    public boolean inBraRange(int n) {
        return this.braRange[0] <= n && n <= this.braRange[1];
    }

    public boolean inLiteralRange(int n) {
        return this.literalRange[0] <= n && n <= this.literalRange[1];
    }

    public String getRevMnemo(String mnemo) {
        for (int i = 0; i < this.bccMnemo.length; ++i) {
            if (!mnemo.equalsIgnoreCase(this.bccMnemo[i])) continue;
            return this.bccMnemo[i ^= 1];
        }
        return null;
    }

    public abstract String toString();
}

