/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.MachineParams;
import coins.backend.ana.EnumRegVars;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import java.io.PrintWriter;
import java.util.Iterator;

public class ScanVarReference
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final BiList[] defSites;
    public final BiList[] useSites;
    public final BiList[] outUseSites;
    public final BasicBlk[] phiDefSite;
    private EnumRegVars rn;
    private int nPhyReg;
    private int maxvar;
    private int[] def;
    private int[] use;
    private Function function;
    private int timeStamp;
    private MachineParams target;
    private int nPhyRegs;

    private ScanVarReference(Function f) {
        this.function = f;
        this.timeStamp = f.timeStamp();
        this.target = f.module.targetMachine.machineParams;
        this.rn = (EnumRegVars)f.require(EnumRegVars.analyzer);
        this.maxvar = this.rn.nRegvars();
        this.nPhyRegs = this.rn.nPhyRegs();
        int nblks = f.flowGraph().idBound();
        this.defSites = new BiList[this.maxvar];
        this.useSites = new BiList[this.maxvar];
        this.outUseSites = new BiList[this.maxvar];
        this.phiDefSite = new BasicBlk[this.maxvar];
        this.def = new int[this.maxvar];
        this.use = new int[this.maxvar];
        LirNode.Scanner sc = new LirNode.Scanner();
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                if (ins.opCode == 59) {
                    this.phiDefSite[this.rn.index((LirNode)ins.kid((int)0))] = blk;
                    int n = ins.nKids();
                    for (int i = 1; i < n; ++i) {
                        if (ins.kid((int)i).kid((int)0).opCode != 6) continue;
                        BasicBlk b = ((LirLabelRef)ins.kid((int)i).kid((int)1)).label.basicBlk();
                        int vid = this.rn.index(ins.kid(i).kid(0));
                        if (this.outUseSites[vid] == null) {
                            this.outUseSites[vid] = new BiList();
                        }
                        this.outUseSites[vid].addNew(b);
                    }
                } else {
                    int v;
                    Iterator it = sc.forUses(ins);
                    while (it.hasNext()) {
                        v = this.rn.index((LirNode)it.next());
                        if (this.def[v] == blk.id || this.use[v] == blk.id) continue;
                        this.use[v] = blk.id;
                        if (this.useSites[v] == null) {
                            this.useSites[v] = new BiList();
                        }
                        this.useSites[v].add(blk);
                    }
                    it = sc.forDefs(ins);
                    while (it.hasNext()) {
                        v = this.rn.index((LirNode)it.next());
                        if (this.def[v] != blk.id) {
                            this.def[v] = blk.id;
                            if (this.defSites[v] == null) {
                                this.defSites[v] = new BiList();
                            }
                            this.defSites[v].add(blk);
                        }
                        if (v >= this.nPhyRegs) continue;
                        short[] subRegs = this.target.subRegs(v);
                        for (int i = 0; i < subRegs.length; ++i) {
                            short w = subRegs[i];
                            if (this.def[w] == blk.id) continue;
                            this.def[w] = blk.id;
                            if (this.defSites[w] == null) {
                                this.defSites[w] = new BiList();
                            }
                            this.defSites[w].add(blk);
                        }
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
        for (int i = 0; i < this.maxvar; ++i) {
            BasicBlk b;
            BiLink p;
            if (this.useSites[i] == null && this.outUseSites[i] == null) continue;
            output.print(this.rn.toString(i) + " used: ");
            boolean beginning = true;
            if (this.useSites[i] != null) {
                p = this.useSites[i].first();
                while (!p.atEnd()) {
                    b = (BasicBlk)p.elem();
                    if (!beginning) {
                        output.print(",");
                    }
                    output.print("#" + b.id);
                    beginning = false;
                    p = p.next();
                }
            }
            if (this.outUseSites[i] != null) {
                p = this.outUseSites[i].first();
                while (!p.atEnd()) {
                    b = (BasicBlk)p.elem();
                    if (!beginning) {
                        output.print(",");
                    }
                    output.print("after #" + b.id);
                    beginning = false;
                    p = p.next();
                }
            }
            beginning = true;
            if (this.defSites[i] != null) {
                output.print("  defined: ");
                p = this.defSites[i].first();
                while (!p.atEnd()) {
                    b = (BasicBlk)p.elem();
                    if (!beginning) {
                        output.print(",");
                    }
                    output.print("#" + b.id);
                    beginning = false;
                    p = p.next();
                }
            }
            if (this.phiDefSite[i] != null) {
                output.print("   Phi-defined: #" + this.phiDefSite[i].id);
            }
            output.println();
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new ScanVarReference(func);
        }

        public String name() {
            return "ScanVarReference";
        }
    }
}

