/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.MachineParams;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;

public class EnumRegVars
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    private Function function;
    private FlowGraph flowGraph;
    private int timeStamp;
    private int nRegvars;
    private int nPhyRegs;
    private int[] regvarIndex;
    private Symbol[] regvarVec;
    private MachineParams target;

    private EnumRegVars(Function f) {
        int i;
        this.function = f;
        this.target = this.function.module.targetMachine.machineParams;
        this.flowGraph = f.flowGraph();
        this.timeStamp = f.timeStamp();
        int maxSyms = this.function.localSymtab.idBound();
        this.nPhyRegs = this.nRegvars = this.target.nRegisters();
        BiLink p = this.function.localSymtab.symbols().first();
        while (!p.atEnd()) {
            if (((Symbol)p.elem()).storage == 2) {
                ++this.nRegvars;
            }
            p = p.next();
        }
        this.regvarVec = new Symbol[this.nRegvars];
        this.regvarIndex = new int[maxSyms];
        for (i = 0; i < maxSyms; ++i) {
            this.regvarIndex[i] = -1;
        }
        for (i = 0; i < this.nPhyRegs; ++i) {
            this.regvarVec[i] = this.target.registerSymbol(i);
        }
        p = this.function.module.globalSymtab.symbols().first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            if (sym.storage == 2) {
                this.regvarIndex[sym.id] = this.target.registerIndex(sym);
            }
            p = p.next();
        }
        int n = this.nPhyRegs;
        BiLink p2 = this.function.localSymtab.symbols().first();
        while (!p2.atEnd()) {
            Symbol sym = (Symbol)p2.elem();
            if (sym.storage == 2) {
                this.regvarVec[n] = sym;
                this.regvarIndex[sym.id] = n++;
            }
            p2 = p2.next();
        }
    }

    public int nRegvars() {
        return this.nRegvars;
    }

    public int nPhyRegs() {
        return this.nPhyRegs;
    }

    public Symbol toSymbol(int index) {
        return this.regvarVec[index];
    }

    public String toString(int index) {
        if (index < this.nPhyRegs) {
            return this.target.registerToString(index);
        }
        return this.regvarVec[index].printName();
    }

    public String toString(NumberSet s) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        NumberSet.Iterator it = s.iterator();
        while (it.hasNext()) {
            if (!first) {
                buf.append(" ");
            }
            buf.append(this.toString(it.next()));
            first = false;
        }
        return buf.toString();
    }

    public int index(LirNode node) {
        if (node.opCode != 6 && (node.opCode != 7 || node.kid((int)0).opCode != 6)) {
            return 0;
        }
        int x = this.target.registerIndex(node);
        if (x != 0) {
            return x;
        }
        if (node.opCode == 7) {
            node = node.kid(0);
        }
        return this.index(((LirSymRef)node).symbol);
    }

    public int index(Symbol sym) {
        if (sym.id < this.regvarIndex.length) {
            return this.regvarIndex[sym.id];
        }
        return 0;
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    public void printIt(PrintWriter out) {
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
        output.println();
        output.println("Register variables numbered as:");
        for (int i = 1; i < this.nRegvars; ++i) {
            output.println(i + ": " + this.toString(i));
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new EnumRegVars(func);
        }

        public String name() {
            return "EnumRegVars";
        }
    }
}

